/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrewHandler {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void handlePotionBrew(NonNullList<ItemStack> brewingItemStacks, World world, BlockPos pos) {
        try {
            ItemStack ingredient = (ItemStack)brewingItemStacks.get(3);
            UUID uuid = ChunkDataHandler.checkPos(world, pos);
            if (uuid != null) {
                double extraChance = XP.getExtraChance(uuid, ((ItemStack)brewingItemStacks.get(3)).func_77973_b().getRegistryName(), JType.INFO_BREW, false) / 100.0;
                int guaranteedDrop = (int)extraChance;
                int potionCount = 0;
                for (int i = 0; i < 3; ++i) {
                    ItemStack potion = (ItemStack)brewingItemStacks.get(i);
                    if (potion.func_190926_b()) continue;
                    int extraDrop = XP.rollChance(extraChance % 1.0) ? 1 : 0;
                    potionCount += 1 + guaranteedDrop + extraDrop;
                    potion.func_190917_f(guaranteedDrop + extraDrop);
                }
                Map<String, Double> award = XP.multiplyMapAnyDouble(XP.getXp(ingredient, JType.XP_VALUE_BREW), potionCount);
                for (String awardSkillName : award.keySet()) {
                    WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.523, (double)pos.func_177952_p() + 0.5, 0.4, award.get(awardSkillName), awardSkillName);
                    xpDrop.setDecaySpeed(0.25);
                    XP.addWorldXpDrop(xpDrop, uuid);
                    Skill.addXp(awardSkillName, uuid, (double)award.get(awardSkillName), "brewing", false, false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }
}

