/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;

public class ChunkDataHandler {
    private static Map<ResourceLocation, Map<ChunkPos, Map<BlockPos, UUID>>> placedMap = new HashMap<ResourceLocation, Map<ChunkPos, Map<BlockPos, UUID>>>();

    public static void init() {
        placedMap = new HashMap<ResourceLocation, Map<ChunkPos, Map<BlockPos, UUID>>>();
    }

    public static void handleChunkDataLoad(ChunkDataEvent.Load event) {
        CompoundNBT levelNBT;
        CompoundNBT chunkNBT = event.getData();
        if (chunkNBT != null && (levelNBT = chunkNBT.func_74775_l("Level")).func_74764_b("placedPos")) {
            CompoundNBT placedPosNBT;
            World world = (World)event.getWorld();
            ResourceLocation dimResLoc = XP.getDimResLoc(world);
            ChunkPos chunkPos = event.getChunk().func_76632_l();
            if (!placedMap.containsKey(dimResLoc)) {
                placedMap.put(dimResLoc, new HashMap());
            }
            if ((placedPosNBT = (CompoundNBT)levelNBT.func_74781_a("placedPos")) == null) {
                return;
            }
            Map<ChunkPos, Map<BlockPos, UUID>> chunkMap = placedMap.get(dimResLoc);
            HashMap blockMap = new HashMap();
            Set keySet = placedPosNBT.func_150296_c();
            keySet.forEach(key -> {
                CompoundNBT entry = placedPosNBT.func_74775_l(key);
                blockMap.put(NBTUtil.func_186861_c((CompoundNBT)entry.func_74775_l("pos")), new UUID(entry.func_74775_l("UUID").func_74763_f("M"), entry.func_74775_l("UUID").func_74763_f("L")));
            });
            chunkMap.remove(chunkPos);
            chunkMap.put(chunkPos, blockMap);
        }
    }

    public static void handleChunkDataSave(ChunkDataEvent.Save event) {
        World world = (World)event.getWorld();
        ResourceLocation dimResLoc = XP.getDimResLoc(world);
        if (placedMap.containsKey(dimResLoc)) {
            ChunkPos chunkPos = event.getChunk().func_76632_l();
            if (placedMap.get(dimResLoc).containsKey(chunkPos)) {
                CompoundNBT levelNBT = (CompoundNBT)event.getData().func_74781_a("Level");
                if (levelNBT == null) {
                    return;
                }
                CompoundNBT newPlacedNBT = new CompoundNBT();
                int i = 0;
                for (Map.Entry<BlockPos, UUID> entry : placedMap.get(dimResLoc).get(chunkPos).entrySet()) {
                    CompoundNBT insidesNBT = new CompoundNBT();
                    insidesNBT.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry.getKey()));
                    insidesNBT.func_218657_a("UUID", (INBT)XP.writeUniqueId(entry.getValue()));
                    newPlacedNBT.func_218657_a(i++ + "", (INBT)insidesNBT);
                }
                levelNBT.func_218657_a("placedPos", (INBT)newPlacedNBT);
            }
        }
    }

    public static void addPos(ResourceLocation dimResLoc, BlockPos blockPos, UUID uuid) {
        Map<ChunkPos, Map<BlockPos, UUID>> chunkMap;
        ChunkPos chunkPos = new ChunkPos(blockPos);
        if (!placedMap.containsKey(dimResLoc)) {
            placedMap.put(dimResLoc, new HashMap());
        }
        if (!(chunkMap = placedMap.get(dimResLoc)).containsKey(chunkPos)) {
            chunkMap.put(chunkPos, new HashMap());
        }
        Map<BlockPos, UUID> blockMap = chunkMap.get(chunkPos);
        blockMap.put(blockPos, uuid);
    }

    public static void delPos(ResourceLocation dimResLoc, BlockPos blockPos) {
        Map<ChunkPos, Map<BlockPos, UUID>> chunkMap;
        ChunkPos chunkPos = new ChunkPos(blockPos);
        if (!placedMap.containsKey(dimResLoc)) {
            placedMap.put(dimResLoc, new HashMap());
        }
        if (!(chunkMap = placedMap.get(dimResLoc)).containsKey(chunkPos)) {
            chunkMap.put(chunkPos, new HashMap());
        }
        Map<BlockPos, UUID> blockMap = chunkMap.get(chunkPos);
        blockMap.remove(blockPos);
    }

    public static UUID checkPos(World world, BlockPos pos) {
        return ChunkDataHandler.checkPos(XP.getDimResLoc(world), pos);
    }

    public static UUID checkPos(ResourceLocation dimResLoc, BlockPos blockPos) {
        return (UUID)((Map)((Map)placedMap.getOrDefault(dimResLoc, new HashMap())).getOrDefault(new ChunkPos(blockPos), new HashMap())).get(blockPos);
    }
}

