/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftedHandler {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void handleCrafted(PlayerEvent.ItemCraftedEvent event) {
        try {
            if (event.getPlayer() instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
                Vector3d pos = player.func_213303_ch();
                double defaultCraftingXp = Config.forgeConfig.defaultCraftingXp.get();
                double durabilityMultiplier = 1.0;
                ItemStack itemStack = event.getCrafting();
                Map<String, Double> xpValue = XP.getXp(itemStack, JType.XP_VALUE_CRAFT);
                HashMap<String, Double> award = new HashMap<String, Double>();
                if (xpValue.size() == 0) {
                    if (itemStack.func_77973_b() instanceof BlockItem) {
                        award.put("crafting", Double.valueOf(((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P().func_185887_b(null, null)));
                    } else {
                        award.put("crafting", defaultCraftingXp);
                    }
                } else {
                    XP.addMapsAnyDouble(award, xpValue);
                }
                if (itemStack.func_77984_f()) {
                    durabilityMultiplier = (double)(itemStack.func_77958_k() - itemStack.func_77952_i()) / (double)itemStack.func_77958_k();
                }
                XP.multiplyMapAnyDouble(award, durabilityMultiplier);
                for (String awardSkillName : award.keySet()) {
                    WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)player.func_71121_q()), pos.func_82615_a(), pos.func_82617_b() + (double)player.func_70047_e() + 0.523, pos.func_82616_c(), 1.523, (Double)award.get(awardSkillName), awardSkillName);
                    XP.addWorldXpDrop(xpDrop, player);
                    Skill.addXp(awardSkillName, player, (double)((Double)award.get(awardSkillName)), "crafting", false, false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("PMMO error while crafting", (Throwable)e);
        }
    }
}

