/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class DamageHandler {
    public static double getEnduranceMultiplier(PlayerEntity player) {
        double maxEndurance;
        double endurancePerLevel;
        int enduranceLevel = Skill.getLevel(Skill.ENDURANCE.toString(), player);
        double endurePercent = (double)enduranceLevel * (endurancePerLevel = Config.forgeConfig.endurancePerLevel.get().doubleValue());
        if (endurePercent > (maxEndurance = Config.forgeConfig.maxEndurance.get().doubleValue())) {
            endurePercent = maxEndurance;
        }
        return endurePercent /= 100.0;
    }

    public static double getFallSaveChance(PlayerEntity player) {
        int agilityLevel = Skill.getLevel(Skill.AGILITY.toString(), player);
        double maxFallSaveChance = Config.forgeConfig.maxFallSaveChance.get();
        double saveChancePerLevel = Math.min(maxFallSaveChance, Config.forgeConfig.saveChancePerLevel.get() / 100.0);
        return (double)agilityLevel * saveChancePerLevel;
    }

    public static void handleDamage(LivingDamageEvent event) {
        if (!(event.getEntity() instanceof FakePlayer)) {
            float damage;
            float startDmg = damage = event.getAmount();
            LivingEntity target = event.getEntityLiving();
            Entity source = event.getSource().func_76346_g();
            if (target instanceof ServerPlayerEntity) {
                boolean isFallDamage = event.getSource().func_76355_l().equals("fall");
                ServerPlayerEntity player = (ServerPlayerEntity)target;
                ServerWorld world = player.func_71121_q();
                double agilityXp = 0.0;
                boolean hideEndurance = false;
                if (source instanceof ServerPlayerEntity && !(source instanceof FakePlayer)) {
                    ServerPlayerEntity sourcePlayer = (ServerPlayerEntity)source;
                    Party party = PmmoSavedData.get().getParty(player.func_110124_au());
                    if (party != null) {
                        PartyMemberInfo sourceMemberInfo = party.getMemberInfo(sourcePlayer.func_110124_au());
                        double friendlyFireMultiplier = Config.forgeConfig.partyFriendlyFireAmount.get() / 100.0;
                        if (sourceMemberInfo != null) {
                            damage = (float)((double)damage * friendlyFireMultiplier);
                        }
                    }
                }
                double endured = Math.max(0.0, (double)damage * DamageHandler.getEnduranceMultiplier((PlayerEntity)player));
                damage = (float)((double)damage - endured);
                double enduranceXp = (double)(damage * 5.0f) + endured * 7.5;
                if (isFallDamage) {
                    double award;
                    int saved = 0;
                    double chance = DamageHandler.getFallSaveChance((PlayerEntity)player);
                    int i = 0;
                    while ((float)i < damage) {
                        if (Math.ceil(Math.random() * 100.0) <= chance) {
                            ++saved;
                        }
                        ++i;
                    }
                    damage -= (float)saved;
                    if (saved != 0 && player.func_110143_aJ() > damage) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.savedFall", new Object[]{saved}), true);
                    }
                    agilityXp = award = (double)(saved * 5);
                }
                if (player.func_110143_aJ() > damage) {
                    if (agilityXp > 0.0) {
                        hideEndurance = true;
                    }
                    Vector3d pos = player.func_213303_ch();
                    if (event.getSource().func_76346_g() != null) {
                        XP.awardXp(player, Skill.ENDURANCE.toString(), event.getSource().func_76346_g().func_145748_c_().getString(), enduranceXp, hideEndurance, false, false);
                    } else {
                        XP.awardXp(player, Skill.ENDURANCE.toString(), event.getSource().func_76355_l(), enduranceXp, hideEndurance, false, false);
                    }
                    if (enduranceXp > 0.0) {
                        WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)world), pos.func_82615_a(), pos.func_82617_b() + (double)player.func_70047_e() + 0.523, pos.func_82616_c(), 1.523, enduranceXp, Skill.ENDURANCE.toString());
                        XP.addWorldXpDrop(xpDrop, player);
                    }
                    if (agilityXp > 0.0) {
                        WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)world), pos.func_82615_a(), pos.func_82617_b() + (double)player.func_70047_e() + 0.523, pos.func_82616_c(), 1.523, agilityXp, Skill.AGILITY.toString());
                        xpDrop.setSize(1.523f);
                        XP.addWorldXpDrop(xpDrop, player);
                        XP.awardXp(player, Skill.AGILITY.toString(), "surviving " + startDmg + " fall damage", agilityXp, false, false, false);
                    }
                }
            }
            if (target instanceof LivingEntity && event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)event.getSource().func_76346_g();
                ServerWorld world = player.func_71121_q();
                if (XP.isHoldingDebugItemInOffhand((PlayerEntity)player)) {
                    player.func_146105_b((ITextComponent)new StringTextComponent("regName:" + target.func_70022_Q()), false);
                    player.func_146105_b((ITextComponent)new StringTextComponent("dmgType:" + event.getSource().field_76373_n), false);
                }
                if (XP.isPlayerSurvival((PlayerEntity)player)) {
                    String skill;
                    ItemStack mainItemStack = player.func_184614_ca();
                    ResourceLocation mainResLoc = player.func_184614_ca().func_77973_b().getRegistryName();
                    ResourceLocation offResLoc = player.func_184592_cb().func_77973_b().getRegistryName();
                    Map<String, Double> weaponReq = XP.getXpBypass(mainResLoc, JType.REQ_WEAPON);
                    NBTHelper.maxDoubleMaps(weaponReq, XP.getXpBypass(offResLoc, JType.REQ_WEAPON));
                    String itemSpecificSkill = AutoValues.getItemSpecificSkill(mainItemStack.func_77973_b().getRegistryName().toString());
                    boolean swordInMainHand = mainItemStack.func_77973_b() instanceof SwordItem;
                    if (itemSpecificSkill != null) {
                        skill = itemSpecificSkill;
                    } else if (event.getSource().field_76373_n.equals("arrow")) {
                        skill = Skill.ARCHERY.toString();
                    } else {
                        skill = Skill.COMBAT.toString();
                        double d = Util.getDistance(player.func_213303_ch(), target.func_213303_ch());
                        double d2 = 4.2 + (double)target.func_213311_cf();
                        double d3 = swordInMainHand ? 1.523 : 0.0;
                        if (d > d2 + d3) {
                            skill = Skill.MAGIC.toString();
                        }
                    }
                    if (Config.getConfig("wearReqEnabled") != 0.0 && Config.getConfig("autoGenerateValuesEnabled") != 0.0 && Config.getConfig("autoGenerateWeaponReqDynamicallyEnabled") != 0.0) {
                        weaponReq.put(skill, weaponReq.getOrDefault(skill, AutoValues.getWeaponReqFromStack(mainItemStack)));
                    }
                    int weaponGap = XP.getSkillReqGap((PlayerEntity)player, weaponReq);
                    int enchantGap = XP.getSkillReqGap((PlayerEntity)player, XP.getEnchantsUseReq(player.func_184614_ca()));
                    int killGap = 0;
                    int gap = Math.max(weaponGap, enchantGap);
                    if (gap > 0) {
                        if (enchantGap < gap) {
                            NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToUseAsWeapon", player.func_184614_ca().func_77977_a(), "", true, 2), player);
                        }
                        if (Config.forgeConfig.strictReqWeapon.get().booleanValue()) {
                            event.setCanceled(true);
                            return;
                        }
                    }
                    if (skill.equals(Skill.ARCHERY.toString())) {
                        damage = (float)((double)damage * (1.0 + (double)Skill.getLevel(skill, (PlayerEntity)player) * Config.forgeConfig.damageBonusPercentPerLevelArchery.get()));
                    } else if (skill.equals(Skill.MAGIC.toString())) {
                        damage = (float)((double)damage * (1.0 + (double)Skill.getLevel(skill, (PlayerEntity)player) * Config.forgeConfig.damageBonusPercentPerLevelMagic.get()));
                    } else if (skill.equals(Skill.GUNSLINGING.toString())) {
                        damage = (float)((double)damage * (1.0 + (double)Skill.getLevel(skill, (PlayerEntity)player) * Config.forgeConfig.damageBonusPercentPerLevelGunslinging.get()));
                    }
                    if (target.func_70022_Q() != null && (killGap = Math.max(killGap, XP.getSkillReqGap((PlayerEntity)player, XP.getResLoc(target.func_70022_Q()), JType.REQ_KILL))) > 0) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToDamage", new Object[]{new TranslationTextComponent(target.func_200600_R().func_210760_d())}).func_230530_a_(XP.textStyle.get("red")), true);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToDamage", new Object[]{new TranslationTextComponent(target.func_200600_R().func_210760_d())}).func_230530_a_(XP.textStyle.get("red")), false);
                        XP.sendPlayerSkillList((PlayerEntity)player, JsonConfig.data.get((Object)JType.REQ_KILL).get(target.func_70022_Q()));
                        if (Config.forgeConfig.strictReqKill.get().booleanValue()) {
                            event.setCanceled(true);
                            return;
                        }
                    }
                    float amount = 0.0f;
                    float playerHealth = player.func_110143_aJ();
                    float targetHealth = target.func_110143_aJ();
                    float targetMaxHealth = target.func_110138_aP();
                    float lowHpBonus = 1.0f;
                    damage /= (float)(weaponGap + 1);
                    if ((damage /= (float)(killGap + 1)) > targetHealth) {
                        damage = targetHealth;
                    }
                    amount += damage * 3.0f;
                    if (startDmg >= targetHealth) {
                        amount /= 2.0f;
                    }
                    if (startDmg >= targetMaxHealth) {
                        amount = (float)((double)amount / 1.5);
                    }
                    if (target instanceof AnimalEntity) {
                        amount /= 2.0f;
                    } else if (playerHealth <= 10.0f) {
                        lowHpBonus += (11.0f - playerHealth) / 5.0f;
                        if (playerHealth <= 2.0f) {
                            lowHpBonus += 1.0f;
                        }
                    }
                    double distance = Util.getHorizontalDistance(event.getEntity().func_213303_ch(), player.func_213303_ch());
                    if (skill.equals(Skill.COMBAT.toString())) {
                        amount *= lowHpBonus;
                    } else if (skill.equals(Skill.ARCHERY.toString())) {
                        distance = distance > 16.0 ? (distance -= 16.0) : 0.0;
                        amount = (float)((double)amount + Math.pow(distance, 1.3251) * (double)damage * 0.5 * (double)(damage / target.func_110138_aP()) * (damage >= targetMaxHealth ? 1.5 : 1.0));
                        amount *= lowHpBonus;
                    } else {
                        distance = distance > 32.0 ? (distance -= 32.0) : 0.0;
                        amount = (float)((double)amount + Math.pow(distance, 1.1523) * (double)damage * (double)0.05f * (double)(damage / target.func_110138_aP()) * (damage >= targetMaxHealth ? 1.5 : 1.0));
                        amount *= lowHpBonus;
                    }
                    Vector3d xpDropPos = target.func_213303_ch();
                    WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)world), xpDropPos.func_82615_a(), xpDropPos.func_82617_b() + (double)target.func_213302_cg(), xpDropPos.func_82616_c(), (double)target.func_213302_cg(), amount, skill);
                    XP.addWorldXpDrop(xpDrop, player);
                    Map<String, Double> entityMap = XP.getXp((Entity)target, JType.XP_MULTIPLIER_ENTITY);
                    if (entityMap.containsKey(skill)) {
                        amount = (float)((double)amount * entityMap.get(skill));
                    }
                    XP.awardXp(player, skill, player.func_184614_ca().func_200301_q().toString(), amount, false, false, false);
                    if (weaponGap > 0) {
                        player.func_184614_ca().func_222118_a(weaponGap - 1, (LivingEntity)player, a -> a.func_213334_d(Hand.MAIN_HAND));
                    }
                }
            }
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                System.out.println(damage);
            }
            event.setAmount(damage);
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                System.out.println(damage);
            }
            if (event.getAmount() <= 0.0f) {
                event.setCanceled(true);
            }
        }
    }
}

