/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.TooltipSupplier;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class DeathHandler {
    public static void handleDeath(LivingDeathEvent event) {
        LivingEntity target = event.getEntityLiving();
        Entity source = event.getSource().func_76346_g();
        double deathPenaltyMultiplier = Config.forgeConfig.deathPenaltyMultiplier.get();
        double passiveMobHunterXp = Config.forgeConfig.passiveMobHunterXp.get();
        double aggresiveMobSlayerXp = Config.forgeConfig.aggresiveMobSlayerXp.get();
        boolean deathLoosesLevels = Config.forgeConfig.deathLoosesLevels.get();
        if (target instanceof ServerPlayerEntity && !(target instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            if (!player.field_70170_p.func_201670_d()) {
                Map<String, Double> xpMap = Config.getXpMap((PlayerEntity)player);
                Map<String, Double> prefsMap = Config.getPreferencesMap((PlayerEntity)player);
                double totalLost = 0.0;
                boolean wipeAllSkills = Config.forgeConfig.wipeAllSkillsUponDeathPermanently.get();
                if (prefsMap.containsKey("wipeAllSkillsUponDeathPermanently") && prefsMap.get("wipeAllSkillsUponDeathPermanently") != 0.0) {
                    wipeAllSkills = true;
                }
                if (wipeAllSkills) {
                    for (Map.Entry<String, Double> entry : new HashMap<String, Double>(xpMap).entrySet()) {
                        totalLost += entry.getValue().doubleValue();
                        xpMap.remove(entry.getKey());
                    }
                } else {
                    for (Map.Entry<String, Double> entry : new HashMap<String, Double>(xpMap).entrySet()) {
                        double lostXp;
                        double startXp = entry.getValue();
                        double floorXp = XP.xpAtLevelDecimal(Math.floor(XP.levelAtXpDecimal(startXp)));
                        double diffXp = startXp - floorXp;
                        if (deathLoosesLevels) {
                            double requiredLevel = XP.levelAtXpDecimal(startXp) * deathPenaltyMultiplier;
                            lostXp = startXp - XP.xpAtLevelDecimal(requiredLevel);
                        } else {
                            lostXp = diffXp * deathPenaltyMultiplier;
                        }
                        double finalXp = startXp - lostXp;
                        totalLost += lostXp;
                        if (finalXp > 0.0) {
                            xpMap.put(entry.getKey(), finalXp);
                            continue;
                        }
                        xpMap.remove(entry.getKey());
                    }
                }
                if (totalLost > 0.0) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.lostXp", new Object[]{DP.dprefix(totalLost)}).func_230530_a_(XP.textStyle.get("red")), false);
                }
                XP.syncPlayer((PlayerEntity)player);
            }
        } else if (source instanceof ServerPlayerEntity && !(source instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)source;
            Collection<PlayerEntity> nearbyPlayers = XP.getNearbyPlayers((Entity)target);
            double scaleValue = 0.0;
            for (PlayerEntity thePlayer : nearbyPlayers) {
                scaleValue += (double)Math.max(1.0f, XP.getPowerLevel(thePlayer.func_110124_au()));
            }
            scaleValue = Math.max(1.0, Math.min(10.0, scaleValue * 0.2));
            scaleValue *= 0.2;
            boolean registeredNBTdata = TooltipSupplier.tooltipExists(target.func_200600_R().getRegistryName(), JType.XP_VALUE_KILL);
            if (registeredNBTdata || JsonConfig.data.get((Object)JType.XP_VALUE_KILL).containsKey(target.func_70022_Q())) {
                Map<String, Double> killXp = registeredNBTdata ? XP.getXp((Entity)target, JType.XP_VALUE_KILL) : XP.getXpBypass(target.func_200600_R().getRegistryName(), JType.XP_VALUE_KILL);
                for (Map.Entry<String, Double> entry : killXp.entrySet()) {
                    XP.awardXp(player, entry.getKey(), player.func_184614_ca().func_200301_q().toString(), entry.getValue() * scaleValue, false, false, false);
                }
            } else if (target instanceof AnimalEntity) {
                XP.awardXp(player, Skill.HUNTER.toString(), player.func_184614_ca().func_200301_q().toString(), passiveMobHunterXp * scaleValue, false, false, false);
            } else if (target instanceof MobEntity) {
                XP.awardXp(player, Skill.SLAYER.toString(), player.func_184614_ca().func_200301_q().toString(), aggresiveMobSlayerXp * scaleValue, false, false, false);
            }
            if (JsonConfig.data.get((Object)JType.MOB_RARE_DROP).containsKey(target.func_70022_Q())) {
                Map<String, Double> dropTable = JsonConfig.data.get((Object)JType.MOB_RARE_DROP).get(target.func_70022_Q());
                for (Map.Entry<String, Double> entry : dropTable.entrySet()) {
                    double chance = entry.getValue();
                    if (Math.floor(Math.random() * (chance /= scaleValue)) != 0.0) continue;
                    ItemStack itemStack = new ItemStack((IItemProvider)XP.getItem(entry.getKey()));
                    XP.dropItemStack(itemStack, player.field_70170_p, target.func_213303_ch());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.rareDrop", new Object[]{new TranslationTextComponent(itemStack.func_77977_a())}).func_230530_a_(XP.textStyle.get("green")), false);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.rareDrop", new Object[]{new TranslationTextComponent(itemStack.func_77977_a())}).func_230530_a_(XP.textStyle.get("green")), true);
                }
            }
        }
    }
}

