/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class FishedHandler {
    public static double getFishPoolChance(PlayerEntity player) {
        double fishPoolBaseChance = Config.getConfig("fishPoolBaseChance");
        double fishPoolChancePerLevel = Config.getConfig("fishPoolChancePerLevel");
        double fishPoolMaxChance = Config.getConfig("fishPoolMaxChance");
        return Math.min(fishPoolMaxChance, fishPoolBaseChance + fishPoolChancePerLevel * Skill.getLevelDecimal(Skill.FISHING.toString(), player)) / 100.0;
    }

    public static void handleFished(ItemFishedEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        if (Config.forgeConfig.disableNormalFishDrops.get().booleanValue()) {
            event.setCanceled(true);
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        int startLevel = Skill.getLevel(Skill.FISHING.toString(), (PlayerEntity)player);
        NonNullList items = event.getDrops();
        double award = 10.0;
        for (ItemStack itemStack : items) {
            Map<String, Double> itemXp = XP.getXp(itemStack, JType.XP_VALUE_GENERAL);
            if (!itemXp.containsKey("fishing")) continue;
            award = itemXp.get("fishing");
        }
        Map<String, Map<String, Double>> fishPool = JsonConfig.data.get((Object)JType.FISH_POOL);
        if (fishPool != null) {
            double fishPoolChance = FishedHandler.getFishPoolChance((PlayerEntity)player);
            if (Math.random() < fishPoolChance) {
                String matchKey = null;
                HashMap<Object, Object> match = new HashMap();
                double totalWeight = FishedHandler.getTotalFishPoolWeight(startLevel);
                double currentWeight = 0.0;
                double result = Math.floor(Math.random() * (totalWeight + 1.0));
                for (Map.Entry<String, Map<String, Double>> entry : fishPool.entrySet()) {
                    double weight = FishedHandler.getFishPoolWeight(startLevel, entry.getValue());
                    if (currentWeight < result && currentWeight + weight >= result) {
                        matchKey = entry.getKey();
                        match = new HashMap<String, Double>(entry.getValue());
                        break;
                    }
                    currentWeight += weight;
                }
                if (matchKey == null) {
                    return;
                }
                Item item = XP.getItem(matchKey);
                int minCount = (int)Math.floor((Double)match.get("minCount"));
                int maxCount = (int)Math.floor((Double)match.get("maxCount"));
                int count = (int)Math.floor(Math.random() * (double)maxCount + (double)minCount);
                ItemStack itemStack = new ItemStack((IItemProvider)item, count);
                if (itemStack.func_77984_f()) {
                    itemStack.func_196085_b((int)Math.floor(Math.random() * (double)itemStack.func_77958_k()));
                }
                if (itemStack.func_77956_u()) {
                    Map<String, Map<String, Double>> enchantMap = JsonConfig.data.get((Object)JType.FISH_ENCHANT_POOL);
                    HashMap<Enchantment, Integer> outEnchants = new HashMap<Enchantment, Integer>();
                    for (Map.Entry<String, Map<String, Double>> entry : enchantMap.entrySet()) {
                        double maxEnchantLevel;
                        double levelPerLevel;
                        int potentialEnchantLevel;
                        double maxChance;
                        int itemLevelReq;
                        int enchantLevelReq;
                        int totalLevelReq;
                        Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(XP.getResLoc(entry.getKey()));
                        Map<String, Double> enchantInfo = entry.getValue();
                        if (!enchant.func_92089_a(itemStack) || startLevel < (totalLevelReq = (enchantLevelReq = (int)Math.floor(enchantInfo.get("levelReq"))) + (itemLevelReq = (int)Math.floor((Double)match.get("enchantLevelReq"))))) continue;
                        int level = startLevel - totalLevelReq;
                        double chancePerLevel = enchantInfo.get("chancePerLevel");
                        double enchantChance = chancePerLevel * (double)level;
                        if (enchantChance > (maxChance = enchantInfo.get("maxChance").doubleValue())) {
                            enchantChance = maxChance;
                        }
                        if ((double)(potentialEnchantLevel = (levelPerLevel = enchantInfo.get("levelPerLevel").doubleValue()) > 0.0 ? (int)Math.floor((double)level / levelPerLevel) : (int)Math.floor(maxEnchantLevel)) > (maxEnchantLevel = enchantInfo.get("maxLevel").doubleValue())) {
                            potentialEnchantLevel = (int)Math.floor(maxEnchantLevel);
                        }
                        int enchantLevel = 0;
                        for (int i = 0; i < potentialEnchantLevel; ++i) {
                            if (!(Math.random() * 10000.0 < enchantChance * 100.0)) continue;
                            ++enchantLevel;
                        }
                        if (enchantLevel <= 0) continue;
                        outEnchants.put(enchant, enchantLevel);
                    }
                    if (outEnchants.size() > 0) {
                        EnchantmentHelper.func_82782_a(outEnchants, (ItemStack)itemStack);
                    }
                }
                XP.dropItemStack(itemStack, player.field_70170_p, player.func_213303_ch());
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.extraFished", new Object[]{count, new TranslationTextComponent(itemStack.func_77977_a())}).func_230530_a_(XP.textStyle.get("green")), true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.extraFished", new Object[]{count, new TranslationTextComponent(itemStack.func_77977_a())}).func_230530_a_(XP.textStyle.get("green")), false);
                award += (Double)match.get("xp") * (double)count;
            }
            Vector3d bobPos = event.getHookEntity().func_213303_ch();
            Vector3d xpDropPos = new Vector3d(bobPos.func_82615_a(), bobPos.func_82617_b() + 2.0, bobPos.func_82616_c());
            WorldXpDrop xpDrop = WorldXpDrop.fromVector(XP.getDimResLoc((World)player.func_71121_q()), xpDropPos, 0.5, award, Skill.FISHING.toString());
            xpDrop.setDecaySpeed(0.2);
            XP.addWorldXpDrop(xpDrop, player);
            XP.awardXp(player, Skill.FISHING.toString(), "catching " + items, award, false, false, false);
        }
    }

    public static double getTotalFishPoolWeight(double level) {
        double totalWeight = 0.0;
        for (Map.Entry<String, Map<String, Double>> entry : JsonConfig.data.get((Object)JType.FISH_POOL).entrySet()) {
            totalWeight += FishedHandler.getFishPoolWeight(level, entry.getValue());
        }
        return totalWeight;
    }

    public static double getFishPoolWeight(double level, Map<String, Double> fishItem) {
        return Util.mapCapped(level, fishItem.get("startLevel"), fishItem.get("endLevel"), fishItem.get("startWeight"), fishItem.get("endWeight"));
    }
}

