/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FurnaceHandler {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void handleSmelted(ItemStack input, ItemStack output, World world, BlockPos pos, int type) {
        try {
            String source;
            JType xpType;
            JType infoType;
            switch (type) {
                case 0: {
                    infoType = JType.INFO_SMELT;
                    xpType = JType.XP_VALUE_SMELT;
                    source = "Smelting";
                    break;
                }
                case 1: {
                    infoType = JType.INFO_COOK;
                    xpType = JType.XP_VALUE_COOK;
                    source = "Cooking";
                    break;
                }
                default: {
                    LOGGER.error("Project MMO handleSmelted WRONG TYPE");
                    return;
                }
            }
            source = source + " " + input.func_77973_b().getRegistryName();
            source = source + " [" + XP.getDimResLoc(world).toString() + "|x" + pos.func_177958_n() + "|y" + pos.func_177956_o() + "|z" + pos.func_177952_p() + "]";
            UUID uuid = ChunkDataHandler.checkPos(world, pos);
            if (uuid != null) {
                double extraChance = XP.getExtraChance(uuid, input.func_77973_b().getRegistryName(), infoType, false) / 100.0;
                int guaranteedDrop = (int)extraChance;
                int extraDrop = XP.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop + extraDrop;
                output.func_190917_f(totalExtraDrops);
                Map<String, Double> award = XP.multiplyMapAnyDouble(XP.getXp(input, xpType), 1 + totalExtraDrops);
                for (String awardSkillName : award.keySet()) {
                    WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.523, (double)pos.func_177952_p() + 0.5, 0.4, award.get(awardSkillName), awardSkillName);
                    xpDrop.setDecaySpeed(0.25);
                    XP.addWorldXpDrop(xpDrop, uuid);
                    Skill.addXp(awardSkillName, uuid, (double)award.get(awardSkillName), source, false, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

