/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;

public class GrowHandler {
    public static void handleSaplingGrow(SaplingGrowTreeEvent event) {
        World world = (World)event.getWorld();
        BlockPos pos = event.getPos();
        ResourceLocation dimResLoc = XP.getDimResLoc(world);
        UUID uuid = ChunkDataHandler.checkPos(dimResLoc, pos);
        ChunkDataHandler.delPos(dimResLoc, pos);
        if (uuid != null) {
            ResourceLocation resLoc = event.getWorld().func_180495_p(pos).func_177230_c().getRegistryName();
            Map<String, Double> award = XP.getXpBypass(resLoc, JType.XP_VALUE_GROW);
            if (award.size() == 0) {
                award.put(Skill.FARMING.toString(), Config.forgeConfig.defaultSaplingGrowXp.get());
            }
            for (String awardSkillName : award.keySet()) {
                WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 3.046, (double)pos.func_177952_p() + 0.5, 1.5, award.get(awardSkillName), awardSkillName);
                xpDrop.setDecaySpeed(0.1);
                XP.addWorldXpDrop(xpDrop, uuid);
                Skill.addXp(awardSkillName, uuid, (double)award.get(awardSkillName), "Growing " + resLoc + " at " + pos, false, false);
            }
        }
    }

    public static void handleCropGrow(BlockEvent.CropGrowEvent.Post event) {
        World world = (World)event.getWorld();
        BlockPos pos = event.getPos();
        ResourceLocation resLoc = event.getWorld().func_180495_p(pos).func_177230_c().getRegistryName();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        UUID uuid = ChunkDataHandler.checkPos(world, pos);
        if (uuid == null && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(resLoc.toString()) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(resLoc.toString()).containsKey("growsUpwards")) {
            BlockPos tempPos = pos;
            while (world.func_180495_p(tempPos.func_177977_b()).func_177230_c().equals(block) && uuid == null) {
                tempPos = tempPos.func_177977_b();
                uuid = ChunkDataHandler.checkPos(world, tempPos);
            }
        }
        if (uuid != null) {
            int age = -1;
            int maxAge = -1;
            if (state.func_235901_b_((Property)BlockStateProperties.field_222512_Y)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_222512_Y);
                maxAge = 1;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208167_T)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208167_T);
                maxAge = 2;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208168_U)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208168_U);
                maxAge = 3;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208169_V)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208169_V);
                maxAge = 5;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208170_W)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208170_W);
                maxAge = 7;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208171_X)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208171_X);
                maxAge = 15;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208172_Y)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208172_Y);
                maxAge = 25;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208135_aj)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208135_aj);
                maxAge = 4;
            }
            if (age != -1 && age == maxAge) {
                Map<String, Double> award = XP.getXpBypass(resLoc, JType.XP_VALUE_GROW);
                if (award.size() == 0) {
                    award.put(Skill.FARMING.toString(), Config.forgeConfig.defaultCropGrowXp.get());
                }
                for (String awardSkillName : award.keySet()) {
                    WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.523, (double)pos.func_177952_p() + 0.5, 0.5, award.get(awardSkillName), awardSkillName);
                    xpDrop.setDecaySpeed(0.1);
                    XP.addWorldXpDrop(xpDrop, uuid);
                    Skill.addXp(awardSkillName, uuid, (double)award.get(awardSkillName), "Growing " + resLoc + " at " + pos, false, false);
                }
            }
        }
    }
}

