/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEvent;

public class JumpHandler {
    public static void handleJump(LivingEvent.LivingJumpEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && !(event.getEntityLiving() instanceof FakePlayer) && XP.isPlayerSurvival(player = (PlayerEntity)event.getEntityLiving())) {
            double jumpBoost = 0.0;
            if (player.func_225608_bj_()) {
                jumpBoost = JumpHandler.getCrouchJumpBoost(player);
            } else if (player.func_70051_ag()) {
                jumpBoost = JumpHandler.getSprintJumpBoost(player);
            }
            if (player.field_70170_p.field_72995_K) {
                if (jumpBoost > 0.0) {
                    player.func_70024_g(0.0, jumpBoost, 0.0);
                }
            } else if (!player.func_70090_H()) {
                double jumpAmp = 0.0;
                if (player.func_70644_a(Effects.field_76430_j)) {
                    jumpAmp = player.func_70660_b(Effects.field_76430_j).func_76458_c() + 1;
                }
                Vector3d xpDropPos = player.func_213303_ch();
                double award = Math.max((jumpBoost * 10.0 + 1.0) * (1.0 + jumpAmp / 4.0), 1.0);
                WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(player.func_130014_f_()), xpDropPos.func_82615_a(), xpDropPos.func_82617_b() + 0.523, xpDropPos.func_82616_c(), 0.15, award, Skill.AGILITY.toString());
                XP.addWorldXpDrop(xpDrop, (ServerPlayerEntity)player);
                XP.awardXp((ServerPlayerEntity)player, Skill.AGILITY.toString(), "jumping", award, true, false, false);
            }
        }
    }

    public static double getCrouchJumpBoost(PlayerEntity player) {
        double maxJumpBoost;
        Map<String, Double> prefsMap = Config.getPreferencesMap(player);
        double maxJumpBoostPref = maxJumpBoost = Config.getConfig("maxJumpBoost");
        int levelsPerCrouchJumpBoost = (int)Math.floor(Config.getConfig("levelsPerCrouchJumpBoost"));
        double agilityLevel = Skill.getLevel(Skill.AGILITY.toString(), player);
        if (prefsMap.containsKey("maxCrouchJumpBoost")) {
            maxJumpBoostPref = prefsMap.get("maxCrouchJumpBoost");
        }
        double jumpBoost = -0.011 + agilityLevel * (0.14 / (double)levelsPerCrouchJumpBoost);
        jumpBoost = Math.min(maxJumpBoostPref, Math.min(maxJumpBoost, jumpBoost));
        return jumpBoost;
    }

    public static double getSprintJumpBoost(PlayerEntity player) {
        double maxJumpBoost;
        Map<String, Double> prefsMap = Config.getPreferencesMap(player);
        double maxJumpBoostPref = maxJumpBoost = Config.getConfig("maxJumpBoost");
        int levelsPerSprintJumpBoost = (int)Math.floor(Config.getConfig("levelsPerSprintJumpBoost"));
        double agilityLevel = Skill.getLevel(Skill.AGILITY.toString(), player);
        if (prefsMap.containsKey("maxSprintJumpBoost")) {
            maxJumpBoostPref = prefsMap.get("maxSprintJumpBoost");
        }
        double jumpBoost = -0.013 + agilityLevel * (0.14 / (double)levelsPerSprintJumpBoost);
        jumpBoost = Math.min(maxJumpBoostPref, Math.min(maxJumpBoost, jumpBoost));
        return jumpBoost;
    }
}

