/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.events.SalvageEvent;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageTripleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerInteractionHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Set<Block> salvageStations = new HashSet<Block>();
    private static long lastWarning = 0L;

    public static void initSalvageStations() {
        salvageStations.clear();
        for (Map.Entry<String, Map<String, Double>> entry : JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).entrySet()) {
            if (entry.getValue().getOrDefault("salvageStation", 0.0) == 0.0) continue;
            salvageStations.add(XP.getBlock(entry.getKey()));
        }
        if (salvageStations.size() == 0) {
            salvageStations.add(Blocks.field_222429_lR);
        }
    }

    public static void handlePlayerInteract(PlayerInteractEvent event) {
        try {
            PlayerInteractEvent.EntityInteractSpecific entityInteractEvent;
            Entity target;
            Map<String, Double> reqMap;
            PlayerEntity player;
            if (event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickItem) {
                PlayerEntity player2 = event.getPlayer();
                ItemStack itemStack = event.getItemStack();
                Item item = itemStack.func_77973_b();
                if (item.getRegistryName() == null) {
                    return;
                }
                String regKey = item.getRegistryName().toString();
                boolean isRemote = player2.field_70170_p.func_201670_d();
                boolean matched = false;
                if (event instanceof PlayerInteractEvent.RightClickItem && XP.isPlayerSurvival(player2) && JsonConfig.data2.get((Object)JType.SALVAGE).containsKey(regKey)) {
                    Object salvageStationBlock;
                    Iterator<Block> iterator = salvageStations.iterator();
                    while (iterator.hasNext() && !(matched = XP.scanBlock((Block)(salvageStationBlock = iterator.next()), 1, player2))) {
                    }
                    if (matched) {
                        event.setCanceled(true);
                    }
                }
                if (item instanceof BlockItem) {
                    if (!XP.checkReq(player2, item.getRegistryName(), JType.REQ_PLACE)) {
                        event.setCanceled(true);
                        if (isRemote) {
                            player2.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToPlaceDown", new Object[]{new TranslationTextComponent(item.func_77658_a())}).func_230530_a_(XP.textStyle.get("red")), true);
                        }
                    }
                } else if (!XP.checkReq(player2, item.getRegistryName(), JType.REQ_USE)) {
                    event.setCanceled(true);
                    if (isRemote) {
                        player2.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslationTextComponent(item.func_77658_a())}).func_230530_a_(XP.textStyle.get("red")), true);
                    }
                }
                if (event instanceof PlayerInteractEvent.RightClickBlock) {
                    Block block = player2.field_70170_p.func_180495_p(event.getPos()).func_177230_c();
                    if (!XP.checkReq(player2, block.getRegistryName(), JType.REQ_USE)) {
                        if (XP.isPlayerSurvival(player2)) {
                            event.setCanceled(true);
                            if (isRemote && event.getHand().equals((Object)Hand.MAIN_HAND)) {
                                player2.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslationTextComponent(block.func_149739_a())}).func_230530_a_(XP.textStyle.get("red")), true);
                                player2.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUse", new Object[]{new TranslationTextComponent(block.func_149739_a())}).func_230530_a_(XP.textStyle.get("red")), false);
                                for (Map.Entry entry : JsonConfig.data.get((Object)JType.REQ_USE).get(block.getRegistryName().toString()).entrySet()) {
                                    double entryValue;
                                    int startLevel = Skill.getLevel((String)entry.getKey(), player2);
                                    if ((double)startLevel < (entryValue = ((Double)entry.getValue()).doubleValue())) {
                                        player2.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + (String)entry.getKey()), "" + DP.dpSoft(entryValue)}).func_230530_a_(XP.textStyle.get("red")), false);
                                        continue;
                                    }
                                    player2.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + (String)entry.getKey()), "" + DP.dpSoft(entryValue)}).func_230530_a_(XP.textStyle.get("green")), false);
                                }
                            }
                        }
                    } else {
                        event.setCanceled(false);
                        if (player2.func_213453_ef() && salvageStations.contains(block)) {
                            if (itemStack.func_190926_b()) {
                                return;
                            }
                            if (isRemote) {
                                return;
                            }
                            boolean mainCanBeSalvaged = PlayerInteractionHandler.canBeSalvaged(player2.func_184614_ca().func_77973_b());
                            boolean bl = PlayerInteractionHandler.canBeSalvaged(player2.func_184592_cb().func_77973_b());
                            if (!mainCanBeSalvaged && !bl) {
                                player2.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.cannotSalvage", new Object[]{new TranslationTextComponent(item.func_77658_a())}).func_230530_a_(XP.textStyle.get("red")), true);
                                return;
                            }
                            SalvageEvent salvageEvent = new SalvageEvent(player2, event.getPos());
                            if (MinecraftForge.EVENT_BUS.post((Event)salvageEvent)) {
                                return;
                            }
                            event.setCanceled(true);
                            if (!(XP.getHorizontalDistance(player2.func_213303_ch(), XP.blockToMiddleVec(event.getPos())) < 2.0)) {
                                player2.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.tooFarAwayToSalvage").func_230530_a_(XP.textStyle.get("red")), true);
                                return;
                            }
                            if (!XP.isPlayerSurvival(player2)) {
                                player2.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.survivalOnlyWarning").func_230530_a_(XP.textStyle.get("red")), true);
                                return;
                            }
                            PlayerInteractionHandler.salvageItem(player2, itemStack, event.getWorld(), event.getPos());
                            if ((double)Skill.getLevel(Skill.SMITHING.toString(), player2) >= Config.getConfig("dualSalvageSmithingLevelReq") && event.getHand().equals((Object)Hand.MAIN_HAND) && bl) {
                                PlayerInteractionHandler.salvageItem(player2, player2.func_184592_cb(), event.getWorld(), event.getPos());
                            }
                        }
                    }
                }
            } else if (event instanceof PlayerInteractEvent.EntityInteractSpecific && !XP.checkReq(player = event.getPlayer(), reqMap = XP.getXp(target = (entityInteractEvent = (PlayerInteractEvent.EntityInteractSpecific)event).getTarget(), JType.REQ_ENTITY_INTERACT))) {
                event.setCanceled(true);
                boolean isRemote = player.field_70170_p.func_201670_d();
                if (isRemote && System.currentTimeMillis() - lastWarning > 1523L) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToInteractWith", new Object[]{target.func_200200_C_()}).func_230530_a_(XP.textStyle.get("red")), false);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToInteractWith", new Object[]{target.func_200200_C_()}).func_230530_a_(XP.textStyle.get("red")), true);
                    XP.sendPlayerSkillList(player, reqMap);
                    lastWarning = System.currentTimeMillis();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public static void salvageItem(PlayerEntity player, ItemStack itemStack, World world, BlockPos pos) {
        Item item = itemStack.func_77973_b();
        String regKey = item.getRegistryName().toString();
        Map<String, Map<String, Double>> salvageFromItemMap = JsonConfig.data2.get((Object)JType.SALVAGE).get(regKey);
        if (salvageFromItemMap == null) {
            return;
        }
        boolean ableToSalvageAny = false;
        double award = 0.0;
        int startSmithingLevel = Skill.getLevel(Skill.SMITHING.toString(), player);
        Integer lowestReqLevel = null;
        for (Map.Entry<String, Map<String, Double>> salvageToItemEntry : salvageFromItemMap.entrySet()) {
            int smithingLevel = startSmithingLevel;
            Item salvageToItem = XP.getItem(salvageToItemEntry.getKey());
            Map<String, Double> salvageToItemMap = salvageToItemEntry.getValue();
            double baseChance = salvageToItemMap.get("baseChance");
            double chancePerLevel = salvageToItemMap.get("chancePerLevel");
            double maxSalvageMaterialChance = salvageToItemMap.get("maxChance");
            int reqLevel = (int)Math.floor(salvageToItemMap.get("levelReq"));
            int salvageMax = (int)Math.floor(salvageToItemMap.get("salvageMax"));
            smithingLevel -= reqLevel;
            if (lowestReqLevel == null || lowestReqLevel > reqLevel) {
                lowestReqLevel = reqLevel;
            }
            if (smithingLevel < 0) continue;
            ableToSalvageAny = true;
            double chance = baseChance + chancePerLevel * (double)smithingLevel;
            if (chance > maxSalvageMaterialChance) {
                chance = maxSalvageMaterialChance;
            }
            double startDmg = itemStack.func_77952_i();
            double maxDmg = itemStack.func_77958_k();
            double displayDurabilityPercent = (1.0 - startDmg / maxDmg) * 100.0;
            double durabilityPercent = 1.0 - startDmg / maxDmg;
            if (Double.isNaN(durabilityPercent)) {
                durabilityPercent = 1.0;
            }
            int potentialReturnAmount = (int)Math.floor((double)salvageMax * durabilityPercent);
            int returnAmount = 0;
            for (int i = 0; i < potentialReturnAmount; ++i) {
                if (!(Math.ceil(Math.random() * 10000.0) <= chance * 100.0)) continue;
                ++returnAmount;
            }
            award += salvageToItemMap.get("xpPerItem") * (double)returnAmount;
            if (returnAmount > 0) {
                XP.dropItems(returnAmount, salvageToItem, world, pos);
            }
            if (returnAmount == potentialReturnAmount) {
                NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageToItem.func_77658_a(), false, 1), (ServerPlayerEntity)player);
                continue;
            }
            if (returnAmount > 0) {
                NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageToItem.func_77658_a(), false, 3), (ServerPlayerEntity)player);
                continue;
            }
            NetworkHandler.sendToPlayer(new MessageTripleTranslation("pmmo.salvageMessage", "" + returnAmount, "" + potentialReturnAmount, salvageToItem.func_77658_a(), true, 2), (ServerPlayerEntity)player);
        }
        if (ableToSalvageAny) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
            double maxSalvageEnchantChance = Config.forgeConfig.maxSalvageEnchantChance.get();
            double enchantSaveChancePerLevel = Config.forgeConfig.enchantSaveChancePerLevel.get();
            double enchantChance = (double)(startSmithingLevel - lowestReqLevel) * enchantSaveChancePerLevel;
            if (enchantChance > maxSalvageEnchantChance) {
                enchantChance = maxSalvageEnchantChance;
            }
            if (enchants.size() > 0) {
                ItemStack salvagedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                Set enchantKeys = enchants.keySet();
                HashMap<Enchantment, Integer> newEnchantMap = new HashMap<Enchantment, Integer>();
                boolean fullEnchants = true;
                for (Enchantment enchant : enchantKeys) {
                    int enchantLevel = 0;
                    for (int i = 1; i <= (Integer)enchants.get(enchant); ++i) {
                        if (Math.floor(Math.random() * 100.0) < enchantChance) {
                            enchantLevel = i;
                            continue;
                        }
                        fullEnchants = false;
                    }
                    if (enchantLevel <= 0) continue;
                    newEnchantMap.put(enchant, enchantLevel);
                }
                if (newEnchantMap.size() > 0) {
                    EnchantmentHelper.func_82782_a(newEnchantMap, (ItemStack)salvagedBook);
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)salvagedBook);
                    if (fullEnchants) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.savedAllEnchants").func_230530_a_(XP.textStyle.get("green")), false);
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.savedSomeEnchants").func_230530_a_(XP.textStyle.get("yellow")), false);
                    }
                }
            }
            if (award > 0.0) {
                WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.523, (double)pos.func_177952_p() + 0.5, 0.35, award, Skill.SMITHING.toString());
                XP.addWorldXpDrop(xpDrop, (ServerPlayerEntity)player);
                XP.awardXp((ServerPlayerEntity)player, Skill.SMITHING.toString(), item.getRegistryName().toString(), award, false, false, false);
            }
            itemStack.func_190918_g(1);
            player.func_213334_d(Hand.OFF_HAND);
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.cannotSalvageLackLevelLonger", new Object[]{lowestReqLevel, new TranslationTextComponent(item.func_77658_a())}).func_230530_a_(XP.textStyle.get("red")), true);
        }
    }

    public static boolean canBeSalvaged(Item item) {
        return JsonConfig.data2.get((Object)JType.SALVAGE).containsKey(item.getRegistryName().toString());
    }
}

