/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.curios.Curios;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.gui.ScreenshotHandler;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.party.PartyPendingSystem;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.skills.CheeseTracker;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;

public class PlayerTickHandler {
    private static final Map<UUID, Long> lastAward = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> lastVeinAward = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> lastCheeseUpdate = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> hpRegen = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> sync = new HashMap<UUID, Long>();
    private static final Map<UUID, Integer> sneakCounter = new HashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> sneakTracker = new HashMap<UUID, Boolean>();
    public static boolean syncPrefs = false;
    private static int ticksSinceAttributeRefresh = 0;

    public static void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        boolean isRemote = player.field_70170_p.field_72995_K;
        if (XP.isPlayerSurvival(player) && player.func_70089_S()) {
            double gap;
            UUID uuid = player.func_110124_au();
            if (player.func_70051_ag()) {
                AttributeHandler.updateSpeed(player);
            } else {
                AttributeHandler.resetSpeed(player);
            }
            if (!player.field_70170_p.field_72995_K && ticksSinceAttributeRefresh++ >= 200) {
                ticksSinceAttributeRefresh = 0;
                for (ServerPlayerEntity otherPlayer : player.field_70170_p.func_73046_m().func_184103_al().func_181057_v()) {
                    AttributeHandler.updateAll((PlayerEntity)otherPlayer);
                }
            }
            if (!lastAward.containsKey(uuid)) {
                lastAward.put(uuid, System.nanoTime());
            }
            if (!isRemote) {
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                if (!lastVeinAward.containsKey(uuid)) {
                    lastVeinAward.put(uuid, System.nanoTime());
                }
                if (!lastCheeseUpdate.containsKey(uuid)) {
                    lastCheeseUpdate.put(uuid, System.nanoTime());
                }
                if (!hpRegen.containsKey(uuid)) {
                    hpRegen.put(uuid, System.nanoTime());
                }
                if (!sync.containsKey(uuid)) {
                    sync.put(uuid, System.nanoTime());
                }
                if (!sneakCounter.containsKey(uuid)) {
                    sneakTracker.put(uuid, player.func_225608_bj_());
                    sneakCounter.put(uuid, sneakTracker.get(uuid) != false ? 1 : 0);
                }
                int sneakCount = sneakCounter.get(uuid);
                if (player.func_225608_bj_() && !sneakTracker.get(uuid).booleanValue()) {
                    ++sneakCount;
                    if (!player.field_70170_p.field_72995_K) {
                        double award;
                        double roll = Math.random();
                        double chance = 0.01 * (double)(sneakCount - 250) / 5.0;
                        if (sneakCount > 250 && roll < chance) {
                            player.func_70097_a(DamageSource.field_82727_n, (float)Math.max(1.0, chance * 2.5));
                            System.out.println(chance);
                            if (serverPlayer.func_110143_aJ() <= 0.0f) {
                                sneakCount = 0;
                            }
                        }
                        if (sneakCount > 50 && (award = (double)(sneakCount - 50) / 200.0) > 0.0) {
                            XP.awardXp(serverPlayer, Skill.ENDURANCE.toString(), "twerking", award, true, false, false);
                        }
                    }
                }
                sneakCounter.put(uuid, sneakCount);
                sneakTracker.put(uuid, player.func_225608_bj_());
                double veinGap = (double)(System.nanoTime() - lastVeinAward.get(uuid)) / 1.0E9;
                double cheeseGap = (double)(System.nanoTime() - lastCheeseUpdate.get(uuid)) / 1.0E9;
                double hpRegenGap = (double)(System.nanoTime() - hpRegen.get(uuid)) / 1.0E9;
                double syncGap = (double)(System.nanoTime() - sync.get(uuid)) / 1.0E9;
                if (veinGap > 0.25) {
                    sneakCounter.put(uuid, Math.max(0, sneakCount - 1));
                    WorldTickHandler.updateVein(player, veinGap);
                    lastVeinAward.put(uuid, System.nanoTime());
                    if (Config.forgeConfig.antiCheeseEnabled.get().booleanValue() && cheeseGap > Config.forgeConfig.cheeseCheckFrequency.get()) {
                        CheeseTracker.trackCheese(serverPlayer);
                        lastCheeseUpdate.put(uuid, System.nanoTime());
                    }
                    if (hpRegenGap > PlayerTickHandler.getHpRegenTime(player)) {
                        float startHp = player.func_110143_aJ();
                        player.func_70691_i(1.0f);
                        XP.awardXp(serverPlayer, Skill.ENDURANCE.toString(), "Regeneration", 60.0 / PlayerTickHandler.getHpRegenTime(player) * Config.forgeConfig.hpRegenXpMultiplier.get() * (double)(player.func_110143_aJ() - startHp), true, false, false);
                        hpRegen.put(uuid, System.nanoTime());
                    }
                }
                if (syncGap > 2.5) {
                    PartyPendingSystem.sendPlayerOfflineData((ServerPlayerEntity)player);
                    sync.put(uuid, System.nanoTime());
                }
            }
            if ((gap = (double)(System.nanoTime() - lastAward.get(uuid)) / 1.0E9) > 0.5) {
                boolean nightVisionPref;
                int swimLevel = Skill.getLevel(Skill.SWIMMING.toString(), player);
                int flyLevel = Skill.getLevel(Skill.FLYING.toString(), player);
                int agilityLevel = Skill.getLevel(Skill.AGILITY.toString(), player);
                float swimAmp = EnchantmentHelper.func_185294_d((LivingEntity)player);
                float speedAmp = 0.0f;
                PlayerInventory inv = player.field_71071_by;
                XP.checkBiomeLevelReq(player);
                if (!isRemote) {
                    if (Curios.isLoaded()) {
                        Curios.getCurios(player).forEach(value -> {
                            for (int i = 0; i < value.getSlots(); ++i) {
                                XP.applyWornPenalty(player, value.getStacks().getStackInSlot(i));
                            }
                        });
                    }
                    if (!inv.func_70301_a(39).func_190926_b()) {
                        XP.applyWornPenalty(player, player.field_71071_by.func_70301_a(39));
                    }
                    if (!inv.func_70301_a(38).func_190926_b()) {
                        XP.applyWornPenalty(player, player.field_71071_by.func_70301_a(38));
                    }
                    if (!inv.func_70301_a(37).func_190926_b()) {
                        XP.applyWornPenalty(player, player.field_71071_by.func_70301_a(37));
                    }
                    if (!inv.func_70301_a(36).func_190926_b()) {
                        XP.applyWornPenalty(player, player.field_71071_by.func_70301_a(36));
                    }
                    if (!player.func_184614_ca().func_190926_b()) {
                        XP.applyEnchantmentUsePenalty(player, player.func_184614_ca());
                    }
                    if (!player.func_184592_cb().func_190926_b()) {
                        XP.applyWornPenalty(player, player.func_184592_cb());
                        XP.applyEnchantmentUsePenalty(player, player.func_184592_cb());
                    }
                }
                if (player.func_70644_a(Effects.field_76424_c)) {
                    speedAmp = player.func_70660_b(Effects.field_76424_c).func_76458_c() + 1;
                }
                double swimAward = (3.0 + (double)swimLevel / 10.0) * gap * (1.0 + (double)swimAmp / 4.0);
                double flyAward = (1.0 + (double)flyLevel / 30.77) * gap;
                double runAward = (1.0 + (double)agilityLevel / 30.77) * gap * (1.0 + (double)speedAmp / 4.0);
                if (!player.field_70133_I) {
                    swimAward *= 0.1;
                }
                lastAward.replace(uuid, System.nanoTime());
                Block waterBlock = Blocks.field_150355_j;
                Block tallSeagrassBlock = Blocks.field_203199_aR;
                Block kelpBlock = Blocks.field_203215_jy;
                BlockPos playerPos = XP.vecToBlock(player.func_213303_ch());
                boolean waterBelow = true;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        Block currBlock = player.func_130014_f_().func_180495_p(playerPos.func_177977_b().func_177965_g(i).func_177964_d(j)).func_177230_c();
                        if (currBlock.equals(waterBlock) || currBlock.equals(tallSeagrassBlock) || currBlock.equals(kelpBlock)) continue;
                        waterBelow = false;
                    }
                }
                boolean waterAbove = player.func_130014_f_().func_180495_p(playerPos.func_177984_a()).func_177230_c().equals(waterBlock);
                boolean bl = nightVisionPref = Config.getPreferencesMap(player).getOrDefault("underwaterNightVision", 1.0) == 1.0;
                if (nightVisionPref && XP.isNightvisionUnlocked(player) && XP.isNightvisionUnlocked(player) && player.func_70090_H() && waterAbove) {
                    player.func_195064_c(new EffectInstance(Effects.field_76439_r, 300, 0, false, false));
                }
                if (!isRemote) {
                    WorldXpDrop xpDrop;
                    ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                    ServerWorld world = serverPlayer.func_71121_q();
                    Vector3d xpDropPos = player.func_213303_ch();
                    if (player.func_70051_ag()) {
                        if (player.func_70090_H() && (waterAbove || waterBelow)) {
                            xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)world), xpDropPos.func_82615_a(), xpDropPos.func_82617_b(), xpDropPos.func_82616_c(), 0.35, swimAward, Skill.SWIMMING.toString());
                            XP.addWorldXpDrop(xpDrop, serverPlayer);
                            XP.awardXp(serverPlayer, Skill.SWIMMING.toString(), "swimming fast", swimAward * 1.25, true, false, false);
                        } else {
                            xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)world), xpDropPos.func_82615_a(), xpDropPos.func_82617_b() + 0.523, xpDropPos.func_82616_c(), 0.15, runAward, Skill.AGILITY.toString());
                            XP.addWorldXpDrop(xpDrop, serverPlayer);
                            XP.awardXp(serverPlayer, Skill.AGILITY.toString(), "running", runAward, true, false, false);
                        }
                    }
                    if (player.func_70090_H() && (waterAbove || waterBelow || player.func_208600_a((ITag)FluidTags.field_206959_a))) {
                        if (!player.func_70051_ag()) {
                            xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)world), xpDropPos.func_82615_a(), xpDropPos.func_82617_b(), xpDropPos.func_82616_c(), 0.35, swimAward, Skill.SWIMMING.toString());
                            XP.addWorldXpDrop(xpDrop, serverPlayer);
                            XP.awardXp(serverPlayer, Skill.SWIMMING.toString(), "swimming", swimAward, true, false, false);
                        }
                    } else if (player.func_184613_cA()) {
                        xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)world), xpDropPos.func_82615_a(), xpDropPos.func_82617_b(), xpDropPos.func_82616_c(), 0.35, flyAward, Skill.FLYING.toString());
                        XP.addWorldXpDrop(xpDrop, serverPlayer);
                        XP.awardXp(serverPlayer, Skill.FLYING.toString(), "flying", flyAward, true, false, false);
                    }
                    if (player.func_184187_bx() instanceof BoatEntity && waterBelow) {
                        if (!player.func_70051_ag()) {
                            swimAward *= 1.5;
                        }
                        xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)world), xpDropPos.func_82615_a(), xpDropPos.func_82617_b(), xpDropPos.func_82616_c(), 0.35, swimAward, Skill.SWIMMING.toString());
                        XP.addWorldXpDrop(xpDrop, serverPlayer);
                        XP.awardXp(serverPlayer, Skill.SAILING.toString(), "Sailing", swimAward, true, false, false);
                    }
                }
            }
        }
        if (isRemote) {
            if (XPOverlayGUI.screenshots.size() > 0) {
                for (String key : new HashSet<String>(XPOverlayGUI.screenshots)) {
                    ScreenshotHandler.takeScreenshot(key, "levelup");
                    XPOverlayGUI.screenshots.remove(key);
                    XPOverlayGUI.listOn = XPOverlayGUI.listWasOn;
                }
            }
            if (syncPrefs) {
                ClientHandler.syncPrefsToServer();
                syncPrefs = false;
            }
        }
    }

    public static double getHpRegenTime(PlayerEntity player) {
        double dividend = Config.getConfig("hpRegenPerMinuteBase") + (double)Skill.getLevel(Skill.ENDURANCE.toString(), player) * Config.getConfig("hpRegenPerMinuteBoostPerLevel");
        return dividend <= 0.0 ? Double.POSITIVE_INFINITY : 60.0 / dividend;
    }
}

