/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.TooltipSupplier;
import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TooltipHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean tooltipOn = true;
    private static String lastKey = "";
    private static int salvageFromArrayPos = 0;
    private static int salvageFromArrayLength;
    private static int salvageToArrayPos;
    private static int salvageToArrayLength;
    private static int treasureFromArrayPos;
    private static int treasureFromArrayLength;
    private static int treasureToArrayPos;
    private static int treasureToArrayLength;
    private static long lastTime;
    private static Object[] salvageFromArray;
    private static Object[] salvageToArray;
    private static Object[] treasureFromArray;
    private static Object[] treasureToArray;

    public static void handleTooltip(ItemTooltipEvent event) {
        block96: {
            try {
                String key;
                Map<String, Double> salvageToItemMap;
                int level;
                double dValue;
                BlockState state;
                if (!tooltipOn) {
                    return;
                }
                PlayerEntity player = event.getPlayer();
                if (player == null) break block96;
                ItemStack itemStack = event.getItemStack();
                Item item = itemStack.func_77973_b();
                List tooltip = event.getToolTip();
                if (item.getRegistryName() == null) {
                    return;
                }
                String regKey = item.getRegistryName().toString();
                BlockState blockState = state = item instanceof BlockItem ? ((BlockItem)item).func_179223_d().func_176223_P() : null;
                if (ClientHandler.OPEN_MENU.func_151470_d()) {
                    GlossaryScreen.setButtonsToKey(regKey);
                    Minecraft.func_71410_x().func_147108_a((Screen)new GlossaryScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au(), (ITextComponent)new TranslationTextComponent("pmmo.glossary"), false));
                    return;
                }
                Map<String, Double> craftReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_CRAFT, itemStack);
                Map<String, Double> wearReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_WEAR, itemStack);
                Map<String, Double> toolReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_TOOL, itemStack);
                Map<String, Double> weaponReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_WEAPON, itemStack);
                Map<String, Double> useReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_USE, itemStack);
                Map<String, Double> useEnchantmentReq = XP.getEnchantsUseReq(itemStack);
                Map<String, Double> placeReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_PLACE, itemStack);
                Map<String, Double> breakReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_BREAK, itemStack);
                Map<String, Double> xpValueGeneral = JsonConfig.data.get((Object)JType.XP_VALUE_GENERAL).get(regKey);
                Map<String, Double> xpValueBreaking = JsonConfig.data.get((Object)JType.XP_VALUE_BREAK).get(regKey);
                Map<String, Double> xpValueCrafting = JsonConfig.data.get((Object)JType.XP_VALUE_CRAFT).get(regKey);
                Map<String, Double> xpValueSmelting = JsonConfig.data.get((Object)JType.XP_VALUE_SMELT).get(regKey);
                Map<String, Double> xpValueCooking = JsonConfig.data.get((Object)JType.XP_VALUE_COOK).get(regKey);
                Map<String, Double> xpValueBrewing = JsonConfig.data.get((Object)JType.XP_VALUE_BREW).get(regKey);
                Map<String, Double> xpValueGrowing = JsonConfig.data.get((Object)JType.XP_VALUE_GROW).get(regKey);
                Map<String, Double> xpValuePlacing = JsonConfig.data.get((Object)JType.XP_VALUE_PLACE).get(regKey);
                Map<String, Map<String, Double>> salvageInfo = JsonConfig.data2.get((Object)JType.SALVAGE).get(regKey);
                Map<String, Map<String, Double>> salvageFrom = JsonConfig.data2.get((Object)JType.SALVAGE_FROM).get(regKey);
                Map<String, Map<String, Double>> treasureInfo = JsonConfig.data2.get((Object)JType.TREASURE).get(regKey);
                Map<String, Map<String, Double>> treasureFromInfo = JsonConfig.data2.get((Object)JType.TREASURE_FROM).get(regKey);
                Map<String, Double> heldItemXpBoost = XP.getStackXpBoosts(itemStack, true);
                Map<String, Double> wornItemXpBoost = XP.getStackXpBoosts(itemStack, false);
                if (Config.getConfig("autoGenerateValuesEnabled") != 0.0) {
                    double dynReq;
                    if (Config.getConfig("autoGenerateWearReqDynamicallyEnabled") != 0.0) {
                        if (wearReq == null) {
                            wearReq = new HashMap<String, Double>();
                        }
                        String wearReqSkill = Config.getConfig("autoGenerateWearReqAsCombat") != 0.0 ? Skill.COMBAT.toString() : Skill.ENDURANCE.toString();
                        dynReq = AutoValues.getWearReqFromStack(itemStack) + XP.getJsonMap(regKey, JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetWear", 0.0);
                        if (dynReq > 0.0 && !wearReq.containsKey(wearReqSkill) && Config.getConfig("wearReqEnabled") != 0.0 && wearReq.getOrDefault(wearReqSkill, 0.0) < dynReq) {
                            wearReq.put(wearReqSkill, dynReq);
                        }
                    }
                    Iterator<String> itemSpecificSkill = AutoValues.getItemSpecificSkillOrDefault(regKey, Skill.COMBAT.toString());
                    if (Config.getConfig("weaponReqEnabled") != 0.0 && Config.getConfig("autoGenerateWeaponReqDynamicallyEnabled") != 0.0) {
                        if (weaponReq == null) {
                            weaponReq = new HashMap<String, Double>();
                        }
                        if ((dynReq = AutoValues.getWeaponReqFromStack(itemStack) + XP.getJsonMap(regKey, JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetWeapon", 0.0)) > 0.0 && !weaponReq.containsKey(itemSpecificSkill)) {
                            weaponReq.put((String)((Object)itemSpecificSkill), dynReq);
                        }
                    }
                    if (Config.getConfig("toolReqEnabled") != 0.0 && Config.getConfig("autoGenerateToolReqDynamicallyEnabled") != 0.0) {
                        if (toolReq == null) {
                            toolReq = new HashMap<String, Double>();
                        }
                        Map<String, Double> dynToolReqMap = AutoValues.getToolReqFromStack(itemStack);
                        for (Map.Entry<String, Double> entry : dynToolReqMap.entrySet()) {
                            double dynReq2 = entry.getValue() + XP.getJsonMap(regKey, JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetTool", 0.0);
                            if (!(dynReq2 > 0.0) || toolReq.containsKey(entry.getKey())) continue;
                            toolReq.put(entry.getKey(), dynReq2);
                        }
                    }
                }
                if (xpValueGeneral != null && xpValueGeneral.size() > 0) {
                    tooltip.add(new TranslationTextComponent("pmmo.xpValue"));
                    for (String key2 : xpValueGeneral.keySet()) {
                        dValue = xpValueGeneral.get(key2);
                        tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key2).getString(), DP.dp(dValue)}).func_230530_a_(Skill.getSkillStyle(key2)));
                    }
                }
                if (xpValueBreaking != null && xpValueBreaking.size() > 0) {
                    tooltip.add(new TranslationTextComponent("pmmo.xpValueBreak"));
                    for (String key3 : xpValueBreaking.keySet()) {
                        dValue = xpValueBreaking.get(key3);
                        tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key3).getString(), DP.dp(dValue)}).func_230530_a_(Skill.getSkillStyle(key3)));
                    }
                }
                if (xpValueCrafting != null && xpValueCrafting.size() > 0) {
                    tooltip.add(new TranslationTextComponent("pmmo.xpValueCraft"));
                    for (String key4 : xpValueCrafting.keySet()) {
                        dValue = xpValueCrafting.get(key4);
                        tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key4).getString(), DP.dp(dValue)}).func_230530_a_(Skill.getSkillStyle(key4)));
                    }
                }
                if (xpValueSmelting != null && xpValueSmelting.size() > 0) {
                    tooltip.add(new TranslationTextComponent("pmmo.xpValueSmelt"));
                    for (String key5 : xpValueSmelting.keySet()) {
                        dValue = xpValueSmelting.get(key5);
                        tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key5).getString(), DP.dp(dValue)}).func_230530_a_(Skill.getSkillStyle(key5)));
                    }
                }
                if (xpValueCooking != null && xpValueCooking.size() > 0) {
                    tooltip.add(new TranslationTextComponent("pmmo.xpValueCook"));
                    for (String key6 : xpValueCooking.keySet()) {
                        dValue = xpValueCooking.get(key6);
                        tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key6).getString(), DP.dp(dValue)}).func_230530_a_(Skill.getSkillStyle(key6)));
                    }
                }
                if (xpValueBrewing != null && xpValueBrewing.size() > 0) {
                    tooltip.add(new TranslationTextComponent("pmmo.xpValueBrew"));
                    for (String key7 : xpValueBrewing.keySet()) {
                        dValue = xpValueBrewing.get(key7);
                        tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key7).getString(), DP.dp(dValue)}).func_230530_a_(Skill.getSkillStyle(key7)));
                    }
                }
                if (xpValueGrowing != null && xpValueGrowing.size() > 0) {
                    tooltip.add(new TranslationTextComponent("pmmo.xpValueGrow"));
                    for (String key8 : xpValueGrowing.keySet()) {
                        dValue = xpValueGrowing.get(key8);
                        tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key8).getString(), DP.dp(dValue)}).func_230530_a_(Skill.getSkillStyle(key8)));
                    }
                }
                if (xpValuePlacing != null && xpValuePlacing.size() > 0) {
                    tooltip.add(new TranslationTextComponent("pmmo.xpValuePlace"));
                    for (String key9 : xpValuePlacing.keySet()) {
                        dValue = xpValuePlacing.get(key9);
                        tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key9).getString(), DP.dp(dValue)}).func_230530_a_(Skill.getSkillStyle(key9)));
                    }
                }
                if (craftReq != null && craftReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.toCraft", craftReq, event);
                }
                if (wearReq != null && wearReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.toWear", wearReq, event);
                }
                if (heldItemXpBoost != null && heldItemXpBoost.size() > 0) {
                    heldItemXpBoost = new HashMap<String, Double>(heldItemXpBoost);
                    TooltipHandler.addTooltipTextSkillPercentage("pmmo.itemXpBoostHeld", heldItemXpBoost, event);
                }
                if (wornItemXpBoost != null && wornItemXpBoost.size() > 0) {
                    wornItemXpBoost = new HashMap<String, Double>(wornItemXpBoost);
                    TooltipHandler.addTooltipTextSkillPercentage("pmmo.itemXpBoostWorn", wornItemXpBoost, event);
                }
                if (toolReq != null && toolReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.tool", toolReq, event);
                }
                if (weaponReq != null && weaponReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.weapon", weaponReq, event);
                }
                if (useReq != null && useReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.use", useReq, event);
                }
                if (useEnchantmentReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.enchantReq", useEnchantmentReq, event);
                }
                if (placeReq != null && placeReq.size() > 0) {
                    if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(item.getRegistryName().toString()) || item instanceof IPlantable) {
                        TooltipHandler.addTooltipTextSkill("pmmo.plant", placeReq, event);
                    } else {
                        TooltipHandler.addTooltipTextSkill("pmmo.place", placeReq, event);
                    }
                }
                if (breakReq != null && breakReq.size() > 0) {
                    if (state != null && XP.getHarvestTool(state).equals("axe")) {
                        TooltipHandler.addTooltipTextSkill("pmmo.chop", breakReq, event);
                    } else if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(item.getRegistryName().toString()) || item instanceof IPlantable) {
                        TooltipHandler.addTooltipTextSkill("pmmo.harvest", breakReq, event);
                    } else {
                        TooltipHandler.addTooltipTextSkill("pmmo.break", breakReq, event);
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_ORE).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_ORE).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_ORE, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslationTextComponent("pmmo.oreExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_230530_a_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslationTextComponent("pmmo.oreExtraDrop", new Object[]{0}).func_230530_a_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_LOG).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_LOG).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_LOG, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslationTextComponent("pmmo.logExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_230530_a_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslationTextComponent("pmmo.logExtraDrop", new Object[]{0}).func_230530_a_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_PLANT).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_PLANT, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslationTextComponent("pmmo.plantExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_230530_a_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslationTextComponent("pmmo.plantExtraDrop", new Object[]{0}).func_230530_a_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_SMELT).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_SMELT).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_SMELT, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslationTextComponent("pmmo.smeltExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_230530_a_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslationTextComponent("pmmo.smeltExtraDrop", new Object[]{0}).func_230530_a_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_COOK).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_COOK).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_COOK, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslationTextComponent("pmmo.cookExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_230530_a_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslationTextComponent("pmmo.cookExtraDrop", new Object[]{0}).func_230530_a_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_BREW).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_BREW).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.func_110124_au(), item.getRegistryName(), JType.INFO_BREW, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslationTextComponent("pmmo.brewExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).func_230530_a_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslationTextComponent("pmmo.brewExtraDrop", new Object[]{0}).func_230530_a_(XP.textStyle.get("red")));
                    }
                }
                if (System.nanoTime() - lastTime > 900000000L) {
                    lastTime = System.nanoTime();
                    if (++salvageToArrayPos >= salvageToArrayLength) {
                        salvageToArrayPos = 0;
                    }
                    if (++salvageFromArrayPos >= salvageFromArrayLength) {
                        salvageFromArrayPos = 0;
                    }
                    if (++treasureToArrayPos >= treasureToArrayLength) {
                        treasureToArrayPos = 0;
                    }
                    if (++treasureFromArrayPos >= treasureFromArrayLength) {
                        treasureFromArrayPos = 0;
                    }
                }
                if (!lastKey.equals(regKey)) {
                    if (salvageInfo != null) {
                        salvageToArray = salvageInfo.keySet().toArray();
                        salvageToArrayLength = salvageToArray.length;
                        salvageToArrayPos = 0;
                    }
                    if (salvageFrom != null) {
                        salvageFromArray = salvageFrom.keySet().toArray();
                        salvageFromArrayLength = salvageFromArray.length;
                        salvageFromArrayPos = 0;
                    }
                    if (treasureInfo != null) {
                        treasureToArray = treasureInfo.keySet().toArray();
                        treasureToArrayLength = treasureToArray.length;
                        treasureToArrayPos = 0;
                    }
                    if (treasureFromInfo != null) {
                        treasureFromArray = treasureFromInfo.keySet().toArray();
                        treasureFromArrayLength = treasureFromArray.length;
                        treasureFromArrayPos = 0;
                    }
                    lastKey = regKey;
                }
                if (salvageInfo != null && salvageInfo.size() > 0) {
                    try {
                        level = Skill.getLevel(Skill.SMITHING.toString(), player);
                        String key10 = (String)salvageToArray[salvageToArrayPos];
                        salvageToItemMap = salvageInfo.get(key10);
                        int reqLevel = (int)Math.floor(salvageToItemMap.get("levelReq"));
                        int finalLevel = level - reqLevel;
                        double baseChance = salvageToItemMap.get("baseChance");
                        double xpPerItem = salvageToItemMap.get("xpPerItem");
                        double chancePerLevel = salvageToItemMap.get("chancePerLevel");
                        double maxSalvageMaterialChance = salvageToItemMap.get("maxChance");
                        double chance = baseChance + chancePerLevel * (double)finalLevel;
                        if (chance > maxSalvageMaterialChance) {
                            chance = maxSalvageMaterialChance;
                        }
                        int salvageMax = (int)Math.floor(salvageToItemMap.get("salvageMax"));
                        double durabilityPercent = 1.0 - (double)itemStack.func_77952_i() / (double)itemStack.func_77958_k();
                        if (Double.isNaN(durabilityPercent)) {
                            durabilityPercent = 1.0;
                        }
                        int potentialReturnAmount = (int)Math.floor((double)salvageMax * durabilityPercent);
                        Item salvageItem = XP.getItem(key10);
                        if (finalLevel < 0) {
                            tooltip.add(new TranslationTextComponent("pmmo.cannotSalvageLackLevel", new Object[]{reqLevel}).func_230530_a_(XP.textStyle.get("red")));
                        } else {
                            tooltip.add(new TranslationTextComponent("pmmo.salvagesIntoCountItem", new Object[]{potentialReturnAmount, new TranslationTextComponent(salvageItem.func_77658_a())}).func_230530_a_(XP.textStyle.get(potentialReturnAmount > 0 ? "green" : "red")));
                            tooltip.add(new TranslationTextComponent("pmmo.xpEachChanceEach", new Object[]{" " + DP.dp(xpPerItem), DP.dp(chance)}).func_230530_a_(XP.textStyle.get(chance > 0.0 ? "green" : "red")));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                }
                if (salvageFrom != null) {
                    try {
                        tooltip.add(new TranslationTextComponent("pmmo.canBeSalvagedFrom").func_230530_a_(XP.textStyle.get("green")));
                        level = Skill.getLevel(Skill.SMITHING.toString(), player);
                        key = (String)salvageFromArray[salvageFromArrayPos];
                        String displayName = new TranslationTextComponent(XP.getItem(key).func_77658_a()).getString();
                        Map<String, Double> salvageFromMap = salvageFrom.get(key);
                        tooltip.add(new TranslationTextComponent("pmmo.valueFromValue", new Object[]{" " + (int)salvageFromMap.get("salvageMax").doubleValue(), displayName}).func_230530_a_(XP.textStyle.get(salvageFromMap.get("levelReq") > (double)level ? "red" : "green")));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                }
                if (treasureInfo != null && treasureInfo.size() > 0) {
                    try {
                        level = Skill.getLevel(Skill.EXCAVATION.toString(), player);
                        String key11 = (String)treasureToArray[treasureToArrayPos];
                        salvageToItemMap = treasureInfo.get(key11);
                        double chance = Util.mapCapped(level, salvageToItemMap.get("startLevel"), salvageToItemMap.get("endLevel"), salvageToItemMap.get("startChance"), salvageToItemMap.get("endChance"));
                        double xpPerItem = salvageToItemMap.get("xpPerItem");
                        String itemName = new TranslationTextComponent(XP.getItem(key11).func_77658_a()).getString();
                        int minCount = (int)salvageToItemMap.get("minCount").doubleValue();
                        int maxCount = (int)salvageToItemMap.get("maxCount").doubleValue();
                        if (chance > 100.0) {
                            chance = 100.0;
                        }
                        if (chance <= 0.0) {
                            chance = 0.0;
                        }
                        tooltip.add(new TranslationTextComponent("pmmo.containsCountItemTreasure", new Object[]{minCount == maxCount ? Integer.valueOf(minCount) : minCount + "-" + maxCount, itemName}).func_230530_a_(XP.textStyle.get("green")));
                        tooltip.add(new TranslationTextComponent("pmmo.xpEachChance", new Object[]{" " + DP.dp(xpPerItem), DP.dp(chance)}).func_230530_a_(XP.textStyle.get(chance > 0.0 ? "green" : "red")));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                }
                if (treasureFromInfo != null) {
                    try {
                        tooltip.add(new TranslationTextComponent("pmmo.treasureFrom").func_230530_a_(XP.textStyle.get("green")));
                        level = Skill.getLevel(Skill.EXCAVATION.toString(), player);
                        key = (String)treasureFromArray[treasureFromArrayPos];
                        String displayName = new TranslationTextComponent(XP.getItem(key).func_77658_a()).getString();
                        Map<String, Double> treasureFromMap = treasureFromInfo.get(key);
                        Map<String, Double> treasureToMap = JsonConfig.data2.get((Object)JType.TREASURE).get(key).get(regKey);
                        int minCount = (int)treasureFromMap.get("minCount").doubleValue();
                        int maxCount = (int)treasureFromMap.get("maxCount").doubleValue();
                        double chance = Util.mapCapped(level, treasureToMap.get("startLevel"), treasureToMap.get("endLevel"), treasureToMap.get("startChance"), treasureToMap.get("endChance"));
                        tooltip.add(new TranslationTextComponent("pmmo.valueFromValue", new Object[]{" " + (minCount == maxCount ? Integer.valueOf(minCount) : minCount + "-" + maxCount), displayName}).func_230530_a_(XP.textStyle.get(chance > 0.0 ? "green" : "red")));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                }
                if (event.getFlags().func_194127_a()) {
                    float hardness;
                    for (ResourceLocation tagKey : item.getTags()) {
                        tooltip.add(new StringTextComponent("#" + tagKey.toString()).func_230530_a_(XP.getColorStyle(0x666666)));
                    }
                    if (state != null && (hardness = state.func_185887_b(null, new BlockPos(0, 0, 0))) > 0.0f) {
                        tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo.hardness", new Object[]{DP.dp(Float.valueOf(hardness))}).getString()}));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void addTooltipTextSkill(String tKey, Map<String, Double> theMap, ItemTooltipEvent event) {
        PlayerEntity player = event.getPlayer();
        List tooltip = event.getToolTip();
        if (theMap.size() > 0) {
            tooltip.add(new TranslationTextComponent(tKey).func_230530_a_(XP.textStyle.get(XP.checkReq(player, theMap) ? "green" : "red")));
            for (String key : theMap.keySet()) {
                double value = theMap.get(key);
                if (!(value > 1.0)) continue;
                double level = Skill.getLevel(key, player);
                tooltip.add(new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + key).getString(), DP.dpSoft(value)}).func_230530_a_(XP.textStyle.get(level < value ? "red" : "green")));
            }
        }
    }

    private static void addTooltipTextSkillPercentage(String tKey, Map<String, Double> theMap, ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        if (theMap.size() > 0) {
            tooltip.add(new TranslationTextComponent(tKey).func_230530_a_(XP.textStyle.get("green")));
            for (String key : theMap.keySet()) {
                double value = theMap.get(key);
                if (value < 0.0) {
                    tooltip.add(new TranslationTextComponent("pmmo.levelDisplayPercentage", new Object[]{" " + DP.dp(value), new TranslationTextComponent("pmmo." + key).getString()}).func_230530_a_(XP.textStyle.get("red")));
                    continue;
                }
                tooltip.add(new TranslationTextComponent("pmmo.levelDisplayPercentage", new Object[]{" +" + DP.dp(value), new TranslationTextComponent("pmmo." + key).getString()}).func_230530_a_(Skill.getSkillStyle(key)));
            }
        }
    }

    static {
        salvageToArrayPos = 0;
        treasureFromArrayPos = 0;
        treasureToArrayPos = 0;
        lastTime = System.nanoTime();
    }
}

