/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.ftb_quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import harmonised.pmmo.ftb_quests.FTBQHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LevelReward
extends Reward {
    public static RewardType LEVEL_REWARD = FTBQHandler.LEVEL_REWARD;
    public String skill = "mining";
    public double amount = 1.0;
    public boolean ignoreBonuses = false;

    public LevelReward(Quest quest) {
        super(quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    public RewardType getType() {
        return LEVEL_REWARD;
    }

    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("skill", this.skill);
        nbt.func_74780_a("amount", this.amount);
    }

    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.skill = nbt.func_74779_i("skill");
        this.amount = nbt.func_74769_h("amount");
    }

    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_180714_a(this.skill);
        buffer.writeDouble(this.amount);
    }

    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.skill = buffer.func_218666_n();
        this.amount = buffer.readDouble();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = (String)input;
        }, NameMap.of((Object)Skill.MINING.toString(), (Object[])Skill.getSkills().keySet().toArray()).create());
        config.addDouble("amount", this.amount, input -> {
            this.amount = input;
        }, 1.0, -XP.getMaxLevel(), XP.getMaxLevel());
    }

    public void claim(ServerPlayerEntity player, boolean notify) {
        Skill.addLevel(this.skill, player.func_110124_au(), this.amount, "Completing a Quest", !notify, this.ignoreBonuses);
    }

    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("pmmo." + this.skill).func_230530_a_(Skill.getSkillStyle(this.skill));
    }
}

