/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.ftb_quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import harmonised.pmmo.ftb_quests.FTBQHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkillTask
extends Task {
    public static TaskType SKILL = FTBQHandler.SKILL;
    public String skill = Skill.MINING.toString();
    public double requiredLevel = 1.0;

    public SkillTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return SKILL;
    }

    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("skill", this.skill);
        nbt.func_74780_a("requiredLevel", this.requiredLevel);
    }

    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.skill = nbt.func_74779_i("skill");
        this.requiredLevel = nbt.func_74769_h("requiredLevel");
    }

    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.skill, Short.MAX_VALUE);
        buffer.writeDouble(this.requiredLevel);
    }

    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.skill = buffer.func_150789_c(Short.MAX_VALUE);
        this.requiredLevel = buffer.readDouble();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = (String)input;
        }, NameMap.of((Object)Skill.MINING.toString(), (Object[])Skill.getSkills().keySet().toArray()).create());
        config.addDouble("requiredLevel", this.requiredLevel, input -> {
            this.requiredLevel = input;
        }, this.requiredLevel, 1.0, XP.getMaxLevel());
    }

    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent(this.skill).func_230530_a_(XP.textStyle.get("dark_green"));
    }

    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    public void submitTask(TeamData teamData, ServerPlayerEntity player, ItemStack craftedItem) {
        if (teamData.isCompleted((QuestObject)this)) {
            return;
        }
        teamData.setProgress((Task)this, (long)Skill.getLevel(this.skill, (PlayerEntity)player));
    }

    public long getMaxProgress() {
        return (long)this.requiredLevel;
    }
}

