/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.ftb_quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.ftb_quests.FTBQHandler;
import harmonised.pmmo.skills.Skill;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XpReward
extends Reward {
    public static RewardType XP_REWARD = FTBQHandler.XP_REWARD;
    public String skill = "mining";
    public double amount = 83.0;
    public boolean ignoreBonuses = false;

    public XpReward(Quest quest) {
        super(quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    public RewardType getType() {
        return XP_REWARD;
    }

    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("skill", this.skill);
        nbt.func_74780_a("amount", this.amount);
        nbt.func_74757_a("ignoreBonuses", this.ignoreBonuses);
    }

    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.skill = nbt.func_74779_i("skill");
        this.amount = nbt.func_74769_h("amount");
        this.ignoreBonuses = nbt.func_74767_n("ignoreBonuses");
    }

    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_180714_a(this.skill);
        buffer.writeDouble(this.amount);
        buffer.writeBoolean(this.ignoreBonuses);
    }

    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.skill = buffer.func_218666_n();
        this.amount = buffer.readDouble();
        this.ignoreBonuses = buffer.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = (String)input;
        }, NameMap.of((Object)Skill.MINING.toString(), (Object[])Skill.getSkills().keySet().toArray()).create());
        config.addDouble("amount", this.amount, input -> {
            this.amount = input;
        }, 1.0, -Config.getConfig("maxXp"), Config.getConfig("maxXp"));
        config.addBool("ignoreBonuses", this.ignoreBonuses, v -> {
            this.ignoreBonuses = v;
        }, false).setNameKey("pmmo.ignoreBonuses");
    }

    public void claim(ServerPlayerEntity player, boolean notify) {
        Skill.addXp(this.skill, player.func_110124_au(), this.amount, "Completing a Quest", !notify, this.ignoreBonuses);
    }

    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("pmmo." + this.skill).func_230530_a_(Skill.getSkillStyle(this.skill));
    }
}

