/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ListButton
extends Button {
    private final ResourceLocation items = XP.getResLoc("pmmo", "textures/gui/items.png");
    private final ResourceLocation buttons = XP.getResLoc("pmmo", "textures/gui/buttons.png");
    public int elementOne;
    public int elementTwo;
    public int offsetOne;
    public int offsetTwo;
    public double mobWidth;
    public double mobHeight;
    public double mobScale;
    public boolean unlocked = true;
    public ItemStack itemStack;
    public String regKey;
    public String title;
    public String buttonText;
    public List<ITextComponent> text = new ArrayList<ITextComponent>();
    public List<ITextComponent> tooltipText = new ArrayList<ITextComponent>();
    Entity testEntity = null;
    LivingEntity entity = null;
    ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
    Minecraft minecraft = Minecraft.func_71410_x();

    public ListButton(int posX, int posY, int elementOne, int elementTwo, String regKey, JType jType, String buttonText, Button.IPressable onPress) {
        super(posX, posY, 32, 32, (ITextComponent)new TranslationTextComponent(""), onPress);
        this.regKey = regKey;
        this.buttonText = buttonText;
        this.itemStack = new ItemStack((IItemProvider)XP.getItem(regKey));
        this.elementOne = elementOne * 32;
        this.elementTwo = elementTwo * 32;
        if (ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(regKey))) {
            this.testEntity = ((EntityType)ForgeRegistries.ENTITIES.getValue(XP.getResLoc(regKey))).func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        }
        if (this.testEntity instanceof LivingEntity) {
            this.entity = (LivingEntity)this.testEntity;
        }
        switch (jType) {
            case FISH_ENCHANT_POOL: {
                this.title = new TranslationTextComponent(((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(XP.getResLoc(regKey))).func_200305_d(1).getString().replace(" I", "")).getString();
                break;
            }
            case XP_VALUE_BREED: 
            case XP_VALUE_TAME: 
            case REQ_KILL: {
                this.title = new TranslationTextComponent(((EntityType)ForgeRegistries.ENTITIES.getValue(XP.getResLoc(regKey))).func_210760_d()).getString();
                break;
            }
            case DIMENSION: {
                if (regKey.equals("all_dimensions")) {
                    this.title = new TranslationTextComponent("pmmo.allDimensions").getString();
                    break;
                }
                if (!regKey.equals("minecraft:overworld") && !regKey.equals("minecraft:the_nether") && !regKey.equals("minecraft:the_end")) break;
                this.title = new TranslationTextComponent(regKey).getString();
                break;
            }
            case STATS: {
                this.title = new TranslationTextComponent("pmmo." + regKey).func_230530_a_(Skill.getSkillStyle(regKey)).getString();
                break;
            }
            case HISCORE: {
                if (XP.playerNames.containsValue(regKey)) {
                    this.title = new StringTextComponent(regKey).func_230530_a_(Skill.getSkillStyle(regKey)).getString();
                    break;
                }
                this.title = new TranslationTextComponent("pmmo." + regKey).func_230530_a_(Skill.getSkillStyle(regKey)).getString();
                break;
            }
            case REQ_BIOME: {
                this.title = new TranslationTextComponent(regKey).getString();
                break;
            }
            default: {
                this.title = new TranslationTextComponent(this.itemStack.func_77977_a()).getString();
            }
        }
        switch (regKey) {
            case "pmmo.otherCrafts": 
            case "pmmo.otherAnimals": 
            case "pmmo.otherPassiveMobs": 
            case "pmmo.otherAggresiveMobs": {
                this.title = new TranslationTextComponent(new TranslationTextComponent(regKey).getString()).getString();
            }
        }
        this.offsetOne = elementOne > 23 ? 192 : (elementOne > 15 ? 128 : (elementOne > 7 ? 64 : 0));
        this.offsetTwo = elementTwo > 23 ? 192 : (elementTwo > 15 ? 128 : (elementTwo > 7 ? 64 : 0));
    }

    public int func_238483_d_() {
        int height = 11;
        for (ITextComponent a : this.text) {
            height += 9;
        }
        if (height > 32) {
            return height;
        }
        return 32;
    }

    public void clickActionGlossary() {
        GlossaryScreen.setButtonsToKey(this.regKey);
        Minecraft.func_71410_x().func_147108_a((Screen)new GlossaryScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au(), (ITextComponent)new TranslationTextComponent("pmmo.glossary"), false));
    }

    public void clickActionSkills() {
        if (XP.playerNames.containsValue(this.regKey)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ListScreen(XP.playerUUIDs.get(this.regKey), (ITextComponent)new TranslationTextComponent(""), this.regKey, JType.SKILLS, (PlayerEntity)Minecraft.func_71410_x().field_71439_g));
        } else {
            Minecraft.func_71410_x().func_147108_a((Screen)new ListScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au(), (ITextComponent)new TranslationTextComponent(""), this.regKey, JType.HISCORE, (PlayerEntity)Minecraft.func_71410_x().field_71439_g));
        }
    }

    public void func_230431_b_(MatrixStack stack, int x, int y, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontrenderer = minecraft.field_71466_p;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        int i = this.func_230989_a_(this.func_230449_g_());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        minecraft.func_110434_K().func_110577_a(this.buttons);
        this.func_238474_b_(stack, this.field_230690_l_, this.field_230691_m_, this.offsetOne + (this.func_230449_g_() ? 32 : 0), this.elementOne, this.field_230688_j_, this.field_230689_k_);
        minecraft.func_110434_K().func_110577_a(this.items);
        this.func_238474_b_(stack, this.field_230690_l_, this.field_230691_m_, this.offsetTwo + (this.func_230449_g_() ? 32 : 0), this.elementTwo, this.field_230688_j_, this.field_230689_k_);
        if (!this.itemStack.func_77973_b().equals(Items.field_190931_a) && this.entity == null) {
            this.itemRenderer.func_175042_a(this.itemStack, this.field_230690_l_ + 8, this.field_230691_m_ + 8);
        }
        if (this.entity != null) {
            this.mobHeight = this.entity.func_213305_a((Pose)Pose.STANDING).field_220316_b;
            this.mobWidth = this.entity.func_213305_a((Pose)Pose.STANDING).field_220315_a;
            this.mobScale = 27.0;
            if (this.mobHeight > 0.0) {
                this.mobScale /= Math.max(this.mobHeight, this.mobWidth);
            }
            ListButton.drawEntityOnScreen(this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230691_m_ + this.field_230689_k_ - 2, (int)this.mobScale, this.entity);
        }
        this.func_230441_a_(stack, minecraft, x, y);
        int j = this.getFGColor();
        ListButton.func_238471_a_((MatrixStack)stack, (FontRenderer)fontrenderer, (String)this.buttonText, (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)(j | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, LivingEntity p_228187_5_) {
        float f = (float)((double)System.currentTimeMillis() / 25.0 % 360.0);
        float f1 = 0.0f;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        float f2 = p_228187_5_.field_70761_aq;
        float f3 = p_228187_5_.field_70177_z;
        float f4 = p_228187_5_.field_70125_A;
        float f5 = p_228187_5_.field_70758_at;
        float f6 = p_228187_5_.field_70759_as;
        p_228187_5_.field_70761_aq = f;
        p_228187_5_.field_70177_z = f;
        p_228187_5_.field_70125_A = -f1 * 20.0f;
        p_228187_5_.field_70759_as = f;
        p_228187_5_.field_70758_at = 0.0f;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)p_228187_5_, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        p_228187_5_.field_70761_aq = f2;
        p_228187_5_.field_70177_z = f3;
        p_228187_5_.field_70125_A = f4;
        p_228187_5_.field_70758_at = f5;
        p_228187_5_.field_70759_as = f6;
        RenderSystem.popMatrix();
    }
}

