/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.BlockBrokenHandler;
import harmonised.pmmo.events.FishedHandler;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListButton;
import harmonised.pmmo.gui.ListScrollPanel;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ListScreen
extends Screen {
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private static final Style greenColor = XP.textStyle.get("green");
    private static Button exitButton;
    Minecraft field_230706_i_ = Minecraft.func_71410_x();
    MainWindow sr = this.field_230706_i_.func_228018_at_();
    FontRenderer field_230712_o_;
    private int boxWidth;
    private int boxHeight;
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private int buttonX;
    private int buttonY;
    private int accumulativeHeight;
    private int buttonsSize;
    private int buttonsLoaded;
    private int futureHeight;
    private int minCount;
    private int maxCount;
    private ListScrollPanel scrollPanel;
    private TextFieldWidget filterTextField;
    private String filterText;
    private final PlayerEntity player;
    private final JType jType;
    private final double baseXp;
    private ArrayList<ListButton> listButtons;
    private ArrayList<ListButton> activeListButtons;
    private UUID uuid;
    private ITextComponent title;
    private String type;

    public ListScreen(UUID uuid, ITextComponent titleIn, String type, JType jType, PlayerEntity player) {
        super(titleIn);
        this.field_230712_o_ = this.field_230706_i_.field_71466_p;
        this.boxWidth = 256;
        this.boxHeight = 256;
        this.filterText = "";
        this.baseXp = Config.getConfig("baseXp");
        this.listButtons = new ArrayList();
        this.activeListButtons = new ArrayList();
        this.title = titleIn;
        this.player = player;
        this.jType = jType;
        this.uuid = uuid;
        this.type = type;
    }

    public void func_231160_c_() {
        ArrayList<String> keyWords = new ArrayList<String>();
        keyWords.add("helmet");
        keyWords.add("chestplate");
        keyWords.add("leggings");
        keyWords.add("boots");
        keyWords.add("pickaxe");
        keyWords.add("axe");
        keyWords.add("shovel");
        keyWords.add("hoe");
        keyWords.add("sword");
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollX = this.x + 16;
        this.scrollY = this.y + 10;
        this.buttonX = this.scrollX + 4;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "", JType.NONE, button -> {
            switch (this.jType) {
                case SKILLS: 
                case HISCORE: 
                case STATS: {
                    Minecraft.func_71410_x().func_147108_a((Screen)new MainScreen(this.uuid, (ITextComponent)ListScreen.getTransComp("pmmo.potato", new Object[0])));
                    break;
                }
                default: {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GlossaryScreen(this.uuid, (ITextComponent)ListScreen.getTransComp("pmmo.skills", new Object[0]), false));
                }
            }
        });
        Map reqMap = JsonConfig.data.get((Object)this.jType);
        Map<String, Map<String, Map<String, Double>>> reqMap2 = JsonConfig.data2.get((Object)this.jType);
        ArrayList<ListButton> tempList = new ArrayList<ListButton>();
        this.listButtons = new ArrayList();
        switch (this.jType) {
            case REQ_BIOME: {
                Map<String, Map<String, Double>> bonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME);
                Map<String, Map<String, Double>> map = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER);
                ArrayList<String> biomesToAdd = new ArrayList<String>();
                if (reqMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                        if (biomesToAdd.contains(entry.getKey())) continue;
                        biomesToAdd.add(entry.getKey());
                    }
                }
                if (bonusMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : bonusMap.entrySet()) {
                        if (biomesToAdd.contains(entry.getKey())) continue;
                        biomesToAdd.add(entry.getKey());
                    }
                }
                if (map != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
                        if (biomesToAdd.contains(entry.getKey())) continue;
                        biomesToAdd.add(entry.getKey());
                    }
                }
                biomesToAdd.sort(Comparator.comparingInt(b -> ListScreen.getReqCount(b, JType.REQ_BIOME)));
                for (String string : biomesToAdd) {
                    if (ForgeRegistries.BIOMES.getValue(XP.getResLoc(string)) == null) continue;
                    tempList.add(new ListButton(0, 0, 3, 8, string, this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case DIMENSION: {
                Map<String, Map<String, Double>> veinBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST);
                if (veinBlacklist == null) break;
                if (veinBlacklist.containsKey("all_dimensions")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "all_dimensions", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                if (veinBlacklist.containsKey("minecraft:overworld")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "minecraft:overworld", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                if (veinBlacklist.containsKey("minecraft:the_nether")) {
                    tempList.add(new ListButton(0, 0, 3, 8, "minecraft:the_nether", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                if (!veinBlacklist.containsKey("minecraft:the_end")) break;
                tempList.add(new ListButton(0, 0, 3, 8, "minecraft:the_end", this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                break;
            }
            case REQ_KILL: {
                Iterator<Map.Entry<String, Map<String, Double>>> killXpMap = JsonConfig.data.get((Object)JType.XP_VALUE_KILL);
                Map<String, Map<String, Double>> map = JsonConfig.data.get((Object)JType.MOB_RARE_DROP);
                Iterator<Object> mobsToAdd = new ArrayList();
                if (reqMap != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                        if (((ArrayList)((Object)mobsToAdd)).contains(entry.getKey())) continue;
                        ((ArrayList)((Object)mobsToAdd)).add(entry.getKey());
                    }
                }
                if (killXpMap != null) {
                    for (Map.Entry entry : killXpMap.entrySet()) {
                        if (((ArrayList)((Object)mobsToAdd)).contains(entry.getKey())) continue;
                        ((ArrayList)((Object)mobsToAdd)).add(entry.getKey());
                    }
                }
                if (map != null) {
                    for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
                        if (((ArrayList)((Object)mobsToAdd)).contains(entry.getKey())) continue;
                        ((ArrayList)((Object)mobsToAdd)).add(entry.getKey());
                    }
                }
                Iterator iterator = ((ArrayList)((Object)mobsToAdd)).iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (!ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(string))) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, string, this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case XP_VALUE_BREED: 
            case XP_VALUE_TAME: {
                if (reqMap == null) break;
                for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                    if (!ForgeRegistries.ENTITIES.containsKey(XP.getResLoc(entry.getKey()))) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case FISH_ENCHANT_POOL: {
                if (reqMap == null) break;
                for (Map.Entry<String, Map<String, Double>> entry : reqMap.entrySet()) {
                    if (!ForgeRegistries.ENCHANTMENTS.containsKey(XP.getResLoc(entry.getKey()))) continue;
                    tempList.add(new ListButton(0, 0, 3, 25, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            case SKILLS: {
                Set<String> skills = XP.getOfflineXpMap(this.uuid).keySet();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                tempList.add(new ListButton(0, 0, 3, 6, "totalLevel", this.jType, "", button -> ((ListButton)button).clickActionSkills()));
                for (String string : skills) {
                    arrayList.add((Object)new ListButton(0, 0, 3, 6, string, this.jType, "", button -> ((ListButton)button).clickActionSkills()));
                }
                arrayList.sort(Comparator.comparingDouble(b -> XP.getOfflineXp(((ListButton)((Object)((Object)((Object)b)))).regKey, this.uuid)).reversed());
                tempList.addAll(arrayList);
                break;
            }
            case HISCORE: {
                Iterator<Object> theSkill = this.type;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Map.Entry entry : XP.playerNames.entrySet()) {
                    arrayList.add((Object)new ListButton(0, 0, 3, 6, (String)entry.getValue(), this.jType, "", button -> ((ListButton)button).clickActionSkills()));
                }
                if (this.type.equals("totalLevel")) {
                    arrayList.sort(Comparator.comparingDouble(b -> XP.getTotalLevelFromMap(XP.getOfflineXpMap(XP.playerUUIDs.get(((ListButton)((Object)((Object)((Object)b)))).regKey)))).reversed());
                } else {
                    arrayList.sort(Comparator.comparingDouble(b -> XP.getOfflineXp(theSkill, XP.playerUUIDs.get(((ListButton)((Object)((Object)((Object)b)))).regKey))).reversed());
                }
                tempList.addAll(arrayList);
                break;
            }
            case SALVAGE: 
            case SALVAGE_FROM: 
            case TREASURE: 
            case TREASURE_FROM: {
                if (reqMap2 == null) break;
                for (Map.Entry<String, Map<String, Object>> entry : reqMap2.entrySet()) {
                    tempList.add(new ListButton(0, 0, 3, 0, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
                break;
            }
            default: {
                if (reqMap == null) {
                    return;
                }
                for (Map.Entry<String, Map<String, Object>> entry : reqMap.entrySet()) {
                    if (XP.getItem(entry.getKey()) == Items.field_190931_a) continue;
                    tempList.add(new ListButton(0, 0, 3, 0, entry.getKey(), this.jType, "", button -> ((ListButton)button).clickActionGlossary()));
                }
            }
        }
        for (String string : keyWords) {
            for (ListButton listButton : tempList) {
                if (!listButton.regKey.contains(string) || this.listButtons.contains((Object)listButton)) continue;
                this.listButtons.add(listButton);
            }
        }
        for (ListButton listButton : tempList) {
            if (this.listButtons.contains((Object)listButton)) continue;
            this.listButtons.add(listButton);
        }
        for (ListButton listButton : tempList) {
            if (!JsonConfig.levelJTypes.contains((Object)this.jType) || Util.mapIsAnyAbove1String(reqMap, listButton.regKey)) continue;
            this.listButtons.remove((Object)listButton);
        }
        block76: for (ListButton listButton : this.listButtons) {
            ArrayList<Object> skillText = new ArrayList<Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<Object> positiveEffectText = new ArrayList<Object>();
            switch (this.jType) {
                case DIMENSION: {
                    Map<String, Map<String, Double>> veinBlacklist = JsonConfig.data.get((Object)JType.VEIN_BLACKLIST);
                    Map<String, Double> dimensionBonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).get(listButton.regKey);
                    if (veinBlacklist != null) {
                        listButton.text.add((ITextComponent)new StringTextComponent(""));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.veinBlacklist", new Object[0]).func_230530_a_(XP.textStyle.get("red")));
                        for (Map.Entry<String, Double> entry : veinBlacklist.get(listButton.regKey).entrySet()) {
                            listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp(XP.getItem(entry.getKey()).func_77658_a(), new Object[0]).getString()).func_230530_a_(XP.textStyle.get("red")));
                        }
                    }
                    if (dimensionBonusMap == null) break;
                    for (Map.Entry<String, Double> entry : dimensionBonusMap.entrySet()) {
                        if (entry.getValue() > 0.0) {
                            skillText.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), "+" + entry.getValue() + "%").getString()).func_230530_a_(Skill.getSkillStyle(entry.getKey())));
                        }
                        if (!(entry.getValue() < 0.0)) continue;
                        skillText.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), entry.getValue() + "%").getString()).func_230530_a_(Skill.getSkillStyle(entry.getKey())));
                    }
                    break;
                }
                case REQ_BIOME: {
                    Effect effect;
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    if (reqMap.containsKey(listButton.regKey)) {
                        ListScreen.addLevelsToButton(listButton, reqMap.get(listButton.regKey), this.player, false);
                    }
                    Map<String, Double> biomeBonusMap = JsonConfig.data.get((Object)JType.XP_BONUS_BIOME).get(listButton.regKey);
                    Map<String, Double> biomeMobMultiplierMap = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER).get(listButton.regKey);
                    Map<String, Double> biomeNegativeEffectsMap = JsonConfig.data.get((Object)JType.BIOME_EFFECT_NEGATIVE).get(listButton.regKey);
                    Map<String, Double> biomePositiveEffectsMap = JsonConfig.data.get((Object)JType.BIOME_EFFECT_POSITIVE).get(listButton.regKey);
                    if (biomeBonusMap != null) {
                        for (Map.Entry<String, Double> entry : biomeBonusMap.entrySet()) {
                            if (entry.getValue() > 0.0) {
                                skillText.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), "+" + entry.getValue() + "%").getString()).func_230530_a_(Skill.getSkillStyle(entry.getKey())));
                            }
                            if (!(entry.getValue() < 0.0)) continue;
                            skillText.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + entry.getKey(), new Object[0]), entry.getValue() + "%").getString()).func_230530_a_(Skill.getSkillStyle(entry.getKey())));
                        }
                    }
                    if (biomeMobMultiplierMap != null) {
                        for (Map.Entry<String, Double> entry : biomeMobMultiplierMap.entrySet()) {
                            Style styleColor = Style.field_240709_b_;
                            if (entry.getValue() > 1.0) {
                                styleColor = XP.textStyle.get("red");
                            } else if (entry.getValue() < 1.0) {
                                styleColor = XP.textStyle.get("green");
                            }
                            switch (entry.getKey()) {
                                case "damageBonus": {
                                    arrayList.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enemyScaleDamage", DP.dp(entry.getValue() * 100.0)).getString()).func_230530_a_(styleColor));
                                    break;
                                }
                                case "hpBonus": {
                                    arrayList.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enemyScaleHp", DP.dp(entry.getValue() * 100.0)).getString()).func_230530_a_(styleColor));
                                    break;
                                }
                                case "speedBonus": {
                                    arrayList.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enemyScaleSpeed", DP.dp(entry.getValue() * 100.0)).getString()).func_230530_a_(styleColor));
                                }
                            }
                        }
                    }
                    if (biomeNegativeEffectsMap != null) {
                        for (Map.Entry<String, Double> entry : biomeNegativeEffectsMap.entrySet()) {
                            if (!ForgeRegistries.POTIONS.containsKey(XP.getResLoc(entry.getKey())) || (effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()))) == null) continue;
                            arrayList2.add(new StringTextComponent(" " + ListScreen.getTransComp(effect.func_199286_c().getString() + " " + (int)(entry.getValue() + 1.0), new Object[0]).getString()).func_230530_a_(XP.textStyle.get("red")));
                        }
                    }
                    if (biomePositiveEffectsMap == null) break;
                    for (Map.Entry<String, Double> entry : biomePositiveEffectsMap.entrySet()) {
                        if (!ForgeRegistries.POTIONS.containsKey(XP.getResLoc(entry.getKey())) || (effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()))) == null) continue;
                        positiveEffectText.add(new StringTextComponent(" " + ListScreen.getTransComp(effect.func_199286_c().getString() + " " + (int)(entry.getValue() + 1.0), new Object[0]).getString()).func_230530_a_(XP.textStyle.get("green")));
                    }
                    break;
                }
                case INFO_ORE: 
                case INFO_LOG: 
                case INFO_PLANT: 
                case INFO_SMELT: 
                case INFO_COOK: 
                case INFO_BREW: {
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    Map<String, Double> breakMap = JsonConfig.data.get((Object)JType.REQ_BREAK).get(listButton.regKey);
                    Map<String, Double> infoMap = XP.getJsonMap(listButton.regKey, this.jType);
                    ArrayList<IFormattableTextComponent> infoText = new ArrayList<IFormattableTextComponent>();
                    String transKey = "pmmo." + this.jType.toString().replace("info_", "") + "ExtraDrop";
                    if (!infoMap.containsKey("extraChance")) continue block76;
                    double extraDroppedPerLevel = infoMap.get("extraChance") / 100.0;
                    double extraDropped = XP.getExtraChance(this.player.func_110124_au(), listButton.regKey, this.jType, true) / 100.0;
                    if (extraDropped <= 0.0) {
                        infoText.add(ListScreen.getTransComp(transKey, DP.dp(extraDropped)).func_230530_a_(XP.textStyle.get("red")));
                    } else {
                        infoText.add(ListScreen.getTransComp(transKey, DP.dp(extraDropped)).func_230530_a_(XP.textStyle.get("green")));
                    }
                    if (extraDroppedPerLevel <= 0.0) {
                        infoText.add(ListScreen.getTransComp("pmmo.extraPerLevel", DP.dpCustom(extraDroppedPerLevel, 4)).func_230530_a_(XP.textStyle.get("red")));
                    } else {
                        infoText.add(ListScreen.getTransComp("pmmo.extraPerLevel", DP.dpCustom(extraDroppedPerLevel, 4)).func_230530_a_(XP.textStyle.get("green")));
                    }
                    if (infoText.size() > 0) {
                        listButton.text.addAll(infoText);
                    }
                    if (breakMap == null || !this.jType.equals((Object)JType.INFO_ORE) && !this.jType.equals((Object)JType.INFO_LOG) && !this.jType.equals((Object)JType.INFO_PLANT)) break;
                    if (XP.checkReq(this.player, listButton.regKey, JType.REQ_BREAK)) {
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.break", new Object[0]).func_230530_a_(XP.textStyle.get("green")));
                    } else {
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.break", new Object[0]).func_230530_a_(XP.textStyle.get("red")));
                    }
                    ListScreen.addLevelsToButton(listButton, breakMap, this.player, false);
                    break;
                }
                case XP_BONUS_WORN: {
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    ListScreen.addPercentageToButton(listButton, reqMap.get(listButton.regKey), XP.checkReq(this.player, listButton.regKey, JType.REQ_WEAR));
                    break;
                }
                case XP_BONUS_HELD: {
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    ListScreen.addPercentageToButton(listButton, reqMap.get(listButton.regKey), true);
                    break;
                }
                case XP_VALUE_BREED: 
                case XP_VALUE_TAME: 
                case XP_VALUE_SMELT: 
                case XP_VALUE_COOK: 
                case XP_VALUE_BREW: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey));
                    break;
                }
                case XP_VALUE_BREAK: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey), JType.REQ_BREAK, this.player);
                    break;
                }
                case XP_VALUE_CRAFT: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey), JType.REQ_CRAFT, this.player);
                    break;
                }
                case XP_VALUE_GROW: {
                    ListScreen.addXpToButton(listButton, reqMap.get(listButton.regKey), JType.REQ_PLACE, this.player);
                    break;
                }
                case FISH_ENCHANT_POOL: {
                    double curChance;
                    Map enchantMap = reqMap.get(listButton.regKey);
                    double fishLevel = Skill.getLevelDecimal(Skill.FISHING.toString(), this.player);
                    double levelReq = enchantMap.get("levelReq");
                    double chancePerLevel = enchantMap.get("chancePerLevel");
                    double maxChance = enchantMap.get("maxChance");
                    double maxLevel = (int)enchantMap.get("maxLevel").doubleValue();
                    double levelsPerTier = enchantMap.get("levelPerLevel");
                    double maxLevelAvailable = levelsPerTier == 0.0 ? maxLevel : Math.floor((fishLevel - levelReq) / levelsPerTier);
                    if (maxLevelAvailable < 0.0) {
                        maxLevelAvailable = 0.0;
                    }
                    if (maxLevelAvailable > maxLevel) {
                        maxLevelAvailable = maxLevel;
                    }
                    if ((curChance = (fishLevel - levelReq) * chancePerLevel) > maxChance) {
                        curChance = maxChance;
                    }
                    if (curChance < 0.0) {
                        curChance = 0.0;
                    }
                    listButton.unlocked = maxLevelAvailable > 0.0;
                    Style color = XP.textStyle.get(listButton.unlocked ? "green" : "red");
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.currentChance", DP.dpSoft(curChance)).getString()).func_230530_a_(color));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.startLevel", DP.dpSoft(levelReq)).getString()).func_230530_a_(color));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.maxEnchantLevel", (int)maxLevelAvailable).getString()).func_230530_a_(color));
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.chancePerLevel", DP.dpSoft(chancePerLevel)).getString()));
                    if (maxLevel > 1.0) {
                        listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelsPerTier", DP.dpSoft(levelsPerTier)).getString()));
                    }
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.maxEnchantLevel", (int)maxLevel).getString()));
                    break;
                }
                case REQ_KILL: {
                    Map<String, Double> killXpMap = JsonConfig.data.get((Object)JType.XP_VALUE_KILL).get(listButton.regKey);
                    Map<String, Double> rareDropMap = JsonConfig.data.get((Object)JType.MOB_RARE_DROP).get(listButton.regKey);
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, this.jType);
                    Style color = XP.textStyle.get(listButton.unlocked ? "green" : "red");
                    if (reqMap.containsKey(listButton.regKey)) {
                        listButton.text.add((ITextComponent)new StringTextComponent(""));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.toHarm", new Object[0]).func_230530_a_(color));
                        ListScreen.addLevelsToButton(listButton, reqMap.get(listButton.regKey), this.player, false);
                    }
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.xpValue", new Object[0]).func_230530_a_(color));
                    if (killXpMap != null) {
                        ListScreen.addXpToButton(listButton, killXpMap, this.jType, this.player);
                    } else if (listButton.entity instanceof AnimalEntity) {
                        listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.hunter", new Object[0]), DP.dpSoft(Config.forgeConfig.passiveMobHunterXp.get())).getString()).func_230530_a_(color));
                    } else if (listButton.entity instanceof MobEntity) {
                        listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.slayer", new Object[0]), DP.dpSoft(Config.forgeConfig.aggresiveMobSlayerXp.get())).getString()).func_230530_a_(color));
                    }
                    if (rareDropMap == null) break;
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.rareDrops", new Object[0]).func_230530_a_(color));
                    for (Map.Entry<String, Double> entry : rareDropMap.entrySet()) {
                        listButton.text.add((ITextComponent)new StringTextComponent(ListScreen.getTransComp(XP.getItem(entry.getKey()).func_77658_a(), new Object[0]).getString() + ": " + ListScreen.getTransComp("pmmo.dropChance", DP.dpSoft(entry.getValue())).getString()).func_230530_a_(color));
                    }
                    break;
                }
                case FISH_POOL: {
                    Map<String, Double> fishPoolMap = reqMap.get(listButton.regKey);
                    double level = Skill.getLevelDecimal(Skill.FISHING.toString(), this.player);
                    double weight = FishedHandler.getFishPoolWeight(level, fishPoolMap);
                    double chance = weight / FishedHandler.getTotalFishPoolWeight(level);
                    listButton.unlocked = weight > 0.0;
                    Style color = XP.textStyle.get(listButton.unlocked ? "green" : "red");
                    this.minCount = (int)fishPoolMap.get("minCount").doubleValue();
                    this.maxCount = (int)fishPoolMap.get("maxCount").doubleValue();
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.currentWeight", DP.dpSoft(weight)).getString()).func_230530_a_(color));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.currentChance", DP.dpCustom(chance, 5)).getString()).func_230530_a_(color));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.dropChance", DP.dpSoft(1.0 / chance)).getString()).func_230530_a_(color));
                    if (this.minCount == this.maxCount) {
                        listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.caughtAmount", this.minCount).getString()).func_230530_a_(color));
                    } else {
                        listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.caughtAmountRange", this.minCount, this.maxCount).getString()).func_230530_a_(color));
                    }
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpEach", DP.dpSoft(fishPoolMap.get("xp"))).getString()).func_230530_a_(color));
                    if (listButton.itemStack.func_77956_u()) {
                        if (fishPoolMap.get("enchantLevelReq") <= level && listButton.unlocked) {
                            listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enchantLevelReq", DP.dpSoft(fishPoolMap.get("enchantLevelReq"))).getString()).func_230530_a_(XP.textStyle.get("green")));
                        } else {
                            listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.enchantLevelReq", DP.dpSoft(fishPoolMap.get("enchantLevelReq"))).getString()).func_230530_a_(XP.textStyle.get("red")));
                        }
                    }
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.startWeight", DP.dpSoft(fishPoolMap.get("startWeight"))).getString()));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.startLevel", DP.dpSoft(fishPoolMap.get("startLevel"))).getString()));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.endWeight", DP.dpSoft(fishPoolMap.get("endWeight"))).getString()));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.endLevel", DP.dpSoft(fishPoolMap.get("endLevel"))).getString()));
                    break;
                }
                case REQ_WEAR: 
                case REQ_TOOL: 
                case REQ_WEAPON: 
                case REQ_USE: 
                case REQ_BREAK: 
                case REQ_CRAFT: 
                case REQ_PLACE: {
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                    listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo." + this.jType.toString().replace("req_", ""), new Object[0]).func_230530_a_(XP.textStyle.get(XP.checkReq(this.player, listButton.regKey, this.jType) ? "green" : "red")));
                    ListScreen.addLevelsToButton(listButton, reqMap.get(listButton.regKey), this.player, false);
                    break;
                }
                case HISCORE: {
                    String skill = this.type;
                    String playerName = listButton.regKey;
                    UUID playerUUID = XP.playerUUIDs.get(playerName);
                    if (this.type.equals("totalLevel")) {
                        listButton.text.add((ITextComponent)new StringTextComponent(" " + XP.getTotalLevelFromMap(XP.getOfflineXpMap(playerUUID))));
                        listButton.text.add((ITextComponent)new TranslationTextComponent("pmmo.xpX", new Object[]{" " + XP.getTotalXpFromMap(XP.getOfflineXpMap(playerUUID))}));
                        break;
                    }
                    Style color = XP.getColorStyle(5503315);
                    Map<String, Double> skillsMap = XP.getOfflineXpMap(playerUUID);
                    if (!skillsMap.containsKey(skill)) break;
                    double xp = skillsMap.get(skill);
                    listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.levelX", DP.dpSoft(XP.levelAtXpDecimal(xp))).func_230530_a_(color));
                    listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.xpX", DP.dpSoft(xp)).func_230530_a_(color));
                    break;
                }
                case SALVAGE: 
                case SALVAGE_FROM: {
                    if (reqMap2 == null) {
                        return;
                    }
                    int smithLevel = (int)Skill.getLevelDecimal(Skill.SMITHING.toString(), this.player);
                    listButton.unlocked = false;
                    int i = 0;
                    ArrayList<String> toItemsList = new ArrayList<String>(reqMap2.get(listButton.regKey).keySet());
                    toItemsList.sort(Comparator.comparingInt(key -> (int)((Double)((Map)((Map)reqMap2.get(button.regKey)).get(key)).get("levelReq")).doubleValue()));
                    for (String salvageToItemKey : toItemsList) {
                        Map<String, Double> salvageToItemMap = reqMap2.get(listButton.regKey).get(salvageToItemKey);
                        String outputName = ListScreen.getTransComp(XP.getItem(salvageToItemKey).func_77658_a(), new Object[0]).getString();
                        double levelReq = salvageToItemMap.get("levelReq");
                        double salvageMax = salvageToItemMap.get("salvageMax");
                        double baseChance = salvageToItemMap.get("baseChance");
                        double chancePerLevel = salvageToItemMap.get("chancePerLevel");
                        double maxChance = salvageToItemMap.get("maxChance");
                        double xpPerItem = salvageToItemMap.get("xpPerItem");
                        double chance = baseChance + chancePerLevel * ((double)smithLevel - levelReq);
                        if (chance < 0.0) {
                            chance = 0.0;
                        }
                        if (chance > maxChance) {
                            chance = maxChance;
                        }
                        Style color = XP.textStyle.get(chance > 0.0 ? "green" : "red");
                        if (chance > 0.0 && (double)smithLevel >= levelReq) {
                            listButton.unlocked = true;
                        }
                        if (i++ == 0) {
                            listButton.text.add((ITextComponent)new TranslationTextComponent(this.jType == JType.SALVAGE ? "pmmo.salvagesInto" : "pmmo.canBeSalvagedFrom"));
                        }
                        listButton.text.add((ITextComponent)new StringTextComponent("____________________________"));
                        listButton.text.add((ITextComponent)new StringTextComponent(""));
                        listButton.text.add((ITextComponent)new StringTextComponent(ListScreen.getTransComp(this.jType == JType.SALVAGE ? "pmmo.valueValue" : "pmmo.valueFromValue", DP.dpSoft(salvageMax), outputName).getString()).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.canBeSalvagedFromLevel", DP.dpSoft(levelReq)).func_230530_a_(color));
                        listButton.text.add((ITextComponent)new StringTextComponent(""));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.xpPerItem", DP.dpSoft(xpPerItem)).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.chancePerItem", DP.dpSoft(chance)).func_230530_a_(color));
                        listButton.text.add((ITextComponent)new StringTextComponent(""));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.baseChance", DP.dpSoft(baseChance)).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.chancePerLevel", DP.dpSoft(chancePerLevel)).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.maxChancePerItem", DP.dpSoft(maxChance)).func_230530_a_(color));
                    }
                    break;
                }
                case TREASURE: 
                case TREASURE_FROM: {
                    if (reqMap2 == null) {
                        return;
                    }
                    int excavationLevel = (int)Skill.getLevelDecimal(Skill.EXCAVATION.toString(), this.player);
                    listButton.unlocked = false;
                    int i = 0;
                    ArrayList<String> toItemsList = new ArrayList<String>(reqMap2.get(listButton.regKey).keySet());
                    toItemsList.sort(Comparator.comparingDouble(key -> BlockBrokenHandler.getTreasureItemChance(excavationLevel, (Map)((Map)reqMap2.get(button.regKey)).get(key))));
                    for (String treasureToItemKey : toItemsList) {
                        Map<String, Double> treasureToItemMap = reqMap2.get(listButton.regKey).get(treasureToItemKey);
                        String outputName = ListScreen.getTransComp(XP.getItem(treasureToItemKey).func_77658_a(), new Object[0]).getString();
                        int startLevel = (int)treasureToItemMap.get("startLevel").doubleValue();
                        int endLevel = (int)treasureToItemMap.get("endLevel").doubleValue();
                        double startChance = treasureToItemMap.get("startChance");
                        double endChance = treasureToItemMap.get("endChance");
                        double xpPerItem = treasureToItemMap.get("xpPerItem");
                        int minCount = (int)treasureToItemMap.get("minCount").doubleValue();
                        int maxCount = (int)treasureToItemMap.get("maxCount").doubleValue();
                        double chance = BlockBrokenHandler.getTreasureItemChance(excavationLevel, treasureToItemMap);
                        Style color = XP.textStyle.get(chance > 0.0 ? "green" : "red");
                        if (chance > 0.0) {
                            listButton.unlocked = true;
                        }
                        if (i++ == 0) {
                            listButton.text.add((ITextComponent)new TranslationTextComponent(this.jType == JType.TREASURE ? "pmmo.containsTreasure" : "pmmo.treasureFrom"));
                        }
                        listButton.text.add((ITextComponent)new StringTextComponent("____________________________"));
                        listButton.text.add((ITextComponent)new StringTextComponent(""));
                        listButton.text.add((ITextComponent)new StringTextComponent(outputName).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.xpPerItem", DP.dpSoft(xpPerItem)).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.chancePerItem", DP.dpSoft(chance)).func_230530_a_(color));
                        listButton.text.add((ITextComponent)new StringTextComponent(""));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.minCount", minCount).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.maxCount", maxCount).func_230530_a_(color));
                        listButton.text.add((ITextComponent)new StringTextComponent(""));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.startChance", startChance).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.startLevel", startLevel).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.endChance", endChance).func_230530_a_(color));
                        listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.endLevel", endLevel).func_230530_a_(color));
                    }
                    break;
                }
                case SKILLS: {
                    if (listButton.regKey.equals("totalLevel")) {
                        listButton.title = "" + ListScreen.getTransComp("pmmo.totalLevel", new Object[0]).getString();
                        listButton.text.add((ITextComponent)new StringTextComponent(" " + XP.getTotalLevelFromMap(XP.getOfflineXpMap(this.uuid))));
                        listButton.text.add((ITextComponent)new TranslationTextComponent("pmmo.xpX", new Object[]{" " + XP.getTotalXpFromMap(XP.getOfflineXpMap(this.uuid))}));
                        break;
                    }
                    String skill = listButton.regKey;
                    double curXp = XP.getOfflineXp(skill, this.uuid);
                    double nextXp = XP.xpAtLevel(XP.levelAtXp(curXp) + 1);
                    listButton.title = ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + listButton.regKey, new Object[0]), DP.dpSoft(XP.levelAtXpDecimal(curXp))).func_230530_a_(Skill.getSkillStyle(listButton.regKey)).getString();
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.currentXp", DP.dpSoft(curXp)).getString()));
                    if ((double)Skill.getLevel(skill, this.player) == XP.getMaxLevel()) break;
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.nextLevelXp", DP.dpSoft(nextXp)).getString()));
                    listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.RemainderXp", DP.dpSoft(nextXp - curXp)).getString()));
                    break;
                }
            }
            if (skillText.size() > 0) {
                listButton.text.add((ITextComponent)new StringTextComponent(""));
                skillText.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
                listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.xpModifiers", new Object[0]));
                listButton.text.addAll(skillText);
            }
            if (arrayList.size() > 0) {
                if (skillText.size() > 0) {
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                }
                arrayList.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
                listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.enemyScaling", new Object[0]));
                listButton.text.addAll(arrayList);
            }
            if (arrayList2.size() > 0) {
                if (skillText.size() > 0 || arrayList.size() > 0) {
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                }
                arrayList2.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
                listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.negativeBiomeEffects", new Object[0]).func_230530_a_(XP.textStyle.get("red")));
                listButton.text.addAll(arrayList2);
            }
            if (positiveEffectText.size() > 0) {
                if (skillText.size() > 0 || arrayList.size() > 0) {
                    listButton.text.add((ITextComponent)new StringTextComponent(""));
                }
                positiveEffectText.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
                listButton.text.add((ITextComponent)ListScreen.getTransComp("pmmo.positiveBiomeEffects", new Object[0]).func_230530_a_(XP.textStyle.get("green")));
                listButton.text.addAll(positiveEffectText);
            }
            switch (this.jType) {
                case INFO_ORE: 
                case INFO_LOG: 
                case INFO_PLANT: 
                case XP_VALUE_BREAK: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_BREAK);
                    break;
                }
                case XP_BONUS_WORN: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_WEAR);
                    break;
                }
                case FISH_POOL: {
                    break;
                }
                case REQ_BIOME: 
                case REQ_WEAR: 
                case REQ_TOOL: 
                case REQ_WEAPON: 
                case REQ_USE: 
                case REQ_BREAK: 
                case REQ_CRAFT: 
                case REQ_PLACE: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, this.jType);
                    break;
                }
                case XP_VALUE_CRAFT: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_CRAFT);
                    break;
                }
                case XP_VALUE_GROW: {
                    listButton.unlocked = XP.checkReq(this.player, listButton.regKey, JType.REQ_PLACE);
                    break;
                }
            }
        }
        switch (this.jType) {
            case INFO_ORE: 
            case INFO_LOG: 
            case INFO_PLANT: 
            case XP_VALUE_BREAK: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, JType.REQ_BREAK)));
                break;
            }
            case REQ_WEAR: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, JType.REQ_WEAR)));
                break;
            }
            case SALVAGE: 
            case SALVAGE_FROM: {
                this.listButtons.sort(Comparator.comparingDouble(b -> ListScreen.getLowestSalvageReq((Map)reqMap2.get(b.regKey))));
                break;
            }
            default: {
                this.listButtons.sort(Comparator.comparingInt(b -> XP.getHighestReq(b.regKey, this.jType)));
            }
        }
        switch (this.jType) {
            case XP_VALUE_BREED: {
                ListButton otherAnimalsBreedButton = new ListButton(0, 0, 3, 20, "pmmo.otherAnimals", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                otherAnimalsBreedButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.farming", new Object[0]), DP.dpSoft(Config.forgeConfig.defaultBreedingXp.get())).getString()).func_230530_a_(greenColor));
                this.listButtons.add(otherAnimalsBreedButton);
                break;
            }
            case XP_VALUE_TAME: {
                ListButton listButton = new ListButton(0, 0, 3, 21, "pmmo.otherAnimals", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.taming", new Object[0]), DP.dpSoft(Config.forgeConfig.defaultTamingXp.get())).getString()).func_230530_a_(greenColor));
                this.listButtons.add(listButton);
                break;
            }
            case REQ_KILL: {
                ListButton listButton = new ListButton(0, 0, 3, 26, "pmmo.otherAggresiveMobs", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.slayer", new Object[0]), DP.dpSoft(Config.forgeConfig.aggresiveMobSlayerXp.get())).getString()).func_230530_a_(greenColor));
                this.listButtons.add(listButton);
                ListButton otherPassiveMobsButton = new ListButton(0, 0, 3, 26, "pmmo.otherPassiveMobs", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                otherPassiveMobsButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.hunter", new Object[0]), DP.dpSoft(Config.forgeConfig.passiveMobHunterXp.get())).getString()).func_230530_a_(greenColor));
                this.listButtons.add(otherPassiveMobsButton);
                break;
            }
            case XP_VALUE_CRAFT: {
                ListButton listButton = new ListButton(0, 0, 3, 22, "pmmo.otherCrafts", this.jType, "", button -> ((ListButton)button).clickActionGlossary());
                listButton.text.add((ITextComponent)new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo.crafting", new Object[0]), DP.dpSoft(Config.forgeConfig.defaultCraftingXp.get())).getString()).func_230530_a_(greenColor));
                this.listButtons.add(listButton);
            }
        }
        this.scrollPanel = new ListScrollPanel(Minecraft.func_71410_x(), this.boxWidth - 40, this.boxHeight - 21, this.scrollY, this.scrollX, this.jType, this.player, this.listButtons);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.children.add((IGuiEventListener)this.scrollPanel);
        this.filterTextField = new TextFieldWidget(this.field_230712_o_, this.x, this.y + this.boxHeight - 10, this.boxWidth, 16, (ITextComponent)new TranslationTextComponent(""));
        this.filterTextField.func_146180_a(this.filterText);
        this.updateListFilter();
        this.filterTextField.func_146195_b(true);
        this.children.add((IGuiEventListener)this.filterTextField);
        this.func_230480_a_((Widget)exitButton);
    }

    private static void addLevelsToButton(ListButton button, Map<String, Double> map, PlayerEntity player, boolean ignoreReq) {
        ArrayList<Object> levelsToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            if (inEntry.getValue() <= 1.0) continue;
            if (!ignoreReq && Skill.getLevelDecimal(inEntry.getKey(), player) < inEntry.getValue()) {
                levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft(inEntry.getValue())).getString()).func_230530_a_(XP.textStyle.get("red")));
                continue;
            }
            levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft(inEntry.getValue())).getString()).func_230530_a_(XP.textStyle.get("green")));
        }
        levelsToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
        button.text.addAll(levelsToAdd);
    }

    private static void addXpToButton(ListButton button, Map<String, Double> map) {
        ArrayList<Object> xpToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            xpToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft(inEntry.getValue())).getString()).func_230530_a_(XP.textStyle.get("green")));
        }
        xpToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
        button.text.addAll(xpToAdd);
    }

    private static void addXpToButton(ListButton button, Map<String, Double> map, JType jType, PlayerEntity player) {
        ArrayList<Object> xpToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            xpToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.xpDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), DP.dpSoft(inEntry.getValue())).getString()).func_230530_a_(XP.textStyle.get(XP.checkReq(player, button.regKey, jType) ? "green" : "red")));
        }
        xpToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
        button.text.addAll(xpToAdd);
    }

    private static void addPercentageToButton(ListButton button, Map<String, Double> map, boolean metReq) {
        ArrayList<Object> levelsToAdd = new ArrayList<Object>();
        for (Map.Entry<String, Double> inEntry : map.entrySet()) {
            double value = inEntry.getValue();
            if (metReq) {
                if (value > 0.0) {
                    levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), "+" + value + "%").getString()).func_230530_a_(XP.textStyle.get("green")));
                    continue;
                }
                if (!(value < 0.0)) continue;
                levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), value + "%").getString()).func_230530_a_(XP.textStyle.get("red")));
                continue;
            }
            levelsToAdd.add(new StringTextComponent(" " + ListScreen.getTransComp("pmmo.levelDisplay", ListScreen.getTransComp("pmmo." + inEntry.getKey(), new Object[0]), value + "%").getString()).func_230530_a_(XP.textStyle.get("red")));
        }
        levelsToAdd.sort(Comparator.comparingInt(textComp -> ListScreen.getTextInt(((ITextComponent)textComp).getString())).reversed());
        button.text.addAll(levelsToAdd);
    }

    private static int getTextInt(String comp) {
        String number = comp.replaceAll("\\D+", "");
        if (number.length() > 0 && !Double.isNaN(Double.parseDouble(number))) {
            return (int)Double.parseDouble(number);
        }
        return 0;
    }

    private static double getTextDouble(String comp) {
        String number = comp.replaceAll("\\D+", "");
        if (number.length() > 0 && !Double.isNaN(Double.parseDouble(number))) {
            return Double.parseDouble(number);
        }
        return 0.0;
    }

    private static int getReqCount(String regKey, JType jType) {
        Map<String, Double> map = XP.getJsonMap(regKey, jType);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_238651_a_(stack, 1);
        if (this.jType.equals((Object)JType.SKILLS)) {
            this.title = ListScreen.getTransComp("pmmo.playerStats", XP.playerNames.get(this.uuid));
        } else if (this.jType.equals((Object)JType.HISCORE)) {
            this.title = ListScreen.getTransComp("pmmo.skillHiscores", ListScreen.getTransComp("pmmo." + this.type, new Object[0])).func_230530_a_(Skill.getSkillStyle(this.type));
        }
        if (this.field_230712_o_.func_78256_a(this.title.getString()) > 220) {
            ListScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.title, (int)(this.sr.func_198107_o() / 2), (int)(this.y - 10), (int)0xFFFFFF);
        } else {
            ListScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.title, (int)(this.sr.func_198107_o() / 2), (int)(this.y - 5), (int)0xFFFFFF);
        }
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollPanel.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.filterTextField.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.accumulativeHeight = 0;
        this.buttonsSize = this.listButtons.size();
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        for (ListButton button : this.activeListButtons) {
            this.buttonX = mouseX - button.field_230690_l_;
            this.buttonY = mouseY - button.field_230691_m_;
            if (mouseY >= this.scrollPanel.getTop() && mouseY <= this.scrollPanel.getBottom() && this.buttonX >= 0 && this.buttonX < 32 && this.buttonY >= 0 && this.buttonY < 32) {
                if (this.jType.equals((Object)JType.REQ_BIOME) || this.jType.equals((Object)JType.REQ_KILL) || this.jType.equals((Object)JType.XP_VALUE_BREED) || this.jType.equals((Object)JType.XP_VALUE_TAME) || this.jType.equals((Object)JType.DIMENSION) || this.jType.equals((Object)JType.FISH_ENCHANT_POOL) || this.jType.equals((Object)JType.SKILLS) || this.jType.equals((Object)JType.HISCORE) || button.regKey.equals("pmmo.otherCrafts")) {
                    this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent(button.title), mouseX, mouseY);
                } else if (button.itemStack != null) {
                    this.func_230457_a_(stack, button.itemStack, mouseX, mouseY);
                }
            }
            this.accumulativeHeight += button.func_238483_d_();
        }
        MainScreen.scrollAmounts.replace(this.jType, this.scrollPanel.getScroll());
    }

    public static double getLowestSalvageReq(Map<String, Map<String, Double>> map) {
        double lowestReq = XP.getMaxLevel();
        for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
            lowestReq = Math.min(lowestReq, (double)((int)entry.getValue().get("levelReq").doubleValue()));
        }
        return lowestReq;
    }

    public void func_238651_a_(MatrixStack stack, int p_renderBackground_1_) {
        if (this.field_230706_i_ != null) {
            this.func_238468_a_(stack, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, stack));
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
        this.func_238474_b_(stack, this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        this.accumulativeHeight = 0;
        for (ListButton listButton : this.listButtons) {
            this.accumulativeHeight += listButton.func_238483_d_();
            if (this.accumulativeHeight <= this.scrollPanel.getBottom() - this.scrollPanel.getTop()) continue;
            this.scrollPanel.func_231043_a_(mouseX, mouseY, scroll);
            break;
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        this.filterTextField.func_231046_a_(keyCode, scanCode, modifiers);
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        this.filterTextField.func_223281_a_(keyCode, scanCode, modifiers);
        this.filterText = this.filterTextField.func_146179_b();
        if (this.filterTextField.func_230999_j_()) {
            this.updateListFilter();
        }
        return false;
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        this.filterTextField.func_231042_a_(codePoint, modifiers);
        return false;
    }

    public void updateListFilter() {
        this.activeListButtons = new ArrayList();
        block0: for (ListButton button : this.listButtons) {
            if (button.title.toLowerCase().contains(this.filterText.toLowerCase())) {
                this.activeListButtons.add(button);
                continue;
            }
            for (ITextComponent textComp : button.text) {
                if (!textComp.getString().toLowerCase().contains(this.filterText.trim().toLowerCase())) continue;
                this.activeListButtons.add(button);
                continue block0;
            }
        }
        this.scrollPanel.setButtons(this.activeListButtons);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.func_230930_b_();
            return true;
        }
        for (ListButton a : this.listButtons) {
            int buttonX = (int)mouseX - a.field_230690_l_;
            int buttonY = (int)mouseY - a.field_230691_m_;
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom()) || buttonX < 0 || buttonX >= 32 || buttonY < 0 || buttonY >= 32) continue;
            a.func_230982_a_(mouseX, mouseY);
        }
        this.scrollPanel.func_231044_a_(mouseX, mouseY, button);
        this.filterTextField.func_231044_a_(mouseX, mouseY, button);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.scrollPanel.func_231048_c_(mouseX, mouseY, button);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.scrollPanel.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static TranslationTextComponent getTransComp(String translationKey, Object ... args) {
        return new TranslationTextComponent(translationKey, args);
    }
}

