/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.ListButton;
import harmonised.pmmo.skills.Skill;
import java.util.ArrayList;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import org.lwjgl.opengl.GL11;

public class ListScrollPanel
extends ScrollPanel {
    MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
    PlayerEntity player;
    String regKey;
    JType jType;
    private final int boxWidth = 256;
    private final int boxHeight = 256;
    private ArrayList<ListButton> buttons;
    private final Minecraft client;
    private final int width;
    private final int height;
    private final int top;
    private final int bottom;
    private final int right;
    private final int left;
    private final int barLeft;
    private final int border = 4;
    private final int barWidth = 6;
    int accumulativeHeight;

    public ListScrollPanel(Minecraft client, int width, int height, int top, int left, JType jType, PlayerEntity player, ArrayList<ListButton> buttons) {
        super(client, width, height, top, left);
        this.player = player;
        this.jType = jType;
        this.buttons = buttons;
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - 6;
    }

    public void setButtons(ArrayList<ListButton> buttons) {
        this.buttons = buttons;
    }

    protected int getContentHeight() {
        int height = 0;
        for (ListButton a : this.buttons) {
            height += a.func_238483_d_() + 4;
        }
        return height;
    }

    protected void drawPanel(MatrixStack stack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        this.accumulativeHeight = 0;
        for (int i = 0; i < this.buttons.size(); ++i) {
            ListButton button = this.buttons.get(i);
            button.field_230690_l_ = this.right - button.func_230998_h_() - 8;
            button.field_230691_m_ = relativeY + this.accumulativeHeight;
            if (button.field_230691_m_ + button.func_238483_d_() + 2 > this.top && button.field_230691_m_ - 2 < this.bottom) {
                int color;
                if (button.unlocked) {
                    this.func_238468_a_(stack, this.left + 4, button.field_230691_m_ - 2, this.right - 2, button.field_230691_m_ + button.func_238483_d_() + 2, 0x22444444, 0x33222222);
                } else {
                    this.func_238468_a_(stack, this.left + 4, button.field_230691_m_ - 2, this.right - 2, button.field_230691_m_ + button.func_238483_d_() + 2, -1438366652, -1440603614);
                }
                button.func_230430_a_(stack, mouseX, mouseY, 0.0f);
                int n = color = button.unlocked ? 5569620 : 16536660;
                if (this.jType.equals((Object)JType.SKILLS) && (color = Skill.getSkillColor(button.regKey)) == 0xFFFFFF) {
                    color = 5569620;
                }
                if (this.jType.equals((Object)JType.HISCORE)) {
                    ListScrollPanel.func_238476_c_((MatrixStack)stack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(i + 1 + "."), (int)(this.left + 178), (int)(button.field_230691_m_ + 2), (int)color);
                } else if (this.jType.equals((Object)JType.SKILLS) && i > 0) {
                    ListScrollPanel.func_238476_c_((MatrixStack)stack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(i + "."), (int)(this.left + 178), (int)(button.field_230691_m_ + 2), (int)color);
                }
                ListScrollPanel.func_238476_c_((MatrixStack)stack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)button.title, (int)(this.left + 6), (int)(button.field_230691_m_ + 2), (int)color);
                int j = 0;
                for (ITextComponent line : button.text) {
                    ListScrollPanel.func_238476_c_((MatrixStack)stack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)line.getString(), (int)(this.left + 6), (int)(button.field_230691_m_ + 11 + j++ * 9), (int)(line.func_150256_b().func_240711_a_() == null ? 0xFFFFFF : line.func_150256_b().func_240711_a_().func_240742_a_()));
                }
            }
            this.accumulativeHeight += button.func_238483_d_() + 4;
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public int getScroll() {
        return (int)this.scrollDistance;
    }

    public void setScroll(int scroll) {
        this.scrollDistance = scroll;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRelativeY() {
        return this.top + this.border - (int)this.scrollDistance;
    }

    private int getMaxScroll() {
        return this.getContentHeight() - (this.height - this.border);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        double scale = this.client.func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.client.func_228018_at_().func_198091_l() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(stack, this.right, baseY, tess, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        int extraHeight = this.getContentHeight() + 4 - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.disableTexture();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)this.bottom, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.bottom, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.top, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)this.top, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        GL11.glDisable((int)3089);
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - 8) {
            barHeight = this.height - 8;
        }
        return barHeight;
    }
}

