/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.ConfigHelper;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.PlayerTickHandler;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.PrefsChoiceScreen;
import harmonised.pmmo.gui.PrefsEntry;
import harmonised.pmmo.gui.PrefsScrollPanel;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PrefsScreen
extends Screen {
    public static Map<String, Double> prefsMap;
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private int i;
    private double value;
    private static Button exitButton;
    Minecraft field_230706_i_ = Minecraft.func_71410_x();
    MainWindow sr = this.field_230706_i_.func_228018_at_();
    FontRenderer field_230712_o_;
    private int boxWidth;
    private int boxHeight;
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private int buttonX;
    private PrefsScrollPanel scrollPanel;
    private final JType jType;
    private ArrayList<PrefsEntry> prefsEntries;
    private ITextComponent title;
    private PlayerEntity player;

    public PrefsScreen(ITextComponent titleIn, JType jType) {
        super(titleIn);
        this.field_230712_o_ = this.field_230706_i_.field_71466_p;
        this.boxWidth = 256;
        this.boxHeight = 256;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.title = titleIn;
        this.jType = jType;
    }

    protected void func_231160_c_() {
        prefsMap = Config.getPreferencesMap(this.player);
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollX = this.x + 16;
        this.scrollY = this.y + 10;
        this.buttonX = this.scrollX + 4;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "", JType.SKILLS, button -> Minecraft.func_71410_x().func_147108_a((Screen)new PrefsChoiceScreen((ITextComponent)new TranslationTextComponent("pmmo.stats"))));
        this.prefsEntries = new ArrayList();
        switch (this.jType) {
            case SETTINGS: {
                this.value = Math.min((double)Skill.getLevel(Skill.BUILDING.toString(), this.player) / Config.getConfig("levelsPerOneReach"), Config.getConfig("maxExtraReachBoost"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxExtraReachBoost, "maxExtraReachBoost", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.ENDURANCE.toString(), this.player) / Config.getConfig("levelsPerHeart"), Config.getConfig("maxExtraHeartBoost"));
                this.addPrefsButtonInteger(Config.forgeConfig.maxExtraHeartBoost, "maxExtraHeartBoost", 0.0, this.value, false, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.COMBAT.toString(), this.player) * Config.getConfig("damageBonusPercentPerLevelMelee"), Config.getConfig("maxExtraDamagePercentageBoostMelee"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxExtraDamagePercentageBoostMelee, "maxExtraDamagePercentageBoostMelee", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.ARCHERY.toString(), this.player) * Config.getConfig("damageBonusPercentPerLevelArchery"), Config.getConfig("maxExtraDamagePercentageBoostArchery"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxExtraDamagePercentageBoostArchery, "maxExtraDamagePercentageBoostArchery", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.MAGIC.toString(), this.player) * Config.getConfig("damageBonusPercentPerLevelMagic"), Config.getConfig("maxExtraDamagePercentageBoostMagic"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxExtraDamagePercentageBoostMagic, "maxExtraDamagePercentageBoostMagic", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.AGILITY.toString(), this.player) * Config.getConfig("speedBoostPerLevel"), Config.getConfig("maxSpeedBoost"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxSpeedBoost, "maxSpeedBoost", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.AGILITY.toString(), this.player) * Config.getConfig("levelsPerSprintJumpBoost"), Config.getConfig("maxJumpBoost"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxJumpBoost, "maxSprintJumpBoost", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.AGILITY.toString(), this.player) * Config.getConfig("levelsPerCrouchJumpBoost"), Config.getConfig("maxJumpBoost"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxJumpBoost, "maxCrouchJumpBoost", 0.0, this.value, true, true, true);
                this.addPrefsButtonBool(Config.forgeConfig.wipeAllSkillsUponDeathPermanently, "wipeAllSkillsUponDeathPermanently", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.spawnFireworksCausedByMe, "spawnFireworksCausedByMe", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.spawnFireworksCausedByOthers, "spawnFireworksCausedByOthers", false, true, false);
                if (!XP.isNightvisionUnlocked(this.player)) break;
                this.addPrefsButtonBool(Config.forgeConfig.underwaterNightVision, "underwaterNightVision", false, true, false);
                break;
            }
            case GUI_SETTINGS: {
                this.addPrefsButtonDouble(Config.forgeConfig.barOffsetX, "barOffsetX", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.barOffsetY, "barOffsetY", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.veinBarOffsetX, "veinBarOffsetX", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.veinBarOffsetY, "veinBarOffsetY", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropOffsetX, "xpDropOffsetX", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropOffsetY, "xpDropOffsetY", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.skillListOffsetX, "skillListOffsetX", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.skillListOffsetY, "skillListOffsetY", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropSpawnDistance, "xpDropSpawnDistance", 0.0, 1000.0, false, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropOpacityPerTime, "xpDropOpacityPerTime", 0.0, 255.0, false, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropMaxOpacity, "xpDropMaxOpacity", 0.0, 255.0, false, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropDecayAge, "xpDropDecayAge", 0.0, 5000.0, false, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.minXpGrow, "minXpGrow", 0.01, 100.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.worldXpDropsSizeMultiplier, "worldXpDropsSizeMultiplier", 0.01, 100.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.worldXpDropsDecaySpeedMultiplier, "worldXpDropsDecaySpeedMultiplier", 0.01, 100.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.worldXpDropsRotationCap, "worldXpDropsRotationCap", 0.01, 100.0, true, true, false);
                this.addPrefsButtonInteger(Config.forgeConfig.maxVeinDisplay, "maxVeinDisplay", 0.0, 10000.0, false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.showSkillsListAtCorner, "showSkillsListAtCorner", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.showXpDrops, "showXpDrops", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.stackXpDrops, "stackXpDrops", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.xpDropsAttachedToBar, "xpDropsAttachedToBar", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.xpBarAlwaysOn, "xpBarAlwaysOn", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.xpLeftDisplayAlwaysOn, "xpLeftDisplayAlwaysOn", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.lvlUpScreenshot, "lvlUpScreenshot", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.xpDropsShowXpBar, "xpDropsShowXpBar", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.showLevelUpUnlocks, "showLevelUpUnlocks", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.worldXpDropsEnabled, "worldXpDropsEnabled", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.worldXpDropsShowSkill, "worldXpDropsShowSkill", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.showOthersWorldXpDrops, "showOthersWorldXpDrops", false, true, false);
            }
        }
        this.i = 0;
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!prefEntry.isSwitch) {
                prefEntry.textField.func_212954_a(text -> {
                    try {
                        this.value = Double.parseDouble(text);
                        if (this.value > prefEntry.slider.maxValue) {
                            this.value = prefEntry.slider.maxValue;
                        }
                        if (this.value < prefEntry.slider.minValue) {
                            this.value = prefEntry.slider.minValue;
                        }
                        prefEntry.slider.setValue(this.value);
                        prefEntry.slider.updateSlider();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                prefEntry.textField.func_200675_a(text -> text.matches("^[0-9]{0,3}[.]?[0-9]*$") && text.replace(".", "").length() < 5);
            }
            prefEntry.slider.setResponder(slider -> {
                slider.precision = 4;
                prefsMap.put(slider.preference, slider.getValue());
                if (prefEntry.removeIfMax && slider.getValue() == slider.maxValue) {
                    prefsMap.remove(slider.preference);
                }
                XPOverlayGUI.doInit();
                PlayerTickHandler.syncPrefs = true;
            });
            prefEntry.slider.updateSlider();
            prefEntry.setX(this.x + 24);
            prefEntry.setY(this.y + 24 + 18 * this.i++);
        }
        this.scrollPanel = new PrefsScrollPanel(new MatrixStack(), Minecraft.func_71410_x(), this.boxWidth - 40, this.boxHeight - 21, this.scrollY, this.scrollX, this.prefsEntries);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.children.add((IGuiEventListener)this.scrollPanel);
        this.func_230480_a_((Widget)exitButton);
    }

    private void addPrefsButtonBool(ConfigHelper.ConfigValueListener<Boolean> config, String key, boolean showDec, boolean showStr, boolean removeIfMax) {
        this.addPrefsButtonValue(key, config.get() != false ? 1.0 : 0.0, 0.0, 1.0, showDec, showStr, removeIfMax, true);
    }

    private void addPrefsButtonInteger(ConfigHelper.ConfigValueListener<Integer> config, String key, double min, double max, boolean showDec, boolean showStr, boolean removeIfMax) {
        this.addPrefsButtonValue(key, config.get().intValue(), min, max, showDec, showStr, removeIfMax, false);
    }

    private void addPrefsButtonDouble(ConfigHelper.ConfigValueListener<Double> config, String key, double min, double max, boolean showDec, boolean showStr, boolean removeIfMax) {
        this.addPrefsButtonValue(key, config.get(), min, max, showDec, showStr, removeIfMax, false);
    }

    private void addPrefsButtonValue(String key, double value, double min, double max, boolean showDec, boolean showStr, boolean removeIfMax, boolean isSwitch) {
        this.prefsEntries.add(new PrefsEntry(key, "", "", min, max, prefsMap.getOrDefault(key, value), value, showDec, showStr, removeIfMax, isSwitch));
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_238651_a_(stack, 1);
        if (this.field_230712_o_.func_78256_a(this.title.getString()) > 220) {
            PrefsScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.title.getString(), (int)(this.sr.func_198107_o() / 2), (int)(this.y - 10), (int)0xFFFFFF);
        } else {
            PrefsScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.title.getString(), (int)(this.sr.func_198107_o() / 2), (int)(this.y - 5), (int)0xFFFFFF);
        }
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollPanel.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (mouseX < prefEntry.button.field_230690_l_ || mouseX >= prefEntry.button.field_230690_l_ + prefEntry.button.func_230998_h_() || mouseY < prefEntry.button.field_230691_m_ || mouseY >= prefEntry.button.field_230691_m_ + prefEntry.button.func_238483_d_()) continue;
            this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent(prefEntry.isSwitch ? (prefEntry.defaultVal == 1.0 ? "ON" : "OFF") : (prefEntry.removeIfMax && prefEntry.defaultVal == prefEntry.slider.maxValue ? "MAX" : DP.dpSoft(prefEntry.defaultVal))), mouseX, mouseY);
        }
        MainScreen.scrollAmounts.replace(this.jType, this.scrollPanel.getScroll());
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public void func_238651_a_(MatrixStack stack, int p_renderBackground_1_) {
        if (this.field_230706_i_ != null && !this.jType.equals((Object)JType.GUI_SETTINGS)) {
            this.boxHeight = 256;
            this.boxWidth = 256;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
            this.func_238468_a_(stack, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, stack));
            this.func_238474_b_(stack, this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (this.prefsEntries.size() >= 9) {
            this.scrollPanel.func_231043_a_(mouseX, mouseY, scroll);
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.func_230930_b_();
            return true;
        }
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseClicked(mouseX, mouseY, button);
            if (prefEntry.isSwitch || !prefEntry.textField.func_231044_a_(mouseX, mouseY, button)) continue;
            this.func_212928_a((IGuiEventListener)prefEntry.textField);
            prefEntry.textField.func_146195_b(true);
        }
        this.scrollPanel.func_231044_a_(mouseX, mouseY, button);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseReleased(mouseX, mouseY, button);
        }
        this.scrollPanel.func_231048_c_(mouseX, mouseY, button);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        this.scrollPanel.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static TranslationTextComponent getTransComp(String translationKey, Double ... args) {
        return new TranslationTextComponent(translationKey, (Object[])args);
    }
}

