/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.curios.Curios;
import harmonised.pmmo.events.DamageHandler;
import harmonised.pmmo.events.FishedHandler;
import harmonised.pmmo.events.JumpHandler;
import harmonised.pmmo.events.PlayerTickHandler;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.StatsEntry;
import harmonised.pmmo.gui.StatsScrollPanel;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class StatsScreen
extends Screen {
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private final List<IGuiEventListener> children = Lists.newArrayList();
    private static TileButton exitButton;
    Minecraft field_230706_i_ = Minecraft.func_71410_x();
    MainWindow sr = this.field_230706_i_.func_228018_at_();
    FontRenderer field_230712_o_;
    private int boxWidth;
    private int boxHeight;
    private int x;
    private int y;
    private StatsScrollPanel scrollPanel;
    private List<StatsEntry> statsEntries;
    private UUID uuid;
    private JType jType;

    public StatsScreen(UUID uuid, ITextComponent titleIn) {
        super(titleIn);
        this.field_230712_o_ = this.field_230706_i_.field_71466_p;
        this.boxWidth = 256;
        this.boxHeight = 256;
        this.jType = JType.STATS;
        this.uuid = uuid;
    }

    public static void addXpMapEntryAsText(List<IFormattableTextComponent> text, Map<String, Double> xpBoosts) {
        for (Map.Entry<String, Double> entry : xpBoosts.entrySet()) {
            String skill = entry.getKey();
            Style color = Skill.getSkillStyle(skill);
            skill = new TranslationTextComponent("pmmo." + skill).getString();
            text.add(new StringTextComponent((entry.getValue() < 0.0 ? " " : " +") + new TranslationTextComponent("pmmo.levelDisplayPercentage", new Object[]{DP.dpSoft(entry.getValue()), skill}).getString()).func_230530_a_(color));
        }
    }

    protected void func_231160_c_() {
        Map<String, Double> map;
        this.statsEntries = new ArrayList<StatsEntry>();
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "pmmo.exit", JType.NONE, something -> Minecraft.func_71410_x().func_147108_a((Screen)new MainScreen(this.uuid, (ITextComponent)new TranslationTextComponent("pmmo.skills"))));
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ArrayList<Object> text = new ArrayList<IFormattableTextComponent>();
        TranslationTextComponent entryTitle = new TranslationTextComponent("pmmo.damage");
        text.add(new TranslationTextComponent("pmmo.damageBonusMelee", new Object[]{(double)(100 * Skill.getLevel(Skill.COMBAT.toString(), (PlayerEntity)player)) * Config.forgeConfig.damageBonusPercentPerLevelMelee.get()}).func_230530_a_(Skill.getSkillStyle(Skill.COMBAT.toString())));
        text.add(new TranslationTextComponent("pmmo.damageBonusArchery", new Object[]{(double)(100 * Skill.getLevel(Skill.ARCHERY.toString(), (PlayerEntity)player)) * Config.forgeConfig.damageBonusPercentPerLevelArchery.get()}).func_230530_a_(Skill.getSkillStyle(Skill.ARCHERY.toString())));
        text.add(new TranslationTextComponent("pmmo.damageBonusMagic", new Object[]{(double)(100 * Skill.getLevel(Skill.MAGIC.toString(), (PlayerEntity)player)) * Config.forgeConfig.damageBonusPercentPerLevelMagic.get()}).func_230530_a_(Skill.getSkillStyle(Skill.MAGIC.toString())));
        text.add(new TranslationTextComponent("pmmo.damageBonusGunslinging", new Object[]{(double)(100 * Skill.getLevel(Skill.MAGIC.toString(), (PlayerEntity)player)) * Config.forgeConfig.damageBonusPercentPerLevelMagic.get()}).func_230530_a_(Skill.getSkillStyle(Skill.GUNSLINGING.toString())));
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.speed");
        text.add(new TranslationTextComponent("pmmo.sprintSpeedBonus", new Object[]{DP.dpSoft(AttributeHandler.getSpeedBoostMultiplier(Skill.getLevel(Skill.AGILITY.toString(), (PlayerEntity)player)) * 100.0)}).func_230530_a_(Skill.getSkillStyle(Skill.AGILITY.toString())));
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.jump");
        text.add(new TranslationTextComponent("pmmo.jumpBonusSprint", new Object[]{DP.dpSoft(JumpHandler.getSprintJumpBoost((PlayerEntity)player) / 0.14)}).func_230530_a_(Skill.getSkillStyle(Skill.AGILITY.toString())));
        text.add(new TranslationTextComponent("pmmo.jumpBonusCrouch", new Object[]{DP.dpSoft(JumpHandler.getCrouchJumpBoost((PlayerEntity)player) / 0.14)}).func_230530_a_(Skill.getSkillStyle(Skill.AGILITY.toString())));
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.fallSaveChance");
        text.add(new TranslationTextComponent("pmmo.fallSaveChancePercentage", new Object[]{DP.dpSoft(DamageHandler.getFallSaveChance((PlayerEntity)player))}).func_230530_a_(Skill.getSkillStyle(Skill.AGILITY.toString())));
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.endurance");
        text.add(new TranslationTextComponent("pmmo.damageReductionPercentage", new Object[]{DP.dpSoft(DamageHandler.getEnduranceMultiplier((PlayerEntity)player) * 100.0)}).func_230530_a_(Skill.getSkillStyle(Skill.ENDURANCE.toString())));
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.hearts");
        text.add(new TranslationTextComponent("pmmo.heartBonus", new Object[]{AttributeHandler.getHeartBoost((PlayerEntity)player) / 2}).func_230530_a_(Skill.getSkillStyle(Skill.ENDURANCE.toString())));
        double hpRegenTime = PlayerTickHandler.getHpRegenTime((PlayerEntity)player);
        if (hpRegenTime < Double.POSITIVE_INFINITY) {
            text.add(new TranslationTextComponent("pmmo.halfHeartRegenerationSeconds", new Object[]{DP.dpSoft(60.0 / hpRegenTime)}).func_230530_a_(Skill.getSkillStyle(Skill.ENDURANCE.toString())));
        }
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.reach");
        text.add(new TranslationTextComponent("pmmo.reachBonus", new Object[]{DP.dpSoft(AttributeHandler.getReachBoost((PlayerEntity)player))}).func_230530_a_(Skill.getSkillStyle(Skill.BUILDING.toString())));
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.underwaterNightVision");
        text.add(new TranslationTextComponent(Skill.getLevelDecimal(Skill.SWIMMING.toString(), (PlayerEntity)player) >= Config.getConfig("nightvisionUnlockLevel") ? "pmmo.unlocked" : "pmmo.locked").func_230530_a_(Skill.getSkillStyle(Skill.SWIMMING.toString())));
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.dualSalvage");
        text.add(new TranslationTextComponent(Skill.getLevelDecimal(Skill.SMITHING.toString(), (PlayerEntity)player) >= Config.getConfig("dualSalvageSmithingLevelReq") ? "pmmo.unlocked" : "pmmo.locked").func_230530_a_(Skill.getSkillStyle(Skill.SMITHING.toString())));
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.rareFishPool");
        text.add(new TranslationTextComponent("pmmo.fishPoolChance", new Object[]{DP.dpSoft(FishedHandler.getFishPoolChance((PlayerEntity)player) * 100.0)}).func_230530_a_(Skill.getSkillStyle(Skill.FISHING.toString())));
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        text = new ArrayList();
        entryTitle = new TranslationTextComponent("pmmo.xpBonuses");
        PlayerInventory inv = player.field_71071_by;
        ItemStack itemStack = inv.func_70301_a(39);
        if (!itemStack.func_190926_b() && (map = XP.getStackXpBoosts(itemStack, false)).size() > 0) {
            text.add((IFormattableTextComponent)new TranslationTextComponent(itemStack.func_77977_a()));
            StatsScreen.addXpMapEntryAsText(text, map);
        }
        if (!(itemStack = inv.func_70301_a(38)).func_190926_b() && (map = XP.getStackXpBoosts(itemStack, false)).size() > 0) {
            text.add(new TranslationTextComponent(itemStack.func_77977_a()));
            StatsScreen.addXpMapEntryAsText(text, map);
        }
        if (!(itemStack = inv.func_70301_a(37)).func_190926_b() && (map = XP.getStackXpBoosts(itemStack, false)).size() > 0) {
            text.add(new TranslationTextComponent(itemStack.func_77977_a()));
            StatsScreen.addXpMapEntryAsText(text, map);
        }
        if (!(itemStack = inv.func_70301_a(36)).func_190926_b() && (map = XP.getStackXpBoosts(itemStack, false)).size() > 0) {
            text.add(new TranslationTextComponent(itemStack.func_77977_a()));
            StatsScreen.addXpMapEntryAsText(text, map);
        }
        if (!(itemStack = player.func_184592_cb()).func_190926_b() && (map = XP.getStackXpBoosts(itemStack, false)).size() > 0) {
            text.add(new TranslationTextComponent(itemStack.func_77977_a()));
            StatsScreen.addXpMapEntryAsText(text, map);
        }
        if (!(itemStack = player.func_184614_ca()).func_190926_b() && (map = XP.getStackXpBoosts(itemStack, true)).size() > 0) {
            text.add(new TranslationTextComponent(itemStack.func_77977_a()));
            StatsScreen.addXpMapEntryAsText(text, map);
        }
        if (Curios.isLoaded()) {
            Collection curiosItems = Curios.getCurios((PlayerEntity)player).collect(Collectors.toSet());
            for (ICurioStacksHandler value : curiosItems) {
                for (int i = 0; i < value.getSlots(); ++i) {
                    StatsScreen.addXpMapEntryAsText(text, XP.getStackXpBoosts(value.getStacks().getStackInSlot(i), true));
                }
            }
        }
        if ((map = XP.getDimensionBoosts("" + XP.getDimResLoc(player.field_70170_p))).size() > 0) {
            text.add(new TranslationTextComponent("pmmo.dimension"));
            StatsScreen.addXpMapEntryAsText(text, map);
        }
        if ((map = XP.getBiomeBoosts((PlayerEntity)player)).size() > 0) {
            text.add(new TranslationTextComponent("pmmo.biome"));
            StatsScreen.addXpMapEntryAsText(text, map);
        }
        for (Map.Entry<String, Map<String, Double>> outterEntry : APIUtils.getXpBoostsMap((PlayerEntity)player).entrySet()) {
            text.add(new TranslationTextComponent(outterEntry.getKey()));
            StatsScreen.addXpMapEntryAsText(text, NBTHelper.mapStringKeyToString(outterEntry.getValue()));
        }
        this.statsEntries.add(new StatsEntry(0, 0, (TextComponent)entryTitle, text));
        this.scrollPanel = new StatsScrollPanel(new MatrixStack(), Minecraft.func_71410_x(), this.boxWidth - 40, this.boxHeight - 21, this.y + 10, this.x + 16, this.statsEntries);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.children.add((IGuiEventListener)this.scrollPanel);
        this.func_230480_a_((Widget)exitButton);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_238651_a_(stack, 1);
        if (this.field_230712_o_.func_78256_a(this.field_230704_d_.getString()) > 220) {
            StatsScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.sr.func_198107_o() / 2), (int)(this.y - 10), (int)0xFFFFFF);
        } else {
            StatsScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.sr.func_198107_o() / 2), (int)(this.y - 5), (int)0xFFFFFF);
        }
        this.x = this.sr.func_198107_o() / 2 - this.boxWidth / 2;
        this.y = this.sr.func_198087_p() / 2 - this.boxHeight / 2;
        this.scrollPanel.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public void func_238651_a_(MatrixStack stack, int p_renderBackground_1_) {
        if (this.field_230706_i_ != null) {
            this.func_238468_a_(stack, 0, 0, this.field_230708_k_, this.field_230709_l_, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, stack));
        }
        this.boxHeight = 256;
        this.boxWidth = 256;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.box);
        this.func_238474_b_(stack, this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        this.scrollPanel.func_231043_a_(mouseX, mouseY, scroll);
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.func_230930_b_();
            return true;
        }
        this.scrollPanel.func_231044_a_(mouseX, mouseY, button);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.scrollPanel.func_231048_c_(mouseX, mouseY, button);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.scrollPanel.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }
}

