/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.gui.StatsEntry;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import org.lwjgl.opengl.GL11;

public class StatsScrollPanel
extends ScrollPanel {
    MainWindow sr;
    private final int boxWidth = 256;
    private final int boxHeight = 256;
    private final List<StatsEntry> statsEntries;
    private StatsEntry statsEntry;
    private FontRenderer font;
    private final Minecraft client;
    private final int width;
    private final int height;
    private final int top;
    private final int bottom;
    private final int right;
    private final int left;
    private final int barLeft;
    private final int border = 4;
    private final int barWidth = 6;

    public StatsScrollPanel(MatrixStack stack, Minecraft client, int width, int height, int top, int left, List<StatsEntry> statsEntries) {
        super(client, width, height, top, left);
        this.statsEntries = statsEntries;
        this.sr = Minecraft.func_71410_x().func_228018_at_();
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - 6;
    }

    protected int getContentHeight() {
        int height = 16;
        for (StatsEntry a : this.statsEntries) {
            height += a.getHeight() + 3;
        }
        return height;
    }

    protected void drawPanel(MatrixStack stack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int accumulativeHeight = 0;
        for (int i = 0; i < this.statsEntries.size(); ++i) {
            this.statsEntry = this.statsEntries.get(i);
            this.statsEntry.setX(this.left + 6);
            this.statsEntry.setY(relativeY + accumulativeHeight);
            Color color = this.statsEntry.title.func_150256_b().func_240711_a_();
            int hexColor = color == null ? 0xFFFFFF : color.func_240742_a_();
            this.func_238468_a_(stack, this.left + 4, this.statsEntry.getY() - 2, this.right - 2, this.statsEntry.getY() + this.statsEntry.getHeight() + 2, 0x22444444, 0x33222222);
            StatsScrollPanel.func_238471_a_((MatrixStack)stack, (FontRenderer)this.font, (String)this.statsEntry.title.getString(), (int)(this.sr.func_198107_o() / 2), (int)this.statsEntry.getY(), (int)hexColor);
            for (int j = 0; j < this.statsEntry.text.size(); ++j) {
                IFormattableTextComponent line = this.statsEntry.text.get(j);
                color = line.func_150256_b().func_240711_a_();
                hexColor = color == null ? 0xFFFFFF : color.func_240742_a_();
                StatsScrollPanel.func_238476_c_((MatrixStack)stack, (FontRenderer)this.font, (String)line.getString(), (int)this.statsEntry.getX(), (int)(2 + this.statsEntry.getY() + (j + 1) * 11), (int)hexColor);
            }
            accumulativeHeight += this.statsEntry.getHeight() + 4;
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public int getScroll() {
        return (int)this.scrollDistance;
    }

    public void setScroll(int scroll) {
        this.scrollDistance = scroll;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRelativeY() {
        return this.top + this.border - (int)this.scrollDistance;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        double scale = this.client.func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.client.func_228018_at_().func_198091_l() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(stack, this.right, baseY, tess, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        int extraHeight = this.getContentHeight() + 4 - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.disableTexture();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)this.bottom, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.bottom, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)this.top, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)this.top, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_225582_a_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            worldr.func_225582_a_((double)this.barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        GL11.glDisable((int)3089);
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - 8) {
            barHeight = this.height - 8;
        }
        return barHeight;
    }
}

