/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WorldRenderHandler {
    private static long lastTime = System.nanoTime();
    private static final FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
    private static final Map<ResourceLocation, List<WorldXpDrop>> xpDrops = new HashMap<ResourceLocation, List<WorldXpDrop>>();
    private static final Map<ResourceLocation, List<WorldText>> worldTexts = new HashMap<ResourceLocation, List<WorldText>>();
    private static long currTime;
    private static double d;

    @SubscribeEvent
    public void handleWorldRender(RenderWorldLastEvent event) {
        currTime = System.nanoTime();
        d = (double)(currTime - lastTime) / 1.0E9;
        WorldRenderHandler.renderWorldText(event);
        WorldRenderHandler.renderWorldXpDrops(event);
        if (XP.isPlayerSurvival((PlayerEntity)WorldRenderHandler.mc.field_71439_g)) {
            WorldRenderHandler.drawBoxHighlights(event);
        }
    }

    public static void drawBoxHighlights(RenderWorldLastEvent event) {
        MatrixStack stack = event.getMatrixStack();
        Vector3d cameraPos = WorldRenderHandler.mc.func_175598_ae().field_217783_c.func_216785_c();
        stack.func_227860_a_();
        stack.func_227861_a_(-cameraPos.func_82615_a(), -cameraPos.func_82617_b(), -cameraPos.func_82616_c());
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228659_m_());
        if (XPOverlayGUI.getVeinKey() && XPOverlayGUI.getLookingAtBlock() && XPOverlayGUI.getMetToolReq() && XPOverlayGUI.getCanBreak()) {
            for (BlockPos pos : XPOverlayGUI.veinShapeSet) {
                WorldRenderHandler.drawBoxHighlight(stack, builder, pos);
            }
        }
        stack.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228461_a_();
    }

    public static void drawBoxHighlight(MatrixStack stack, IVertexBuilder builder, BlockPos pos) {
        stack.func_227860_a_();
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        int red = 255;
        int green = 0;
        int blue = 255;
        int alpha = 255;
        block5: for (int i = 0; i < 12; ++i) {
            int mode = i / 4;
            int j = i % 4;
            float modulus = j % 2;
            float divide = j / 2;
            switch (mode) {
                case 0: {
                    builder.func_227888_a_(matrix4f, (float)pos.func_177958_n() + modulus, (float)pos.func_177956_o() + divide, (float)pos.func_177952_p()).func_225586_a_(red, green, blue, alpha).func_181675_d();
                    builder.func_227888_a_(matrix4f, (float)pos.func_177958_n() + modulus, (float)pos.func_177956_o() + divide, (float)(pos.func_177952_p() + 1)).func_225586_a_(red, green, blue, alpha).func_181675_d();
                    continue block5;
                }
                case 1: {
                    builder.func_227888_a_(matrix4f, (float)pos.func_177958_n(), (float)pos.func_177956_o() + modulus, (float)pos.func_177952_p() + divide).func_225586_a_(red, green, blue, alpha).func_181675_d();
                    builder.func_227888_a_(matrix4f, (float)(pos.func_177958_n() + 1), (float)pos.func_177956_o() + modulus, (float)pos.func_177952_p() + divide).func_225586_a_(red, green, blue, alpha).func_181675_d();
                    continue block5;
                }
                case 2: {
                    builder.func_227888_a_(matrix4f, (float)pos.func_177958_n() + divide, (float)pos.func_177956_o(), (float)pos.func_177952_p() + modulus).func_225586_a_(red, green, blue, alpha).func_181675_d();
                    builder.func_227888_a_(matrix4f, (float)pos.func_177958_n() + divide, (float)(pos.func_177956_o() + 1), (float)pos.func_177952_p() + modulus).func_225586_a_(red, green, blue, alpha).func_181675_d();
                }
            }
        }
        stack.func_227865_b_();
    }

    public static void drawText(MatrixStack stack, Vector3d cameraPos, Vector3d textPos, String text, float scale, float rotation, int color) {
        stack.func_227860_a_();
        float textWidth = fr.func_78256_a(text);
        float textOffset = -textWidth / 2.0f;
        stack.func_227861_a_(textPos.func_82615_a() - cameraPos.func_82615_a(), textPos.func_82617_b() - cameraPos.func_82617_b(), textPos.func_82616_c() - cameraPos.func_82616_c());
        stack.func_227863_a_(mc.func_175598_ae().func_229098_b_());
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotation));
        stack.func_227862_a_(-scale, -scale, scale);
        IReorderingProcessor reorderingProcessor = IReorderingProcessor.func_242239_a((String)text, (Style)XP.getColorStyle(color));
        fr.func_238416_a_(reorderingProcessor, textOffset, 0.0f, color, true, stack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, color, 225);
        stack.func_227865_b_();
    }

    private static void renderWorldText(RenderWorldLastEvent event) {
        ClientWorld world = WorldRenderHandler.mc.field_71441_e;
        if (world == null) {
            return;
        }
        ResourceLocation dimResLoc = XP.getDimResLoc((World)world);
        if (!worldTexts.containsKey(dimResLoc)) {
            return;
        }
        List<WorldText> dimTexts = worldTexts.get(dimResLoc);
        MatrixStack stack = event.getMatrixStack();
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        Vector3d cameraPos = WorldRenderHandler.mc.field_71460_t.func_215316_n().func_216785_c();
        stack.func_227860_a_();
        for (int i = dimTexts.size() - 1; i >= 0; --i) {
            WorldText worldText = dimTexts.get(i);
            if (worldText == null) continue;
            if (!worldText.tick(d * (1.0 + (double)i * 0.01))) {
                dimTexts.remove(i);
                continue;
            }
            WorldRenderHandler.drawText(stack, cameraPos, worldText.getPos(), worldText.getText(), (float)worldText.getSize(), worldText.getRotation(), worldText.getColor());
        }
        stack.func_227865_b_();
        buffer.func_228461_a_();
        lastTime = currTime;
    }

    private static void renderWorldXpDrops(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        ResourceLocation dimResLoc = XP.getDimResLoc((World)world);
        if (!xpDrops.containsKey(dimResLoc)) {
            return;
        }
        List<WorldXpDrop> dimXpDrops = xpDrops.get(dimResLoc);
        MatrixStack stack = event.getMatrixStack();
        Vector3d cameraPos = mc.field_71460_t.func_215316_n().func_216785_c();
        stack.func_227860_a_();
        for (int i = dimXpDrops.size() - 1; i >= 0; --i) {
            WorldXpDrop xpDrop = dimXpDrops.get(i);
            if (xpDrop == null) continue;
            if (xpDrop.xp <= 0.0f) {
                dimXpDrops.remove(i);
                continue;
            }
            float scale = 0.02f * (xpDrop.xp / xpDrop.getStartXp()) * xpDrop.getSize() * WorldText.worldXpDropsSizeMultiplier;
            int color = xpDrop.getColor();
            String text = "+" + DP.dpSoft(xpDrop.xp);
            if (WorldText.worldXpDropsShowSkill) {
                text = text + " " + new TranslationTextComponent(xpDrop.getSkill()).getString();
            }
            WorldRenderHandler.drawText(stack, cameraPos, xpDrop.getPos(), text, scale, xpDrop.getRotation(), color);
            xpDrop.xp = (float)((double)xpDrop.xp - Math.max(0.01523, (double)(xpDrop.xp * xpDrop.getDecaySpeed()) * (1.0 + (double)i * 0.01)) * (double)WorldText.worldXpDropsDecaySpeedMultiplier * d);
        }
        stack.func_227865_b_();
        buffer.func_228461_a_();
        lastTime = currTime;
    }

    public static void addWorldXpDropOffline(WorldXpDrop xpDrop) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && Config.getPreferencesMap((PlayerEntity)player).getOrDefault("worldXpDropsEnabled", 1.0) != 0.0) {
            ResourceLocation dimResLoc = xpDrop.getWorldResLoc();
            if (!xpDrops.containsKey(dimResLoc)) {
                xpDrops.put(dimResLoc, new ArrayList());
                lastTime = System.nanoTime();
            }
            xpDrops.get(dimResLoc).add(xpDrop);
        }
    }

    public static void addWorldTextOffline(WorldText worldText) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ResourceLocation dimResLoc = worldText.getWorldResLoc();
        if (!worldTexts.containsKey(dimResLoc)) {
            worldTexts.put(dimResLoc, new ArrayList());
            lastTime = System.nanoTime();
        }
        worldTexts.get(dimResLoc).add(worldText);
    }
}

