/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.skills.Skill;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class WorldXpDrop {
    public static float worldXpDropsRotationCap = (float)(0.0 + Config.forgeConfig.worldXpDropsRotationCap.get());
    private final ResourceLocation worldResLoc;
    private final Vector3d pos;
    private final String skill;
    private final int color;
    private float rotation;
    private float size = 1.0f;
    private float decaySpeed = 1.0f;
    public float xp;
    public float startXp;

    public static WorldXpDrop fromXYZ(ResourceLocation worldResLoc, double x, double y, double z, double maxOffset, double xp, String skill) {
        return WorldXpDrop.fromXYZ(worldResLoc, x, y, z, maxOffset, (float)xp, skill);
    }

    public static WorldXpDrop fromXYZ(ResourceLocation worldResLoc, double x, double y, double z, double maxOffset, float xp, String skill) {
        return new WorldXpDrop(worldResLoc, new Vector3d(x + Math.random() * maxOffset * 2.0 - maxOffset, y + Math.random() * maxOffset * 2.0 - maxOffset, z + Math.random() * maxOffset * 2.0 - maxOffset), xp, skill);
    }

    public static WorldXpDrop fromVector(ResourceLocation worldResLoc, Vector3d pos, double maxOffset, double xp, String skill) {
        return WorldXpDrop.fromVector(worldResLoc, pos, maxOffset, (float)xp, skill);
    }

    public static WorldXpDrop fromVector(ResourceLocation worldResLoc, Vector3d pos, double maxOffset, float xp, String skill) {
        return new WorldXpDrop(worldResLoc, maxOffset == 0.0 ? pos : new Vector3d(pos.func_82615_a() + Math.random() * maxOffset * 2.0 - maxOffset, pos.func_82617_b() + Math.random() * maxOffset * 2.0 - maxOffset, pos.func_82616_c() + Math.random() * maxOffset * 2.0 - maxOffset), xp, skill);
    }

    public static WorldXpDrop fromBlockPos(ResourceLocation worldResLoc, BlockPos pos, double maxOffset, double xp, String skill) {
        return WorldXpDrop.fromBlockPos(worldResLoc, pos, maxOffset, (float)xp, skill);
    }

    public static WorldXpDrop fromBlockPos(ResourceLocation worldResLoc, BlockPos pos, double maxOffset, float xp, String skill) {
        return new WorldXpDrop(worldResLoc, new Vector3d((double)pos.func_177958_n() + 0.5 + Math.random() * maxOffset * 2.0 - maxOffset, (double)pos.func_177956_o() + 0.5 + Math.random() * maxOffset * 2.0 - maxOffset, (double)pos.func_177952_p() + 0.5 + Math.random() * maxOffset * 2.0 - maxOffset), xp, skill);
    }

    private WorldXpDrop(ResourceLocation worldResLoc, Vector3d pos, float xp, String skill) {
        this.worldResLoc = worldResLoc;
        this.pos = pos;
        this.xp = this.startXp = xp;
        this.skill = skill;
        this.color = Skill.getSkillColor(skill);
        this.rotation = WorldXpDrop.getRandomRotation();
    }

    private static float getRandomRotation() {
        return (float)(Math.random() * (double)worldXpDropsRotationCap * 2.0 - (double)worldXpDropsRotationCap);
    }

    public Vector3d getPos() {
        return this.pos;
    }

    public String getSkill() {
        return this.skill;
    }

    public int getColor() {
        return this.color;
    }

    public float getStartXp() {
        return this.startXp;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public float getDecaySpeed() {
        return this.decaySpeed;
    }

    public void setDecaySpeed(double decaySpeed) {
        this.decaySpeed = (float)decaySpeed;
    }

    public void setDecaySpeed(float decaySpeed) {
        this.decaySpeed = decaySpeed;
    }

    public ResourceLocation getWorldResLoc() {
        return this.worldResLoc;
    }
}

