/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.gui.ASkill;
import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.gui.XpDrop;
import harmonised.pmmo.network.MessageLevelUp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.skills.VeinInfo;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XPOverlayGUI
extends AbstractGui {
    public static final Logger LOGGER = LogManager.getLogger();
    private static int barWidth = 102;
    private static int barHeight = 5;
    private static int barPosX;
    private static int barPosY;
    private static int veinBarPosX;
    private static int veinBarPosY;
    private static int xpDropPosX;
    private static int xpDropPosY;
    private static int skillListX;
    private static int skillListY;
    private static int tempAlpha;
    private static int levelGap;
    private static int skillGap;
    private static int xpGap;
    private static int halfscreen;
    private static int tempInt;
    private static int xpDropDecayAge;
    private static ArrayList<String> skillsKeys;
    private static double xp;
    private static double goalXp;
    private static double cooldown;
    private static double lastTime;
    private static double startLevel;
    private static double timeDiff;
    private static double bonus;
    private static double level;
    private static double decayRate;
    private static double decayAmount;
    private static double growAmount;
    private static double xpDropOffset;
    private static double xpDropOffsetCap;
    private static double minXpGrow;
    private static double barOffsetX;
    private static double barOffsetY;
    private static double veinBarOffsetX;
    private static double veinBarOffsetY;
    private static double xpDropOffsetX;
    private static double xpDropOffsetY;
    private static double skillListOffsetX;
    private static double skillListOffsetY;
    private static double xpDropSpawnDistance;
    private static double xpDropOpacityPerTime;
    private static double xpDropMaxOpacity;
    private static double biomePenaltyMultiplier;
    private static double maxVeinCharge;
    private static String tempString;
    private static int theme;
    private static int themePos;
    private static int listIndex;
    private static int xpDropYLimit;
    private static boolean stackXpDrops;
    private static boolean init;
    private static boolean showSkillsListAtCorner;
    private static boolean showXpDrops;
    private static boolean barKey;
    private static boolean listKey;
    private static boolean veinKey;
    private static boolean barPressed;
    private static boolean listPressed;
    private static boolean xpDropsAttachedToBar;
    private static boolean xpDropWasStacked;
    private static boolean xpLeftDisplayAlwaysOn;
    private static boolean xpBarAlwaysOn;
    private static boolean lvlUpScreenshot;
    private static boolean lvlUpScreenshotShowSkills;
    private static boolean xpDropsShowXpBar;
    private static boolean showLevelUpUnlocks;
    private final ResourceLocation bar = XP.getResLoc("pmmo", "textures/gui/xpbar.png");
    private static ArrayList<XpDrop> xpDrops;
    private static Minecraft mc;
    private static PlayerEntity player;
    public static Map<String, ASkill> skills;
    private static ASkill aSkill;
    private static ASkill tempASkill;
    private static String activeSkill;
    private static String tempSkill;
    private static FontRenderer fontRenderer;
    private static int maxLevel;
    private static int color;
    private static int breakAmount;
    private static int veinMaxBlocks;
    private static double maxXp;
    private static XpDrop xpDrop;
    private static long lastBonusUpdate;
    private static long lastVeinBlockUpdate;
    private static double itemBoost;
    private static double biomeBoost;
    private static double dimensionBoost;
    private static double playerXpBoost;
    private static double dimensionMultiplier;
    private static double multiplier;
    private static double tempDouble;
    private static double veinPos;
    private static double lastVeinPos;
    private static double veinPosGoal;
    private static double addAmount;
    private static double lossAmount;
    private static double veinLeft;
    private static BlockState blockState;
    private static BlockState lastBlockState;
    public static BlockPos blockPos;
    public static BlockPos lastBlockPos;
    private static String lastBlockRegKey;
    private static String lastBlockTransKey;
    private static Item lastToolHeld;
    private static Map<String, Double> biomeBoosts;
    private static MatrixStack stack;
    public static Set<String> screenshots;
    public static boolean listWasOn;
    public static boolean barOn;
    public static boolean listOn;
    public static boolean isVeining;
    public static boolean canBreak;
    public static boolean canVein;
    public static boolean lookingAtBlock;
    public static boolean metToolReq;
    public static Set<BlockPos> veinShapeSet;
    MainWindow sr;

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            try {
                this.sr = mc.func_228018_at_();
                stack = event.getMatrixStack();
                player = Minecraft.func_71410_x().field_71439_g;
                if (!init) {
                    XPOverlayGUI.doInit();
                    init = true;
                }
                barPosX = (int)((double)(this.sr.func_198107_o() - barWidth) * barOffsetX);
                barPosY = (int)((double)(this.sr.func_198087_p() - barHeight) * barOffsetY);
                xpDropPosX = (int)((double)(this.sr.func_198107_o() - barWidth) * xpDropOffsetX);
                xpDropPosY = (int)((double)(this.sr.func_198087_p() - barHeight) * xpDropOffsetY);
                skillListX = (int)((double)this.sr.func_198107_o() * skillListOffsetX);
                skillListY = (int)((double)this.sr.func_198087_p() * skillListOffsetY);
                timeDiff = (double)System.nanoTime() - lastTime;
                lastTime = System.nanoTime();
                barKey = ClientHandler.SHOW_BAR.func_151470_d();
                listKey = ClientHandler.SHOW_LIST.func_151470_d();
                veinKey = ClientHandler.VEIN_KEY.func_151470_d();
                if (barKey || xpBarAlwaysOn) {
                    cooldown = 1.0;
                }
                if (barKey) {
                    if (!barPressed) {
                        barOn = !barOn;
                        barPressed = true;
                    }
                } else {
                    barPressed = false;
                }
                if (listKey) {
                    if (!listPressed) {
                        listOn = !listOn;
                        listPressed = true;
                    }
                } else {
                    listPressed = false;
                }
                this.updateASkill();
                if (showSkillsListAtCorner) {
                    this.doSkillList();
                }
                if (!Minecraft.func_71410_x().func_147113_T()) {
                    this.doRayTrace();
                    this.doVein();
                    this.doSkills();
                }
                if (aSkill != null) {
                    this.doXpDrops(stack);
                    this.doXpBar();
                }
                if (cooldown > 0.0) {
                    cooldown -= timeDiff / 1000000.0;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error rendering PMMO GUI", (Throwable)e);
            }
            RenderSystem.color3f((float)255.0f, (float)255.0f, (float)255.0f);
            RenderSystem.popMatrix();
        }
    }

    private void updateASkill() {
        aSkill = skills.get(activeSkill);
        if (aSkill == null && skills.size() > 0) {
            activeSkill = skills.keySet().iterator().next();
            aSkill = skills.get(activeSkill);
        }
    }

    private void doRayTrace() {
        if (XPOverlayGUI.mc.field_71476_x != null && XPOverlayGUI.mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
            lookingAtBlock = true;
            blockPos = ((BlockRayTraceResult)XPOverlayGUI.mc.field_71476_x).func_216350_a();
            blockState = XPOverlayGUI.mc.field_71441_e.func_180495_p(blockPos);
            if (lastBlockPos == null) {
                this.updateLastBlock();
            }
            if (!blockPos.equals((Object)lastBlockPos) && XP.isPlayerSurvival(player)) {
                XPOverlayGUI.updateVein();
            }
            if (lastBlockState.func_177230_c().equals(blockState.func_177230_c())) {
                lastVeinBlockUpdate = System.nanoTime();
            }
            if (!isVeining && System.nanoTime() - lastVeinBlockUpdate > 100000000L) {
                this.updateLastBlock();
            }
            canBreak = XP.checkReq(player, lastBlockRegKey, JType.REQ_BREAK);
        } else {
            lookingAtBlock = false;
        }
    }

    private void updateLastBlock() {
        lastBlockState = blockState;
        lastBlockPos = blockPos;
        if (lastBlockState.func_177230_c().getRegistryName() != null) {
            lastBlockRegKey = lastBlockState.func_177230_c().getRegistryName().toString();
        }
        canVein = WorldTickHandler.canVeinGlobal(lastBlockRegKey, player) && WorldTickHandler.canVeinDimension(lastBlockRegKey, player);
        lastBlockTransKey = lastBlockState.func_177230_c().func_149739_a();
    }

    public static void updateVein() {
        if (blockState == null) {
            return;
        }
        veinShapeSet.clear();
        VeinInfo veinInfo = new VeinInfo((World)XPOverlayGUI.mc.field_71441_e, blockState, blockPos, player.func_184614_ca());
        ArrayList<BlockPos> veinShape = WorldTickHandler.getVeinShape(veinInfo, WorldTickHandler.getVeinLeft(player), WorldTickHandler.getVeinCost(blockState, blockPos, player), false, false);
        int veinShapeSize = veinShape.size();
        int matches = 0;
        for (int i = 0; i < veinShapeSize; ++i) {
            BlockPos pos = veinShape.get(i);
            if (pos.equals((Object)blockPos)) continue;
            if (++matches > breakAmount || (double)matches > Config.getPreferencesMap(player).getOrDefault("maxVeinDisplay", (double)Config.forgeConfig.maxVeinDisplay.get())) break;
            veinShapeSet.add(pos);
        }
    }

    private void doXpDrops(MatrixStack stack) {
        if (xpDropsAttachedToBar) {
            xpDropOffsetCap = cooldown <= 0.0 ? -9.0 : (barKey || xpLeftDisplayAlwaysOn ? (XPOverlayGUI.aSkill.xp >= maxXp ? 25.0 : 34.0) : 16.0);
            if (xpDropOffset > xpDropOffsetCap) {
                xpDropOffset -= 1.0 * timeDiff / 1.0E7;
            }
            if (xpDropOffset < xpDropOffsetCap) {
                xpDropOffset = xpDropOffsetCap;
            }
        }
        for (int i = 0; i < xpDrops.size(); ++i) {
            xpDrop = xpDrops.get(i);
            XPOverlayGUI.xpDrop.age = (int)((double)XPOverlayGUI.xpDrop.age + timeDiff / 5000000.0);
            decayRate = 0.75f + (float)(1 * xpDrops.size()) * 0.02f;
            decayAmount = decayRate * timeDiff / 1.0E7;
            if (!mc.func_147113_T() && (XPOverlayGUI.xpDrop.Y - decayAmount < 0.0 && XPOverlayGUI.xpDrop.age >= xpDropDecayAge || !showXpDrops || !xpDropsAttachedToBar && XPOverlayGUI.xpDrop.age >= xpDropDecayAge)) {
                tempASkill = skills.get(XPOverlayGUI.xpDrop.skill);
                if (!XPOverlayGUI.xpDrop.skip) {
                    activeSkill = XPOverlayGUI.xpDrop.skill;
                }
                decayRate = XPOverlayGUI.xpDrop.gainedXp * 0.03 * timeDiff / 1.0E7;
                if (stackXpDrops) {
                    if (decayRate < 0.1) {
                        decayRate = 0.1;
                    }
                } else if (decayRate < 1.0) {
                    decayRate = 1.0;
                }
                if (XPOverlayGUI.xpDrop.gainedXp - decayRate < 0.0) {
                    XPOverlayGUI.tempASkill.goalXp += XPOverlayGUI.xpDrop.gainedXp;
                    XPOverlayGUI.xpDrop.gainedXp = 0.0;
                } else {
                    XPOverlayGUI.tempASkill.goalXp += decayRate;
                    XPOverlayGUI.xpDrop.gainedXp -= decayRate;
                }
                XPOverlayGUI.tempASkill.goalPos = XP.levelAtXpDecimal(XPOverlayGUI.tempASkill.goalXp);
            }
            if (!showXpDrops) continue;
            if (xpDropOffset == xpDropOffsetCap) {
                XPOverlayGUI.xpDrop.Y -= decayAmount;
            }
            if (XPOverlayGUI.xpDrop.Y < (double)(i * 9 - xpDropYLimit)) {
                XPOverlayGUI.xpDrop.Y = i * 9 - xpDropYLimit;
            }
            if ((tempInt = (int)Math.floor(XPOverlayGUI.xpDrop.Y * xpDropOpacityPerTime)) < 0) {
                tempInt = -tempInt;
            }
            if ((tempAlpha = (double)tempInt > xpDropMaxOpacity ? 0 : (int)Math.floor(xpDropMaxOpacity - (double)tempInt)) <= 3) continue;
            XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)("+" + DP.dprefix(XPOverlayGUI.xpDrop.gainedXp) + " " + new TranslationTextComponent("pmmo." + XPOverlayGUI.xpDrop.skill).getString()), (int)(xpDropPosX + barWidth / 2), (int)((int)XPOverlayGUI.xpDrop.Y + (int)xpDropOffset + xpDropPosY), (int)(tempAlpha << 24 | Skill.getSkillColor(XPOverlayGUI.xpDrop.skill)));
        }
        if (xpDrops.size() > 0 && XPOverlayGUI.xpDrops.get((int)0).gainedXp <= 0.0) {
            xpDrops.remove(0);
        }
    }

    private void doSkills() {
        for (Map.Entry<String, ASkill> entry : skills.entrySet()) {
            tempASkill = entry.getValue();
            startLevel = Math.floor(XPOverlayGUI.tempASkill.pos);
            growAmount = (XPOverlayGUI.tempASkill.goalPos - XPOverlayGUI.tempASkill.pos) * timeDiff / 100000.0;
            if (growAmount < minXpGrow) {
                growAmount = minXpGrow;
            }
            if (XPOverlayGUI.tempASkill.pos < XPOverlayGUI.tempASkill.goalPos) {
                XPOverlayGUI.tempASkill.pos += 5.0E-5 * growAmount;
            }
            XPOverlayGUI.tempASkill.pos = Math.min(XPOverlayGUI.tempASkill.goalPos, XPOverlayGUI.tempASkill.pos);
            XPOverlayGUI.tempASkill.xp = XP.xpAtLevelDecimal(XPOverlayGUI.tempASkill.pos);
            if (!(startLevel < (double)((int)XPOverlayGUI.tempASkill.pos))) continue;
            XPOverlayGUI.sendLvlUp((int)Math.floor(XPOverlayGUI.tempASkill.pos), entry.getKey());
        }
    }

    private void doXpBar() {
        if ((themePos = (int)((double)themePos + (2.5 + 7.5 * (XPOverlayGUI.aSkill.pos % Math.floor(XPOverlayGUI.aSkill.pos))) * (timeDiff / 1000000.0))) > 10000) {
            themePos %= 10000;
        }
        if (cooldown > 0.0) {
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            try {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bar);
                RenderSystem.color3f((float)255.0f, (float)255.0f, (float)255.0f);
                this.func_238474_b_(stack, barPosX, barPosY + 10, 0, 0, barWidth, barHeight);
                if (!Config.forgeConfig.xpBarTheme.get().booleanValue()) {
                    this.func_238474_b_(stack, barPosX, barPosY + 10, 0, barHeight * 1, (int)Math.floor((double)barWidth * (XPOverlayGUI.aSkill.pos - Math.floor(XPOverlayGUI.aSkill.pos))), barHeight);
                } else {
                    tempInt = (int)Math.floor((double)barWidth * (XPOverlayGUI.aSkill.pos - Math.floor(XPOverlayGUI.aSkill.pos)));
                    if (tempInt > 100) {
                        tempInt = 100;
                    }
                    if (XPOverlayGUI.aSkill.pos >= (double)maxLevel) {
                        tempInt = 100;
                    }
                    this.func_238474_b_(stack, barPosX, barPosY + 10, 0, barHeight * 3, barWidth - 1, barHeight);
                    this.func_238474_b_(stack, barPosX + 1, barPosY + 10, 1 + (int)Math.floor((double)themePos / 100.0), barHeight * 2, tempInt, barHeight);
                }
                if (XPOverlayGUI.aSkill.pos >= (double)maxLevel) {
                    XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + activeSkill.toLowerCase()).getString(), maxLevel}).getString(), (int)(barPosX + barWidth / 2), (int)barPosY, (int)Skill.getSkillColor(activeSkill));
                } else {
                    XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + activeSkill.toLowerCase()).getString(), DP.dp(Math.floor(XPOverlayGUI.aSkill.pos * 100.0) / 100.0)}).getString(), (int)(barPosX + barWidth / 2), (int)barPosY, (int)Skill.getSkillColor(activeSkill));
                }
                if (barKey || xpLeftDisplayAlwaysOn) {
                    if (XPOverlayGUI.aSkill.xp >= maxXp) {
                        XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)new TranslationTextComponent("pmmo.maxLevel").getString(), (int)(barPosX + barWidth / 2), (int)(17 + barPosY), (int)Skill.getSkillColor(activeSkill));
                    } else {
                        if (goalXp >= maxXp) {
                            goalXp = maxXp;
                        }
                        goalXp = XP.xpAtLevel(XP.levelAtXp(XPOverlayGUI.aSkill.xp) + 1);
                        XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)(DP.dprefix(XPOverlayGUI.aSkill.xp) + " / " + DP.dprefix(goalXp)), (int)(barPosX + barWidth / 2), (int)(17 + barPosY), (int)Skill.getSkillColor(activeSkill));
                        XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)new TranslationTextComponent("pmmo.xpLeft", new Object[]{DP.dprefix(goalXp - XPOverlayGUI.aSkill.xp)}).getString(), (int)(barPosX + barWidth / 2), (int)(26 + barPosY), (int)Skill.getSkillColor(activeSkill));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error rendering PMMO GUI XP Bar", (Throwable)e);
            }
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
    }

    private void doVein() {
        veinLeft = Config.getAbilitiesMap(player).getOrDefault("veinLeft", 0.0);
        veinPosGoal = veinLeft / maxVeinCharge;
        addAmount = (veinPosGoal - veinPos) * (timeDiff / 2.0E8);
        if (addAmount < 3.0E-5) {
            addAmount = 3.0E-5;
        }
        lossAmount = -(veinPosGoal - veinPos) * (timeDiff / 2.0E8);
        if (veinPos < veinPosGoal) {
            if ((veinPos += addAmount) > veinPosGoal) {
                veinPos = veinPosGoal;
            }
        } else if (veinPos > veinPosGoal && (veinPos -= lossAmount) < veinPosGoal) {
            veinPos = veinPosGoal;
        }
        if (veinPos < 0.0 || veinPos > 1.0) {
            veinPos = veinPosGoal;
        }
        if (veinPos == 1.0 && lastVeinPos != 1.0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.veinCharge", new Object[]{100}).func_230530_a_(XP.textStyle.get("green")), true);
        }
        lastVeinPos = veinPos;
        veinBarPosX = (int)((double)this.sr.func_198107_o() * veinBarOffsetX - (double)(barWidth / 2));
        veinBarPosY = (int)((double)this.sr.func_198087_p() * veinBarOffsetY - (double)(barHeight / 2));
        if (veinKey && XP.isPlayerSurvival(player)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bar);
            this.func_238474_b_(stack, veinBarPosX, veinBarPosY, 0, 0, barWidth, barHeight);
            this.func_238474_b_(stack, veinBarPosX, veinBarPosY, 0, barHeight, (int)Math.floor((double)barWidth * veinPos), barHeight);
            XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)((int)Math.floor(veinPos * maxVeinCharge) + "/" + (int)Math.floor(maxVeinCharge) + " " + DP.dprefix(veinPos * 100.0) + "%"), (int)(veinBarPosX + barWidth / 2), (int)(veinBarPosY - 8), (int)65280);
            metToolReq = XP.checkReq(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL);
            if (!metToolReq) {
                XPOverlayGUI.func_238472_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUseAsTool", new Object[]{new TranslationTextComponent(player.func_184614_ca().func_77977_a())}).func_230530_a_(XP.textStyle.get("red")), (int)(this.sr.func_198107_o() / 2), (int)(veinBarPosY + 6), (int)0xFFFFFF);
                return;
            }
            if (lookingAtBlock && !canBreak) {
                XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)new TranslationTextComponent("pmmo.notSkilledEnoughToBreak", new Object[]{new TranslationTextComponent(lastBlockTransKey)}).func_230530_a_(XP.textStyle.get("red")).getString(), (int)(this.sr.func_198107_o() / 2), (int)(veinBarPosY + 6), (int)0xFFFFFF);
                return;
            }
            if (lastBlockState != null && canBreak && (lookingAtBlock || isVeining)) {
                if (canVein) {
                    breakAmount = (int)(maxVeinCharge * veinPos / WorldTickHandler.getVeinCost(lastBlockState, lastBlockPos, player));
                    if (breakAmount > veinMaxBlocks) {
                        breakAmount = veinMaxBlocks;
                    }
                    XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)new TranslationTextComponent("pmmo.canVein", new Object[]{breakAmount, new TranslationTextComponent(lastBlockTransKey)}).getString(), (int)(veinBarPosX + barWidth / 2), (int)(veinBarPosY + 6), (int)65280);
                } else if (WorldTickHandler.canVeinDimension(lastBlockRegKey, player)) {
                    XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)new TranslationTextComponent("pmmo.cannotVein", new Object[]{new TranslationTextComponent(lastBlockTransKey).getString()}).getString(), (int)(veinBarPosX + barWidth / 2), (int)(veinBarPosY + 6), (int)0xFF5454);
                } else {
                    XPOverlayGUI.func_238471_a_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)new TranslationTextComponent("pmmo.cannotVeinDimension", new Object[]{new TranslationTextComponent(lastBlockTransKey).getString()}).getString(), (int)(veinBarPosX + barWidth / 2), (int)(veinBarPosY + 6), (int)0xFF5454);
                }
            }
        }
    }

    private void doSkillList() {
        if (listOn && !XPOverlayGUI.mc.field_71474_y.field_74330_P) {
            listIndex = 0;
            if (System.nanoTime() - lastBonusUpdate > 250000000L) {
                biomeBoosts = XP.getBiomeBoosts(player);
                for (Map.Entry<String, ASkill> entry : skills.entrySet()) {
                    tempSkill = entry.getKey();
                    itemBoost = XP.getItemBoost(player, tempSkill);
                    dimensionBoost = XP.getDimensionBoost(player, tempSkill);
                    playerXpBoost = APIUtils.getPlayerXpBoost(player, tempSkill);
                    XPOverlayGUI.skills.get((Object)XPOverlayGUI.tempSkill).bonus = itemBoost + biomeBoosts.getOrDefault(tempSkill, 0.0) + dimensionBoost + playerXpBoost;
                    if (!(XPOverlayGUI.skills.get((Object)XPOverlayGUI.tempSkill).bonus <= -100.0)) continue;
                    XPOverlayGUI.skills.get((Object)XPOverlayGUI.tempSkill).bonus = -100.0;
                }
                lastBonusUpdate = System.nanoTime();
            }
            skillsKeys = new ArrayList<String>(skills.keySet());
            skillsKeys.sort(Comparator.comparingDouble(a -> XPOverlayGUI.skills.get((Object)a).xp).reversed());
            Iterator<Object> iterator = skillsKeys.iterator();
            while (iterator.hasNext()) {
                String key;
                tempSkill = key = (String)iterator.next();
                tempASkill = skills.get(key);
                if (tempASkill == null) continue;
                level = XP.levelAtXpDecimal(XPOverlayGUI.tempASkill.xp);
                tempString = DP.dp(Math.floor(level * 100.0) / 100.0);
                color = Skill.getSkillColor(tempSkill);
                if (level >= (double)maxLevel) {
                    tempString = "" + maxLevel;
                }
                XPOverlayGUI.func_238476_c_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)tempString, (int)(skillListX + levelGap + 4 - fontRenderer.func_78256_a(tempString)), (int)(skillListY + 3 + listIndex), (int)color);
                XPOverlayGUI.func_238476_c_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)(" | " + new TranslationTextComponent("pmmo." + tempSkill).getString()), (int)(skillListX + levelGap + 4), (int)(skillListY + 3 + listIndex), (int)color);
                XPOverlayGUI.func_238476_c_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)(" | " + DP.dprefix(XPOverlayGUI.tempASkill.xp)), (int)(skillListX + levelGap + skillGap + 13), (int)(skillListY + 3 + listIndex), (int)color);
                if (XPOverlayGUI.tempASkill.bonus != 0.0) {
                    bonus = Math.floor(XPOverlayGUI.tempASkill.bonus * 100.0) / 100.0;
                    tempString = bonus > 0.0 ? "+" + (bonus % 1.0 == 0.0 ? Integer.valueOf((int)Math.floor(bonus)) : DP.dp(bonus)) + "%" : (bonus < 0.0 ? (bonus % 1.0 == 0.0 ? Integer.valueOf((int)Math.floor(bonus)) : DP.dp(bonus)) + "%" : "");
                    XPOverlayGUI.func_238476_c_((MatrixStack)stack, (FontRenderer)fontRenderer, (String)tempString, (int)(skillListX + levelGap + skillGap + xpGap + 32), (int)(skillListY + 3 + listIndex), (int)color);
                }
                listIndex += 9;
            }
        }
    }

    private void doCrosshair() {
    }

    public static void doInit() {
        player = Minecraft.func_71410_x().field_71439_g;
        Map<String, Double> prefsMap = Config.getPreferencesMap(player);
        barOffsetX = prefsMap.containsKey("barOffsetX") ? prefsMap.get("barOffsetX").doubleValue() : Config.forgeConfig.barOffsetX.get().doubleValue();
        barOffsetY = prefsMap.containsKey("barOffsetY") ? prefsMap.get("barOffsetY").doubleValue() : Config.forgeConfig.barOffsetY.get().doubleValue();
        veinBarOffsetX = prefsMap.containsKey("veinBarOffsetX") ? prefsMap.get("veinBarOffsetX").doubleValue() : Config.forgeConfig.veinBarOffsetX.get().doubleValue();
        veinBarOffsetY = prefsMap.containsKey("veinBarOffsetY") ? prefsMap.get("veinBarOffsetY").doubleValue() : Config.forgeConfig.veinBarOffsetY.get().doubleValue();
        xpDropOffsetX = prefsMap.containsKey("xpDropOffsetX") ? prefsMap.get("xpDropOffsetX").doubleValue() : Config.forgeConfig.xpDropOffsetX.get().doubleValue();
        xpDropOffsetY = prefsMap.containsKey("xpDropOffsetY") ? prefsMap.get("xpDropOffsetY").doubleValue() : Config.forgeConfig.xpDropOffsetY.get().doubleValue();
        skillListOffsetX = prefsMap.containsKey("skillListOffsetX") ? prefsMap.get("skillListOffsetX").doubleValue() : Config.forgeConfig.skillListOffsetX.get().doubleValue();
        skillListOffsetY = prefsMap.containsKey("skillListOffsetY") ? prefsMap.get("skillListOffsetY").doubleValue() : Config.forgeConfig.skillListOffsetY.get().doubleValue();
        xpDropSpawnDistance = prefsMap.containsKey("xpDropSpawnDistance") ? prefsMap.get("xpDropSpawnDistance").doubleValue() : Config.forgeConfig.xpDropSpawnDistance.get().doubleValue();
        xpDropOpacityPerTime = prefsMap.containsKey("xpDropOpacityPerTime") ? prefsMap.get("xpDropOpacityPerTime").doubleValue() : Config.forgeConfig.xpDropOpacityPerTime.get().doubleValue();
        xpDropMaxOpacity = prefsMap.containsKey("xpDropMaxOpacity") ? prefsMap.get("xpDropMaxOpacity").doubleValue() : Config.forgeConfig.xpDropMaxOpacity.get().doubleValue();
        minXpGrow = prefsMap.containsKey("minXpGrow") ? prefsMap.get("minXpGrow").doubleValue() : Config.forgeConfig.minXpGrow.get().doubleValue();
        xpDropDecayAge = prefsMap.containsKey("xpDropDecayAge") ? (int)Math.floor(prefsMap.get("xpDropDecayAge")) : (int)Math.floor(Config.forgeConfig.xpDropDecayAge.get());
        maxLevel = prefsMap.containsKey("maxLevel") ? (int)Math.floor(XP.getMaxLevel()) : (int)Math.floor(Config.forgeConfig.maxLevel.get().intValue());
        maxXp = prefsMap.containsKey("maxXp") ? (double)((int)Math.floor(Config.getConfig("maxXp"))) : XP.xpAtLevel(maxLevel);
        WorldText.worldXpDropsSizeMultiplier = prefsMap.containsKey("worldXpDropsSizeMultiplier") ? (float)(0.0 + prefsMap.get("worldXpDropsSizeMultiplier")) : (float)(0.0 + Config.forgeConfig.worldXpDropsSizeMultiplier.get());
        WorldText.worldXpDropsDecaySpeedMultiplier = prefsMap.containsKey("worldXpDropsDecaySpeedMultiplier") ? (float)(0.0 + prefsMap.get("worldXpDropsDecaySpeedMultiplier")) : (float)(0.0 + Config.forgeConfig.worldXpDropsDecaySpeedMultiplier.get());
        WorldXpDrop.worldXpDropsRotationCap = prefsMap.containsKey("worldXpDropsRotationCap") ? (float)(0.0 + prefsMap.get("worldXpDropsRotationCap")) : (float)(0.0 + Config.forgeConfig.worldXpDropsRotationCap.get());
        WorldText.worldXpDropsShowSkill = prefsMap.containsKey("worldXpDropsShowSkill") ? prefsMap.get("worldXpDropsShowSkill") != 0.0 : Config.forgeConfig.worldXpDropsShowSkill.get();
        xpDropsAttachedToBar = prefsMap.containsKey("xpDropsAttachedToBar") ? prefsMap.get("xpDropsAttachedToBar") != 0.0 : Config.forgeConfig.xpDropsAttachedToBar.get();
        xpBarAlwaysOn = prefsMap.containsKey("xpBarAlwaysOn") ? prefsMap.get("xpBarAlwaysOn") != 0.0 : Config.forgeConfig.xpBarAlwaysOn.get();
        xpLeftDisplayAlwaysOn = prefsMap.containsKey("xpLeftDisplayAlwaysOn") ? prefsMap.get("xpLeftDisplayAlwaysOn") != 0.0 : Config.forgeConfig.xpLeftDisplayAlwaysOn.get();
        showSkillsListAtCorner = prefsMap.containsKey("showSkillsListAtCorner") ? prefsMap.get("showSkillsListAtCorner") != 0.0 : Config.forgeConfig.showSkillsListAtCorner.get();
        showXpDrops = prefsMap.containsKey("showXpDrops") ? prefsMap.get("showXpDrops") != 0.0 : Config.forgeConfig.showXpDrops.get();
        stackXpDrops = prefsMap.containsKey("stackXpDrops") ? prefsMap.get("stackXpDrops") != 0.0 : Config.forgeConfig.stackXpDrops.get();
        lvlUpScreenshot = prefsMap.containsKey("lvlUpScreenshot") ? prefsMap.get("lvlUpScreenshot") != 0.0 : Config.forgeConfig.lvlUpScreenshot.get();
        lvlUpScreenshotShowSkills = prefsMap.containsKey("lvlUpScreenshotShowSkills") ? prefsMap.get("lvlUpScreenshotShowSkills") != 0.0 : Config.forgeConfig.lvlUpScreenshotShowSkills.get();
        xpDropsShowXpBar = prefsMap.containsKey("xpDropsShowXpBar") ? prefsMap.get("xpDropsShowXpBar") != 0.0 : Config.forgeConfig.xpDropsShowXpBar.get();
        showLevelUpUnlocks = prefsMap.containsKey("showLevelUpUnlocks") ? prefsMap.get("showLevelUpUnlocks") != 0.0 : Config.forgeConfig.showLevelUpUnlocks.get();
        xpDropYLimit = !xpDropsAttachedToBar ? 999999999 : 0;
        if (barOffsetX < 0.0 || barOffsetX > 1.0) {
            barOffsetX = Config.forgeConfig.barOffsetX.get();
        }
        if (barOffsetY < 0.0 || barOffsetY > 1.0) {
            barOffsetY = Config.forgeConfig.barOffsetY.get();
        }
        if (xpDropOffsetX < 0.0 || xpDropOffsetX > 1.0) {
            xpDropOffsetX = Config.forgeConfig.xpDropOffsetX.get();
        }
        if (xpDropOffsetY < 0.0 || xpDropOffsetY > 1.0) {
            xpDropOffsetY = Config.forgeConfig.xpDropOffsetY.get();
        }
        if (skillListOffsetX < 0.0 || skillListOffsetX > 1.0) {
            skillListOffsetX = Config.forgeConfig.skillListOffsetX.get();
        }
        if (skillListOffsetY < 0.0 || skillListOffsetY > 1.0) {
            skillListOffsetY = Config.forgeConfig.skillListOffsetY.get();
        }
        if (veinBarOffsetX < 0.0 || veinBarOffsetX > 1.0) {
            veinBarOffsetX = Config.forgeConfig.veinBarOffsetX.get();
        }
        if (veinBarOffsetY < 0.0 || veinBarOffsetY > 1.0) {
            veinBarOffsetY = Config.forgeConfig.veinBarOffsetY.get();
        }
        if (xpDropSpawnDistance < 0.0 || xpDropSpawnDistance > 1000.0) {
            xpDropSpawnDistance = Config.forgeConfig.xpDropSpawnDistance.get();
        }
        if (xpDropOpacityPerTime < 0.0 || xpDropOpacityPerTime > 255.0) {
            xpDropOpacityPerTime = Config.forgeConfig.xpDropOpacityPerTime.get();
        }
        if (xpDropMaxOpacity < 0.0 || xpDropMaxOpacity > 255.0) {
            xpDropMaxOpacity = Config.forgeConfig.xpDropMaxOpacity.get();
        }
        if (xpDropDecayAge < 0 || xpDropDecayAge > 5000) {
            xpDropDecayAge = (int)Math.floor(Config.forgeConfig.xpDropDecayAge.get());
        }
        if (minXpGrow < 0.01 || minXpGrow > 100.0) {
            minXpGrow = Config.forgeConfig.minXpGrow.get();
        }
        biomePenaltyMultiplier = Config.getConfig("biomePenaltyMultiplier");
        maxVeinCharge = Config.getConfig("maxVeinCharge");
        veinMaxBlocks = (int)Config.getConfig("veinMaxBlocks");
    }

    public static void sendLvlUp(int level, String skill) {
        TranslationTextComponent msg;
        player = Minecraft.func_71410_x().field_71439_g;
        Map<String, Double> configMap = Config.getConfigMap();
        if (level < 1 || configMap.containsKey("maxLevel") && (double)level > configMap.get("maxLevel")) {
            return;
        }
        switch (skill) {
            case "building": {
                double levelsPerOneReach = configMap.get("levelsPerOneReach");
                double maxExtraReachBoost = configMap.get("maxExtraReachBoost");
                double reachBoost = Math.min(maxExtraReachBoost, (double)level / levelsPerOneReach);
                msg = new TranslationTextComponent("pmmo.levelUpReachBoost", new Object[]{level, new TranslationTextComponent("pmmo." + skill.toLowerCase()).getString(), DP.dpSoft(reachBoost)});
                break;
            }
            case "combat": {
                double percentDmgBoostPerLevel = configMap.get("damageBonusPercentPerLevelMelee");
                double maxExtraDamageBoost = configMap.get("maxExtraDamagePercentageBoostMelee");
                double damageBoost = Math.min(maxExtraDamageBoost, (double)level * percentDmgBoostPerLevel) * 100.0;
                msg = new TranslationTextComponent("pmmo.levelUpDamageBoostPercentMelee", new Object[]{level, new TranslationTextComponent("pmmo." + skill.toLowerCase()).getString(), DP.dpSoft(damageBoost)});
                break;
            }
            case "archery": {
                double percentDmgBoostPerLevel = configMap.get("damageBonusPercentPerLevelArchery");
                double maxExtraDamageBoost = configMap.get("maxExtraDamagePercentageBoostArchery");
                double damageBoost = Math.min(maxExtraDamageBoost, (double)level * percentDmgBoostPerLevel) * 100.0;
                msg = new TranslationTextComponent("pmmo.levelUpDamageBoostPercentArchery", new Object[]{level, new TranslationTextComponent("pmmo." + skill.toLowerCase()).getString(), DP.dpSoft(damageBoost)});
                break;
            }
            case "magic": {
                double percentDmgBoostPerLevel = configMap.get("damageBonusPercentPerLevelMagic");
                double maxExtraDamageBoost = configMap.get("maxExtraDamagePercentageBoostMagic");
                double damageBoost = Math.min(maxExtraDamageBoost, (double)level * percentDmgBoostPerLevel) * 100.0;
                msg = new TranslationTextComponent("pmmo.levelUpDamageBoostPercentMagic", new Object[]{level, new TranslationTextComponent("pmmo." + skill.toLowerCase()).getString(), DP.dpSoft(damageBoost)});
                break;
            }
            case "endurance": {
                double endurancePerLevel = configMap.get("endurancePerLevel");
                double maxEndurance = configMap.get("maxEndurance");
                double enduranceBoost = Math.min(maxEndurance, (double)level * endurancePerLevel);
                double levelsPerHeart = configMap.get("levelsPerHeart");
                double maxExtraHeartBoost = configMap.get("maxExtraHeartBoost");
                int heartBoost = Math.min((int)maxExtraHeartBoost, (int)Math.floor((double)level / levelsPerHeart));
                if (level % (int)levelsPerHeart == 0 && heartBoost <= (int)maxExtraHeartBoost) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.gainedExtraHeart").func_230530_a_(Skill.getSkillStyle(skill)), false);
                }
                msg = new TranslationTextComponent("pmmo.levelUpEnduranceBoost", new Object[]{level, new TranslationTextComponent("pmmo." + skill.toLowerCase()).getString(), enduranceBoost});
                break;
            }
            case "agility": {
                msg = new TranslationTextComponent("pmmo.levelUpSprintSpeedBonus", new Object[]{level, new TranslationTextComponent("pmmo." + skill.toLowerCase()).getString(), DP.dpSoft(AttributeHandler.getSpeedBoostMultiplier(level) * 100.0) + "%"});
                break;
            }
            default: {
                msg = new TranslationTextComponent("pmmo.levelUp", new Object[]{level, new TranslationTextComponent("pmmo." + skill.toLowerCase()).getString()});
            }
        }
        player.func_146105_b((ITextComponent)msg.func_230530_a_(Skill.getSkillStyle(skill)), false);
        HashMap<String, Double> skillsMap = new HashMap<String, Double>(XP.getOfflineXpMap(player.func_110124_au()));
        skillsMap.put(skill, XP.xpAtLevel(level));
        int totalLevel = XP.getTotalLevelFromMap(skillsMap);
        if (totalLevel % Config.forgeConfig.levelsPerTotalLevelMilestone.get() == 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.totalLevelUp", new Object[]{totalLevel}).func_230530_a_(XP.getColorStyle(65280)), true);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.totalLevelUp", new Object[]{totalLevel}).func_230530_a_(XP.getColorStyle(65280)), false);
        }
        if (showLevelUpUnlocks) {
            XPOverlayGUI.checkUnlocks(level, skill, player);
        }
        int nightvisionUnlockLevel = (int)Config.getConfig("nightvisionUnlockLevel");
        int dualSalvageUnlockLevel = (int)Config.getConfig("dualSalvageSmithingLevelReq");
        if (Skill.SWIMMING.equals(skill) && level - 1 < nightvisionUnlockLevel && level >= nightvisionUnlockLevel) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.underwaterNightVisionUnLocked", new Object[]{level}).func_230530_a_(Skill.getSkillStyle(skill)), false);
        }
        if (Skill.SMITHING.equals(skill) && level - 1 < dualSalvageUnlockLevel && level >= dualSalvageUnlockLevel) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.dualSalvageUnLocked", new Object[]{level}).func_230530_a_(Skill.getSkillStyle(skill)), false);
        }
        listWasOn = barOn;
        if (lvlUpScreenshotShowSkills) {
            barOn = true;
        }
        if (lvlUpScreenshot) {
            screenshots.add(player.func_145748_c_().getString() + " " + skill.toLowerCase() + " " + level);
        }
        NetworkHandler.sendToServer(new MessageLevelUp(skill, level));
    }

    public static void makeXpDrop(double xp, String skillIn, int cooldown, double gainedXp, boolean skip) {
        xpDropWasStacked = false;
        if (xp + gainedXp <= 0.0 || skillIn.equals(Skill.INVALID_SKILL.toString())) {
            skills.remove(skillIn);
            return;
        }
        if (skills.get(skillIn) == null) {
            skills.put(skillIn, new ASkill(xp, XP.levelAtXpDecimal(xp), xp, XP.levelAtXpDecimal(xp)));
        }
        if (!skip) {
            activeSkill = skillIn;
            aSkill = skills.get(activeSkill);
        }
        tempASkill = skills.get(skillIn);
        if (gainedXp <= 0.0) {
            XPOverlayGUI.tempASkill.goalXp = XPOverlayGUI.tempASkill.xp = xp + gainedXp;
            XPOverlayGUI.tempASkill.goalPos = XPOverlayGUI.tempASkill.pos = XP.levelAtXpDecimal(XPOverlayGUI.tempASkill.xp);
            if (gainedXp == 0.0) {
                if (xpDropsShowXpBar) {
                    XPOverlayGUI.cooldown = cooldown;
                }
                for (int i = 0; i < xpDrops.size(); ++i) {
                    if (!XPOverlayGUI.xpDrops.get((int)i).skill.equals(skillIn)) continue;
                    xpDrops.remove(i);
                    i = 0;
                }
            }
        } else if (stackXpDrops && xpDrops.size() > 0) {
            for (XpDrop xpDrop : xpDrops) {
                if (!xpDrop.skill.equals(skillIn) || xpDrop.age >= xpDropDecayAge && !(xpDrop.Y > 0.0)) continue;
                xpDrop.gainedXp += gainedXp;
                xpDrop.startXp += gainedXp;
                if (XPOverlayGUI.xpDrops.get((int)(XPOverlayGUI.xpDrops.size() - 1)).age > xpDropDecayAge - 25) {
                    XPOverlayGUI.xpDrops.get((int)(XPOverlayGUI.xpDrops.size() - 1)).age = xpDropDecayAge - 25;
                }
                xpDropWasStacked = true;
            }
        }
        if (!xpDropWasStacked && gainedXp != 0.0) {
            if (xpDrops.size() > 0) {
                xpDrops.add(new XpDrop(0, XPOverlayGUI.xpDrops.get((int)(XPOverlayGUI.xpDrops.size() - 1)).Y + 15.0, skillIn, xp, gainedXp, skip));
            } else {
                xpDrops.add(new XpDrop(0, xpDropSpawnDistance, skillIn, xp, gainedXp, skip));
            }
        }
        if (xpDropsShowXpBar && !skip) {
            XPOverlayGUI.cooldown = cooldown;
        }
        levelGap = 0;
        skillGap = 0;
        xpGap = 0;
        skills.forEach((thisSkill, thisASkill) -> {
            if (XPOverlayGUI.skills.get((Object)thisSkill).pos >= (double)maxLevel) {
                if (levelGap < fontRenderer.func_78256_a("" + maxLevel)) {
                    levelGap = fontRenderer.func_78256_a("" + maxLevel);
                }
            } else if (levelGap < fontRenderer.func_78256_a(DP.dp(XP.levelAtXpDecimal(XPOverlayGUI.skills.get((Object)thisSkill).goalXp)))) {
                levelGap = fontRenderer.func_78256_a(DP.dp(XP.levelAtXpDecimal(XPOverlayGUI.skills.get((Object)thisSkill).goalXp)));
            }
            if (skillGap < fontRenderer.func_78256_a(new TranslationTextComponent("pmmo." + thisSkill.toLowerCase()).getString())) {
                skillGap = fontRenderer.func_78256_a(new TranslationTextComponent("pmmo." + thisSkill.toLowerCase()).getString());
            }
            if (xpGap < fontRenderer.func_78256_a(DP.dp(XPOverlayGUI.skills.get((Object)thisSkill).goalXp))) {
                xpGap = fontRenderer.func_78256_a(DP.dprefix(XPOverlayGUI.skills.get((Object)thisSkill).goalXp));
            }
        });
    }

    public static void clearXP() {
        skills = new HashMap<String, ASkill>();
        xpDrops = new ArrayList();
        xp = 0.0;
        activeSkill = Skill.INVALID_SKILL.toString();
        levelGap = 0;
        skillGap = 0;
        xpGap = 0;
    }

    private static void addItemsWithSameLevel(int level, String skill, JType jType, Map<JType, Map<String, Map<String, Double>>> output) {
        output.put(jType, new HashMap());
        Map<String, Map<String, Double>> outputJMap = output.get((Object)jType);
        for (Map.Entry element : ((Map)JsonConfig.data.getOrDefault((Object)jType, new HashMap())).entrySet()) {
            if (((Map)element.getValue()).getOrDefault(skill, -1.0) != (double)level) continue;
            outputJMap.put((String)element.getKey(), (Map<String, Double>)element.getValue());
        }
    }

    public static void checkUnlocks(int level, String skill, PlayerEntity player) {
        HashMap<JType, Map<String, Map<String, Double>>> itemsWithReqs = new HashMap<JType, Map<String, Map<String, Double>>>();
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_WEAR, itemsWithReqs);
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_WEAPON, itemsWithReqs);
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_TOOL, itemsWithReqs);
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_PLACE, itemsWithReqs);
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_BREAK, itemsWithReqs);
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_USE, itemsWithReqs);
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_USE_ENCHANTMENT, itemsWithReqs);
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_BIOME, itemsWithReqs);
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_KILL, itemsWithReqs);
        XPOverlayGUI.addItemsWithSameLevel(level, skill, JType.REQ_CRAFT, itemsWithReqs);
        for (Map.Entry element : itemsWithReqs.entrySet()) {
            String jTypeName = new TranslationTextComponent("pmmo." + ((JType)((Object)element.getKey())).toString().replace("req_", "").replaceAll("_", " ")).getString();
            for (Map.Entry itemElement : ((Map)element.getValue()).entrySet()) {
                Item item = XP.getItem((String)itemElement.getKey());
                String unlockName = !item.equals(Items.field_190931_a) ? new TranslationTextComponent(item.func_77658_a()).getString() : (String)itemElement.getKey();
                if (XP.checkReq(player, (Map)itemElement.getValue())) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelUpFeatureUnlock", new Object[]{unlockName, jTypeName}).func_230530_a_(XP.getColorStyle(65280)), false);
                    continue;
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelUpPartialFeatureUnlock", new Object[]{unlockName, jTypeName}).func_230530_a_(XP.getColorStyle(0xFFFF00)), false);
            }
        }
    }

    public static boolean getVeinKey() {
        return veinKey;
    }

    public static boolean getLookingAtBlock() {
        return lookingAtBlock;
    }

    public static boolean getMetToolReq() {
        return metToolReq;
    }

    public static boolean getCanBreak() {
        return canBreak;
    }

    static {
        levelGap = 0;
        xpDropDecayAge = 0;
        xpDropOffset = 0.0;
        xpDropOffsetCap = 0.0;
        minXpGrow = 0.2;
        barOffsetX = 0.0;
        barOffsetY = 0.0;
        xpDropOffsetX = 0.0;
        xpDropOffsetY = 0.0;
        skillListOffsetX = 0.0;
        skillListOffsetY = 0.0;
        xpDropSpawnDistance = 0.0;
        xpDropOpacityPerTime = 0.0;
        xpDropMaxOpacity = 0.0;
        biomePenaltyMultiplier = 0.0;
        maxVeinCharge = 64.0;
        theme = 2;
        themePos = 1;
        listIndex = 0;
        xpDropYLimit = 0;
        stackXpDrops = true;
        init = false;
        showSkillsListAtCorner = true;
        showXpDrops = true;
        barKey = false;
        listKey = false;
        veinKey = false;
        barPressed = false;
        listPressed = false;
        xpDropsAttachedToBar = true;
        xpDrops = new ArrayList();
        mc = Minecraft.func_71410_x();
        player = XPOverlayGUI.mc.field_71439_g;
        skills = new HashMap<String, ASkill>();
        activeSkill = Skill.INVALID_SKILL.toString();
        tempSkill = Skill.INVALID_SKILL.toString();
        fontRenderer = XPOverlayGUI.mc.field_71466_p;
        lastBonusUpdate = System.nanoTime();
        lastVeinBlockUpdate = System.nanoTime();
        veinPos = -1000.0;
        lastVeinPos = -1000.0;
        addAmount = 0.0;
        lossAmount = 0.0;
        lastBlockRegKey = "";
        lastBlockTransKey = "";
        lastToolHeld = Items.field_190931_a;
        screenshots = new HashSet<String>();
        listWasOn = false;
        barOn = false;
        listOn = false;
        isVeining = false;
        canBreak = true;
        canVein = false;
        lookingAtBlock = false;
        metToolReq = true;
        veinShapeSet = new HashSet<BlockPos>();
    }
}

