/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageLevelUp {
    public static final Logger LOGGER = LogManager.getLogger();
    private int level;
    private String skill;

    public MessageLevelUp(String skill, int level) {
        this.skill = skill;
        this.level = level;
    }

    public MessageLevelUp() {
    }

    public static MessageLevelUp decode(PacketBuffer buf) {
        MessageLevelUp packet = new MessageLevelUp();
        packet.skill = buf.func_150789_c(64);
        packet.level = buf.readInt();
        return packet;
    }

    public static void encode(MessageLevelUp packet, PacketBuffer buf) {
        buf.func_180714_a(packet.skill);
        buf.writeInt(packet.level);
    }

    public static void handlePacket(MessageLevelUp packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                String skill = packet.skill.toLowerCase();
                int realLevel = Skill.getLevel(skill, (PlayerEntity)player);
                if (packet.level <= realLevel) {
                    Map<String, Double> prefsMap = Config.getPreferencesMap((PlayerEntity)player);
                    Vector3d playerPos = player.func_213303_ch();
                    WorldText explosionText = WorldText.fromVector(XP.getDimResLoc((World)player.func_71121_q()), player.func_213303_ch());
                    explosionText.setColor(Skill.getSkillColor(skill));
                    explosionText.setText(player.func_145748_c_().getString() + " " + packet.level + " " + skill + " level up!");
                    explosionText.setMaxOffset(1.0f);
                    explosionText.setStartSize(4.0f);
                    explosionText.setEndSize(0.0f);
                    explosionText.setSecondsLifespan(15.23f);
                    if (Config.forgeConfig.levelUpFirework.get().booleanValue() && (!prefsMap.containsKey("spawnFireworksCausedByMe") || prefsMap.get("spawnFireworksCausedByMe") != 0.0)) {
                        XP.spawnRocket(player.field_70170_p, player.func_213303_ch(), skill, explosionText);
                    }
                    LOGGER.info(player.func_145748_c_().getString() + " has reached level " + packet.level + " in " + skill + "! [" + XP.getDimResLoc(player.field_70170_p).toString() + "|x:" + DP.dp(playerPos.func_82615_a()) + "|y:" + DP.dp(playerPos.func_82617_b()) + "|z:" + DP.dp(playerPos.func_82616_c()) + "]");
                    if (Config.forgeConfig.broadcastMilestone.get().booleanValue()) {
                        boolean totalLevelMilestone;
                        HashMap<String, Double> skillsMap = new HashMap<String, Double>(PmmoSavedData.get().getXpMap(player.func_110124_au()));
                        skillsMap.put(skill, XP.xpAtLevel(packet.level));
                        int totalLevel = XP.getTotalLevelFromMap(skillsMap);
                        boolean levelUpMilestone = packet.level % Config.forgeConfig.levelsPerMilestone.get() == 0;
                        boolean bl = totalLevelMilestone = totalLevel % Config.forgeConfig.levelsPerTotalLevelMilestone.get() == 0;
                        if (levelUpMilestone || totalLevelMilestone) {
                            ArrayList players = new ArrayList(player.field_71133_b.func_184103_al().func_181057_v());
                            for (ServerPlayerEntity otherPlayer : players) {
                                if (otherPlayer.func_110124_au() == player.func_110124_au()) continue;
                                Map<String, Double> otherprefsMap = Config.getPreferencesMap((PlayerEntity)otherPlayer);
                                if (levelUpMilestone) {
                                    otherPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.milestoneLevelUp", new Object[]{player.func_145748_c_(), packet.level, new TranslationTextComponent("pmmo." + skill)}).func_230530_a_(Skill.getSkillStyle(skill)), false);
                                    if (Config.forgeConfig.milestoneLevelUpFirework.get().booleanValue() && (!otherprefsMap.containsKey("spawnFireworksCausedByOthers") || otherprefsMap.get("spawnFireworksCausedByOthers") != 0.0)) {
                                        XP.spawnRocket(otherPlayer.field_70170_p, otherPlayer.func_213303_ch(), skill, explosionText);
                                    }
                                }
                                if (!totalLevelMilestone) continue;
                                otherPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.milestoneTotalLevel", new Object[]{player.func_145748_c_(), totalLevel}).func_230530_a_(XP.getColorStyle(65280)), false);
                            }
                        }
                    }
                } else {
                    NetworkHandler.sendToPlayer(new MessageXp(Skill.getXp(skill, (PlayerEntity)player), skill, 0.0, true), player);
                }
            }
            catch (Exception e) {
                LOGGER.debug((Object)e);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

