/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.util.XP;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageWorldText {
    private ResourceLocation worldResLoc;
    private Vector3d startPos;
    private Vector3d endPos;
    private String text = "EMPTY";
    private float secondsLifespan = 1.0f;
    private float maxOffset = 0.0f;
    private byte preset = 0;
    private boolean hueColor = false;
    private int color = 0xFFFFFF;
    private float startHue = 0.0f;
    private float startSaturation = 1.0f;
    private float startBrightness = 1.0f;
    private float endHue = 360.0f;
    private float endSaturation = 1.0f;
    private float endBrightness = 1.0f;
    private boolean showValue = false;
    private float startValue = 0.0f;
    private float endValue = 0.0f;
    private float valueDecaySpeed = 1.0f;
    private boolean decayByValue = false;
    private float value = 0.0f;
    private float startSize = 1.0f;
    private float endSize = 0.0f;
    private float startRot = 0.0f;
    private float endRot = 0.0f;

    public MessageWorldText(WorldText worldText) {
        this.worldResLoc = worldText.getWorldResLoc();
        this.startPos = worldText.getStartPos();
        this.endPos = worldText.getEndPos();
        this.text = worldText.getText();
        this.secondsLifespan = worldText.getSecondsLifespan();
        this.maxOffset = worldText.getMaxOffset();
        this.preset = worldText.getPreset();
        this.hueColor = worldText.isHueColor();
        this.color = worldText.getColor();
        this.startHue = worldText.getStartHue();
        this.startSaturation = worldText.getStartSaturation();
        this.startBrightness = worldText.getStartBrightness();
        this.endHue = worldText.getEndHue();
        this.endSaturation = worldText.getEndSaturation();
        this.endBrightness = worldText.getEndBrightness();
        this.showValue = worldText.isShowValue();
        this.startValue = worldText.getStartValue();
        this.endValue = worldText.getEndValue();
        this.valueDecaySpeed = worldText.getValueDecaySpeed();
        this.decayByValue = worldText.isDecayByValue();
        this.value = worldText.getValue();
        this.startSize = worldText.getStartSize();
        this.endSize = worldText.getEndSize();
        this.startRot = worldText.getStartRot();
        this.endRot = worldText.getEndRot();
    }

    public MessageWorldText() {
    }

    public static MessageWorldText decode(PacketBuffer buf) {
        MessageWorldText packet = new MessageWorldText();
        packet.worldResLoc = new ResourceLocation(buf.func_218666_n());
        packet.startPos = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        packet.endPos = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        packet.text = buf.func_218666_n();
        packet.secondsLifespan = buf.readFloat();
        packet.maxOffset = buf.readFloat();
        packet.preset = buf.readByte();
        packet.hueColor = buf.readBoolean();
        packet.color = buf.readInt();
        packet.startHue = buf.readFloat();
        packet.startSaturation = buf.readFloat();
        packet.startBrightness = buf.readFloat();
        packet.endHue = buf.readFloat();
        packet.endSaturation = buf.readFloat();
        packet.endBrightness = buf.readFloat();
        packet.showValue = buf.readBoolean();
        packet.startValue = buf.readFloat();
        packet.endValue = buf.readFloat();
        packet.valueDecaySpeed = buf.readFloat();
        packet.decayByValue = buf.readBoolean();
        packet.startSize = buf.readFloat();
        packet.endSize = buf.readFloat();
        packet.startRot = buf.readFloat();
        packet.endRot = buf.readFloat();
        return packet;
    }

    public static void encode(MessageWorldText packet, PacketBuffer buf) {
        buf.func_180714_a(packet.worldResLoc.toString());
        buf.writeDouble(packet.startPos.func_82615_a());
        buf.writeDouble(packet.startPos.func_82617_b());
        buf.writeDouble(packet.startPos.func_82616_c());
        buf.writeDouble(packet.endPos.func_82615_a());
        buf.writeDouble(packet.endPos.func_82617_b());
        buf.writeDouble(packet.endPos.func_82616_c());
        buf.func_180714_a(packet.text);
        buf.writeFloat(packet.secondsLifespan);
        buf.writeFloat(packet.maxOffset);
        buf.writeByte((int)packet.preset);
        buf.writeBoolean(packet.hueColor);
        buf.writeInt(packet.color);
        buf.writeFloat(packet.startHue);
        buf.writeFloat(packet.startSaturation);
        buf.writeFloat(packet.startBrightness);
        buf.writeFloat(packet.endHue);
        buf.writeFloat(packet.endSaturation);
        buf.writeFloat(packet.endBrightness);
        buf.writeBoolean(packet.showValue);
        buf.writeFloat(packet.startValue);
        buf.writeFloat(packet.endValue);
        buf.writeFloat(packet.valueDecaySpeed);
        buf.writeBoolean(packet.decayByValue);
        buf.writeFloat(packet.startSize);
        buf.writeFloat(packet.endSize);
        buf.writeFloat(packet.startRot);
        buf.writeFloat(packet.endRot);
    }

    public static void handlePacket(MessageWorldText packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            WorldText worldText = WorldText.fromVector(packet.worldResLoc, packet.startPos, packet.endPos);
            worldText.setText(packet.text);
            worldText.setSecondsLifespan(packet.secondsLifespan);
            worldText.setMaxOffset(packet.maxOffset);
            worldText.setPreset(packet.preset);
            worldText.setHueColor(packet.hueColor);
            worldText.setColor(packet.color);
            worldText.setStartHue(packet.startHue);
            worldText.setStartSaturation(packet.startSaturation);
            worldText.setStartBrightness(packet.startBrightness);
            worldText.setEndHue(packet.endHue);
            worldText.setEndSaturation(packet.endSaturation);
            worldText.setEndBrightness(packet.endBrightness);
            worldText.setShowValue(packet.showValue);
            worldText.setStartValue(packet.startValue);
            worldText.setEndValue(packet.endValue);
            worldText.setValueDecaySpeed(packet.valueDecaySpeed);
            worldText.setDecayByValue(packet.decayByValue);
            worldText.setStartSize(packet.startSize);
            worldText.setEndSize(packet.endSize);
            worldText.setStartRot(packet.startRot);
            worldText.setEndRot(packet.endRot);
            XP.addWorldTextOffline(worldText);
        });
        ctx.get().setPacketHandled(true);
    }
}

