/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.party;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.util.XP;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;

public class Party {
    private final long creationDate;
    private final Set<PartyMemberInfo> membersInfo;

    public Party(long creationDate, Set<PartyMemberInfo> members) {
        this.creationDate = creationDate;
        this.membersInfo = members;
    }

    public int getPartySize() {
        return this.membersInfo.size();
    }

    public PartyMemberInfo getMemberInfo(UUID uuid) {
        PartyMemberInfo info = null;
        for (PartyMemberInfo memberInfo : this.membersInfo) {
            if (!memberInfo.uuid.equals(uuid)) continue;
            info = memberInfo;
            break;
        }
        return info;
    }

    public void addMember(UUID uuid) {
        this.membersInfo.add(new PartyMemberInfo(uuid, System.currentTimeMillis(), 0.0));
    }

    public boolean removeMember(UUID uuid) {
        PartyMemberInfo memberInfo = this.getMemberInfo(uuid);
        if (memberInfo == null) {
            return false;
        }
        this.membersInfo.remove(memberInfo);
        return true;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public Set<PartyMemberInfo> getAllMembersInfo() {
        return this.membersInfo;
    }

    public Set<ServerPlayerEntity> getOnlineMembers(MinecraftServer server) {
        HashSet<ServerPlayerEntity> onlineMembers = new HashSet<ServerPlayerEntity>();
        for (ServerPlayerEntity onlinePlayer : server.func_184103_al().func_181057_v()) {
            if (this.getMemberInfo(onlinePlayer.func_110124_au()) == null) continue;
            onlineMembers.add(onlinePlayer);
        }
        return onlineMembers;
    }

    public Set<ServerPlayerEntity> getOnlineMembersInRange(ServerPlayerEntity originPlayer) {
        Set<ServerPlayerEntity> membersInRange = XP.getEntitiesInRange(originPlayer.func_213303_ch(), this.getOnlineMembers(originPlayer.func_184102_h()), Config.forgeConfig.partyRange.get());
        membersInRange.remove(originPlayer);
        for (ServerPlayerEntity memberInRange : new HashSet<ServerPlayerEntity>(membersInRange)) {
            if (XP.isPlayerSurvival((PlayerEntity)memberInRange)) continue;
            membersInRange.remove(memberInRange);
        }
        return membersInRange;
    }

    public int getMembersCount() {
        return this.membersInfo.size();
    }

    public Set<PartyMemberInfo> getMembersInfo(Set<ServerPlayerEntity> membersInRange) {
        HashSet<PartyMemberInfo> onlineMembersInfo = new HashSet<PartyMemberInfo>();
        for (ServerPlayerEntity player : membersInRange) {
            onlineMembersInfo.add(this.getMemberInfo(player.func_110124_au()));
        }
        return onlineMembersInfo;
    }

    public double getTotalXpGained() {
        double totalXpGained = 0.0;
        for (PartyMemberInfo memberInfo : this.membersInfo) {
            totalXpGained += memberInfo.xpGained;
        }
        return totalXpGained;
    }

    public double getMultiplier(int membersInRange) {
        return 1.0 + Math.min((double)membersInRange * Config.forgeConfig.partyXpIncreasePerPlayer.get() / 100.0, Config.forgeConfig.maxPartyXpBonus.get() / 100.0);
    }

    public void submitXpGained(UUID uuid, double xpGained) {
        PartyMemberInfo memberInfo = this.getMemberInfo(uuid);
        if (memberInfo != null) {
            memberInfo.xpGained += xpGained;
        }
    }

    public static int getMaxPartyMembers() {
        return Config.forgeConfig.partyMaxMembers.get();
    }
}

