/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.party;

import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.vector.Vector3d;

public class PartyPendingSystem {
    public static CompoundNBT offlineData = new CompoundNBT();
    public static Map<UUID, UUID> pendingInvitations = new HashMap<UUID, UUID>();
    public static Map<UUID, Long> invitationDates = new HashMap<UUID, Long>();
    public static final long expirationTime = 300000L;

    public static UUID getOwnerUUID(UUID inviteeUUID) {
        UUID ownerUUID = null;
        if (pendingInvitations.containsKey(inviteeUUID)) {
            ownerUUID = pendingInvitations.get(inviteeUUID);
        }
        return ownerUUID;
    }

    public static int createInvitation(ServerPlayerEntity invitee, UUID ownerUUID) {
        PmmoSavedData pmmoSavedData = PmmoSavedData.get();
        Party ownerParty = pmmoSavedData.getParty(ownerUUID);
        UUID inviteeUUID = invitee.func_110124_au();
        if (pendingInvitations.containsKey(inviteeUUID) && pendingInvitations.get(inviteeUUID).equals(ownerUUID)) {
            return -3;
        }
        if (ownerParty == null) {
            return -1;
        }
        if (pmmoSavedData.getParty(inviteeUUID) != null) {
            return -2;
        }
        if (ownerParty.getMembersCount() + 1 > Party.getMaxPartyMembers()) {
            return -4;
        }
        pendingInvitations.put(inviteeUUID, ownerUUID);
        invitationDates.put(inviteeUUID, System.currentTimeMillis());
        return 0;
    }

    public static int acceptInvitation(ServerPlayerEntity invitee, UUID ownerUUID) {
        UUID inviteeUUID = invitee.func_110124_au();
        int result = -3;
        if (pendingInvitations.containsKey(inviteeUUID)) {
            long createdAgo = invitationDates.get(inviteeUUID);
            invitationDates.remove(inviteeUUID);
            if (System.currentTimeMillis() - createdAgo <= 300000L) {
                PmmoSavedData pmmoSavedData = PmmoSavedData.get();
                result = pmmoSavedData.addToParty(ownerUUID, inviteeUUID);
            }
        }
        pendingInvitations.remove(inviteeUUID);
        return result;
    }

    public static boolean declineInvitation(UUID inviteeUUID) {
        boolean success = false;
        if (pendingInvitations.containsKey(inviteeUUID)) {
            success = true;
        }
        pendingInvitations.remove(inviteeUUID);
        return success;
    }

    public static void sendPlayerOfflineData(ServerPlayerEntity player) {
        CompoundNBT partyData = new CompoundNBT();
        Party party = PmmoSavedData.get().getParty(player.func_110124_au());
        if (party != null) {
            Set<PartyMemberInfo> membersInfo = party.getAllMembersInfo();
            for (PartyMemberInfo partyMemberInfo : membersInfo) {
                UUID uuid = partyMemberInfo.uuid;
                ServerPlayerEntity partyMember = XP.getPlayerByUUID(uuid);
                CompoundNBT partyMemberData = new CompoundNBT();
                if (partyMember != null) {
                    partyMemberData.func_74776_a("maxHp", partyMember.func_110138_aP());
                    partyMemberData.func_74776_a("hp", partyMember.func_110143_aJ());
                    partyMemberData.func_74778_a("dim", XP.getDimResLoc(partyMember.field_70170_p).toString());
                    Vector3d pos = partyMember.func_213303_ch();
                    partyMemberData.func_74780_a("x", pos.func_82615_a());
                    partyMemberData.func_74780_a("y", pos.func_82617_b());
                    partyMemberData.func_74780_a("z", pos.func_82616_c());
                }
                partyData.func_218657_a(PmmoSavedData.get().getName(uuid), (INBT)partyMemberData);
            }
        }
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(partyData, 7), player);
    }
}

