/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.pmmo_saved_data;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PmmoSavedData
extends WorldSavedData {
    public static final Logger LOGGER = LogManager.getLogger();
    private static PmmoSavedData pmmoSavedData;
    private static MinecraftServer server;
    private static String NAME;
    private Map<UUID, Map<String, Double>> xp = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Double>> scheduledXp = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Double>> abilities = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Double>> preferences = new HashMap<UUID, Map<String, Double>>();
    private Map<UUID, Map<String, Map<String, Double>>> xpBoosts = new HashMap<UUID, Map<String, Map<String, Double>>>();
    private Set<Party> parties = new HashSet<Party>();
    private Map<UUID, String> name = new HashMap<UUID, String>();

    public PmmoSavedData() {
        super(NAME);
    }

    public void func_76184_a(CompoundNBT inData) {
        if (inData.func_74764_b("players")) {
            CompoundNBT playersTag = inData.func_74775_l("players");
            for (String playerUuidKey : playersTag.func_150296_c()) {
                CompoundNBT playerTag = playersTag.func_74775_l(playerUuidKey);
                if (playerTag.func_74764_b("xp")) {
                    CompoundNBT xpTag = playerTag.func_74775_l("xp");
                    for (String tag : new HashSet(xpTag.func_150296_c())) {
                        if (xpTag.func_74769_h(tag) > 0.0) {
                            xpTag.func_74780_a(tag.toLowerCase(), xpTag.func_74769_h(tag));
                            continue;
                        }
                        xpTag.func_82580_o(tag.toLowerCase());
                    }
                }
                if (playerTag.func_74764_b("name")) {
                    this.name.put(UUID.fromString(playerUuidKey), playerTag.func_74779_i("name"));
                }
                this.xp = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "xp"));
                this.scheduledXp = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "scheduledXp"));
                this.abilities = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "abilities"));
                this.preferences = NBTHelper.nbtToMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "preferences"));
                this.xpBoosts = NBTHelper.nbtToMapStringMapUuidString(NBTHelper.extractNbtPlayersIndividualTagsFromPlayersTag(playersTag, "xpBoosts"));
            }
        }
        if (inData.func_74764_b("parties")) {
            CompoundNBT partiesTag = inData.func_74775_l("parties");
            for (String key : partiesTag.func_150296_c()) {
                CompoundNBT partyTag = partiesTag.func_74775_l(key);
                CompoundNBT membersTag = partyTag.func_74775_l("members");
                HashSet<PartyMemberInfo> membersInfo = new HashSet<PartyMemberInfo>();
                for (String id : membersTag.func_150296_c()) {
                    CompoundNBT memberInfoTag = membersTag.func_74775_l(id);
                    PartyMemberInfo memberInfo = new PartyMemberInfo(UUID.fromString(memberInfoTag.func_74779_i("uuid")), memberInfoTag.func_74763_f("joinDate"), memberInfoTag.func_74769_h("xpGained"));
                    membersInfo.add(memberInfo);
                }
                this.parties.add(new Party(partyTag.func_74763_f("creationDate"), membersInfo));
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT outData) {
        CompoundNBT playersTag = new CompoundNBT();
        CompoundNBT partiesTag = new CompoundNBT();
        for (Map.Entry<UUID, Map<String, Double>> entry : this.xp.entrySet()) {
            HashMap<String, CompoundNBT> playerMap = new HashMap<String, CompoundNBT>();
            playerMap.put("xp", NBTHelper.mapStringToNbt(this.xp.getOrDefault(entry.getKey(), new HashMap())));
            playerMap.put("scheduledXp", NBTHelper.mapStringToNbt(this.scheduledXp.getOrDefault(entry.getKey(), new HashMap())));
            playerMap.put("abilities", NBTHelper.mapStringToNbt(this.abilities.getOrDefault(entry.getKey(), new HashMap())));
            playerMap.put("preferences", NBTHelper.mapStringToNbt(this.preferences.getOrDefault(entry.getKey(), new HashMap())));
            playerMap.put("xpBoosts", NBTHelper.mapStringMapStringToNbt(this.xpBoosts.getOrDefault(entry.getKey(), new HashMap())));
            CompoundNBT playerTag = NBTHelper.mapStringNbtToNbt(playerMap);
            playerTag.func_74778_a("name", this.name.get(entry.getKey()));
            playersTag.func_218657_a(entry.getKey().toString(), (INBT)playerTag);
        }
        outData.func_218657_a("players", (INBT)playersTag);
        int i = 0;
        for (Party party : this.parties) {
            CompoundNBT partyTag = new CompoundNBT();
            CompoundNBT membersTag = new CompoundNBT();
            int j = 0;
            for (PartyMemberInfo memberInfo : party.getAllMembersInfo()) {
                CompoundNBT memberInfoTag = new CompoundNBT();
                memberInfoTag.func_74778_a("uuid", memberInfo.uuid.toString());
                memberInfoTag.func_74772_a("joinDate", memberInfo.joinDate);
                memberInfoTag.func_74780_a("xpGained", memberInfo.xpGained);
                membersTag.func_218657_a("" + j++, (INBT)memberInfoTag);
            }
            partyTag.func_74772_a("creationDate", party.getCreationDate());
            partyTag.func_218657_a("members", (INBT)membersTag);
            partiesTag.func_218657_a("" + i, (INBT)partyTag);
            ++i;
        }
        outData.func_218657_a("parties", (INBT)partiesTag);
        return outData;
    }

    public Map<String, Double> getXpMap(UUID uuid) {
        if (!this.xp.containsKey(uuid)) {
            this.xp.put(uuid, new HashMap());
        }
        return this.xp.get(uuid);
    }

    public Map<String, Double> getScheduledXpMap(UUID uuid) {
        if (!this.scheduledXp.containsKey(uuid)) {
            this.scheduledXp.put(uuid, new HashMap());
        }
        return this.scheduledXp.get(uuid);
    }

    public Map<String, Double> getAbilitiesMap(UUID uuid) {
        if (!this.abilities.containsKey(uuid)) {
            this.abilities.put(uuid, new HashMap());
        }
        return this.abilities.get(uuid);
    }

    public Map<String, Double> getPreferencesMap(UUID uuid) {
        if (!this.preferences.containsKey(uuid)) {
            this.preferences.put(uuid, new HashMap());
        }
        return this.preferences.get(uuid);
    }

    public double getXp(String skill, UUID uuid) {
        return ((Map)this.xp.getOrDefault(uuid, new HashMap())).getOrDefault(skill, 0.0);
    }

    public int getLevel(String skill, UUID uuid) {
        return XP.levelAtXp(this.getXp(skill, uuid));
    }

    public double getLevelDecimal(String skill, UUID uuid) {
        return XP.levelAtXpDecimal(this.getXp(skill, uuid));
    }

    public boolean setXp(String skill, UUID uuid, double amount) {
        double maxXp = Config.getConfig("maxXp");
        if (amount > maxXp) {
            amount = maxXp;
        }
        if (amount < 0.0) {
            amount = 0.0;
        }
        if (!this.xp.containsKey(uuid)) {
            this.xp.put(uuid, new HashMap());
        }
        if (amount > 0.0) {
            this.xp.get(uuid).put(skill, amount);
        } else {
            this.xp.get(uuid).remove(skill);
        }
        this.func_76186_a(true);
        return true;
    }

    public boolean addXp(String skill, UUID uuid, double amount) {
        this.setXp(skill, uuid, this.getXp(skill, uuid) + amount);
        this.func_76186_a(true);
        return true;
    }

    public void scheduleXp(String skill, UUID uuid, double amount, String sourceName) {
        Map<String, Double> scheduledXpMap = this.getScheduledXpMap(uuid);
        if (!scheduledXpMap.containsKey(skill)) {
            scheduledXpMap.put(skill, amount);
        } else {
            scheduledXpMap.put(skill, amount + scheduledXpMap.get(skill));
        }
        LOGGER.debug("Scheduled " + amount + "xp for: " + sourceName + ", to: " + this.getName(uuid));
        this.func_76186_a(true);
    }

    public void removeScheduledXpUuid(UUID uuid) {
        this.scheduledXp.remove(uuid);
    }

    public void setName(String name, UUID uuid) {
        this.name.put(uuid, name);
    }

    public String getName(UUID uuid) {
        return this.name.getOrDefault(uuid, "Nameless Warning");
    }

    public Party getParty(UUID uuid) {
        Party party = null;
        for (Party thisParty : this.parties) {
            if (thisParty.getMemberInfo(uuid) == null) continue;
            party = thisParty;
        }
        return party;
    }

    public boolean makeParty(UUID uuid) {
        if (this.getParty(uuid) == null) {
            Party party = new Party(System.currentTimeMillis(), new HashSet<PartyMemberInfo>());
            party.addMember(uuid);
            this.parties.add(party);
            return true;
        }
        return false;
    }

    public int addToParty(UUID ownerUuid, UUID newMemberUuid) {
        Party ownerParty = this.getParty(ownerUuid);
        Party newMemberParty = this.getParty(newMemberUuid);
        if (ownerParty == null) {
            return -1;
        }
        if (newMemberParty != null) {
            return -2;
        }
        if (ownerParty.getMembersCount() + 1 > Party.getMaxPartyMembers()) {
            return -4;
        }
        ownerParty.addMember(newMemberUuid);
        this.func_76185_a();
        return 0;
    }

    public int removeFromParty(UUID uuid) {
        Party party = this.getParty(uuid);
        if (party == null) {
            return -1;
        }
        party.removeMember(uuid);
        if (party.getPartySize() == 0) {
            this.parties.remove(party);
            this.func_76185_a();
            return 1;
        }
        return 0;
    }

    public static void init(MinecraftServer server) {
        PmmoSavedData.server = server;
        pmmoSavedData = (PmmoSavedData)server.func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(PmmoSavedData::new, NAME);
    }

    public static PmmoSavedData get() {
        return pmmoSavedData;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public Map<String, Map<String, Double>> getPlayerXpBoostsMap(UUID playerUUID) {
        return this.xpBoosts.getOrDefault(playerUUID, new HashMap());
    }

    public Map<String, Double> getPlayerXpBoostMap(UUID playerUUID, String xpBoostKey) {
        return this.getPlayerXpBoostsMap(playerUUID).getOrDefault(xpBoostKey, new HashMap());
    }

    public double getPlayerXpBoost(UUID playerUUID, String skill) {
        double xpBoost = 0.0;
        for (Map.Entry<String, Map<String, Double>> entry : this.getPlayerXpBoostsMap(playerUUID).entrySet()) {
            xpBoost += entry.getValue().getOrDefault(skill, 0.0).doubleValue();
        }
        return xpBoost;
    }

    public void setPlayerXpBoostsMaps(UUID playerUUID, Map<String, Map<String, Double>> newBoosts) {
        HashMap<String, Map<String, Double>> sanitizedBoosts = new HashMap<String, Map<String, Double>>();
        for (Map.Entry<String, Map<String, Double>> boostMapEntry : newBoosts.entrySet()) {
            sanitizedBoosts.put(boostMapEntry.getKey(), NBTHelper.stringMapToLowerCase(boostMapEntry.getValue()));
        }
        this.xpBoosts.put(playerUUID, sanitizedBoosts);
        this.func_76186_a(true);
    }

    public void setPlayerXpBoost(UUID playerUUID, String xpBoostKey, Map<String, Double> newXpBoosts) {
        for (Map.Entry<String, Double> entry : newXpBoosts.entrySet()) {
            this.setPlayerXpBoost(playerUUID, xpBoostKey, entry.getKey(), entry.getValue());
        }
        ServerPlayerEntity player = XP.getPlayerByUUID(playerUUID, server);
        if (player != null) {
            XP.syncPlayerXpBoost((PlayerEntity)player);
        }
        this.func_76186_a(true);
    }

    private void setPlayerXpBoost(UUID playerUUID, String xpBoostKey, String skill, Double xpBoost) {
        if (!this.xpBoosts.containsKey(playerUUID)) {
            this.xpBoosts.put(playerUUID, new HashMap());
        }
        if (!this.xpBoosts.get(playerUUID).containsKey(xpBoostKey)) {
            this.xpBoosts.get(playerUUID).put(xpBoostKey, new HashMap());
        }
        this.xpBoosts.get(playerUUID).get(xpBoostKey).put(skill.toLowerCase(), xpBoost);
        this.func_76186_a(true);
    }

    public void removePlayerXpBoost(UUID playerUUID, String xpBoostKey) {
        this.getPlayerXpBoostsMap(playerUUID).remove(xpBoostKey);
        this.func_76186_a(true);
    }

    public void removeAllPlayerXpBoosts(UUID playerUUID) {
        this.xpBoosts.remove(playerUUID);
        this.func_76186_a(true);
    }

    public Map<UUID, Map<String, Double>> getAllXpMaps() {
        return this.xp;
    }

    static {
        NAME = "pmmo";
    }
}

