/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.proxy;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.InfoScreen;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.gui.WorldRenderHandler;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final KeyBinding SHOW_BAR = new KeyBinding("key.pmmo.showBar", 258, "category.pmmo");
    public static final KeyBinding SHOW_LIST = new KeyBinding("key.pmmo.showList", 342, "category.pmmo");
    public static final KeyBinding TOGGLE_TOOLTIP = new KeyBinding("key.pmmo.toggleTooltip", 295, "category.pmmo");
    public static final KeyBinding VEIN_KEY = new KeyBinding("key.pmmo.vein", 96, "category.pmmo");
    public static final KeyBinding OPEN_MENU = new KeyBinding("key.pmmo.openMenu", 80, "category.pmmo");
    public static final KeyBinding OPEN_SETTINGS = new KeyBinding("key.pmmo.openSettings", -1, "category.pmmo");
    public static final KeyBinding OPEN_SKILLS = new KeyBinding("key.pmmo.openSkills", -1, "category.pmmo");
    public static final KeyBinding OPEN_GLOSSARY = new KeyBinding("key.pmmo.openGlossary", -1, "category.pmmo");
    public static Map<String, Map<String, Map<String, Double>>> hiscoreMap = new HashMap<String, Map<String, Map<String, Double>>>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new XPOverlayGUI());
        MinecraftForge.EVENT_BUS.register((Object)new WorldRenderHandler());
        ClientRegistry.registerKeyBinding((KeyBinding)SHOW_BAR);
        ClientRegistry.registerKeyBinding((KeyBinding)SHOW_LIST);
        ClientRegistry.registerKeyBinding((KeyBinding)TOGGLE_TOOLTIP);
        ClientRegistry.registerKeyBinding((KeyBinding)VEIN_KEY);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_MENU);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_SETTINGS);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_SKILLS);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_GLOSSARY);
    }

    public static void updateNBTTag(MessageUpdatePlayerNBT packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        CompoundNBT newPackage = packet.reqPackage;
        Set keySet = newPackage.func_150296_c();
        switch (packet.type) {
            case 0: {
                Map<String, Double> prefsMap = Config.getPreferencesMap((PlayerEntity)player);
                for (String tag : keySet) {
                    prefsMap.put(tag, newPackage.func_74769_h(tag));
                }
                AttributeHandler.updateAll((PlayerEntity)player);
                XPOverlayGUI.doInit();
                break;
            }
            case 1: {
                Map<String, Double> abilitiesMap = Config.getAbilitiesMap((PlayerEntity)player);
                for (String tag : keySet) {
                    abilitiesMap.put(tag, newPackage.func_74769_h(tag));
                }
                if (!XP.isPlayerSurvival((PlayerEntity)player)) break;
                XPOverlayGUI.updateVein();
                break;
            }
            case 6: {
                APIUtils.setPlayerXpBoostsMaps((PlayerEntity)player, NBTHelper.nbtToMapStringString(newPackage));
                break;
            }
            case 7: {
                break;
            }
            default: {
                LOGGER.error("ERROR MessageUpdateNBT WRONG TYPE");
            }
        }
    }

    public static void openStats(UUID uuid) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ListScreen(uuid, (ITextComponent)new TranslationTextComponent("pmmo.skills"), "", JType.SKILLS, (PlayerEntity)Minecraft.func_71410_x().field_71439_g));
    }

    public static void syncPrefsToServer() {
        NetworkHandler.sendToServer(new MessageUpdatePlayerNBT(NBTHelper.mapStringToNbt(Config.getPreferencesMap((PlayerEntity)Minecraft.func_71410_x().field_71439_g)), 0));
    }

    public static void openInfoMenu() {
        Minecraft.func_71410_x().func_147108_a((Screen)new InfoScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au(), (ITextComponent)new TranslationTextComponent("pmmo.info")));
    }
}

