/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.skills.Skill;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeMod;

public class AttributeHandler {
    private static final UUID reachModifierID = UUID.fromString("b20d3436-0d39-4868-96ab-d0a4856e68c6");
    private static final UUID speedModifierID = UUID.fromString("d6103cbc-b90b-4c4b-b3c0-92701fb357b3");
    private static final UUID hpModifierID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcb");
    private static final UUID damageModifierID = UUID.fromString("992b11f1-7b3f-48d9-8ebd-1acfc3257b17");

    public static void updateAll(PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d()) {
            WorldTickHandler.updateVein(player, 0.0);
        }
        AttributeHandler.updateReach(player);
        AttributeHandler.updateHP(player);
        AttributeHandler.updateDamage(player);
    }

    public static double getReachBoost(PlayerEntity player) {
        double maxReach;
        Map<String, Double> prefsMap = Config.getPreferencesMap(player);
        double buildLevel = Skill.getLevel(Skill.BUILDING.toString(), player);
        double reach = -0.91 + buildLevel / Config.getConfig("levelsPerOneReach");
        double maxReachPref = maxReach = Config.getConfig("maxExtraReachBoost");
        if (prefsMap.containsKey("maxExtraReachBoost")) {
            maxReachPref = prefsMap.get("maxExtraReachBoost");
        }
        reach = Math.min(maxReach, Math.min(maxReachPref, reach));
        return player.func_184812_l_() ? Math.max(50.0, reach) : reach;
    }

    public static void updateReach(PlayerEntity player) {
        double reach = AttributeHandler.getReachBoost(player);
        ModifiableAttributeInstance reachAttribute = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachAttribute.func_111127_a(reachModifierID) == null || reachAttribute.func_111127_a(reachModifierID).func_111164_d() != reach) {
            AttributeModifier reachModifier = new AttributeModifier(reachModifierID, "Reach bonus thanks to Build Level", reach, AttributeModifier.Operation.ADDITION);
            reachAttribute.func_188479_b(reachModifierID);
            reachAttribute.func_233769_c_(reachModifier);
        }
    }

    public static double getBaseSpeed(PlayerEntity player) {
        return player.func_110148_a(Attributes.field_233821_d_).func_111125_b();
    }

    public static double getSpeedBoost(PlayerEntity player) {
        int agilityLevel = Skill.getLevel(Skill.AGILITY.toString(), player);
        return AttributeHandler.getBaseSpeed(player) * AttributeHandler.getSpeedBoostMultiplier(agilityLevel);
    }

    public static double getSpeedBoostMultiplier(int agilityLevel) {
        double maxSpeedBoost;
        Map<String, Double> prefsMap = Config.getPreferencesMapOffline();
        double maxSpeedBoostPref = maxSpeedBoost = Config.getConfig("maxSpeedBoost") / 100.0;
        if (prefsMap.containsKey("maxSpeedBoost")) {
            maxSpeedBoostPref = prefsMap.get("maxSpeedBoost") / 100.0;
        }
        return Math.max(0.0, Math.min(maxSpeedBoost, Math.min(maxSpeedBoostPref, (double)agilityLevel * Config.getConfig("speedBoostPerLevel") / 100.0)));
    }

    public static int getHeartBoost(PlayerEntity player) {
        int maxHP;
        Map<String, Double> prefsMap = Config.getPreferencesMap(player);
        double enduranceLevel = Skill.getLevel(Skill.ENDURANCE.toString(), player);
        int heartBoost = (int)Math.floor(enduranceLevel / Config.getConfig("levelsPerHeart")) * 2;
        int maxHPPref = maxHP = (int)Config.getConfig("maxExtraHeartBoost") * 2;
        if (prefsMap.containsKey("maxExtraHeartBoost")) {
            maxHPPref = (int)Math.floor(prefsMap.get("maxExtraHeartBoost") * 2.0);
        }
        heartBoost = Math.min(maxHP, Math.min(maxHPPref, heartBoost));
        return heartBoost;
    }

    public static void updateSpeed(PlayerEntity player) {
        ModifiableAttributeInstance speedAttribute = player.func_110148_a(Attributes.field_233821_d_);
        double speedBoost = AttributeHandler.getSpeedBoost(player);
        if (speedBoost > 0.0 && (speedAttribute.func_111127_a(speedModifierID) == null || speedAttribute.func_111127_a(speedModifierID).func_111164_d() != speedBoost)) {
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Speed bonus thanks to Agility Level", speedBoost, AttributeModifier.Operation.ADDITION);
            speedAttribute.func_188479_b(speedModifierID);
            speedAttribute.func_233769_c_(speedModifier);
        }
    }

    public static void resetSpeed(PlayerEntity player) {
        ModifiableAttributeInstance speedAttribute = player.func_110148_a(Attributes.field_233821_d_);
        speedAttribute.func_188479_b(speedModifierID);
    }

    public static void updateHP(PlayerEntity player) {
        int heartBoost = AttributeHandler.getHeartBoost(player);
        ModifiableAttributeInstance hpAttribute = player.func_110148_a(Attributes.field_233818_a_);
        AttributeModifier hpModifier = new AttributeModifier(hpModifierID, "Max HP Bonus thanks to Endurance Level", (double)heartBoost, AttributeModifier.Operation.ADDITION);
        hpAttribute.func_188479_b(hpModifierID);
        hpAttribute.func_233769_c_(hpModifier);
    }

    public static void updateDamage(PlayerEntity player) {
        double maxDamage;
        ModifiableAttributeInstance damageAttribute = player.func_110148_a(Attributes.field_233823_f_);
        Map<String, Double> prefsMap = Config.getPreferencesMap(player);
        double maxDamagePref = maxDamage = Config.getConfig("maxExtraDamagePercentageBoostMelee");
        if (prefsMap.containsKey("maxExtraDamagePercentageBoostMelee")) {
            maxDamagePref = prefsMap.get("maxExtraDamagePercentageBoostMelee");
        }
        double combatLevel = Skill.getLevel(Skill.COMBAT.toString(), player);
        double damageBoost = Math.min(maxDamage, Math.min(maxDamagePref, combatLevel * Config.getConfig("damageBonusPercentPerLevelMelee")));
        AttributeModifier damageModifier = new AttributeModifier(damageModifierID, "Damage Boost thanks to Combat Level", damageBoost, AttributeModifier.Operation.MULTIPLY_BASE);
        damageAttribute.func_188479_b(damageModifierID);
        damageAttribute.func_233769_c_(damageModifier);
    }

    public static void updateHP(MobEntity mob, float bonus) {
        ModifiableAttributeInstance hpAttribute = mob.func_110148_a(Attributes.field_233818_a_);
        if (hpAttribute != null) {
            boolean wasMaxHealth = mob.func_110143_aJ() == mob.func_110138_aP();
            double maxMobHPBoost = Config.getConfig("maxMobHPBoost");
            double mobHPBoostPerPowerLevel = Config.getConfig("mobHPBoostPerPowerLevel");
            if (!(mob instanceof AnimalEntity)) {
                bonus = (float)((double)bonus * mobHPBoostPerPowerLevel);
            }
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "hpBonus"))) > maxMobHPBoost) {
                bonus = (float)maxMobHPBoost;
            }
            AttributeModifier hpModifier = new AttributeModifier(hpModifierID, "Max HP Bonus thanks to Nearby Player Power Level", (double)bonus, AttributeModifier.Operation.ADDITION);
            hpAttribute.func_188479_b(hpModifierID);
            hpAttribute.func_233769_c_(hpModifier);
            if (wasMaxHealth) {
                mob.func_70606_j(mob.func_110138_aP());
            }
        }
    }

    public static void updateDamage(MobEntity mob, float bonus) {
        ModifiableAttributeInstance damageAttribute = mob.func_110148_a(Attributes.field_233823_f_);
        if (damageAttribute != null) {
            double maxMobDamageBoost = Config.getConfig("maxMobDamageBoost");
            double mobDamageBoostPerPowerLevel = Config.getConfig("mobDamageBoostPerPowerLevel");
            bonus = (float)((double)bonus * mobDamageBoostPerPowerLevel);
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "damageBonus"))) > maxMobDamageBoost) {
                bonus = (float)maxMobDamageBoost;
            }
            AttributeModifier damageModifier = new AttributeModifier(damageModifierID, "Damage Boost thanks to Nearby Player Power Level", (double)bonus, AttributeModifier.Operation.ADDITION);
            damageAttribute.func_188479_b(damageModifierID);
            damageAttribute.func_233769_c_(damageModifier);
        }
    }

    public static void updateSpeed(MobEntity mob, float bonus) {
        ModifiableAttributeInstance speedAttribute = mob.func_110148_a(Attributes.field_233821_d_);
        if (speedAttribute != null && !(mob instanceof AnimalEntity)) {
            double maxMobSpeedBoost = Config.getConfig("maxMobSpeedBoost");
            double mobSpeedBoostPerPowerLevel = Config.getConfig("mobSpeedBoostPerPowerLevel");
            bonus = (float)((double)bonus * mobSpeedBoostPerPowerLevel);
            if ((double)(bonus = (float)((double)bonus * AttributeHandler.getBiomeMobMultiplier(mob, "speedBonus"))) > maxMobSpeedBoost) {
                bonus = (float)maxMobSpeedBoost;
            }
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Movement Speed Boost thanks to Nearby Player Power Level", (double)(bonus / 100.0f), AttributeModifier.Operation.ADDITION);
            speedAttribute.func_188479_b(speedModifierID);
            speedAttribute.func_233769_c_(speedModifier);
        }
    }

    private static double getBiomeMobMultiplier(MobEntity mob, String type) {
        Biome biome = mob.field_70170_p.func_226691_t_(new BlockPos(mob.func_213303_ch()));
        ResourceLocation biomeResLoc = biome.getRegistryName();
        double multiplier = 1.0;
        if (biomeResLoc != null) {
            String biomeKey = biome.getRegistryName().toString();
            Map<String, Double> theMap = JsonConfig.data.get((Object)JType.BIOME_MOB_MULTIPLIER).get(biomeKey);
            if (theMap != null && theMap.containsKey(type)) {
                multiplier = theMap.get(type);
            }
        }
        return multiplier;
    }
}

