/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CheeseTracker {
    private static final Map<UUID, Integer> playersLookCheeseCount = new HashMap<UUID, Integer>();
    private static final Map<UUID, Double> playersLastLookVecs = new HashMap<UUID, Double>();

    public static void trackCheese(ServerPlayerEntity player) {
        UUID uuid = player.func_110124_au();
        Vector3d playerLookVec = player.func_70040_Z();
        double currLookVec = playerLookVec.field_72450_a + playerLookVec.field_72448_b + playerLookVec.field_72449_c;
        double cheeseMaxStorage = Config.forgeConfig.cheeseMaxStorage.get().intValue();
        if (!playersLookCheeseCount.containsKey(uuid)) {
            playersLookCheeseCount.put(uuid, 0);
            playersLastLookVecs.put(uuid, currLookVec);
        }
        int lookVecCheese = playersLookCheeseCount.get(uuid);
        double lazyMultiplier = CheeseTracker.getLazyMultiplier(uuid);
        if (playersLastLookVecs.get(uuid) != currLookVec) {
            playersLookCheeseCount.put(uuid, Math.max(0, lookVecCheese - Config.forgeConfig.activityCheeseReplenishSpeed.get()));
            if (lazyMultiplier != 1.0) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.afkMultiplierRestored", new Object[]{DP.dpSoft(CheeseTracker.getLazyMultiplier(uuid) * 100.0)}).func_230530_a_(XP.getColorStyle(65280)), true);
            }
        } else {
            playersLookCheeseCount.put(uuid, (int)Math.min(cheeseMaxStorage, Math.min(cheeseMaxStorage, (double)(lookVecCheese + 1))));
            if (lazyMultiplier < Config.forgeConfig.sendPlayerCheeseWarningBelowMultiplier.get()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.afkMultiplierWarning", new Object[]{DP.dpSoft(CheeseTracker.getLazyMultiplier(uuid) * 100.0)}).func_230530_a_(XP.getColorStyle(0xFF0000)), true);
            }
        }
        playersLastLookVecs.put(uuid, currLookVec);
    }

    public static double getLazyMultiplier(UUID uuid, String skill) {
        if (JsonConfig.localData.get((Object)JType.SKILLS).containsKey(skill) && JsonConfig.localData.get((Object)JType.SKILLS).get(skill).getOrDefault("noAfkPenalty", 0.0) != 0.0) {
            return 1.0;
        }
        return CheeseTracker.getLazyMultiplier(uuid);
    }

    public static double getLazyMultiplier(UUID uuid) {
        if (!playersLookCheeseCount.containsKey(uuid)) {
            return 1.0;
        }
        int playerCheese = playersLookCheeseCount.get(uuid);
        return Util.mapCapped(playerCheese - Config.forgeConfig.freeCheese.get(), 0.0, Config.forgeConfig.cheeseMaxStorage.get() - Config.forgeConfig.freeCheese.get(), 1.0, Config.forgeConfig.minimumCheeseXpMultiplier.get());
    }
}

