/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.commands.PmmoCommand;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.Style;

public enum Skill {
    INVALID_SKILL(0xFFFFFF),
    MINING(65535),
    BUILDING(65535),
    EXCAVATION(15112448),
    WOODCUTTING(16753434),
    FARMING(58880),
    AGILITY(0x66CC66),
    ENDURANCE(0xCC0000),
    COMBAT(0xFF3300),
    GUNSLINGING(13877667),
    ARCHERY(0xFFFF00),
    SMITHING(0xF0F0F0),
    FLYING(0xCCCCFF),
    SWIMMING(0x3366FF),
    SAILING(10073087),
    FISHING(52479),
    CRAFTING(0xFF9900),
    MAGIC(255),
    SLAYER(0xFFFFFF),
    HUNTER(13596693),
    TAMING(0xFFFFFF),
    COOKING(15112448),
    ALCHEMY(15112448);

    private static final Map<String, Integer> validSkills;
    private static final Map<String, Style> skillStyle;
    public final String name = this.name();
    public final int color;

    private Skill(int color) {
        this.color = color;
    }

    public static void setSkill(String skill, int color) {
        if (!(skill = skill.toLowerCase()).equals(INVALID_SKILL.toString())) {
            validSkills.put(skill, color);
            skillStyle.put(skill, Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)color)));
        }
    }

    public static int getSkillColor(String skill) {
        return validSkills.getOrDefault(skill, 0xFFFFFF);
    }

    public static Style getSkillStyle(String skill) {
        return skillStyle.getOrDefault(skill, Style.field_240709_b_);
    }

    public static void updateSkills() {
        for (Map.Entry entry : ((Map)JsonConfig.data.getOrDefault((Object)JType.SKILLS, new HashMap())).entrySet()) {
            if (!((Map)entry.getValue()).containsKey("color")) continue;
            Skill.setSkill((String)entry.getKey(), (int)Math.floor((Double)((Map)entry.getValue()).get("color")));
        }
        PmmoCommand.init();
    }

    public static void setSkillStyle(String skill, Style style) {
        skillStyle.put(skill.toLowerCase(), style);
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public boolean equals(String string) {
        return this.toString().equals(string.toLowerCase());
    }

    public static Map<String, Integer> getSkills() {
        return new HashMap<String, Integer>(validSkills);
    }

    @Deprecated
    public static int getLevel(String skill, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return XP.levelAtXp(XP.getOfflineXp(skill, player.func_110124_au()));
        }
        return PmmoSavedData.get().getLevel(skill, player.func_110124_au());
    }

    public static int getLevel(String skill, UUID uuid) {
        return PmmoSavedData.get().getLevel(skill, uuid);
    }

    public static double getLevelDecimal(String skill, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return XP.levelAtXpDecimal(XP.getOfflineXp(skill, player.func_110124_au()));
        }
        return PmmoSavedData.get().getLevelDecimal(skill, player.func_110124_au());
    }

    public static double getLevelDecimal(String skill, UUID uuid) {
        return PmmoSavedData.get().getLevelDecimal(skill, uuid);
    }

    @Deprecated
    public static double getXp(String skill, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return XP.getOfflineXp(skill, player.func_110124_au());
        }
        return PmmoSavedData.get().getXp(skill, player.func_110124_au());
    }

    public static double getXp(String skill, UUID uuid) {
        return PmmoSavedData.get().getXp(skill, uuid);
    }

    @Deprecated
    public static void setLevel(String skill, ServerPlayerEntity player, double amount) {
        Skill.setXp(skill, player, XP.xpAtLevelDecimal(amount));
    }

    public static void setXp(String skill, UUID uuid, double amount) {
        ServerPlayerEntity player = PmmoSavedData.getServer().func_184103_al().func_177451_a(uuid);
        if (player == null) {
            PmmoSavedData.get().setXp(skill, uuid, amount);
        } else {
            Skill.setXp(skill, player, amount);
        }
    }

    @Deprecated
    public static void setXp(String skill, ServerPlayerEntity player, double amount) {
        if (PmmoSavedData.get().setXp(skill, player.func_110124_au(), amount)) {
            AttributeHandler.updateAll((PlayerEntity)player);
            XP.updateRecipes(player);
            NetworkHandler.sendToPlayer(new MessageXp(amount, skill, 0.0, false), player);
        }
    }

    @Deprecated
    public static void addLevel(String skill, UUID uuid, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        double missingXp = XP.xpAtLevelDecimal(Skill.getLevelDecimal(skill, uuid) + amount) - Skill.getXp(skill, uuid);
        Skill.addXp(skill, uuid, missingXp, sourceName, skip, ignoreBonuses);
    }

    public static void addLevel(String skill, ServerPlayerEntity player, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        double missingXp = XP.xpAtLevelDecimal(Skill.getLevelDecimal(skill, (PlayerEntity)player) + amount) - Skill.getXp(skill, (PlayerEntity)player);
        Skill.addXp(skill, player, missingXp, sourceName, skip, ignoreBonuses);
    }

    @Deprecated
    public static void addXp(String skill, UUID uuid, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        ServerPlayerEntity player = PmmoSavedData.getServer().func_184103_al().func_177451_a(uuid);
        if (player == null) {
            PmmoSavedData.get().scheduleXp(skill, uuid, amount, sourceName);
        } else {
            Skill.addXp(skill, player, amount, sourceName, skip, ignoreBonuses);
        }
    }

    public static void addXp(String skill, ServerPlayerEntity player, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        XP.awardXp(player, skill, sourceName, amount, skip, ignoreBonuses, false);
    }

    static {
        validSkills = new HashMap<String, Integer>();
        skillStyle = new HashMap<String, Style>();
        for (Skill skill : Skill.values()) {
            Skill.setSkill(skill.name, skill.color);
        }
    }
}

