/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DrawUtil {
    public static Set<BlockPos> getCircle(int r) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        int x = 0;
        int d = 1 - r;
        int y = r;
        do {
            posSet.add(new BlockPos(x, 0, y));
            posSet.add(new BlockPos(x, 0, -y));
            posSet.add(new BlockPos(-x, 0, y));
            posSet.add(new BlockPos(-x, 0, -y));
            posSet.add(new BlockPos(y, 0, x));
            posSet.add(new BlockPos(y, 0, -x));
            posSet.add(new BlockPos(-y, 0, x));
            posSet.add(new BlockPos(-y, 0, -x));
            ++x;
            if (d < 0) {
                d += 2 * x + 2;
                continue;
            }
            d += 2 * (x - --y) + 1;
        } while (x < y);
        posSet.add(new BlockPos(x, 0, y));
        posSet.add(new BlockPos(x, 0, -y));
        posSet.add(new BlockPos(-x, 0, y));
        posSet.add(new BlockPos(-x, 0, -y));
        return posSet;
    }

    public static Set<BlockPos> getCircleSolid(int r) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        List<Integer> lengths = DrawUtil.getCircleLengths(r);
        int line = 0;
        for (int length : lengths) {
            for (int z = 0; z <= length; ++z) {
                posSet.add(new BlockPos(line, 0, z));
                posSet.add(new BlockPos(line, 0, -z));
                posSet.add(new BlockPos(-line, 0, z));
                posSet.add(new BlockPos(-line, 0, -z));
                posSet.add(new BlockPos(z, 0, line));
                posSet.add(new BlockPos(z, 0, -line));
                posSet.add(new BlockPos(-z, 0, line));
                posSet.add(new BlockPos(-z, 0, -line));
            }
            ++line;
        }
        return posSet;
    }

    public static Set<BlockPos> getSphereSolid(int r) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        int i = 0;
        List<Integer> sphereRadii = DrawUtil.getSphereRadii(r);
        System.out.println(sphereRadii);
        for (int radius : sphereRadii) {
            for (BlockPos pos : DrawUtil.getCircleSolid(radius)) {
                posSet.add(pos.func_177979_c(r - i));
            }
            ++i;
        }
        return posSet;
    }

    public static List<Integer> getSphereRadii(int r) {
        int y;
        ArrayList<Integer> fourthRadii = new ArrayList<Integer>();
        ArrayList<Integer> allY = new ArrayList<Integer>();
        int x = 0;
        int d = 1 - r;
        int oldY = y = r;
        boolean corner = false;
        do {
            d = d < 0 ? (d += 2 * x + 2) : (d += 2 * (++x - --y) + 1);
            if (y != oldY) {
                fourthRadii.add(x - 1);
            }
            oldY = y;
            if (x == y) {
                corner = true;
                continue;
            }
            allY.add(y);
        } while (x < y);
        if (corner) {
            fourthRadii.add(++x);
        }
        List reversedAllY = Lists.reverse(allY);
        reversedAllY.add(reversedAllY.get(reversedAllY.size() - 1));
        fourthRadii.addAll(reversedAllY);
        return fourthRadii;
    }

    public static List<Integer> getCircleLengths(int r) {
        ArrayList<Integer> halfLengths = new ArrayList<Integer>();
        int x = 0;
        int d = 1 - r;
        int y = r;
        do {
            halfLengths.add(y);
            ++x;
            if (d < 0) {
                d += 2 * x + 2;
                continue;
            }
            d += 2 * (x - --y) + 1;
        } while (x < y);
        return halfLengths;
    }

    public static void drawToWorld(World world, BlockPos offset, Set<BlockPos> posSet, BlockState state) {
        for (BlockPos pos : posSet) {
            world.func_175656_a(new BlockPos(offset.func_177958_n() + pos.func_177958_n(), offset.func_177956_o() + pos.func_177956_o(), offset.func_177952_p() + pos.func_177952_p()), state);
        }
    }

    public static void drawToWorld(World world, BlockPos offset, Set<BlockPos> posSet, BlockState state, Direction direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                DrawUtil.drawToWorld(world, offset, posSet, state);
                break;
            }
            case EAST: 
            case WEST: {
                break;
            }
        }
    }
}

