/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class NBTHelper {
    public static <T> Map<T, Double> maxDoubleMaps(Map<T, Double> mapA, Map<T, Double> mapB) {
        for (Map.Entry<T, Double> entry : mapB.entrySet()) {
            mapA.put(entry.getKey(), Math.max(entry.getValue(), mapA.getOrDefault(entry.getKey(), entry.getValue())));
        }
        return mapA;
    }

    public static <T> Map<String, T> stringMapToLowerCase(Map<String, T> inMap) {
        HashMap<String, T> outMap = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : inMap.entrySet()) {
            outMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return outMap;
    }

    public static <T> Map<String, T> mapStringKeyToString(Map<String, T> inMap) {
        HashMap<String, T> outMap = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : inMap.entrySet()) {
            outMap.put(entry.getKey(), entry.getValue());
        }
        return outMap;
    }

    public static Map<String, Double> nbtToMapString(CompoundNBT nbt) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String key : nbt.func_150296_c()) {
            if (Double.isNaN(nbt.func_74769_h(key))) continue;
            map.put(key, nbt.func_74769_h(key));
        }
        return map;
    }

    public static CompoundNBT mapStringToNbt(Map<String, Double> map) {
        if (map == null) {
            return new CompoundNBT();
        }
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            nbt.func_74780_a(entry.getKey(), entry.getValue().doubleValue());
        }
        return nbt;
    }

    public static CompoundNBT mapStringMapStringToNbt(Map<String, Map<String, Double>> map) {
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry<String, Map<String, Double>> entry : map.entrySet()) {
            nbt.func_218657_a(entry.getKey(), (INBT)NBTHelper.mapStringToNbt(entry.getValue()));
        }
        return nbt;
    }

    public static CompoundNBT mapUuidStringToNbt(Map<UUID, Map<String, Double>> inMap) {
        CompoundNBT outData = new CompoundNBT();
        for (Map.Entry<UUID, Map<String, Double>> entry : inMap.entrySet()) {
            outData.func_218657_a(entry.getKey().toString(), (INBT)NBTHelper.mapStringToNbt(entry.getValue()));
        }
        return outData;
    }

    public static Map<UUID, Map<String, Double>> nbtToMapUuidString(CompoundNBT inData) {
        HashMap<UUID, Map<String, Double>> outMap = new HashMap<UUID, Map<String, Double>>();
        for (String uuidKey : inData.func_150296_c()) {
            outMap.put(UUID.fromString(uuidKey), NBTHelper.nbtToMapString(inData.func_74775_l(uuidKey)));
        }
        return outMap;
    }

    public static Map<String, Map<String, Double>> nbtToMapStringString(CompoundNBT inData) {
        HashMap<String, Map<String, Double>> outMap = new HashMap<String, Map<String, Double>>();
        for (String key : inData.func_150296_c()) {
            outMap.put(key, NBTHelper.nbtToMapString(inData.func_74775_l(key)));
        }
        return outMap;
    }

    public static Map<UUID, Map<String, Map<String, Double>>> nbtToMapStringMapUuidString(CompoundNBT inData) {
        HashMap<UUID, Map<String, Map<String, Double>>> outMap = new HashMap<UUID, Map<String, Map<String, Double>>>();
        for (String playerUUIDKey : inData.func_150296_c()) {
            UUID playerUUID = UUID.fromString(playerUUIDKey);
            outMap.put(playerUUID, new HashMap());
            for (String xpBoostKey : inData.func_74775_l(playerUUIDKey).func_150296_c()) {
                ((Map)outMap.get(playerUUID)).put(xpBoostKey, NBTHelper.nbtToMapString(inData.func_74775_l(playerUUIDKey).func_74775_l(xpBoostKey)));
            }
        }
        return outMap;
    }

    public static CompoundNBT mapStringNbtToNbt(Map<String, CompoundNBT> inMap) {
        CompoundNBT outNbt = new CompoundNBT();
        for (Map.Entry<String, CompoundNBT> entry : inMap.entrySet()) {
            outNbt.func_218657_a(entry.getKey(), (INBT)entry.getValue());
        }
        return outNbt;
    }

    public static CompoundNBT extractNbtPlayersIndividualTagsFromPlayersTag(CompoundNBT playersTag, String element) {
        CompoundNBT outData = new CompoundNBT();
        for (String uuidKey : playersTag.func_150296_c()) {
            CompoundNBT playerTag = playersTag.func_74775_l(uuidKey);
            if (!playerTag.func_74764_b(element)) continue;
            outData.func_218657_a(uuidKey, (INBT)playerTag.func_74775_l(element));
        }
        return outData;
    }

    public static Map<UUID, Map<String, Double>> nbtToXpMaps(CompoundNBT input) {
        HashMap<UUID, Map<String, Double>> output = new HashMap<UUID, Map<String, Double>>();
        for (String key1 : input.func_150296_c()) {
            UUID uuid = UUID.fromString(key1);
            output.put(uuid, new HashMap());
            for (String key2 : input.func_74775_l(key1).func_150296_c()) {
                ((Map)output.get(uuid)).put(key2, input.func_74775_l(key1).func_74769_h(key2));
            }
        }
        return output;
    }

    public static CompoundNBT xpMapsToNbt(Map<UUID, Map<String, Double>> input) {
        CompoundNBT output = new CompoundNBT();
        for (UUID key1 : input.keySet()) {
            output.func_218657_a(key1.toString(), (INBT)new CompoundNBT());
            output.func_74775_l(key1.toString()).func_74778_a("name", PmmoSavedData.get().getName(key1));
            for (String skill : input.get(key1).keySet()) {
                Double value = input.get(key1).get(skill);
                output.func_74775_l(key1.toString()).func_74780_a(skill, value.doubleValue());
            }
        }
        return output;
    }

    public static Map<JType, Map<String, Map<String, Double>>> nbtToData3(CompoundNBT input) {
        HashMap<JType, Map<String, Map<String, Double>>> output = new HashMap<JType, Map<String, Map<String, Double>>>();
        for (String jTypeKey : input.func_150296_c()) {
            JType jType = JType.getJType(jTypeKey);
            output.put(jType, new HashMap());
            for (String topKey : input.func_74775_l(jTypeKey).func_150296_c()) {
                ((Map)output.get((Object)jType)).put(topKey, new HashMap());
                for (String botKey : input.func_74775_l(jTypeKey).func_74775_l(topKey).func_150296_c()) {
                    ((Map)((Map)output.get((Object)jType)).get(topKey)).put(botKey, input.func_74775_l(jTypeKey).func_74775_l(topKey).func_74769_h(botKey));
                }
            }
        }
        return output;
    }

    public static CompoundNBT data3ToNbt(Map<JType, Map<String, Map<String, Double>>> input) {
        CompoundNBT output = new CompoundNBT();
        for (JType jType : input.keySet()) {
            output.func_218657_a(jType.toString(), (INBT)new CompoundNBT());
            for (String topKey : input.get((Object)jType).keySet()) {
                output.func_74775_l(jType.toString()).func_218657_a(topKey, (INBT)new CompoundNBT());
                for (String botKey : input.get((Object)jType).get(topKey).keySet()) {
                    Double value = input.get((Object)jType).get(topKey).get(botKey);
                    output.func_74775_l(jType.toString()).func_74775_l(topKey).func_74780_a(botKey, value.doubleValue());
                }
            }
        }
        return output;
    }

    public static void addData3(Map<JType, Map<String, Map<String, Double>>> input1, Map<JType, Map<String, Map<String, Double>>> input2) {
        for (Map.Entry<JType, Map<String, Map<String, Double>>> entry3 : input2.entrySet()) {
            if (!input1.containsKey((Object)entry3.getKey())) {
                input1.put(entry3.getKey(), new HashMap());
            }
            for (Map.Entry<String, Map<String, Double>> entry2 : entry3.getValue().entrySet()) {
                if (!input1.get((Object)entry3.getKey()).containsKey(entry2.getKey())) {
                    input1.get((Object)entry3.getKey()).put(entry2.getKey(), new HashMap());
                }
                for (Map.Entry<String, Double> entry1 : entry2.getValue().entrySet()) {
                    if (input1.get((Object)entry3.getKey()).get(entry2.getKey()).containsKey(entry1.getKey())) continue;
                    input1.get((Object)entry3.getKey()).get(entry2.getKey()).put(entry1.getKey(), entry1.getValue());
                }
            }
        }
    }

    public static Map<JType, Map<String, Map<String, Map<String, Double>>>> nbtToData4(CompoundNBT input) {
        HashMap<JType, Map<String, Map<String, Map<String, Double>>>> output = new HashMap<JType, Map<String, Map<String, Map<String, Double>>>>();
        for (String jTypeKey : input.func_150296_c()) {
            JType jType = JType.getJType(jTypeKey);
            output.put(jType, new HashMap());
            for (String topKey : input.func_74775_l(jTypeKey).func_150296_c()) {
                ((Map)output.get((Object)jType)).put(topKey, new HashMap());
                for (String midKey : input.func_74775_l(jTypeKey).func_74775_l(topKey).func_150296_c()) {
                    ((Map)((Map)output.get((Object)jType)).get(topKey)).put(midKey, new HashMap());
                    for (String botKey : input.func_74775_l(jTypeKey).func_74775_l(topKey).func_74775_l(midKey).func_150296_c()) {
                        ((Map)((Map)((Map)output.get((Object)jType)).get(topKey)).get(midKey)).put(botKey, input.func_74775_l(jTypeKey).func_74775_l(topKey).func_74775_l(midKey).func_74769_h(botKey));
                    }
                }
            }
        }
        return output;
    }

    public static CompoundNBT data4ToNbt(Map<JType, Map<String, Map<String, Map<String, Double>>>> input) {
        CompoundNBT output = new CompoundNBT();
        for (JType jType : input.keySet()) {
            output.func_218657_a(jType.toString(), (INBT)new CompoundNBT());
            for (String topKey : input.get((Object)jType).keySet()) {
                output.func_74775_l(jType.toString()).func_218657_a(topKey, (INBT)new CompoundNBT());
                for (String midKey : input.get((Object)jType).get(topKey).keySet()) {
                    output.func_74775_l(jType.toString()).func_74775_l(topKey).func_218657_a(midKey, (INBT)new CompoundNBT());
                    for (String botKey : input.get((Object)jType).get(topKey).get(midKey).keySet()) {
                        Double value = input.get((Object)jType).get(topKey).get(midKey).get(botKey);
                        output.func_74775_l(jType.toString()).func_74775_l(topKey).func_74775_l(midKey).func_74780_a(botKey, value.doubleValue());
                    }
                }
            }
        }
        return output;
    }

    public static void addData4(Map<JType, Map<String, Map<String, Map<String, Double>>>> input1, Map<JType, Map<String, Map<String, Map<String, Double>>>> input2) {
        for (Map.Entry<JType, Map<String, Map<String, Map<String, Double>>>> entry4 : input2.entrySet()) {
            if (!input1.containsKey((Object)entry4.getKey())) {
                input1.put(entry4.getKey(), new HashMap());
            }
            for (Map.Entry<String, Map<String, Map<String, Double>>> entry3 : entry4.getValue().entrySet()) {
                if (!input1.get((Object)entry4.getKey()).containsKey(entry3.getKey())) {
                    input1.get((Object)entry4.getKey()).put(entry3.getKey(), new HashMap());
                }
                for (Map.Entry<String, Map<String, Double>> entry2 : entry3.getValue().entrySet()) {
                    if (input1.get((Object)entry4.getKey()).get(entry3.getKey()).containsKey(entry2.getKey())) continue;
                    input1.get((Object)entry4.getKey()).get(entry3.getKey()).put(entry2.getKey(), entry2.getValue());
                }
            }
        }
    }

    public static float getOrDefaultFromNBT(CompoundNBT nbt, String key, float defaultValue) {
        return nbt.func_74764_b(key) ? nbt.func_74760_g(key) : defaultValue;
    }

    public static double getOrDefaultFromNBT(CompoundNBT nbt, String key, double defaultValue) {
        try {
            return nbt.func_74764_b(key) ? nbt.func_74769_h(key) : defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static long getOrDefaultFromNBT(CompoundNBT nbt, String key, long defaultValue) {
        return nbt.func_74764_b(key) ? nbt.func_74763_f(key) : defaultValue;
    }

    public static int getOrDefaultFromNBT(CompoundNBT nbt, String key, int defaultValue) {
        return nbt.func_74764_b(key) ? nbt.func_74762_e(key) : defaultValue;
    }

    public static String getOrDefaultFromNBT(CompoundNBT nbt, String key, String defaultValue) {
        return nbt.func_74764_b(key) ? nbt.func_74779_i(key) : defaultValue;
    }

    public static boolean getOrDefaultFromNBT(CompoundNBT nbt, String key, boolean defaultValue) {
        return nbt.func_74764_b(key) ? nbt.func_74767_n(key) : defaultValue;
    }

    public static byte getOrDefaultFromNBT(CompoundNBT nbt, String key, byte defaultValue) {
        return nbt.func_74764_b(key) ? nbt.func_74771_c(key) : defaultValue;
    }
}

