/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class Util {
    public static double mapCapped(double input, double inLow, double inHigh, double outLow, double outHigh) {
        if (input < inLow) {
            input = inLow;
        }
        if (input > inHigh) {
            input = inHigh;
        }
        return Util.map(input, inLow, inHigh, outLow, outHigh);
    }

    public static double map(double input, double inLow, double inHigh, double outLow, double outHigh) {
        if (inLow == inHigh) {
            return outHigh;
        }
        return (input - inLow) / (inHigh - inLow) * (outHigh - outLow) + outLow;
    }

    public static Vector3d getMidVec(Vector3d v1, Vector3d v2) {
        return new Vector3d((v1.field_72450_a + v2.field_72450_a) / 2.0, (v1.field_72448_b + v2.field_72448_b) / 2.0, (v1.field_72449_c + v2.field_72449_c) / 2.0);
    }

    public static double getDistance(BlockPos p1, BlockPos p2) {
        return Util.getDistance(new Vector3d((double)p1.func_177958_n(), (double)p1.func_177956_o(), (double)p1.func_177952_p()), new Vector3d((double)p2.func_177958_n(), (double)p2.func_177956_o(), (double)p2.func_177952_p()));
    }

    public static double getDistance(Vector3d p1, Vector3d p2) {
        return Math.sqrt(Math.pow(p2.field_72450_a - p1.field_72450_a, 2.0) + Math.pow(p2.field_72448_b - p1.field_72448_b, 2.0) + Math.pow(p2.field_72449_c - p1.field_72449_c, 2.0));
    }

    public static double getHorizontalDistance(Vector3d p1, Vector3d p2) {
        return Math.sqrt(Math.pow(p2.field_72450_a - p1.field_72450_a, 2.0) + Math.pow(p2.field_72449_c - p1.field_72449_c, 2.0));
    }

    public static <T> T orDefault(T input, T defaultTo) {
        return input == null ? defaultTo : input;
    }

    public static void binaryPrint(byte input) {
        StringBuilder msg = new StringBuilder();
        for (int i = 7; i >= 0; --i) {
            msg.append((1 << i & input) > 0 ? 1 : 0);
        }
        System.out.println(msg);
    }

    public static void binaryPrint(int input) {
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            for (int j = 7; j >= 0; --j) {
                msg.append((1 << i * 8 + j & input) > 0 ? 1 : 0);
            }
            msg.append(" ");
        }
        System.out.println(msg);
    }

    public static Vector3d blockPosToVector(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static int hueToRGB(float hue, float saturation, float brightness) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float chroma = brightness * saturation;
        float hue1 = hue / 60.0f;
        float x = chroma * (1.0f - Math.abs(hue1 % 2.0f - 1.0f));
        switch ((int)hue1) {
            case 0: {
                r = chroma;
                g = x;
                b = 0.0f;
                break;
            }
            case 1: {
                r = x;
                g = chroma;
                b = 0.0f;
                break;
            }
            case 2: {
                r = 0.0f;
                g = chroma;
                b = x;
                break;
            }
            case 3: {
                r = 0.0f;
                g = x;
                b = chroma;
                break;
            }
            case 4: {
                r = x;
                g = 0.0f;
                b = chroma;
                break;
            }
            case 5: {
                r = chroma;
                g = 0.0f;
                b = x;
            }
        }
        float m = brightness - chroma;
        int r1 = (int)((r + m) * 255.0f);
        int g1 = (int)((g + m) * 255.0f);
        int b1 = (int)((b + m) * 255.0f);
        return r1 << 16 | b1 << 8 | g1;
    }

    public static <T> boolean mapIsAnyAbove1(Map<T, Double> input) {
        for (Map.Entry<T, Double> entry : input.entrySet()) {
            if (!(entry.getValue() > 1.0)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean mapIsAnyAbove1String(Map<String, Map<T, Double>> input, String key) {
        if (input != null && input.containsKey(key)) {
            for (Map.Entry<T, Double> entry : input.get(key).entrySet()) {
                if (!(entry.getValue() > 1.0)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isProduction() {
        return FMLEnvironment.production;
    }
}

