/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.PredicateRegistry;
import harmonised.pmmo.api.TooltipSupplier;
import harmonised.pmmo.api.events.XpEvent;
import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.curios.Curios;
import harmonised.pmmo.events.PlayerConnectedHandler;
import harmonised.pmmo.gui.WorldRenderHandler;
import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageUpdateBoolean;
import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.MessageWorldText;
import harmonised.pmmo.network.MessageWorldXp;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.skills.CheeseTracker;
import harmonised.pmmo.skills.PMMOFireworkEntity;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class XP {
    public static final Logger LOGGER = LogManager.getLogger();
    private static Map<Material, String> materialHarvestTool = new HashMap<Material, String>();
    public static Set<UUID> isVeining = new HashSet<UUID>();
    public static Map<String, Style> textStyle = new HashMap<String, Style>();
    public static Map<UUID, String> playerNames = new HashMap<UUID, String>();
    public static Map<String, UUID> playerUUIDs = new HashMap<String, UUID>();
    public static Map<UUID, Map<String, Double>> offlineXp = new HashMap<UUID, Map<String, Double>>();
    private static Map<UUID, String> lastBiome = new HashMap<UUID, String>();

    public static Style getColorStyle(int color) {
        return Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)color));
    }

    public static void initValues() {
        WorldText.init();
        textStyle.put("red", Style.field_240709_b_.func_240721_b_(TextFormatting.RED));
        textStyle.put("green", Style.field_240709_b_.func_240721_b_(TextFormatting.GREEN));
        textStyle.put("dark_green", Style.field_240709_b_.func_240721_b_(TextFormatting.DARK_GREEN));
        textStyle.put("yellow", Style.field_240709_b_.func_240721_b_(TextFormatting.YELLOW));
        textStyle.put("grey", Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY));
        textStyle.put("cyan", Style.field_240709_b_.func_240721_b_(TextFormatting.AQUA));
        textStyle.put("blue", Style.field_240709_b_.func_240721_b_(TextFormatting.BLUE));
        textStyle.put("dark_blue", Style.field_240709_b_.func_240721_b_(TextFormatting.DARK_BLUE));
        textStyle.put("pink", Style.field_240709_b_.func_240721_b_(TextFormatting.LIGHT_PURPLE));
        textStyle.put("dark_purple", Style.field_240709_b_.func_240721_b_(TextFormatting.DARK_PURPLE));
        PlayerConnectedHandler.lapisPatreons.add(UUID.fromString("e4c7e475-c1ff-4f94-956c-ac5be02ce04a"));
        PlayerConnectedHandler.dandelionPatreons.add(UUID.fromString("8eb0578d-c113-49d3-abf6-a6d36f6d1116"));
        PlayerConnectedHandler.dandelionPatreons.add(UUID.fromString("554b53b8-d0fa-409e-ab87-2a34bf83e506"));
        PlayerConnectedHandler.dandelionPatreons.add(UUID.fromString("2ea5efa1-756b-4c9e-9605-7f53830d6cfa"));
        PlayerConnectedHandler.dandelionPatreons.add(UUID.fromString("21bb554a-f339-48ef-80f7-9a5083172892"));
        PlayerConnectedHandler.muteList.add(UUID.fromString("21bb554a-f339-48ef-80f7-9a5083172892"));
        PlayerConnectedHandler.ironPatreons.add(UUID.fromString("0bc51f06-9906-41ea-9fb4-7e9be169c980"));
        PlayerConnectedHandler.ironPatreons.add(UUID.fromString("5bfdb948-7b66-476a-aefe-d45e4778fb2d"));
        PlayerConnectedHandler.ironPatreons.add(UUID.fromString("edafb5eb-9ccb-4121-bef7-e7ffded64ee3"));
        materialHarvestTool.put(Material.field_151574_g, "pickaxe");
        materialHarvestTool.put(Material.field_151592_s, "pickaxe");
        materialHarvestTool.put(Material.field_151588_w, "pickaxe");
        materialHarvestTool.put(Material.field_151573_f, "pickaxe");
        materialHarvestTool.put(Material.field_151598_x, "pickaxe");
        materialHarvestTool.put(Material.field_76233_E, "pickaxe");
        materialHarvestTool.put(Material.field_151591_t, "pickaxe");
        materialHarvestTool.put(Material.field_151576_e, "pickaxe");
        materialHarvestTool.put(Material.field_215711_w, "pickaxe");
        materialHarvestTool.put(Material.field_175972_I, "pickaxe");
        materialHarvestTool.put(Material.field_151594_q, "pickaxe");
        materialHarvestTool.put(Material.field_151575_d, "axe");
        materialHarvestTool.put(Material.field_151584_j, "axe");
        materialHarvestTool.put(Material.field_151572_C, "axe");
        materialHarvestTool.put(Material.field_151571_B, "shovel");
        materialHarvestTool.put(Material.field_151578_c, "shovel");
        materialHarvestTool.put(Material.field_151595_p, "shovel");
        materialHarvestTool.put(Material.field_151597_y, "shovel");
        materialHarvestTool.put(Material.field_204868_h, "shovel");
        materialHarvestTool.put(Material.field_151596_z, "shovel");
        materialHarvestTool.put(Material.field_151585_k, "hoe");
        materialHarvestTool.put(Material.field_203243_f, "hoe");
        materialHarvestTool.put(Material.field_151570_A, "hoe");
        materialHarvestTool.put(Material.field_151589_v, "hoe");
        materialHarvestTool.put(Material.field_151582_l, "hoe");
        materialHarvestTool.put(Material.field_215713_z, "hoe");
        materialHarvestTool.put(Material.field_215712_y, "hoe");
        materialHarvestTool.put(Material.field_151577_b, "hoe");
        materialHarvestTool.put(Material.field_151580_n, "shears");
        materialHarvestTool.put(Material.field_151593_r, "shears");
        materialHarvestTool.put(Material.field_151590_u, "shears");
        materialHarvestTool.put(Material.field_151566_D, "shears");
        materialHarvestTool.put(Material.field_151569_G, "shears");
        materialHarvestTool.put(Material.field_151568_F, "shears");
        materialHarvestTool.put(Material.field_151583_m, "shears");
    }

    public static String getSkill(BlockState state) {
        String skill = XP.getSkillFromTool(XP.getHarvestTool(state));
        if (skill.equals(Skill.INVALID_SKILL.toString())) {
            return XP.getSkill(state.func_177230_c());
        }
        return skill;
    }

    public static String getSkill(Block block) {
        if (block.getTags().contains(XP.getResLoc("forge:ores"))) {
            return Skill.MINING.toString();
        }
        if (block.getTags().contains(XP.getResLoc("forge:logs"))) {
            return Skill.WOODCUTTING.toString();
        }
        if (block.getTags().contains(XP.getResLoc("forge:plants"))) {
            return Skill.FARMING.toString();
        }
        return Skill.INVALID_SKILL.toString();
    }

    public static String getSkillFromTool(String tool) {
        if (tool == null) {
            return Skill.INVALID_SKILL.toString();
        }
        switch (tool) {
            case "pickaxe": {
                return Skill.MINING.toString();
            }
            case "shovel": {
                return Skill.EXCAVATION.toString();
            }
            case "axe": {
                return Skill.WOODCUTTING.toString();
            }
            case "hoe": {
                return Skill.FARMING.toString();
            }
            case "shears": {
                return Skill.CRAFTING.toString();
            }
        }
        return Skill.INVALID_SKILL.toString();
    }

    public static Map<String, Double> getXp(TileEntity tile, JType jType) {
        ResourceLocation res = tile.func_195044_w().func_177230_c().getRegistryName();
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return TooltipSupplier.getTooltipData(res, jType, tile);
        }
        return XP.getXp(res, jType);
    }

    public static Map<String, Double> getXp(ItemStack stack, JType jType) {
        ResourceLocation res = stack.func_77973_b().getRegistryName();
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return TooltipSupplier.getTooltipData(res, jType, stack);
        }
        return XP.getXp(res, jType);
    }

    public static Map<String, Double> getXp(Entity entity, JType jType) {
        ResourceLocation res = entity.func_200600_R().getRegistryName();
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return TooltipSupplier.getTooltipData(res, jType, entity);
        }
        return XP.getXp(res, jType);
    }

    public static Map<String, Double> getXpBypass(ResourceLocation registryName, JType jType) {
        return XP.getXp(registryName, jType);
    }

    public static Map<String, Double> getXpBypass(String registryName, JType jType) {
        return XP.getXp(registryName, jType);
    }

    private static Map<String, Double> getXp(ResourceLocation registryName, JType jType) {
        return XP.getXp(registryName.toString(), jType);
    }

    private static Map<String, Double> getXp(String registryName, JType jType) {
        return new HashMap<String, Double>(JsonConfig.data.get((Object)jType).getOrDefault(registryName, new HashMap()));
    }

    public static ResourceLocation getBiomeResLoc(World world, Biome biome) {
        return ((MutableRegistry)world.func_241828_r().func_230521_a_(Registry.field_239720_u_).get()).func_177774_c((Object)biome);
    }

    public static ResourceLocation getBiomeResLoc(World world, BlockPos pos) {
        return ((RegistryKey)world.func_242406_i(pos).get()).getRegistryName();
    }

    public static ResourceLocation getDimResLoc(World world) {
        return world.func_234923_W_().func_240901_a_();
    }

    public static String getHarvestTool(BlockState state) {
        String correctTool = materialHarvestTool.getOrDefault(state.func_185904_a(), "none");
        if (correctTool.equals("none")) {
            double pickDestroySpeed = new ItemStack((IItemProvider)Items.field_151046_w).func_150997_a(state);
            double axeDestroySpeed = new ItemStack((IItemProvider)Items.field_151056_x).func_150997_a(state);
            double shovelDestroySpeed = new ItemStack((IItemProvider)Items.field_151047_v).func_150997_a(state);
            double swordDestroySpeed = new ItemStack((IItemProvider)Items.field_151048_u).func_150997_a(state);
            double highestDestroySpeed = pickDestroySpeed;
            correctTool = "pickaxe";
            if (highestDestroySpeed < axeDestroySpeed) {
                highestDestroySpeed = axeDestroySpeed;
                correctTool = "axe";
            }
            if (highestDestroySpeed < shovelDestroySpeed) {
                highestDestroySpeed = shovelDestroySpeed;
                correctTool = "shovel";
            }
            if (highestDestroySpeed < swordDestroySpeed) {
                correctTool = "shears";
            }
        }
        return correctTool;
    }

    public static String checkMaterial(Material material) {
        if (material.equals(Material.field_151579_a)) {
            return "AIR";
        }
        if (material.equals(Material.field_189963_J)) {
            return "STRUCTURE_VOID";
        }
        if (material.equals(Material.field_151567_E)) {
            return "PORTAL";
        }
        if (material.equals(Material.field_151593_r)) {
            return "CARPET";
        }
        if (material.equals(Material.field_151585_k)) {
            return "PLANTS";
        }
        if (material.equals(Material.field_203243_f)) {
            return "OCEAN_PLANT";
        }
        if (material.equals(Material.field_151582_l)) {
            return "TALL_PLANTS";
        }
        if (material.equals(Material.field_204868_h)) {
            return "SEA_GRASS";
        }
        if (material.equals(Material.field_151586_h)) {
            return "WATER";
        }
        if (material.equals(Material.field_203244_i)) {
            return "BUBBLE_COLUMN";
        }
        if (material.equals(Material.field_151587_i)) {
            return "LAVA";
        }
        if (material.equals(Material.field_151597_y)) {
            return "SNOW";
        }
        if (material.equals(Material.field_151581_o)) {
            return "FIRE";
        }
        if (material.equals(Material.field_151594_q)) {
            return "MISCELLANEOUS";
        }
        if (material.equals(Material.field_151569_G)) {
            return "WEB";
        }
        if (material.equals(Material.field_151591_t)) {
            return "REDSTONE_LIGHT";
        }
        if (material.equals(Material.field_151571_B)) {
            return "CLAY";
        }
        if (material.equals(Material.field_151578_c)) {
            return "EARTH";
        }
        if (material.equals(Material.field_151577_b)) {
            return "ORGANIC";
        }
        if (material.equals(Material.field_151598_x)) {
            return "PACKED_ICE";
        }
        if (material.equals(Material.field_151595_p)) {
            return "SAND";
        }
        if (material.equals(Material.field_151583_m)) {
            return "SPONGE";
        }
        if (material.equals(Material.field_215711_w)) {
            return "SHULKER";
        }
        if (material.equals(Material.field_151575_d)) {
            return "WOOD";
        }
        if (material.equals(Material.field_215712_y)) {
            return "BAMBOO_SAPLING";
        }
        if (material.equals(Material.field_215713_z)) {
            return "BAMBOO";
        }
        if (material.equals(Material.field_151580_n)) {
            return "WOOL";
        }
        if (material.equals(Material.field_151590_u)) {
            return "TNT";
        }
        if (material.equals(Material.field_151584_j)) {
            return "LEAVES";
        }
        if (material.equals(Material.field_151592_s)) {
            return "GLASS";
        }
        if (material.equals(Material.field_151588_w)) {
            return "ICE";
        }
        if (material.equals(Material.field_151570_A)) {
            return "CACTUS";
        }
        if (material.equals(Material.field_151576_e)) {
            return "ROCK";
        }
        if (material.equals(Material.field_151573_f)) {
            return "IRON";
        }
        if (material.equals(Material.field_151596_z)) {
            return "SNOW_BLOCK";
        }
        if (material.equals(Material.field_151574_g)) {
            return "ANVIL";
        }
        if (material.equals(Material.field_175972_I)) {
            return "BARRIER";
        }
        if (material.equals(Material.field_76233_E)) {
            return "PISTON";
        }
        if (material.equals(Material.field_151589_v)) {
            return "CORAL";
        }
        if (material.equals(Material.field_151572_C)) {
            return "GOURD";
        }
        if (material.equals(Material.field_151566_D)) {
            return "DRAGON_EGG";
        }
        if (material.equals(Material.field_151568_F)) {
            return "CAKE";
        }
        return "UNKNOWN";
    }

    public static void sendMessage(String msg, boolean bar, PlayerEntity player) {
        player.func_146105_b((ITextComponent)new StringTextComponent(msg), bar);
    }

    public static void sendMessage(String msg, boolean bar, PlayerEntity player, TextFormatting format) {
        player.func_146105_b((ITextComponent)new StringTextComponent(msg).func_230530_a_(Style.field_240709_b_.func_240721_b_(format)), bar);
    }

    public static <T> Map<T, Double> addMapsAnyDouble(Map<T, Double> mapOne, Map<T, Double> mapTwo) {
        for (T key : mapTwo.keySet()) {
            if (mapOne.containsKey(key)) {
                mapOne.replace(key, mapOne.get(key) + mapTwo.get(key));
                continue;
            }
            mapOne.put(key, mapTwo.get(key));
        }
        return mapOne;
    }

    private static int doubleDoubleToInt(Double object) {
        return (int)Math.floor(object);
    }

    public static double getExtraChance(UUID uuid, String resLoc, JType jType, boolean offline) {
        return XP.getExtraChance(uuid, XP.getResLoc(resLoc), jType, offline);
    }

    public static double getExtraChance(UUID uuid, ResourceLocation resLoc, JType jType, boolean offline) {
        double extraChance;
        int startLevel;
        String skill;
        String regKey = resLoc.toString();
        double extraChancePerLevel = 0.0;
        int highestReq = 1;
        if (JsonConfig.data.get((Object)JType.REQ_BREAK).containsKey(resLoc.toString())) {
            highestReq = JsonConfig.data.get((Object)JType.REQ_BREAK).get(resLoc.toString()).entrySet().stream().map(a -> XP.doubleDoubleToInt((Double)a.getValue())).reduce(0, Math::max);
        }
        switch (jType) {
            case INFO_ORE: {
                skill = Skill.MINING.toString();
                break;
            }
            case INFO_LOG: {
                skill = Skill.WOODCUTTING.toString();
                break;
            }
            case INFO_PLANT: {
                skill = Skill.FARMING.toString();
                break;
            }
            case INFO_SMELT: {
                skill = Skill.SMITHING.toString();
                break;
            }
            case INFO_COOK: {
                skill = Skill.COOKING.toString();
                break;
            }
            case INFO_BREW: {
                skill = Skill.ALCHEMY.toString();
                break;
            }
            default: {
                LOGGER.error("WRONG getExtraChance CHANCE TYPE! PLEASE REPORT!");
                return 0.0;
            }
        }
        int n = startLevel = offline ? XP.getOfflineLevel(skill, uuid) : Skill.getLevel(skill, uuid);
        if (JsonConfig.data.get((Object)jType).containsKey(regKey) && JsonConfig.data.get((Object)jType).get(regKey).containsKey("extraChance") && JsonConfig.data.get((Object)jType).get(regKey).get("extraChance") != null) {
            extraChancePerLevel = JsonConfig.data.get((Object)jType).get(regKey).get("extraChance");
        }
        if ((extraChance = (double)(startLevel - highestReq) * extraChancePerLevel) < 0.0) {
            extraChance = 0.0;
        }
        return extraChance;
    }

    public static boolean hasElement(ResourceLocation key, JType jType) {
        return XP.hasElement(key.toString(), jType);
    }

    public static boolean hasElement(String key, JType jType) {
        return JsonConfig.data.get((Object)jType).containsKey(key);
    }

    public static boolean rollChance(double extraChance) {
        return Math.random() < extraChance;
    }

    public static void dropItems(int dropsLeft, Item item, World world, BlockPos pos) {
        if (dropsLeft > 0) {
            while (dropsLeft > 64) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)item, 64));
                dropsLeft -= 64;
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)item, dropsLeft));
        }
    }

    public static void dropItemStack(ItemStack itemStack, World world, Vector3d pos) {
        XP.dropItemStack(itemStack, world, new BlockPos(pos));
    }

    public static void dropItemStack(ItemStack itemStack, World world, BlockPos pos) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
    }

    public static boolean isPlayerSurvival(PlayerEntity player) {
        return !player.func_184812_l_() && !player.func_175149_v();
    }

    public static Collection<PlayerEntity> getNearbyPlayers(Entity mob) {
        World world = mob.func_130014_f_();
        List allPlayers = world.func_217369_A();
        ArrayList<PlayerEntity> nearbyPlayers = new ArrayList<PlayerEntity>();
        Float closestDistance = null;
        for (PlayerEntity player : allPlayers) {
            float tempDistance = mob.func_70032_d((Entity)player);
            if (closestDistance != null && !(tempDistance < closestDistance.floatValue())) continue;
            closestDistance = Float.valueOf(tempDistance);
        }
        if (closestDistance != null) {
            float searchRange = closestDistance.floatValue() + 30.0f;
            for (PlayerEntity player : allPlayers) {
                if (!(mob.func_70032_d((Entity)player) < searchRange)) continue;
                nearbyPlayers.add(player);
            }
        }
        return nearbyPlayers;
    }

    public static float getPowerLevel(UUID uuid) {
        int enduranceLevel = Skill.getLevel(Skill.ENDURANCE.toString(), uuid);
        int combatLevel = Skill.getLevel(Skill.COMBAT.toString(), uuid);
        int archeryLevel = Skill.getLevel(Skill.ARCHERY.toString(), uuid);
        int magicLevel = Skill.getLevel(Skill.MAGIC.toString(), uuid);
        int gunslingLevel = Skill.getLevel(Skill.GUNSLINGING.toString(), uuid);
        int maxOffensive = combatLevel;
        if (maxOffensive < archeryLevel) {
            maxOffensive = archeryLevel;
        }
        if (maxOffensive < magicLevel) {
            maxOffensive = magicLevel;
        }
        if (maxOffensive < gunslingLevel) {
            maxOffensive = gunslingLevel;
        }
        return ((float)enduranceLevel + (float)maxOffensive * 1.5f) / 50.0f;
    }

    public static ServerPlayerEntity getPlayerByUUID(UUID uuid) {
        return XP.getPlayerByUUID(uuid, PmmoSavedData.getServer());
    }

    public static ServerPlayerEntity getPlayerByUUID(UUID uuid, MinecraftServer server) {
        ServerPlayerEntity matchedPlayer = null;
        for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
            if (!player.func_110124_au().equals(uuid)) continue;
            matchedPlayer = player;
            break;
        }
        return matchedPlayer;
    }

    public static double getDistance(Vector3d a, Vector3d b) {
        return Math.sqrt(Math.pow(a.func_82615_a() - b.func_82615_a(), 2.0) + Math.pow(a.func_82617_b() - b.func_82617_b(), 2.0) + Math.pow(a.func_82616_c() - b.func_82616_c(), 2.0));
    }

    public static <T extends Entity> Set<T> getEntitiesInRange(Vector3d origin, Set<T> entities, double range) {
        HashSet<Entity> withinRange = new HashSet<Entity>();
        for (Entity entity : entities) {
            Vector3d pos = entity.func_213303_ch();
            double distance = XP.getDistance(origin, pos);
            if (!(distance <= range)) continue;
            withinRange.add(entity);
        }
        return withinRange;
    }

    public static void syncPlayerDataAndConfig(PlayerEntity player) {
        XP.syncPlayerData3(player);
        XP.syncPlayerData4(player);
        XP.syncPlayerXpBoost(player);
        XP.syncPlayersSkills(player);
        NetworkHandler.sendToPlayer(new MessageUpdateBoolean(true, 1), (ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.mapStringToNbt(Config.localConfig), 2), (ServerPlayerEntity)player);
    }

    public static void syncPlayersSkills(PlayerEntity player) {
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.xpMapsToNbt(PmmoSavedData.get().getAllXpMaps()), 3), (ServerPlayerEntity)player);
    }

    public static void syncPlayerXpBoost(PlayerEntity player) {
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.mapStringMapStringToNbt(APIUtils.getXpBoostsMap(player)), 6), (ServerPlayerEntity)player);
    }

    public static void syncPlayerData3(PlayerEntity player) {
        CompoundNBT fullData = NBTHelper.data3ToNbt(JsonConfig.localData);
        CompoundNBT dataChunk = new CompoundNBT();
        dataChunk.func_74757_a("wipe", true);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 4), (ServerPlayerEntity)player);
        dataChunk = new CompoundNBT();
        int i = 0;
        for (String key3 : fullData.func_150296_c()) {
            if (!dataChunk.func_74764_b(key3)) {
                dataChunk.func_218657_a(key3, (INBT)new CompoundNBT());
            }
            for (String key2 : fullData.func_74775_l(key3).func_150296_c()) {
                if (i >= 1000) {
                    i = 0;
                    NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 4), (ServerPlayerEntity)player);
                    dataChunk = new CompoundNBT();
                    dataChunk.func_218657_a(key3, (INBT)new CompoundNBT());
                }
                dataChunk.func_74775_l(key3).func_218657_a(key2, (INBT)fullData.func_74775_l(key3).func_74775_l(key2));
                ++i;
            }
        }
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 4), (ServerPlayerEntity)player);
    }

    public static void syncPlayerData4(PlayerEntity player) {
        CompoundNBT fullData = NBTHelper.data4ToNbt(JsonConfig.localData2);
        CompoundNBT dataChunk = new CompoundNBT();
        dataChunk.func_74757_a("wipe", true);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 5), (ServerPlayerEntity)player);
        dataChunk = new CompoundNBT();
        int i = 0;
        for (String key4 : fullData.func_150296_c()) {
            if (!dataChunk.func_74764_b(key4)) {
                dataChunk.func_218657_a(key4, (INBT)new CompoundNBT());
            }
            for (String key3 : fullData.func_74775_l(key4).func_150296_c()) {
                if (!dataChunk.func_74775_l(key4).func_74764_b(key3)) {
                    dataChunk.func_74775_l(key4).func_218657_a(key3, (INBT)new CompoundNBT());
                }
                for (String key2 : fullData.func_74775_l(key4).func_74775_l(key3).func_150296_c()) {
                    if (i >= 1000) {
                        i = 0;
                        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 5), (ServerPlayerEntity)player);
                        dataChunk = new CompoundNBT();
                        dataChunk.func_218657_a(key4, (INBT)new CompoundNBT());
                        dataChunk.func_74775_l(key4).func_218657_a(key3, (INBT)new CompoundNBT());
                    }
                    dataChunk.func_74775_l(key4).func_74775_l(key3).func_218657_a(key2, (INBT)fullData.func_74775_l(key4).func_74775_l(key3).func_74775_l(key2));
                    ++i;
                }
            }
        }
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 5), (ServerPlayerEntity)player);
    }

    public static void syncPlayer(PlayerEntity player) {
        CompoundNBT prefsTag = NBTHelper.mapStringToNbt(Config.getPreferencesMap(player));
        CompoundNBT abilitiesTag = NBTHelper.mapStringToNbt(Config.getAbilitiesMap(player));
        XP.syncPlayerDataAndConfig(player);
        XP.updateRecipes((ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageXp(0.0, "42069", 0.0, true), (ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(prefsTag, 0), (ServerPlayerEntity)player);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(abilitiesTag, 1), (ServerPlayerEntity)player);
        AttributeHandler.updateAll(player);
        for (Map.Entry<String, Double> entry : Config.getXpMap(player).entrySet()) {
            NetworkHandler.sendToPlayer(new MessageXp(entry.getValue(), entry.getKey(), 0.0, true), (ServerPlayerEntity)player);
        }
    }

    public static ResourceLocation getResLoc(String regKey) {
        try {
            return new ResourceLocation(regKey);
        }
        catch (Exception e) {
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getResLoc(String firstPart, String secondPart) {
        try {
            return new ResourceLocation(firstPart, secondPart);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Double> getJsonMap(ResourceLocation registryName, JType type) {
        return XP.getJsonMap(registryName.toString(), type);
    }

    public static Map<String, Double> getJsonMap(String registryName, JType type) {
        return ((Map)JsonConfig.data.getOrDefault((Object)type, new HashMap())).getOrDefault(registryName, new HashMap());
    }

    public static boolean checkReq(PlayerEntity player, String res, JType jType) {
        return XP.checkReq(player, XP.getResLoc(res), jType);
    }

    public static boolean checkReq(PlayerEntity player, TileEntity tile, JType jType) {
        if (tile == null) {
            return true;
        }
        if (tile.func_195044_w().func_196958_f()) {
            return true;
        }
        if (PredicateRegistry.predicateExists(tile.func_195044_w().func_177230_c().getRegistryName(), jType)) {
            return PredicateRegistry.checkPredicateReq(player, tile, jType);
        }
        return XP.checkReq(player, XP.getJsonMap(tile.func_195044_w().func_177230_c().getRegistryName().toString(), jType));
    }

    public static boolean checkReq(PlayerEntity player, ResourceLocation res, JType jType) {
        if (res == null) {
            return true;
        }
        if (res.equals((Object)Items.field_190931_a.getRegistryName()) || player.func_184812_l_()) {
            return true;
        }
        if (PredicateRegistry.predicateExists(res, jType)) {
            return PredicateRegistry.checkPredicateReq(player, res, jType);
        }
        return XP.checkReq(player, XP.getJsonMap(res.toString(), jType));
    }

    public static boolean checkReq(PlayerEntity player, Map<String, Double> reqMap) {
        boolean failedReq = false;
        try {
            if (JsonConfig.data.get((Object)JType.PLAYER_SPECIFIC).containsKey(player.func_110124_au().toString()) && JsonConfig.data.get((Object)JType.PLAYER_SPECIFIC).get(player.func_110124_au().toString()).containsKey("ignoreReq")) {
                return true;
            }
            if (reqMap != null) {
                for (Map.Entry<String, Double> entry : reqMap.entrySet()) {
                    double startLevel = Skill.getLevel(entry.getKey(), player);
                    if (!(startLevel < entry.getValue())) continue;
                    failedReq = true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        return !failedReq;
    }

    public static int getHighestReq(String regKey, JType jType) {
        int highestReq = 1;
        Map<String, Double> map = XP.getJsonMap(regKey, jType);
        if (map != null) {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (!((double)highestReq < entry.getValue())) continue;
                highestReq = (int)entry.getValue().doubleValue();
            }
        }
        return highestReq;
    }

    public static Set<String> getElementsFromTag(String tag) {
        HashSet<String> results = new HashSet<String>();
        for (ITag.INamedTag namedTag : ItemTags.func_242177_b()) {
            if (!namedTag.func_230234_a_().toString().startsWith(tag)) continue;
            for (Item element : namedTag.func_230236_b_()) {
                try {
                    results.add(element.getRegistryName().toString());
                }
                catch (Exception exception) {}
            }
        }
        for (ITag.INamedTag namedTag : BlockTags.func_242174_b()) {
            if (!namedTag.func_230234_a_().toString().equals(tag)) continue;
            for (Item element : namedTag.func_230236_b_()) {
                try {
                    results.add(element.getRegistryName().toString());
                }
                catch (Exception exception) {}
            }
        }
        for (ITag.INamedTag namedTag : FluidTags.func_241280_c_()) {
            if (!namedTag.func_230234_a_().toString().equals(tag)) continue;
            for (Item element : namedTag.func_230236_b_()) {
                try {
                    results.add(element.getRegistryName().toString());
                }
                catch (Exception exception) {}
            }
        }
        for (ITag.INamedTag namedTag : EntityTypeTags.func_242175_b()) {
            if (!namedTag.func_230234_a_().toString().equals(tag)) continue;
            for (Item element : namedTag.func_230236_b_()) {
                try {
                    results.add(element.getRegistryName().toString());
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    public static Block getBlock(String regKey) {
        ResourceLocation resLoc = XP.getResLoc(regKey);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resLoc);
        return block == null ? Blocks.field_150350_a : block;
    }

    public static Item getItem(String regKey) {
        ResourceLocation resLoc = XP.getResLoc(regKey);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resLoc);
        if (item != null && !item.equals(Items.field_190931_a)) {
            return item;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resLoc);
        if (block != null) {
            return block.func_199767_j();
        }
        return Items.field_190931_a;
    }

    public static Item getItem(ResourceLocation resLoc) {
        return XP.getItem(resLoc.toString());
    }

    public static boolean scanBlock(Block block, int radius, PlayerEntity player) {
        BlockPos playerPos = XP.vecToBlock(player.func_213303_ch());
        boolean matched = false;
        for (int x = -radius; x <= radius; ++x) {
            block1: for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block currBlock = player.field_70170_p.func_180495_p(new BlockPos(playerPos.func_177958_n() + x, playerPos.func_177956_o() + y, playerPos.func_177952_p() + z)).func_177230_c();
                    if (!currBlock.equals(block)) continue;
                    matched = true;
                    continue block1;
                }
            }
        }
        return matched;
    }

    public static double getMaxLevel() {
        double serverMaxLevel = Config.getConfig("maxLevel");
        return serverMaxLevel <= 1.0 ? (double)Config.forgeConfig.maxLevel.get().intValue() : serverMaxLevel;
    }

    public static double getXpBoostDurabilityMultiplier(ItemStack itemStack) {
        double scale = 1.0;
        if (itemStack.func_77984_f()) {
            double durabilityPercentage = 1.0 - (double)itemStack.func_77952_i() / (double)itemStack.func_77958_k();
            double scaleStart = Config.getConfig("scaleXpBoostByDurabilityStart") / 100.0;
            double scaleEnd = Math.max(scaleStart, Config.getConfig("scaleXpBoostByDurabilityEnd") / 100.0);
            scale = Util.mapCapped(durabilityPercentage, scaleStart, scaleEnd, 0.0, 1.0);
        }
        return scale;
    }

    public static Map<String, Double> getStackXpBoosts(ItemStack itemStack, boolean type) {
        Map itemXpMap;
        Item item = itemStack.func_77973_b();
        JType jType = type ? JType.XP_BONUS_HELD : JType.XP_BONUS_WORN;
        String regName = item.getRegistryName().toString();
        Map map = itemXpMap = PredicateRegistry.predicateExists(item.getRegistryName(), jType) ? TooltipSupplier.getTooltipData(item.getRegistryName(), jType, itemStack) : (Map)JsonConfig.data.get((Object)jType).getOrDefault(regName, new HashMap());
        if (Config.getConfig("scaleXpBoostByDurability") != 0.0) {
            XP.multiplyMapAnyDouble(itemXpMap, XP.getXpBoostDurabilityMultiplier(itemStack));
        }
        return itemXpMap;
    }

    public static double getStackXpBoost(PlayerEntity player, ItemStack itemStack, String skill, boolean type) {
        Map itemXpMap;
        if (itemStack == null || itemStack.func_190926_b()) {
            return 0.0;
        }
        Item item = itemStack.func_77973_b();
        JType jType = type ? JType.XP_BONUS_HELD : JType.XP_BONUS_WORN;
        double boost = 0.0;
        String regName = item.getRegistryName().toString();
        Map map = itemXpMap = PredicateRegistry.predicateExists(item.getRegistryName(), jType) ? TooltipSupplier.getTooltipData(item.getRegistryName(), jType, itemStack) : (Map)JsonConfig.data.get((Object)jType).getOrDefault(regName, new HashMap());
        if (itemXpMap != null && itemXpMap.containsKey(skill) && (type || XP.checkReq(player, item.getRegistryName(), JType.REQ_WEAR))) {
            boost = (Double)itemXpMap.get(skill);
            if (Config.getConfig("scaleXpBoostByDurability") != 0.0 && itemStack.func_77984_f()) {
                boost *= XP.getXpBoostDurabilityMultiplier(itemStack);
            }
        }
        return boost;
    }

    public static double getGlobalMultiplier(String skill) {
        return ((Map)JsonConfig.data.get((Object)JType.XP_MULTIPLIER_DIMENSION).getOrDefault("all_dimensions", new HashMap())).getOrDefault(skill, 1.0);
    }

    public static double getDimensionMultiplier(String skill, PlayerEntity player) {
        try {
            String dimensionKey = XP.getDimResLoc(player.field_70170_p).toString();
            return ((Map)JsonConfig.data.get((Object)JType.XP_MULTIPLIER_DIMENSION).getOrDefault(dimensionKey, new HashMap())).getOrDefault(skill, 1.0);
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    public static double getDifficultyMultiplier(PlayerEntity player, String skill) {
        double difficultyMultiplier = 1.0;
        if (skill.equals(Skill.COMBAT.toString()) || skill.equals(Skill.ARCHERY.toString()) || skill.equals(Skill.GUNSLINGING.toString()) || skill.equals(Skill.ENDURANCE.toString())) {
            switch (player.field_70170_p.func_175659_aa()) {
                case PEACEFUL: {
                    difficultyMultiplier = Config.forgeConfig.peacefulMultiplier.get();
                    break;
                }
                case EASY: {
                    difficultyMultiplier = Config.forgeConfig.easyMultiplier.get();
                    break;
                }
                case NORMAL: {
                    difficultyMultiplier = Config.forgeConfig.normalMultiplier.get();
                    break;
                }
                case HARD: {
                    difficultyMultiplier = Config.forgeConfig.hardMultiplier.get();
                    break;
                }
            }
        }
        return difficultyMultiplier;
    }

    public static double getItemBoost(PlayerEntity player, String skill) {
        if (player.func_184614_ca().func_77973_b().getRegistryName() == null) {
            return 0.0;
        }
        double itemBoost = 0.0;
        skill = skill.toLowerCase();
        PlayerInventory inv = player.field_71071_by;
        if (Curios.isLoaded()) {
            Collection curiosItems = Curios.getCurios(player).collect(Collectors.toSet());
            for (ICurioStacksHandler value : curiosItems) {
                for (int i = 0; i < value.getSlots(); ++i) {
                    itemBoost += XP.getStackXpBoost(player, value.getStacks().getStackInSlot(i), skill, false);
                }
            }
        }
        itemBoost += XP.getStackXpBoost(player, player.func_184614_ca(), skill, true);
        if (!inv.func_70301_a(39).func_190926_b()) {
            itemBoost += XP.getStackXpBoost(player, inv.func_70301_a(39), skill, false);
        }
        if (!inv.func_70301_a(38).func_190926_b()) {
            itemBoost += XP.getStackXpBoost(player, inv.func_70301_a(38), skill, false);
        }
        if (!inv.func_70301_a(37).func_190926_b()) {
            itemBoost += XP.getStackXpBoost(player, inv.func_70301_a(37), skill, false);
        }
        if (!inv.func_70301_a(36).func_190926_b()) {
            itemBoost += XP.getStackXpBoost(player, inv.func_70301_a(36), skill, false);
        }
        if (!inv.func_70301_a(40).func_190926_b()) {
            itemBoost += XP.getStackXpBoost(player, inv.func_70301_a(40), skill, false);
        }
        return itemBoost;
    }

    public static Map<String, Double> getDimensionBoosts(String dimKey) {
        return JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).getOrDefault(dimKey, new HashMap());
    }

    public static double getDimensionBoost(PlayerEntity player, String skill) {
        try {
            String dimensionKey = XP.getDimResLoc(player.field_70170_p).toString();
            return ((Map)JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).getOrDefault(dimensionKey, new HashMap())).getOrDefault(skill, 0.0);
        }
        catch (NullPointerException e) {
            return 0.0;
        }
    }

    public static double getGlobalBoost(String skill) {
        return ((Map)JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).getOrDefault("all_dimensions", new HashMap())).getOrDefault(skill, 0.0);
    }

    public static CompoundNBT writeUniqueId(UUID uuid) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74772_a("M", uuid.getMostSignificantBits());
        compoundnbt.func_74772_a("L", uuid.getLeastSignificantBits());
        return compoundnbt;
    }

    public static Map<String, Double> getBiomeBoosts(PlayerEntity player) {
        HashMap<String, Double> biomeBoosts = new HashMap<String, Double>();
        double biomePenaltyMultiplier = Config.getConfig("biomePenaltyMultiplier");
        Biome biome = player.field_70170_p.func_226691_t_(XP.vecToBlock(player.func_213303_ch()));
        ResourceLocation resLoc = biome.getRegistryName();
        if (resLoc == null) {
            return new HashMap<String, Double>();
        }
        String biomeKey = resLoc.toString();
        Map<String, Double> biomeMap = XP.getJsonMap(biomeKey, JType.XP_BONUS_BIOME);
        if (biomeMap != null) {
            boolean metReq = XP.checkReq(player, resLoc, JType.REQ_BIOME);
            for (Map.Entry<String, Double> entry : biomeMap.entrySet()) {
                biomeBoosts.put(entry.getKey(), metReq ? entry.getValue() : Double.valueOf(Math.min(entry.getValue(), -biomePenaltyMultiplier * 100.0)));
            }
        }
        return biomeBoosts;
    }

    public static double getMultiplier(PlayerEntity player, String skill) {
        double multiplier = Config.forgeConfig.globalMultiplier.get();
        double globalMultiplier = XP.getGlobalMultiplier(skill);
        double dimensionMultiplier = XP.getDimensionMultiplier(skill, player);
        double difficultyMultiplier = XP.getDifficultyMultiplier(player, skill);
        double globalBoost = XP.getGlobalBoost(skill);
        double itemBoost = XP.getItemBoost(player, skill);
        double biomeBoost = XP.getBiomeBoosts(player).getOrDefault(skill, 0.0);
        double dimensionBoost = XP.getDimensionBoost(player, skill);
        double playerBoost = PmmoSavedData.get().getPlayerXpBoost(player.func_110124_au(), skill);
        double additiveMultiplier = 1.0 + (itemBoost + biomeBoost + dimensionBoost + globalBoost + playerBoost) / 100.0;
        multiplier *= globalMultiplier;
        multiplier *= dimensionMultiplier;
        multiplier *= difficultyMultiplier;
        multiplier *= additiveMultiplier;
        return Math.max(0.0, multiplier *= CheeseTracker.getLazyMultiplier(player.func_110124_au(), skill));
    }

    public static double getHorizontalDistance(Vector3d p1, Vector3d p2) {
        return Math.sqrt(Math.pow(p1.func_82615_a() - p2.func_82615_a(), 2.0) + Math.pow(p1.func_82616_c() - p2.func_82616_c(), 2.0));
    }

    public static void awardXp(ServerPlayerEntity player, String skill, @Nullable String sourceName, double amount, boolean skip, boolean ignoreBonuses, boolean causedByParty) {
        int currLevel;
        Party party;
        if (player.field_70170_p.field_72995_K || Double.isNaN(amount) || player instanceof FakePlayer) {
            return;
        }
        PmmoSavedData pmmoSavedData = PmmoSavedData.get();
        UUID uuid = player.func_110124_au();
        XpEvent xpEvent = new XpEvent((PlayerEntity)player, skill, sourceName, amount, skip, ignoreBonuses, causedByParty);
        if (MinecraftForge.EVENT_BUS.post((Event)xpEvent)) {
            return;
        }
        skill = xpEvent.getSkill();
        sourceName = xpEvent.getSourceName();
        amount = xpEvent.getAmount();
        skip = xpEvent.isSkip();
        ignoreBonuses = xpEvent.isIgnoreBonuses();
        causedByParty = xpEvent.isCausedByParty();
        if (!ignoreBonuses && !causedByParty) {
            amount *= XP.getMultiplier((PlayerEntity)player, skill);
        }
        String playerName = player.func_145748_c_().getString();
        int startLevel = Skill.getLevel(skill, uuid);
        double startXp = Skill.getXp(skill, uuid);
        double maxXp = Config.getConfig("maxXp");
        pmmoSavedData.addXp(skill, uuid, amount);
        if (!causedByParty && (party = pmmoSavedData.getParty(uuid)) != null) {
            Set<ServerPlayerEntity> membersInRange = party.getOnlineMembersInRange(player);
            int membersInRangeSize = membersInRange.size();
            double partyMultiplier = party.getMultiplier(membersInRangeSize);
            party.submitXpGained(uuid, amount *= partyMultiplier);
            amount /= (double)membersInRangeSize + 1.0;
            for (ServerPlayerEntity partyMember : membersInRange) {
                XP.awardXp(partyMember, skill, sourceName, amount, true, ignoreBonuses, true);
            }
        }
        if (amount == 0.0 || startXp >= 2.0E9) {
            return;
        }
        if (startXp + amount >= 2.0E9) {
            XP.sendMessage(skill + " cap of 2b xp reached, you fucking psycho!", false, (PlayerEntity)player, TextFormatting.LIGHT_PURPLE);
            LOGGER.info(player.func_145748_c_().getString() + " " + skill + " 2b cap reached");
            amount = 2.0E9 - startXp;
        }
        if (startLevel != (currLevel = Skill.getLevel(skill, uuid))) {
            AttributeHandler.updateAll((PlayerEntity)player);
            XP.updateRecipes(player);
            if (JsonConfig.data.get((Object)JType.LEVEL_UP_COMMAND).get(skill.toLowerCase()) != null) {
                Map<String, Double> commandMap = JsonConfig.data.get((Object)JType.LEVEL_UP_COMMAND).get(skill.toLowerCase());
                for (Map.Entry<String, Double> entry : commandMap.entrySet()) {
                    int commandLevel = (int)Math.floor(entry.getValue());
                    if (startLevel >= commandLevel || currLevel < commandLevel) continue;
                    String command = entry.getKey().replace(">player<", playerName).replace(">level<", "" + commandLevel);
                    try {
                        player.func_184102_h().func_195571_aL().func_197054_a().execute(command, (Object)player.func_184102_h().func_195573_aM());
                        LOGGER.info("Executing command \"" + command + "\"\nTrigger: " + playerName + " level up from " + startLevel + " to " + currLevel + " in " + skill + ", trigger level " + commandLevel);
                    }
                    catch (CommandSyntaxException e) {
                        LOGGER.error("Invalid level up command \"" + command + "\"", (Throwable)e);
                    }
                }
            }
        }
        NetworkHandler.sendToPlayer(new MessageXp(startXp, skill, amount, skip), player);
        if (!skip && Config.forgeConfig.logXpGainedInDebugLog.get().booleanValue()) {
            LOGGER.debug(playerName + " +" + amount + "xp in: " + skill + " for: " + sourceName + " total xp: " + Skill.getXp(skill, uuid));
        }
        if (startXp + amount >= maxXp && startXp < maxXp) {
            XP.sendMessage(skill + " max startLevel reached, you psycho!", false, (PlayerEntity)player, TextFormatting.LIGHT_PURPLE);
            LOGGER.info(playerName + " " + skill + " max startLevel reached");
        }
    }

    @Deprecated
    public static void awardXpTrigger(UUID uuid, String triggerKey, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        if (JsonConfig.data.get((Object)JType.XP_VALUE_TRIGGER).containsKey(triggerKey)) {
            XP.awardXpMap(uuid, JsonConfig.data.get((Object)JType.XP_VALUE_TRIGGER).get(triggerKey), sourceName, skip, ignoreBonuses);
        } else {
            LOGGER.error("TRIGGER XP AWARD \"" + triggerKey + "\" DOES NOT HAVE ANY VALUES, CANNOT AWARD");
        }
    }

    public static void awardXpMap(UUID uuid, Map<String, Double> map, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            Skill.addXp(entry.getKey(), uuid, (double)entry.getValue(), sourceName, skip, ignoreBonuses);
        }
    }

    public static void updateRecipes(ServerPlayerEntity player) {
        if (Config.forgeConfig.craftReqEnabled.get().booleanValue()) {
            Collection allRecipes = player.func_184102_h().func_199529_aN().func_199510_b();
            HashSet<IRecipe> removeRecipes = new HashSet<IRecipe>();
            HashSet<IRecipe> newRecipes = new HashSet<IRecipe>();
            for (IRecipe recipe : allRecipes) {
                if (XP.checkReq((PlayerEntity)player, recipe.func_77571_b().func_77973_b().getRegistryName(), JType.REQ_CRAFT)) {
                    newRecipes.add(recipe);
                    continue;
                }
                removeRecipes.add(recipe);
            }
            player.func_192037_E().func_197925_b(removeRecipes, player);
            player.func_192037_E().func_197926_a(newRecipes, player);
        }
    }

    public static void scanUnlocks(int level, String skill) {
    }

    public static int getSkillReqGap(PlayerEntity player, ResourceLocation res, JType jType) {
        Map<String, Double> reqs = XP.getJsonMap(res.toString(), jType);
        if (reqs == null) {
            return 0;
        }
        return XP.getSkillReqGap(player, reqs);
    }

    public static int getSkillReqGap(PlayerEntity player, Map<String, Double> reqs) {
        int gap = 0;
        if (!XP.checkReq(player, reqs) && reqs != null) {
            gap = (int)Math.floor(reqs.entrySet().stream().map(entry -> (int)Math.floor((Double)entry.getValue()) - Skill.getLevel((String)entry.getKey(), player)).reduce(0, Math::max).intValue());
        }
        return gap;
    }

    public static BlockPos vecToBlock(Vector3d pos) {
        return new BlockPos(pos);
    }

    public static Vector3d blockToVec(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static Vector3d blockToMiddleVec(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static void spawnRocket(World world, BlockPos pos, String skill, @Nullable WorldText explosionText) {
        XP.spawnRocket(world, new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), skill, explosionText);
    }

    public static void spawnRocket(World world, Vector3d pos, String skill, @Nullable WorldText explosionText) {
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT fw = new CompoundNBT();
        ListNBT explosion = new ListNBT();
        CompoundNBT l = new CompoundNBT();
        int[] colors = new int[]{Skill.getSkillColor(skill)};
        l.func_74768_a("Flicker", 1);
        l.func_74768_a("Trail", 0);
        l.func_74768_a("Type", 1);
        l.func_218657_a("Colors", (INBT)new IntArrayNBT(colors));
        explosion.add((Object)l);
        fw.func_218657_a("Explosions", (INBT)explosion);
        fw.func_74768_a("Flight", 0);
        nbt.func_218657_a("Fireworks", (INBT)fw);
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196152_dE);
        itemStack.func_77982_d(nbt);
        PMMOFireworkEntity fireworkRocketEntity = new PMMOFireworkEntity(world, pos.func_82615_a() + 0.5, pos.func_82617_b() + 0.5, pos.func_82616_c() + 0.5, itemStack);
        if (explosionText != null) {
            fireworkRocketEntity.setExplosionText(explosionText);
        }
        world.func_217376_c((Entity)fireworkRocketEntity);
    }

    public static <T> Map<T, Double> ceilMapAnyDouble(Map<T, Double> input) {
        for (Map.Entry<T, Double> entry : input.entrySet()) {
            input.replace(entry.getKey(), Math.ceil(entry.getValue()));
        }
        return input;
    }

    public static <T> Map<T, Double> multiplyMapAnyDouble(Map<T, Double> input, double multiplier) {
        for (Map.Entry<T, Double> entry : input.entrySet()) {
            input.put(entry.getKey(), entry.getValue() * multiplier);
        }
        return input;
    }

    public static <T> Map<T, Double> mergeMapHighestValue(Map<T, Double> map1, Map<T, Double> map2) {
        for (Map.Entry<T, Double> entry : map2.entrySet()) {
            if (!map1.containsKey(entry.getKey())) {
                map1.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(map1.get(entry.getKey()) < entry.getValue())) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
        return map1;
    }

    public static Map<String, Double> getEnchantUseReq(ResourceLocation resLoc, int enchantLevel) {
        HashMap<String, Double> reqs = new HashMap<String, Double>();
        int highestSpecifiedLevel = 0;
        if (((Map)JsonConfig.data2.getOrDefault((Object)JType.REQ_USE_ENCHANTMENT, new HashMap())).containsKey(resLoc.toString())) {
            int level;
            Map<String, Map<String, Double>> levelMaps = JsonConfig.data2.get((Object)JType.REQ_USE_ENCHANTMENT).get(resLoc.toString());
            ArrayList<Integer> levels = new ArrayList<Integer>();
            for (String levelKey : levelMaps.keySet()) {
                levels.add(Integer.parseInt(levelKey));
            }
            levels.sort(Comparator.comparingInt(a -> a));
            Iterator<String> iterator = levels.iterator();
            while (iterator.hasNext() && (level = ((Integer)((Object)iterator.next())).intValue()) <= enchantLevel) {
                highestSpecifiedLevel = level;
                Map<String, Double> skillMap = levelMaps.get(String.valueOf(level));
                for (Map.Entry<String, Double> skillElement : skillMap.entrySet()) {
                    String skill = skillElement.getKey();
                    if (!reqs.containsKey(skill)) {
                        reqs.put(skill, skillElement.getValue());
                        continue;
                    }
                    if (!((Double)reqs.get(skill) < skillElement.getValue())) continue;
                    reqs.put(skill, skillElement.getValue());
                }
            }
        }
        if (Config.forgeConfig.enchantUseReqAutoScaleEnabled.get().booleanValue() && enchantLevel > highestSpecifiedLevel) {
            XP.multiplyMapAnyDouble(reqs, (double)enchantLevel / (double)highestSpecifiedLevel);
        }
        return reqs;
    }

    public static Map<String, Double> getEnchantsUseReq(ItemStack itemStack) {
        HashMap<String, Double> reqs = new HashMap<String, Double>();
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (Map.Entry entry : enchantments.entrySet()) {
            XP.mergeMapHighestValue(reqs, XP.getEnchantUseReq(((Enchantment)entry.getKey()).getRegistryName(), (Integer)entry.getValue()));
        }
        return reqs;
    }

    public static void applyWornPenalty(PlayerEntity player, ItemStack itemStack) {
        String wearReqSkill;
        if (Config.getConfig("wearReqEnabled") == 0.0) {
            return;
        }
        ResourceLocation resLoc = itemStack.func_77973_b().getRegistryName();
        Map<String, Double> wearReq = XP.getJsonMap(resLoc, JType.REQ_WEAR);
        String string = wearReqSkill = Config.forgeConfig.autoGenerateWearReqAsCombat.get() != false ? Skill.COMBAT.toString() : Skill.ENDURANCE.toString();
        if (!wearReq.containsKey(wearReqSkill) && Config.getConfig("autoGenerateValuesEnabled") != 0.0 && Config.getConfig("autoGenerateWearReqDynamicallyEnabled") != 0.0) {
            wearReq.put(wearReqSkill, AutoValues.getWearReqFromStack(itemStack));
        }
        if (!XP.checkReq(player, wearReq)) {
            int gap = XP.getSkillReqGap(player, resLoc, JType.REQ_WEAR);
            if (gap > 9) {
                gap = 9;
            }
            player.func_195064_c(new EffectInstance(Effects.field_76419_f, 75, gap, false, true));
            player.func_195064_c(new EffectInstance(Effects.field_76437_t, 75, gap, false, true));
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 75, gap, false, true));
            if (Config.forgeConfig.strictReqWear.get().booleanValue() || EnchantmentHelper.func_190938_b((ItemStack)itemStack)) {
                ItemStack droppedItemStack = itemStack.func_77946_l();
                player.func_146097_a(droppedItemStack, false, false);
                itemStack.func_190920_e(0);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.gotTooHotDroppedItem", new Object[]{new TranslationTextComponent(droppedItemStack.func_77973_b().func_77658_a())}).func_230530_a_(textStyle.get("red")), true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.gotTooHotDroppedItem", new Object[]{new TranslationTextComponent(droppedItemStack.func_77973_b().func_77658_a())}).func_230530_a_(textStyle.get("red")), false);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToWear", new Object[]{new TranslationTextComponent(itemStack.func_77973_b().func_77658_a())}).func_230530_a_(textStyle.get("red")), true);
            }
        }
        XP.applyEnchantmentUsePenalty(player, itemStack);
    }

    public static void applyEnchantmentUsePenalty(PlayerEntity player, ItemStack itemStack) {
        if (Config.getConfig("enchantUseReqEnabled") == 0.0) {
            return;
        }
        ResourceLocation resLoc = itemStack.func_77973_b().getRegistryName();
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (Map.Entry entry : enchantments.entrySet()) {
            ResourceLocation enchantResLoc = ((Enchantment)entry.getKey()).getRegistryName();
            if (XP.checkReq(player, XP.getEnchantUseReq(enchantResLoc, (Integer)entry.getValue()))) continue;
            int gap = XP.getSkillReqGap(player, resLoc, JType.REQ_USE_ENCHANTMENT);
            if (gap > 9) {
                gap = 9;
            }
            player.func_195064_c(new EffectInstance(Effects.field_76419_f, 75, gap, false, true));
            player.func_195064_c(new EffectInstance(Effects.field_76437_t, 75, gap, false, true));
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 75, gap, false, true));
            if (Config.forgeConfig.strictReqUseEnchantment.get().booleanValue() || EnchantmentHelper.func_190938_b((ItemStack)itemStack)) {
                ItemStack droppedItemStack = itemStack.func_77946_l();
                player.func_146097_a(droppedItemStack, false, false);
                itemStack.func_190920_e(0);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.gotTooHotDroppedItem", new Object[]{new TranslationTextComponent(droppedItemStack.func_77973_b().func_77658_a())}).func_230530_a_(textStyle.get("red")), true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.gotTooHotDroppedItem", new Object[]{new TranslationTextComponent(droppedItemStack.func_77973_b().func_77658_a())}).func_230530_a_(textStyle.get("red")), false);
                continue;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUseEnchantment", new Object[]{new TranslationTextComponent(((Enchantment)entry.getKey()).func_77320_a()), new TranslationTextComponent(itemStack.func_77973_b().func_77658_a())}).func_230530_a_(textStyle.get("red")), true);
        }
    }

    public static void checkBiomeLevelReq(PlayerEntity player) {
        Map<String, Double> negativeEffect;
        Biome biome = player.field_70170_p.func_226691_t_(XP.vecToBlock(player.func_213303_ch()));
        ResourceLocation resLoc = XP.getBiomeResLoc(player.field_70170_p, biome);
        if (resLoc == null) {
            return;
        }
        String biomeKey = resLoc.toString();
        UUID playerUUID = player.func_110124_au();
        if (!JsonConfig.data.containsKey((Object)JType.REQ_BIOME)) {
            return;
        }
        Map<String, Double> biomeReq = JsonConfig.data.get((Object)JType.REQ_BIOME).get(biomeKey);
        Map<String, Map<String, Double>> negativeEffects = JsonConfig.data.get((Object)JType.BIOME_EFFECT_NEGATIVE);
        Map<String, Map<String, Double>> positiveEffects = JsonConfig.data.get((Object)JType.BIOME_EFFECT_POSITIVE);
        if (!lastBiome.containsKey(playerUUID)) {
            lastBiome.put(playerUUID, "none");
        }
        if (XP.checkReq(player, resLoc, JType.REQ_BIOME)) {
            Map<String, Double> positiveEffect;
            if (positiveEffects != null && (positiveEffect = positiveEffects.get(biomeKey)) != null) {
                for (Map.Entry<String, Double> entry : positiveEffect.entrySet()) {
                    Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()));
                    if (effect == null) continue;
                    player.func_195064_c(new EffectInstance(effect, 75, (int)Math.floor(entry.getValue()), false, false));
                }
            }
        } else if (negativeEffects != null && (negativeEffect = negativeEffects.get(biomeKey)) != null) {
            for (Map.Entry<String, Double> entry : negativeEffect.entrySet()) {
                Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()));
                if (effect == null) continue;
                player.func_195064_c(new EffectInstance(effect, 75, (int)Math.floor(entry.getValue()), false, true));
            }
            if (player.field_70170_p.func_201670_d() && !lastBiome.get(playerUUID).equals(biomeKey)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToSurvive", new Object[]{new TranslationTextComponent(XP.getBiomeResLoc(player.field_70170_p, biome).toString())}).func_230530_a_(textStyle.get("red")), true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToSurvive", new Object[]{new TranslationTextComponent(XP.getBiomeResLoc(player.field_70170_p, biome).toString())}).func_230530_a_(textStyle.get("red")), false);
                for (Map.Entry<String, Double> entry : biomeReq.entrySet()) {
                    int startLevel = Skill.getLevel(entry.getKey(), player);
                    if ((double)startLevel < entry.getValue()) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + entry.getKey()).getString(), "" + (int)Math.floor(entry.getValue())}).func_230530_a_(textStyle.get("red")), false);
                        continue;
                    }
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{" " + new TranslationTextComponent("pmmo." + entry.getKey()).getString(), "" + (int)Math.floor(entry.getValue())}).func_230530_a_(textStyle.get("green")), false);
                }
            }
        }
        lastBiome.put(playerUUID, biomeKey);
    }

    public static <T> int getTotalLevelFromMap(Map<T, Double> input) {
        int sum = 0;
        for (double xp : input.values()) {
            sum += XP.levelAtXp(xp);
        }
        return sum;
    }

    public static <T> int getTotalXpFromMap(Map<T, Double> input) {
        int sum = 0;
        for (double xp : input.values()) {
            sum = (int)((double)sum + xp);
        }
        return sum;
    }

    public static Map<String, Double> getOfflineXpMap(UUID uuid) {
        if (!offlineXp.containsKey(uuid)) {
            offlineXp.put(uuid, new HashMap());
        }
        return offlineXp.get(uuid);
    }

    public static void setOfflineXpMaps(Map<UUID, Map<String, Double>> newOfflineXp) {
        offlineXp = new HashMap<UUID, Map<String, Double>>(newOfflineXp);
    }

    public static void removeOfflineXpUuid(UUID uuid) {
        offlineXp.remove(uuid);
    }

    public static int getOfflineLevel(String skill, UUID uuid) {
        return XP.levelAtXp(XP.getOfflineXp(skill, uuid));
    }

    public static double getOfflineXp(String skill, UUID uuid) {
        return ((Map)offlineXp.getOrDefault(uuid, new HashMap())).getOrDefault(skill, 0.0);
    }

    public static double logBase(double base, double goal) {
        return Math.log(goal) / Math.log(base);
    }

    public static int levelAtXp(float xp) {
        return XP.levelAtXp((double)xp);
    }

    public static int levelAtXp(double xp) {
        boolean useExponentialFormula = Config.getConfig("useExponentialFormula") != 0.0;
        double baseXp = Config.getConfig("baseXp");
        double exponentialBaseXp = Config.getConfig("exponentialBaseXp");
        double exponentialBase = Config.getConfig("exponentialBase");
        double exponentialRate = Config.getConfig("exponentialRate");
        int maxLevel = (int)Math.floor(XP.getMaxLevel());
        double xpIncreasePerLevel = Config.getConfig("xpIncreasePerLevel");
        int theXp = 0;
        int level = 0;
        while (!(xp < (double)theXp) && level < maxLevel) {
            theXp = useExponentialFormula ? (int)((double)theXp + exponentialBaseXp * Math.pow(exponentialBase, exponentialRate * (double)level)) : (int)((double)theXp + (baseXp + (double)level * xpIncreasePerLevel));
            ++level;
        }
        return level;
    }

    public static float levelAtXpDecimal(float xp) {
        return (float)XP.levelAtXpDecimal((double)xp);
    }

    public static double levelAtXpDecimal(double xp) {
        double goalXp;
        int maxLevel = (int)Math.floor(XP.getMaxLevel());
        if (XP.levelAtXp(xp) >= maxLevel) {
            return maxLevel;
        }
        int startLevel = XP.levelAtXp(xp);
        double startXp = XP.xpAtLevel(startLevel);
        if (startXp == (goalXp = XP.xpAtLevel(startLevel + 1))) {
            return maxLevel;
        }
        return (double)startLevel + (xp - startXp) / (goalXp - startXp);
    }

    public static double xpAtLevel(int givenLevel) {
        return XP.xpAtLevel((double)givenLevel);
    }

    public static double xpAtLevel(float givenLevel) {
        return XP.xpAtLevel((double)givenLevel);
    }

    public static double xpAtLevel(double givenLevel) {
        boolean useExponentialFormula = Config.getConfig("useExponentialFormula") != 0.0;
        double baseXp = Config.getConfig("baseXp");
        double exponentialBaseXp = Config.getConfig("exponentialBaseXp");
        double exponentialBase = Config.getConfig("exponentialBase");
        double exponentialRate = Config.getConfig("exponentialRate");
        int maxLevel = (int)Math.floor(XP.getMaxLevel());
        if (givenLevel > (double)maxLevel) {
            givenLevel = maxLevel;
        }
        double theXp = 0.0;
        double xpIncreasePerLevel = Config.getConfig("xpIncreasePerLevel");
        int startLevel = 1;
        while ((double)startLevel < givenLevel) {
            theXp = useExponentialFormula ? (theXp += exponentialBaseXp * Math.pow(exponentialBase, exponentialRate * (double)(startLevel - 1))) : (theXp += baseXp + (double)(startLevel - 1) * xpIncreasePerLevel);
            ++startLevel;
        }
        return theXp;
    }

    public static double xpAtLevelDecimal(double givenLevel) {
        double startXp = XP.xpAtLevel(Math.floor(givenLevel));
        double endXp = XP.xpAtLevel(Math.floor(givenLevel + 1.0));
        double pos = givenLevel - Math.floor(givenLevel);
        return startXp + (endXp - startXp) * pos;
    }

    public static boolean isHoldingDebugItemInOffhand(PlayerEntity player) {
        return XP.isItemDebugItem(player.func_184592_cb().func_77973_b());
    }

    public static boolean isItemDebugItem(Item item) {
        return Items.field_196158_dT.equals(item);
    }

    public static boolean isNightvisionUnlocked(PlayerEntity player) {
        return (double)Skill.getLevel(Skill.SWIMMING.toString(), player) >= Config.getConfig("nightvisionUnlockLevel");
    }

    public static void addWorldXpDrop(WorldXpDrop xpDrop, ServerPlayerEntity player) {
        xpDrop.startXp *= (float)XP.getMultiplier((PlayerEntity)player, xpDrop.getSkill());
        if (Config.getPreferencesMap((PlayerEntity)player).getOrDefault("worldXpDropsEnabled", 1.0) != 0.0) {
            NetworkHandler.sendToPlayer(new MessageWorldXp(xpDrop), player);
        }
        UUID uuid = player.func_110124_au();
        for (ServerPlayerEntity otherPlayer : PmmoSavedData.getServer().func_184103_al().func_181057_v()) {
            double distance = Util.getDistance(xpDrop.getPos(), otherPlayer.func_213303_ch());
            if (!(distance < 64.0) || uuid.equals(otherPlayer.func_110124_au()) || Config.getPreferencesMap((PlayerEntity)otherPlayer).getOrDefault("showOthersWorldXpDrops", 0.0) == 0.0) continue;
            NetworkHandler.sendToPlayer(new MessageWorldXp(xpDrop), otherPlayer);
        }
    }

    public static void addWorldXpDrop(WorldXpDrop xpDrop, UUID uuid) {
        ServerPlayerEntity player = PmmoSavedData.getServer().func_184103_al().func_177451_a(uuid);
        if (player != null) {
            XP.addWorldXpDrop(xpDrop, player);
        }
    }

    public static void addWorldXpDropOffline(WorldXpDrop xpDrop) {
        WorldRenderHandler.addWorldXpDropOffline(xpDrop);
    }

    public static void addWorldText(WorldText worldText, UUID uuid) {
        ServerPlayerEntity player = PmmoSavedData.getServer().func_184103_al().func_177451_a(uuid);
        if (player != null) {
            XP.addWorldText(worldText, player);
        }
    }

    public static void addWorldTextRadius(ResourceLocation dimResLoc, WorldText worldText, double radius) {
        worldText.updatePos();
        for (ServerPlayerEntity otherPlayer : PmmoSavedData.getServer().func_184103_al().func_181057_v()) {
            double distance;
            if (dimResLoc != XP.getDimResLoc(otherPlayer.func_130014_f_()) || !((distance = Util.getDistance(worldText.getPos(), otherPlayer.func_213303_ch())) < radius)) continue;
            NetworkHandler.sendToPlayer(new MessageWorldText(worldText), otherPlayer);
        }
    }

    public static void addWorldText(WorldText worldText, ServerPlayerEntity player) {
        worldText.updatePos();
        NetworkHandler.sendToPlayer(new MessageWorldText(worldText), player);
    }

    public static void addWorldTextOffline(WorldText worldText) {
        WorldRenderHandler.addWorldTextOffline(worldText);
    }

    public static void sendPlayerSkillList(PlayerEntity player, Map<String, Double> skills) {
        for (Map.Entry<String, Double> entry : skills.entrySet()) {
            int level = Skill.getLevel(entry.getKey(), player);
            if ((double)level < entry.getValue()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + entry.getKey()), "" + (int)Math.floor(entry.getValue())}).func_230530_a_(textStyle.get("red")), false);
                continue;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.levelDisplay", new Object[]{new TranslationTextComponent("pmmo." + entry.getKey()), "" + (int)Math.floor(entry.getValue())}).func_230530_a_(textStyle.get("green")), false);
        }
    }
}

