/*
 * Decompiled with CFR 0.152.
 */
package com.projectvibrantjourneys.client;

import com.projectvibrantjourneys.core.registry.PVJBlocks;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockColorsInit {
    @SubscribeEvent
    public static void onColorHandlerEvent(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        BlockColorsInit.registerFoliageColorBlock(blockColors, (Block)PVJBlocks.TWIGS.get());
        BlockColorsInit.registerFoliageColorBlock(blockColors, (Block)PVJBlocks.FALLEN_LEAVES.get());
        BlockColorsInit.registerGrassColorBlock(blockColors, (Block)PVJBlocks.SHORT_GRASS.get());
    }

    @SubscribeEvent
    public static void onColorHandlerEvent(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        BlockColors blockColors = event.getBlockColors();
        itemColors.m_92689_((itemstack, tintIndex) -> {
            BlockState state = Blocks.f_50050_.m_49966_();
            int color = blockColors.m_92577_(state, null, null, tintIndex);
            return color;
        }, new ItemLike[]{(ItemLike)PVJBlocks.FALLEN_LEAVES.get()});
        itemColors.m_92689_((itemstack, tintIndex) -> {
            BlockState state = Blocks.f_50050_.m_49966_();
            int color = blockColors.m_92577_(state, null, null, tintIndex);
            return color;
        }, new ItemLike[]{(ItemLike)PVJBlocks.SHORT_GRASS.get()});
    }

    private static void registerFoliageColorBlock(BlockColors bc, Block block) {
        bc.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{block});
    }

    private static void registerWaterColorBlock(BlockColors bc, Block block) {
        bc.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos) : -1, new Block[]{block});
    }

    private static void registerFoliageColorBlock(BlockColors bc, Block block, int color) {
        bc.m_92589_((state, world, pos, tintIndex) -> color, new Block[]{block});
    }

    private static void registerFoliageColorItem(ItemColors ic, BlockColors bc, Block block) {
        ic.m_92689_((itemstack, tintIndex) -> {
            BlockState state = Blocks.f_50050_.m_49966_();
            int color = bc.m_92577_(state, null, null, tintIndex);
            return color;
        }, new ItemLike[]{block});
    }

    private static void registerFoliageColorItem(ItemColors ic, BlockColors bc, Block block, int color) {
        ic.m_92689_((itemstack, tintIndex) -> color, new ItemLike[]{block});
    }

    private static void registerGrassColorBlock(BlockColors bc, Block block) {
        bc.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{block});
    }
}

