/*
 * Decompiled with CFR 0.152.
 */
package com.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import com.projectvibrantjourneys.common.blocks.BarkMushroomBlock;
import com.projectvibrantjourneys.common.blocks.FallenLeavesBlock;
import com.projectvibrantjourneys.common.blocks.GroundcoverBlock;
import com.projectvibrantjourneys.common.world.features.configs.FallenTreeConfiguration;
import com.projectvibrantjourneys.util.TreeFeatureUtils;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FallenTreeFeature
extends Feature<FallenTreeConfiguration> {
    public FallenTreeFeature(Codec<FallenTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FallenTreeConfiguration> context) {
        int i;
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        BlockState hollowLog = ((FallenTreeConfiguration)context.m_159778_()).hollowLog();
        BlockState baseLog = ((FallenTreeConfiguration)context.m_159778_()).baseLog();
        ResourceLocation biome = ((Biome)world.m_204166_(pos).m_203334_()).getRegistryName();
        int chance = TreeFeatureUtils.getChance(biome, new HashSet<TreeFeatureUtils.ChanceBiomeEntry>(((FallenTreeConfiguration)context.m_159778_()).data()));
        if (rand.nextFloat() > (float)chance / 100.0f) {
            return false;
        }
        BlockState below = world.m_8055_(pos.m_7495_());
        if (below.m_204336_(BlockTags.f_13047_) || below.m_60734_() == Blocks.f_50127_ || below.m_60819_().m_76170_()) {
            return false;
        }
        int length = rand.nextInt(3) + 4;
        Direction dir = Direction.Plane.HORIZONTAL.m_122560_(rand);
        Direction dirCounterClockwise = dir.m_122428_();
        Direction dirClockwise = dir.m_122427_();
        boolean branched = false;
        for (i = 0; i < length; ++i) {
            if (!this.canReplace(world, pos)) {
                return false;
            }
            pos = pos.m_141952_(dir.m_122436_());
        }
        pos = context.m_159777_();
        for (i = 0; i < length; ++i) {
            if (this.canReplace(world, pos)) {
                if (!below.m_60767_().m_76336_() && !below.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || i > length / 2) {
                    BarkMushroomBlock mushroom;
                    world.m_7731_(pos, (BlockState)hollowLog.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_()), 2);
                    if (world.m_46859_(pos.m_7494_()) && rand.nextFloat() < 0.4f) {
                        world.m_7731_(pos.m_7494_(), Blocks.f_152543_.m_49966_(), 2);
                    }
                    if (!branched && i <= length / 2 + 1 && rand.nextFloat() < 0.2f) {
                        BlockPos branchPos = rand.nextBoolean() ? pos.m_141952_(dirCounterClockwise.m_122436_()) : pos.m_141952_(dirClockwise.m_122436_());
                        world.m_7731_(branchPos, (BlockState)baseLog.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dirCounterClockwise.m_122434_()), 2);
                        if (world.m_46859_(branchPos.m_7494_()) && rand.nextFloat() < 0.4f) {
                            world.m_7731_(branchPos.m_7494_(), Blocks.f_152543_.m_49966_(), 2);
                        }
                        branched = true;
                    }
                    BlockPos original = pos;
                    if (this.canReplace(world, pos = pos.m_141952_(dirCounterClockwise.m_122436_()))) {
                        if (rand.nextFloat() < 0.4f && Block.m_49918_((VoxelShape)world.m_8055_(pos.m_7495_()).m_60812_((BlockGetter)world, pos.m_7495_()), (Direction)Direction.UP)) {
                            world.m_7731_(pos, Blocks.f_152543_.m_49966_(), 2);
                        } else if (rand.nextFloat() < 0.4f) {
                            mushroom = BarkMushroomBlock.getRandom(rand);
                            world.m_7731_(pos, (BlockState)mushroom.m_49966_().m_61124_((Property)BarkMushroomBlock.f_54117_, (Comparable)dirCounterClockwise), 2);
                        }
                    }
                    pos = original;
                    if (this.canReplace(world, pos = pos.m_141952_(dirClockwise.m_122436_()))) {
                        if (rand.nextFloat() < 0.4f && Block.m_49918_((VoxelShape)world.m_8055_(pos.m_7495_()).m_60812_((BlockGetter)world, pos.m_7495_()), (Direction)Direction.UP)) {
                            world.m_7731_(pos, Blocks.f_152543_.m_49966_(), 2);
                        } else if (rand.nextFloat() < 0.4f) {
                            mushroom = BarkMushroomBlock.getRandom(rand);
                            world.m_7731_(pos, (BlockState)mushroom.m_49966_().m_61124_((Property)BarkMushroomBlock.f_54117_, (Comparable)dirClockwise), 2);
                        }
                    }
                    pos = original;
                    pos = pos.m_141952_(dir.m_122436_());
                } else {
                    dir = dir.m_122424_();
                    pos = context.m_159777_().m_141952_(dir.m_122436_());
                }
            } else {
                return length - i < length;
            }
            below = world.m_8055_(pos.m_7495_());
        }
        return true;
    }

    public boolean canReplace(WorldGenLevel world, BlockPos pos) {
        return world.m_8055_(pos).m_60767_().m_76336_() || world.m_46859_(pos) || world.m_8055_(pos).m_60734_() instanceof FallenLeavesBlock || world.m_8055_(pos).m_60734_() instanceof GroundcoverBlock;
    }
}

