/*
 * Decompiled with CFR 0.152.
 */
package com.projectvibrantjourneys.event;

import com.projectvibrantjourneys.core.config.PVJConfig;
import com.projectvibrantjourneys.core.registry.features.PVJPlacements;
import com.projectvibrantjourneys.util.PVJFeatureVars;
import com.projectvibrantjourneys.util.TreeFeatureUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class PVJWorldGenEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addBiomeFeatures(BiomeLoadingEvent event) {
        ResourceKey biome = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
        Optional holder = ForgeRegistries.BIOMES.getHolder(biome);
        Set biomeTypes = BiomeDictionary.getTypes((ResourceKey)biome);
        List vegetalFeatures = event.getGeneration().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION);
        MobSpawnSettingsBuilder mobSpawns = event.getSpawns();
        if (event.getCategory() == Biome.BiomeCategory.NETHER) {
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.CHARRED_BONES, PVJConfig.CONFIG_DATA.enableCharredBones, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.GLOWCAP, PVJConfig.CONFIG_DATA.enableGlowcap, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.CINDERCANE, PVJConfig.CONFIG_DATA.enableCindercane, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.WARPED_NETTLE, PVJConfig.CONFIG_DATA.enableNetherNettles, biome == Biomes.f_48201_);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.CRIMSON_NETTLE, PVJConfig.CONFIG_DATA.enableNetherNettles, biome == Biomes.f_48200_);
        } else if (this.overworld(biomeTypes, holder) && !biome.getRegistryName().toString().equals("biomesoplenty:origin_valley") && biome != Biomes.f_186761_ && event.getCategory() != Biome.BiomeCategory.MUSHROOM) {
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.TWIGS, PVJConfig.CONFIG_DATA.enableTwigs, this.forestOrPlains(biomeTypes, holder));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.FALLEN_LEAVES, PVJConfig.CONFIG_DATA.enableFallenLeaves, this.forestOrPlains(biomeTypes, holder));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.PINECONES, PVJConfig.CONFIG_DATA.enablePinecones, this.coniferous(biomeTypes, holder));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.SEASHELLS, PVJConfig.CONFIG_DATA.enableSeashells, this.oceanOrBeach(biomeTypes, holder));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.OCEAN_FLOOR_SEASHELLS, PVJConfig.CONFIG_DATA.enableSeashells, this.oceanOrBeach(biomeTypes, holder));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.EXTRA_OCEAN_FLOOR_SEASHELLS, PVJConfig.CONFIG_DATA.enableSeashells, this.oceanOrBeach(biomeTypes, holder));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.ROCKS, PVJConfig.CONFIG_DATA.enableRocks, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.CAVE_ROCKS, PVJConfig.CONFIG_DATA.enableBones, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.BONES, PVJConfig.CONFIG_DATA.enableBones, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.CAVE_BONES, PVJConfig.CONFIG_DATA.enableBones, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.ICE_CHUNKS, PVJConfig.CONFIG_DATA.enableIceChunks, this.snowy(biomeTypes, holder));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.BADLANDS_DEAD_FALLEN_LEAVES, PVJConfig.CONFIG_DATA.enableFallenLeaves, biome == Biomes.f_186753_);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.DENSE_DEAD_FALLEN_LEAVES, PVJConfig.CONFIG_DATA.enableFallenLeaves, biome == Biomes.f_186763_ || biome == Biomes.f_186764_);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.MOSS_CARPET, PVJConfig.CONFIG_DATA.enableMossCarpets, biome == Biomes.f_186763_ || biome == Biomes.f_186764_);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.BARK_MUSHROOM, PVJConfig.CONFIG_DATA.enableBarkMushrooms, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.SEA_OATS, PVJConfig.CONFIG_DATA.enableSeaOats, this.beach(biomeTypes, holder) && !this.veryCold((ResourceKey<Biome>)biome));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.BEACH_GRASS, PVJConfig.CONFIG_DATA.enableBeachGrass, this.beach(biomeTypes, holder));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.CATTAILS, PVJConfig.CONFIG_DATA.enableCattails, !this.oceanOrBeach(biomeTypes, holder) && !this.veryCold((ResourceKey<Biome>)biome) && event.getCategory() != Biome.BiomeCategory.MESA);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.SHORT_GRASS, PVJConfig.CONFIG_DATA.enableShortGrass, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.NATURAL_COBWEB, PVJConfig.CONFIG_DATA.enableNaturalCobwebs, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.SMALL_CACTUS, PVJConfig.CONFIG_DATA.enableSmallCacti, event.getCategory() == Biome.BiomeCategory.DESERT);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.EXTRA_SEAGRASS, PVJConfig.CONFIG_DATA.enableExtraSeagrass, this.inlandNotDesert(event.getCategory()));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.EXTRA_LILYPADS, PVJConfig.CONFIG_DATA.enableExtraLilypads, this.inlandNotDesert(event.getCategory()) && !this.veryCold((ResourceKey<Biome>)biome));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.EXTRA_GRASS, PVJConfig.CONFIG_DATA.enableExtraRiverGrass, event.getCategory() == Biome.BiomeCategory.RIVER);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.TIDE_POOL, PVJConfig.CONFIG_DATA.enableTidePools, biome == Biomes.f_186760_);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.PRICKLY_BUSH, PVJConfig.CONFIG_DATA.enablePricklyBush, biome == Biomes.f_186753_);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.REEDS, PVJConfig.CONFIG_DATA.enableReeds, event.getCategory() == Biome.BiomeCategory.PLAINS || event.getCategory() == Biome.BiomeCategory.SAVANNA);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.CAVE_ROOTS, PVJConfig.CONFIG_DATA.enableCaveRoots, true);
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.ICICLE, PVJConfig.CONFIG_DATA.enableCaveRoots, this.snowy(biomeTypes, holder));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.OAK_FALLEN_TREE, PVJConfig.CONFIG_DATA.enableFallenTrees, TreeFeatureUtils.isIn(PVJFeatureVars.OAK, event.getName()));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.BIRCH_FALLEN_TREE, PVJConfig.CONFIG_DATA.enableFallenTrees, TreeFeatureUtils.isIn(PVJFeatureVars.BIRCH, event.getName()));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.SPRUCE_FALLEN_TREE, PVJConfig.CONFIG_DATA.enableFallenTrees, TreeFeatureUtils.isIn(PVJFeatureVars.SPRUCE, event.getName()));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.JUNGLE_FALLEN_TREE, PVJConfig.CONFIG_DATA.enableFallenTrees, TreeFeatureUtils.isIn(PVJFeatureVars.JUNGLE, event.getName()));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.ACACIA_FALLEN_TREE, PVJConfig.CONFIG_DATA.enableFallenTrees, TreeFeatureUtils.isIn(PVJFeatureVars.ACACIA, event.getName()));
            this.addFeature((List<Holder<PlacedFeature>>)vegetalFeatures, PVJPlacements.DARK_OAK_FALLEN_TREE, PVJConfig.CONFIG_DATA.enableFallenTrees, TreeFeatureUtils.isIn(PVJFeatureVars.DARK_OAK, event.getName()));
        }
        if (biomeTypes.contains(BiomeDictionary.Type.OVERWORLD) || this.hasAnyTag(holder, Tags.Biomes.IS_OVERWORLD)) {
            this.addSpawn(mobSpawns, MobCategory.WATER_AMBIENT, EntityType.f_20489_, 25, 5, 5, PVJConfig.CONFIG_DATA.enableJungleTropicalFish, event.getCategory() == Biome.BiomeCategory.JUNGLE);
            this.addSpawn(mobSpawns, MobCategory.WATER_AMBIENT, EntityType.f_20556_, 25, 1, 4, PVJConfig.CONFIG_DATA.enableTidePools, biome == Biomes.f_186760_);
        }
    }

    private boolean hasAnyType(Set<BiomeDictionary.Type> list, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type t : types) {
            if (!list.contains(t)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    private boolean hasAnyTag(Optional<Holder<Biome>> biome, TagKey<Biome> ... tags) {
        return false;
    }

    private void addFeature(List<Holder<PlacedFeature>> decorations, Holder<PlacedFeature> placedFeature, ForgeConfigSpec.BooleanValue configValue, boolean conditions) {
        if (((Boolean)configValue.get()).booleanValue() && conditions) {
            decorations.add(placedFeature);
        }
    }

    private void addFeature(List<Holder<PlacedFeature>> decorations, RegistryObject<PlacedFeature> placedFeature, ForgeConfigSpec.BooleanValue configValue, boolean conditions) {
        this.addFeature(decorations, (Holder<PlacedFeature>)((Holder)placedFeature.getHolder().get()), configValue, conditions);
    }

    private void addSpawn(MobSpawnSettingsBuilder spawns, MobCategory category, EntityType<?> entityType, int weight, int minCount, int maxCount, ForgeConfigSpec.BooleanValue configValue, boolean conditions) {
        if (((Boolean)configValue.get()).booleanValue() && conditions) {
            spawns.m_48376_(category, new MobSpawnSettings.SpawnerData(entityType, weight, minCount, maxCount));
        }
    }

    private boolean forestOrPlains(Set<BiomeDictionary.Type> biomeTypes, Optional<Holder<Biome>> holder) {
        return this.hasAnyType(biomeTypes, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS) || this.hasAnyTag(holder, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_);
    }

    private boolean oceanOrBeach(Set<BiomeDictionary.Type> biomeTypes, Optional<Holder<Biome>> holder) {
        return this.hasAnyType(biomeTypes, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH) || this.hasAnyTag(holder, Tags.Biomes.IS_BEACH, BiomeTags.f_207604_, BiomeTags.f_207603_);
    }

    private boolean beach(Set<BiomeDictionary.Type> biomeTypes, Optional<Holder<Biome>> holder) {
        return this.hasAnyType(biomeTypes, BiomeDictionary.Type.BEACH) || this.hasAnyTag(holder, Tags.Biomes.IS_BEACH, BiomeTags.f_207604_);
    }

    private boolean coniferous(Set<BiomeDictionary.Type> biomeTypes, Optional<Holder<Biome>> holder) {
        return this.hasAnyType(biomeTypes, BiomeDictionary.Type.CONIFEROUS) || this.hasAnyTag(holder, Tags.Biomes.IS_CONIFEROUS);
    }

    private boolean snowy(Set<BiomeDictionary.Type> biomeTypes, Optional<Holder<Biome>> holder) {
        return this.hasAnyType(biomeTypes, BiomeDictionary.Type.SNOWY) || this.hasAnyTag(holder, Tags.Biomes.IS_SNOWY);
    }

    private boolean veryCold(ResourceKey<Biome> biome) {
        return biome == Biomes.f_48212_ || biome == Biomes.f_186761_ || biome == Biomes.f_48148_ || biome == Biomes.f_186756_ || biome == Biomes.f_48182_ || biome == Biomes.f_48211_ || biome == Biomes.f_48172_;
    }

    private boolean inlandNotDesert(Biome.BiomeCategory category) {
        return category != Biome.BiomeCategory.DESERT && category != Biome.BiomeCategory.MESA && category != Biome.BiomeCategory.RIVER && category != Biome.BiomeCategory.OCEAN && category != Biome.BiomeCategory.BEACH;
    }

    private boolean overworld(Set<BiomeDictionary.Type> biomeTypes, Optional<Holder<Biome>> holder) {
        return biomeTypes.contains(BiomeDictionary.Type.OVERWORLD) || this.hasAnyTag(holder, Tags.Biomes.IS_OVERWORLD);
    }
}

