/*
 * Decompiled with CFR 0.152.
 */
package com.projectvibrantjourneys.common.blocks;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GroundcoverBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty MODEL = IntegerProperty.m_61631_((String)"model", (int)0, (int)4);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);

    public GroundcoverBlock(SoundType soundType) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60913_(0.05f, 0.0f).m_60955_().m_222979_(BlockBehaviour.OffsetType.XZ).m_60918_(soundType));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MODEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public GroundcoverBlock(Material material, SoundType soundType) {
        super(BlockBehaviour.Properties.m_60939_((Material)material).m_60913_(0.1f, 0.0f).m_60918_(soundType).m_60955_().m_222979_(BlockBehaviour.OffsetType.XZ));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)MODEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        int model = context.m_43725_().m_213780_().m_188503_(5);
        Direction facing = Direction.Plane.HORIZONTAL.m_235690_(context.m_43725_().m_213780_());
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)MODEL, (Comparable)Integer.valueOf(model))).m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return Block.m_49936_((BlockGetter)world, (BlockPos)pos.m_7495_());
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46961_(pos, false);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brt) {
        if (!player.m_21120_(hand).m_41619_()) {
            return super.m_6227_(state, world, pos, player, hand, brt);
        }
        if (!player.m_7500_() && player.m_36326_()) {
            LootContext lootContext;
            LootTable lootTable;
            ObjectArrayList randomItems;
            ItemStack loot = null;
            if (!world.m_5776_() && (randomItems = (lootTable = world.m_7654_().m_129898_().m_79217_(this.m_60589_())).m_230922_(lootContext = new LootContext.Builder((ServerLevel)world).m_230911_(world.m_213780_()).m_78975_(LootContextParamSets.f_81410_))).size() > 0) {
                loot = (ItemStack)randomItems.get(0);
            }
            if (loot == null) {
                loot = new ItemStack((ItemLike)this);
            }
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)loot);
        }
        world.m_7471_(pos, true);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MODEL, FACING, WATERLOGGED});
    }
}

