/*
 * Decompiled with CFR 0.152.
 */
package com.projectvibrantjourneys.core.data;

import com.google.gson.JsonElement;
import com.projectvibrantjourneys.common.world.modifiers.PVJBiomeModifier;
import com.projectvibrantjourneys.common.world.modifiers.PVJSpawnModifier;
import com.projectvibrantjourneys.core.config.PVJTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;

public class PVJBiomeModifierDataGen {
    private static final TagKey<Biome> OVERWORLD = BiomeTags.f_215817_;
    private static final TagKey<Biome> NETHER = BiomeTags.f_207612_;
    private static final TagKey<Biome> END = BiomeTags.f_215818_;

    public static Map<ResourceLocation, BiomeModifier> createFeatureGenMap(RegistryOps<JsonElement> registryOps) {
        HashMap<ResourceLocation, BiomeModifier> map = new HashMap<ResourceLocation, BiomeModifier>();
        PVJBiomeModifierDataGen.addFeature(map, "twigs", new Builder(registryOps, "twigs", "enableTwigs").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.desert(), PVJBiomeModifierDataGen.oceanOrBeach(), PVJBiomeModifierDataGen.mushroom()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifierDataGen.addFeature(map, "fallen_leaves", new Builder(registryOps, "fallen_leaves", "enableFallenLeaves").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.desert(), PVJBiomeModifierDataGen.oceanOrBeach(), PVJBiomeModifierDataGen.mushroom()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifierDataGen.addFeature(map, "dead_fallen_leaves", new Builder(registryOps, "dead_fallen_leaves", "enableFallenLeaves").extraBiomes(Biomes.f_186753_));
        PVJBiomeModifierDataGen.addFeature(map, "dense_dead_fallen_leaves", new Builder(registryOps, "dense_dead_fallen_leaves", "enableFallenLeaves").extraBiomes(Biomes.f_186763_, Biomes.f_186764_));
        PVJBiomeModifierDataGen.addFeature(map, "pinecones", new Builder(registryOps, "pinecones", "enablePinecones").tag(PVJBiomeModifierDataGen.coniferous()));
        PVJBiomeModifierDataGen.addFeature(map, "seashells", new Builder(registryOps, "seashells", "enableSeashells").tag(PVJBiomeModifierDataGen.oceanOrBeach()));
        PVJBiomeModifierDataGen.addFeature(map, "ocean_floor_seashells", new Builder(registryOps, "ocean_floor_seashells", "enableSeashells").tag(PVJBiomeModifierDataGen.oceanOrBeach()));
        PVJBiomeModifierDataGen.addFeature(map, "rocks", new Builder(registryOps, "rocks", "enableRocks").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.mushroom()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()));
        PVJBiomeModifierDataGen.addFeature(map, "bones", new Builder(registryOps, "bones", "enableBones").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.mushroom()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()));
        PVJBiomeModifierDataGen.addFeature(map, "cave_rocks", new Builder(registryOps, "cave_rocks", "enableRocks").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.mushroom()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()));
        PVJBiomeModifierDataGen.addFeature(map, "cave_bones", new Builder(registryOps, "cave_bones", "enableBones").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.mushroom()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()));
        PVJBiomeModifierDataGen.addFeature(map, "ice_chunks", new Builder(registryOps, "ice_chunks", "enableIceChunks").tag(PVJBiomeModifierDataGen.snowy()).extraBlacklist(Biomes.f_48148_));
        PVJBiomeModifierDataGen.addFeature(map, "moss_carpet", new Builder(registryOps, "moss_carpet", "enableMossCarpets").extraBiomes(Biomes.f_186763_, Biomes.f_186764_));
        PVJBiomeModifierDataGen.addFeature(map, "bark_mushroom", new Builder(registryOps, "bark_mushroom", "enableBarkMushrooms").tag(PVJBiomeModifierDataGen.overworld()));
        PVJBiomeModifierDataGen.addFeature(map, "sea_oats", new Builder(registryOps, "sea_oats", "enableSeaOats").tag(PVJBiomeModifierDataGen.beach()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()));
        PVJBiomeModifierDataGen.addFeature(map, "beach_grass", new Builder(registryOps, "beach_grass", "enableBeachGrass").tag(PVJBiomeModifierDataGen.beach()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()));
        PVJBiomeModifierDataGen.addFeature(map, "cattails", new Builder(registryOps, "cattails", "enableCattails").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.oceanOrBeach(), PVJBiomeModifierDataGen.badlands()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifierDataGen.addFeature(map, "short_grass", new Builder(registryOps, "short_grass", "enableShortGrass").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.mushroom()).extraBlacklist(Biomes.f_186761_));
        PVJBiomeModifierDataGen.addFeature(map, "natural_cobweb", new Builder(registryOps, "natural_cobweb", "enableNaturalCobwebs").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.mushroom()).extraBlacklist(Biomes.f_186761_));
        PVJBiomeModifierDataGen.addFeature(map, "small_cactus", new Builder(registryOps, "small_cactus", "enableSmallCacti").tag(PVJBiomeModifierDataGen.desert()));
        PVJBiomeModifierDataGen.addFeature(map, "extra_seagrass", new Builder(registryOps, "extra_seagrass", "enableExtraSeagrass").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.oceanOrBeach(), PVJBiomeModifierDataGen.desert()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifierDataGen.addFeature(map, "extra_lilypads", new Builder(registryOps, "extra_lilypads", "enableExtraLilypads").tag(PVJBiomeModifierDataGen.overworld()).blacklist(PVJBiomeModifierDataGen.oceanOrBeach(), PVJBiomeModifierDataGen.desert()).extraBlacklist(PVJBiomeModifierDataGen.veryCold()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifierDataGen.addFeature(map, "extra_grass", new Builder(registryOps, "extra_grass", "enableExtraSeagrass").tag(PVJBiomeModifierDataGen.river()));
        PVJBiomeModifierDataGen.addFeature(map, "tide_pool", new Builder(registryOps, "tide_pool", "enableTidePools").extraBiomes(Biomes.f_186760_));
        PVJBiomeModifierDataGen.addFeature(map, "cave_roots", new Builder(registryOps, "cave_roots", "enableCaveRoots").tag(PVJBiomeModifierDataGen.overworld()));
        PVJBiomeModifierDataGen.addFeature(map, "reeds", new Builder(registryOps, "reeds", "enableReeds").tag(PVJBiomeModifierDataGen.plainsType()).extraBlacklist(Biomes.f_186761_));
        PVJBiomeModifierDataGen.addFeature(map, "prickly_bush", new Builder(registryOps, "prickly_bush", "enablePricklyBush").extraBiomes(Biomes.f_186753_));
        PVJBiomeModifierDataGen.addFeature(map, "icicle", new Builder(registryOps, "icicle", "enableIcicles").tag(PVJBiomeModifierDataGen.snowy()));
        PVJBiomeModifierDataGen.addFeature(map, "oak_fallen_tree", new Builder(registryOps, "oak_fallen_tree", "enableFallenTrees").biomes((HolderSet.Named<Biome>)new HolderSet.Named((Registry)registryOps.m_206826_(Registry.f_122885_).get(), PVJTags.HAS_OAK_LOGS)));
        PVJBiomeModifierDataGen.addFeature(map, "birch_fallen_tree", new Builder(registryOps, "birch_fallen_tree", "enableFallenTrees").biomes((HolderSet.Named<Biome>)new HolderSet.Named((Registry)registryOps.m_206826_(Registry.f_122885_).get(), PVJTags.HAS_BIRCH_LOGS)));
        PVJBiomeModifierDataGen.addFeature(map, "spruce_fallen_tree", new Builder(registryOps, "spruce_fallen_tree", "enableFallenTrees").biomes((HolderSet.Named<Biome>)new HolderSet.Named((Registry)registryOps.m_206826_(Registry.f_122885_).get(), PVJTags.HAS_SPRUCE_LOGS)));
        PVJBiomeModifierDataGen.addFeature(map, "jungle_fallen_tree", new Builder(registryOps, "jungle_fallen_tree", "enableFallenTrees").biomes((HolderSet.Named<Biome>)new HolderSet.Named((Registry)registryOps.m_206826_(Registry.f_122885_).get(), PVJTags.HAS_JUNGLE_LOGS)));
        PVJBiomeModifierDataGen.addFeature(map, "acacia_fallen_tree", new Builder(registryOps, "acacia_fallen_tree", "enableFallenTrees").biomes((HolderSet.Named<Biome>)new HolderSet.Named((Registry)registryOps.m_206826_(Registry.f_122885_).get(), PVJTags.HAS_ACACIA_LOGS)));
        PVJBiomeModifierDataGen.addFeature(map, "dark_oak_fallen_tree", new Builder(registryOps, "dark_oak_fallen_tree", "enableFallenTrees").biomes((HolderSet.Named<Biome>)new HolderSet.Named((Registry)registryOps.m_206826_(Registry.f_122885_).get(), PVJTags.HAS_DARK_OAK_LOGS)));
        PVJBiomeModifierDataGen.addFeature(map, "charred_bones", new Builder(registryOps, "charred_bones", "enableCharredBones").dimension(NETHER).tag(List.of(NETHER)));
        PVJBiomeModifierDataGen.addFeature(map, "glowcap", new Builder(registryOps, "glowcap", "enableGlowcap").dimension(NETHER).tag(List.of(NETHER)));
        PVJBiomeModifierDataGen.addFeature(map, "cindercane", new Builder(registryOps, "cindercane", "enableCindercane").dimension(NETHER).tag(List.of(NETHER)));
        PVJBiomeModifierDataGen.addFeature(map, "warped_nettle", new Builder(registryOps, "warped_nettle", "enableNetherNettles").dimension(NETHER).extraBiomes(Biomes.f_48201_));
        PVJBiomeModifierDataGen.addFeature(map, "crimson_nettle", new Builder(registryOps, "crimson_nettle", "enableNetherNettles").dimension(NETHER).extraBiomes(Biomes.f_48200_));
        PVJBiomeModifierDataGen.addSpawn(map, "tropical_fish_in_jungles", PVJBiomeModifierDataGen.getAllBiomes(registryOps, (TagKey<Biome>)BiomeTags.f_207610_), OVERWORLD, MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 5, 5));
        return map;
    }

    private static void addFeature(Map<ResourceLocation, BiomeModifier> map, String placedFeatureName, Builder builder) {
        PVJBiomeModifier modifier = builder.build();
        ResourceLocation location = new ResourceLocation("projectvibrantjourneys", placedFeatureName);
        map.put(location, modifier);
    }

    private static void addSpawn(Map<ResourceLocation, BiomeModifier> map, String spawnName, HolderSet<Biome> biomes, TagKey<Biome> dimension, MobCategory category, MobSpawnSettings.SpawnerData data) {
        PVJSpawnModifier modifier = new PVJSpawnModifier(dimension, biomes, category, data, "enableJungleTropicalFish");
        map.put(new ResourceLocation("projectvibrantjourneys", spawnName), modifier);
    }

    private static HolderSet<Biome> getAllBiomes(RegistryOps<JsonElement> registryOps, TagKey<Biome> tag) {
        return new HolderSet.Named((Registry)registryOps.m_206826_(Registry.f_122885_).get(), tag);
    }

    private static List<TagKey<Biome>> forestOrPlains() {
        return List.of(Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_);
    }

    private static List<TagKey<Biome>> plainsType() {
        return List.of(Tags.Biomes.IS_PLAINS, BiomeTags.f_215816_);
    }

    private static List<TagKey<Biome>> oceanOrBeach() {
        return List.of(BiomeTags.f_207604_, BiomeTags.f_207603_);
    }

    private static List<TagKey<Biome>> badlands() {
        return List.of(BiomeTags.f_207607_);
    }

    private static List<TagKey<Biome>> beach() {
        return List.of(BiomeTags.f_207604_);
    }

    private static List<TagKey<Biome>> river() {
        return List.of(BiomeTags.f_207605_);
    }

    private static List<TagKey<Biome>> coniferous() {
        return List.of(Tags.Biomes.IS_CONIFEROUS);
    }

    private static List<TagKey<Biome>> snowy() {
        return List.of(Tags.Biomes.IS_SNOWY);
    }

    private static List<TagKey<Biome>> mushroom() {
        return List.of(Tags.Biomes.IS_MUSHROOM);
    }

    private static List<ResourceKey<Biome>> veryCold() {
        return List.of(Biomes.f_48212_, Biomes.f_186761_, Biomes.f_48148_, Biomes.f_186756_, Biomes.f_48182_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_186758_);
    }

    private static List<TagKey<Biome>> desert() {
        return List.of(BiomeTags.f_207614_, BiomeTags.f_207607_);
    }

    private static List<TagKey<Biome>> overworld() {
        return List.of(BiomeTags.f_215817_);
    }

    private static List<TagKey<Biome>> nether() {
        return List.of(BiomeTags.f_207612_);
    }

    private static Holder<Biome> getBiome(RegistryOps<JsonElement> registryOps, ResourceKey<Biome> biomeKey) {
        return (Holder)((Registry)registryOps.m_206826_(Registry.f_122885_).get()).m_203636_(biomeKey).get();
    }

    private static class Builder {
        private String placedFeatureName;
        private TagKey<Biome> dimension = OVERWORLD;
        private HolderSet.Named<Biome> namedTags;
        private List<TagKey<Biome>> biomeTags = new ArrayList<TagKey<Biome>>();
        private List<TagKey<Biome>> blacklistTags = new ArrayList<TagKey<Biome>>();
        private List<Holder<Biome>> extraBiomes = new ArrayList<Holder<Biome>>();
        private List<Holder<Biome>> extraBlacklist = new ArrayList<Holder<Biome>>();
        private RegistryOps<JsonElement> registryOps;
        private GenerationStep.Decoration decoration = GenerationStep.Decoration.VEGETAL_DECORATION;
        private String configOption;

        public Builder(RegistryOps<JsonElement> registryOps, String placedFeatureName, String configOption) {
            this.registryOps = registryOps;
            this.placedFeatureName = placedFeatureName;
            this.configOption = configOption;
        }

        public Builder dimension(TagKey<Biome> tag) {
            this.dimension = tag;
            return this;
        }

        public Builder tag(List<TagKey<Biome>> tags) {
            this.biomeTags.addAll(this.combine(tags));
            return this;
        }

        public Builder blacklist(List<TagKey<Biome>> ... tags) {
            this.blacklistTags.addAll(this.combine(tags));
            return this;
        }

        public Builder extraBiomes(List<Holder<Biome>> ... biomes) {
            this.extraBiomes.addAll(this.combine(biomes));
            return this;
        }

        public Builder extraBiomes(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                this.extraBiomes.add((Holder<Biome>)((Holder)((Registry)this.registryOps.m_206826_(Registry.f_122885_).get()).m_203636_(biome).get()));
            }
            return this;
        }

        public Builder biomes(HolderSet.Named<Biome> holders) {
            this.namedTags = holders;
            return this;
        }

        public Builder extraBlacklist(List<Holder<Biome>> ... biomes) {
            this.extraBlacklist.addAll(this.combine(biomes));
            return this;
        }

        public Builder extraBlacklist(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                this.extraBlacklist.add((Holder<Biome>)((Holder)((Registry)this.registryOps.m_206826_(Registry.f_122885_).get()).m_203636_(biome).get()));
            }
            return this;
        }

        public Builder extraBlacklist(List<ResourceKey<Biome>> biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                this.extraBlacklist.add((Holder<Biome>)((Holder)((Registry)this.registryOps.m_206826_(Registry.f_122885_).get()).m_203636_(biome).get()));
            }
            return this;
        }

        public Builder decoration(GenerationStep.Decoration decoration) {
            this.decoration = decoration;
            return this;
        }

        @SafeVarargs
        public final <T> List<T> combine(List<T> ... lists) {
            ArrayList<T> list = new ArrayList<T>();
            for (List<T> i : lists) {
                for (T tag : i) {
                    list.add(tag);
                }
            }
            return list;
        }

        public PVJBiomeModifier build() {
            ArrayList<HolderSet<Biome>> biomesSet = new ArrayList<HolderSet<Biome>>(this.biomeTags.stream().map(tag -> PVJBiomeModifierDataGen.getAllBiomes(this.registryOps, (TagKey<Biome>)tag)).toList());
            ArrayList<HolderSet<Biome>> blacklistSet = new ArrayList<HolderSet<Biome>>(this.blacklistTags.stream().map(tag -> PVJBiomeModifierDataGen.getAllBiomes(this.registryOps, (TagKey<Biome>)tag)).toList());
            if (!this.extraBiomes.isEmpty()) {
                biomesSet.add((HolderSet)HolderSet.m_205800_(this.extraBiomes));
            }
            if (this.namedTags != null) {
                biomesSet.add((HolderSet<Biome>)this.namedTags);
            }
            if (!this.extraBlacklist.isEmpty()) {
                blacklistSet.add((HolderSet)HolderSet.m_205800_(this.extraBlacklist));
            }
            ResourceLocation location = new ResourceLocation("projectvibrantjourneys", this.placedFeatureName);
            Holder placedFeature = ((Registry)this.registryOps.m_206826_(Registry.f_194567_).get()).m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)location));
            return new PVJBiomeModifier(this.dimension, biomesSet, blacklistSet, this.decoration, (Holder<PlacedFeature>)placedFeature, this.configOption);
        }
    }
}

