/*
 * Decompiled with CFR 0.152.
 */
package com.projectvibrantjourneys.core.registry;

import com.projectvibrantjourneys.common.blocks.BarkMushroomBlock;
import com.projectvibrantjourneys.common.blocks.BeachGrassBlock;
import com.projectvibrantjourneys.common.blocks.CindercaneBlock;
import com.projectvibrantjourneys.common.blocks.DoubleHighWaterPlantBlock;
import com.projectvibrantjourneys.common.blocks.FallenLeavesBlock;
import com.projectvibrantjourneys.common.blocks.GlowcapBlock;
import com.projectvibrantjourneys.common.blocks.GlowingFungusBlock;
import com.projectvibrantjourneys.common.blocks.GroundcoverBlock;
import com.projectvibrantjourneys.common.blocks.HollowLogBlock;
import com.projectvibrantjourneys.common.blocks.IcicleBlock;
import com.projectvibrantjourneys.common.blocks.NaturalCobwebBlock;
import com.projectvibrantjourneys.common.blocks.NetherPlantBlock;
import com.projectvibrantjourneys.common.blocks.SeaOatsBlock;
import com.projectvibrantjourneys.common.blocks.ShortGrassBlock;
import com.projectvibrantjourneys.common.blocks.SmallCactusBlock;
import com.projectvibrantjourneys.common.blocks.ThornsBlock;
import com.projectvibrantjourneys.core.registry.PVJCreativeModeTab;
import com.projectvibrantjourneys.core.registry.PVJItems;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class PVJBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"projectvibrantjourneys");
    public static final RegistryObject<Block> BEACH_GRASS = PVJBlocks.registerBlock("beach_grass", () -> new BeachGrassBlock());
    public static final RegistryObject<Block> SEA_OATS = PVJBlocks.registerBlock("sea_oats", () -> new SeaOatsBlock());
    public static final RegistryObject<Block> CATTAIL = PVJBlocks.registerBlock("cattail", () -> new DoubleHighWaterPlantBlock());
    public static final RegistryObject<Block> BARK_MUSHROOM = PVJBlocks.registerBlockWithFuel("bark_mushroom", 100, () -> new BarkMushroomBlock());
    public static final RegistryObject<Block> LIGHT_BROWN_BARK_MUSHROOM = PVJBlocks.registerBlockWithFuel("light_brown_bark_mushroom", 100, () -> new BarkMushroomBlock());
    public static final RegistryObject<Block> ORANGE_BARK_MUSHROOM = PVJBlocks.registerBlockWithFuel("orange_bark_mushroom", 100, () -> new BarkMushroomBlock());
    public static final RegistryObject<Block> GLOWING_BLUE_FUNGUS = PVJBlocks.registerBlockWithFuel("glowing_blue_fungus", 100, () -> new GlowingFungusBlock());
    public static final RegistryObject<Block> SHORT_GRASS = PVJBlocks.registerBlock("short_grass", () -> new ShortGrassBlock());
    public static final RegistryObject<Block> SMALL_CACTUS = PVJBlocks.registerBlock("small_cactus", () -> new SmallCactusBlock());
    public static final RegistryObject<Block> PRICKLY_BUSH = PVJBlocks.registerBlock("prickly_bush", () -> new ThornsBlock());
    public static final RegistryObject<Block> REEDS = PVJBlocks.registerBlock("reeds", () -> new DoubleHighWaterPlantBlock());
    public static final RegistryObject<Block> ICICLE = PVJBlocks.registerBlock("icicle", () -> new IcicleBlock());
    public static final RegistryObject<Block> CRIMSON_NETTLE = PVJBlocks.registerBlock("crimson_nettle", () -> new NetherPlantBlock(MaterialColor.f_76389_));
    public static final RegistryObject<Block> WARPED_NETTLE = PVJBlocks.registerBlock("warped_nettle", () -> new NetherPlantBlock(MaterialColor.f_76392_));
    public static final RegistryObject<Block> CINDERCANE = PVJBlocks.registerBlockWithFuel("cindercane", 800, () -> new CindercaneBlock());
    public static final RegistryObject<Block> GLOWCAP = PVJBlocks.registerBlock("glowcap", () -> new GlowcapBlock());
    public static final RegistryObject<Block> TWIGS = PVJBlocks.registerBlockWithFuel("twigs", 100, () -> new GroundcoverBlock(SoundType.f_56758_));
    public static final RegistryObject<Block> FALLEN_LEAVES = PVJBlocks.registerBlock("fallen_leaves", () -> new FallenLeavesBlock());
    public static final RegistryObject<Block> DEAD_FALLEN_LEAVES = PVJBlocks.registerBlock("dead_fallen_leaves", () -> new FallenLeavesBlock());
    public static final RegistryObject<Block> ROCKS = PVJBlocks.registerBlock("rocks", () -> new GroundcoverBlock(SoundType.f_56742_));
    public static final RegistryObject<Block> MOSSY_ROCKS = PVJBlocks.registerBlock("mossy_rocks", () -> new GroundcoverBlock(SoundType.f_56742_));
    public static final RegistryObject<Block> SANDSTONE_ROCKS = PVJBlocks.registerBlock("sandstone_rocks", () -> new GroundcoverBlock(SoundType.f_56742_));
    public static final RegistryObject<Block> RED_SANDSTONE_ROCKS = PVJBlocks.registerBlock("red_sandstone_rocks", () -> new GroundcoverBlock(SoundType.f_56742_));
    public static final RegistryObject<Block> ICE_CHUNKS = PVJBlocks.registerBlock("ice_chunks", () -> new GroundcoverBlock(SoundType.f_56744_));
    public static final RegistryObject<Block> BONES = PVJBlocks.registerBlock("bones", () -> new GroundcoverBlock(SoundType.f_56724_));
    public static final RegistryObject<Block> CHARRED_BONES = PVJBlocks.registerBlock("charred_bones", () -> new GroundcoverBlock(SoundType.f_56724_));
    public static final RegistryObject<Block> PINECONES = PVJBlocks.registerBlockWithFuel("pinecones", 100, () -> new GroundcoverBlock(SoundType.f_56758_));
    public static final RegistryObject<Block> SEASHELLS = PVJBlocks.registerBlock("seashells", () -> new GroundcoverBlock(SoundType.f_56742_));
    public static final RegistryObject<Block> NATURAL_COBWEB = PVJBlocks.registerBlockWithoutItem("natural_cobweb", () -> new NaturalCobwebBlock());
    public static final RegistryObject<Block> OAK_HOLLOW_LOG = PVJBlocks.registerBlock("oak_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
    public static final RegistryObject<Block> BIRCH_HOLLOW_LOG = PVJBlocks.registerBlock("birch_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50001_)));
    public static final RegistryObject<Block> SPRUCE_HOLLOW_LOG = PVJBlocks.registerBlock("spruce_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50000_)));
    public static final RegistryObject<Block> JUNGLE_HOLLOW_LOG = PVJBlocks.registerBlock("jungle_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50002_)));
    public static final RegistryObject<Block> ACACIA_HOLLOW_LOG = PVJBlocks.registerBlock("acacia_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50003_)));
    public static final RegistryObject<Block> DARK_OAK_HOLLOW_LOG = PVJBlocks.registerBlock("dark_oak_hollow_log", () -> new HollowLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50004_)));
    public static final RegistryObject<Block> POTTED_GLOWCAP = PVJBlocks.registerBlockWithoutItem("potted_glowcap", () -> PVJBlocks.createFlowerPot((Block)GLOWCAP.get()));
    public static final RegistryObject<Block> POTTED_CRIMSON_NETTLE = PVJBlocks.registerBlockWithoutItem("potted_crimson_nettle", () -> PVJBlocks.createFlowerPot((Block)CRIMSON_NETTLE.get()));
    public static final RegistryObject<Block> POTTED_WARPED_NETTLE = PVJBlocks.registerBlockWithoutItem("potted_warped_nettle", () -> PVJBlocks.createFlowerPot((Block)WARPED_NETTLE.get()));
    public static final RegistryObject<Block> POTTED_CINDERCANE = PVJBlocks.registerBlockWithoutItem("potted_cindercane", () -> PVJBlocks.createFlowerPot((Block)CINDERCANE.get()));
    public static final RegistryObject<Block> POTTED_SMALL_CACTUS = PVJBlocks.registerBlockWithoutItem("potted_small_cactus", () -> PVJBlocks.createFlowerPot((Block)SMALL_CACTUS.get()));
    public static final RegistryObject<Block> POTTED_PRICKLY_BUSH = PVJBlocks.registerBlockWithoutItem("potted_prickly_bush", () -> PVJBlocks.createFlowerPot((Block)PRICKLY_BUSH.get()));

    private static RegistryObject<Block> registerBlock(String name, Supplier<Block> block) {
        RegistryObject temp = BLOCKS.register(name, block);
        PVJItems.ITEMS.register(name, () -> new ItemNameBlockItem((Block)temp.get(), new Item.Properties().m_41491_((CreativeModeTab)PVJCreativeModeTab.INSTANCE)));
        return temp;
    }

    private static RegistryObject<Block> registerBlock(String name, Supplier<Item> item, Supplier<Block> block) {
        RegistryObject temp = BLOCKS.register(name, block);
        PVJItems.ITEMS.register(name, item);
        return temp;
    }

    private static RegistryObject<Block> registerBlockWithoutItem(String name, Supplier<Block> block) {
        return BLOCKS.register(name, block);
    }

    private static RegistryObject<Block> registerBlockWithFuel(String name, final int burnTime, Supplier<Block> block) {
        RegistryObject temp = BLOCKS.register(name, block);
        PVJItems.ITEMS.register(name, () -> new ItemNameBlockItem((Block)temp.get(), new Item.Properties().m_41491_((CreativeModeTab)PVJCreativeModeTab.INSTANCE)){

            public int getBurnTime(ItemStack stack, RecipeType<?> type) {
                return burnTime;
            }
        });
        return temp;
    }

    public static RotatedPillarBlock createLogBlock(MaterialColor topColor, MaterialColor barkColor, final Supplier<Block> stripped) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : barkColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_)){

            public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                if (toolAction == ToolActions.AXE_STRIP && stripped != null) {
                    return (BlockState)((Block)stripped.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)));
                }
                return super.getToolModifiedState(state, context, toolAction, simulate);
            }
        };
    }

    public static Block createFlowerPot(Block plant) {
        FlowerPotBlock block = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> plant, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_).m_60953_(state -> plant == GLOWCAP.get() ? 12 : 0));
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(ForgeRegistries.BLOCKS.getKey((Object)plant), () -> PVJBlocks.lambda$createFlowerPot$47((Block)block));
        return block;
    }

    private static /* synthetic */ Block lambda$createFlowerPot$47(Block block) {
        return block;
    }
}

