/*
 * Decompiled with CFR 0.152.
 */
package com.projectvibrantjourneys.core.registry.world;

import com.projectvibrantjourneys.common.blocks.GroundcoverBlock;
import com.projectvibrantjourneys.common.blocks.ShortGrassBlock;
import com.projectvibrantjourneys.common.world.features.configs.FallenTreeConfiguration;
import com.projectvibrantjourneys.common.world.features.configs.MultipleVegetationPatchConfiguration;
import com.projectvibrantjourneys.common.world.features.stateproviders.DirectionalStateProvider;
import com.projectvibrantjourneys.core.registry.PVJBlocks;
import com.projectvibrantjourneys.core.registry.world.PVJFeatures;
import com.projectvibrantjourneys.util.PVJFeatureVars;
import com.projectvibrantjourneys.util.TreeFeatureUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.AquaticFeatures;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class PVJConfiguredFeatures {
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"projectvibrantjourneys");
    public static final RegistryObject<ConfiguredFeature<?, ?>> MOSS_CARPETS = PVJConfiguredFeatures.register("moss_carpet", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.mossCarpetConfig(10, 7, 2, Blocks.f_152543_)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> LILYPADS = PVJConfiguredFeatures.register("lilypads", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(24, 7, 3, PlacementUtils.m_206495_((Feature)((Feature)PVJFeatures.LILYPAD.get()), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.75f)))));
    public static final RegistryObject<ConfiguredFeature<?, ?>> CAVE_ROOTS = PVJConfiguredFeatures.register("cave_roots", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(2, 2, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152548_)), (BlockPredicate)BlockPredicate.m_224768_((Vec3i)new BlockPos(0, -1, 0), (TagKey)BlockTags.f_144274_)))));
    public static final RegistryObject<ConfiguredFeature<?, ?>> BEACH_GRASS = PVJConfiguredFeatures.register("beach_grass", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.simpleRandomPatch(((Block)PVJBlocks.BEACH_GRASS.get()).m_49966_())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SEA_OATS = PVJConfiguredFeatures.register("sea_oats", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.simpleRandomPatch(((Block)PVJBlocks.SEA_OATS.get()).m_49966_())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> CATTAILS = PVJConfiguredFeatures.register("cattails", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.cattailConfig(128, 7, 2, ((Block)PVJBlocks.CATTAIL.get()).m_49966_())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> BARK_MUSHROOM = PVJConfiguredFeatures.register("bark_mushroom", () -> new ConfiguredFeature((Feature)PVJFeatures.BARK_MUSHROOM.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    public static final RegistryObject<ConfiguredFeature<?, ?>> NATURAL_COBWEB = PVJConfiguredFeatures.register("natural_cobweb", () -> new ConfiguredFeature((Feature)PVJFeatures.NATURAL_COBWEB.get(), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.1f)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SHORT_GRASS = PVJConfiguredFeatures.register("short_grass", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)PVJBlocks.SHORT_GRASS.get())), ShortGrassBlock.MODEL, (IntProvider)UniformInt.m_146622_((int)0, (int)6))))));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SMALL_CACTUS = PVJConfiguredFeatures.register("small_cactus", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.randomPatchConfig(8, 7, 3, ((Block)PVJBlocks.SMALL_CACTUS.get()).m_49966_())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ICICLE = PVJConfiguredFeatures.register("icicle", () -> new ConfiguredFeature((Feature)PVJFeatures.ICICLE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    public static final RegistryObject<ConfiguredFeature<?, ?>> REEDS = PVJConfiguredFeatures.register("reeds", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.cattailConfig(250, 12, 2, ((Block)PVJBlocks.REEDS.get()).m_49966_())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> PRICKLY_BUSH = PVJConfiguredFeatures.register("prickly_bush", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.randomPatchConfig(10, 7, 3, ((Block)PVJBlocks.PRICKLY_BUSH.get()).m_49966_())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> TWIGS = PVJConfiguredFeatures.register("twigs", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.groundcoverConfig(4, 7, 3, (Block)PVJBlocks.TWIGS.get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> FALLEN_LEAVES = PVJConfiguredFeatures.register("fallen_leaves", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.randomPatchConfig(4, 7, 3, ((Block)PVJBlocks.FALLEN_LEAVES.get()).m_49966_())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> DEAD_FALLEN_LEAVES = PVJConfiguredFeatures.register("dead_fallen_leaves", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.randomPatchConfig(3, 7, 3, ((Block)PVJBlocks.DEAD_FALLEN_LEAVES.get()).m_49966_())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> PINECONES = PVJConfiguredFeatures.register("pinecones", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.groundcoverConfig(4, 7, 3, (Block)PVJBlocks.PINECONES.get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SEASHELLS = PVJConfiguredFeatures.register("seashells", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.groundcoverConfig(4, 7, 3, (Block)PVJBlocks.SEASHELLS.get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ROCKS = PVJConfiguredFeatures.register("rocks", () -> new ConfiguredFeature((Feature)PVJFeatures.ROCKS.get(), (FeatureConfiguration)PVJConfiguredFeatures.groundcoverConfig(4, 7, 3, (Block)PVJBlocks.ROCKS.get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ICE_CHUNKS = PVJConfiguredFeatures.register("ice_chunks", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.iceChunksConfig(4, 7, 3, (Block)PVJBlocks.ICE_CHUNKS.get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> BONES = PVJConfiguredFeatures.register("bones", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.groundcoverConfig(1, 7, 3, (Block)PVJBlocks.BONES.get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> CHARRED_BONES = PVJConfiguredFeatures.register("charred_bones", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.groundcoverConfig(50, 7, 3, (Block)PVJBlocks.CHARRED_BONES.get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> WARPED_NETTLE = PVJConfiguredFeatures.register("warped_nettle", () -> new ConfiguredFeature(Feature.f_65744_, (FeatureConfiguration)new NetherForestVegetationConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)PVJBlocks.WARPED_NETTLE.get())), 8, 4)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> CRIMSON_NETTLE = PVJConfiguredFeatures.register("crimson_nettle", () -> new ConfiguredFeature(Feature.f_65744_, (FeatureConfiguration)new NetherForestVegetationConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)PVJBlocks.CRIMSON_NETTLE.get())), 8, 4)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> CINDERCANE = PVJConfiguredFeatures.register("cindercane", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.columnPlantWithFluid(256, 7, 3, (Block)PVJBlocks.CINDERCANE.get(), new Fluid[]{Fluids.f_76195_, Fluids.f_76194_})));
    public static final RegistryObject<ConfiguredFeature<?, ?>> GLOWCAP = PVJConfiguredFeatures.register("glowcap", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)PVJConfiguredFeatures.simpleRandomPatch(((Block)PVJBlocks.GLOWCAP.get()).m_49966_())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> OAK_FALLEN_TREE = PVJConfiguredFeatures.register("oak_fallen_tree", () -> PVJConfiguredFeatures.fallenTree((Block)PVJBlocks.OAK_HOLLOW_LOG.get(), Blocks.f_49999_, PVJFeatureVars.OAK));
    public static final RegistryObject<ConfiguredFeature<?, ?>> BIRCH_FALLEN_TREE = PVJConfiguredFeatures.register("birch_fallen_tree", () -> PVJConfiguredFeatures.fallenTree((Block)PVJBlocks.BIRCH_HOLLOW_LOG.get(), Blocks.f_50001_, PVJFeatureVars.BIRCH));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SPRUCE_FALLEN_TREE = PVJConfiguredFeatures.register("spruce_fallen_tree", () -> PVJConfiguredFeatures.fallenTree((Block)PVJBlocks.SPRUCE_HOLLOW_LOG.get(), Blocks.f_50000_, PVJFeatureVars.SPRUCE));
    public static final RegistryObject<ConfiguredFeature<?, ?>> JUNGLE_FALLEN_TREE = PVJConfiguredFeatures.register("jungle_fallen_tree", () -> PVJConfiguredFeatures.fallenTree((Block)PVJBlocks.JUNGLE_HOLLOW_LOG.get(), Blocks.f_50002_, PVJFeatureVars.JUNGLE));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ACACIA_FALLEN_TREE = PVJConfiguredFeatures.register("acacia_fallen_tree", () -> PVJConfiguredFeatures.fallenTree((Block)PVJBlocks.ACACIA_HOLLOW_LOG.get(), Blocks.f_50003_, PVJFeatureVars.ACACIA));
    public static final RegistryObject<ConfiguredFeature<?, ?>> DARK_OAK_FALLEN_TREE = PVJConfiguredFeatures.register("dark_oak_fallen_tree", () -> PVJConfiguredFeatures.fallenTree((Block)PVJBlocks.DARK_OAK_HOLLOW_LOG.get(), Blocks.f_50004_, PVJFeatureVars.DARK_OAK));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SEA_PICKLE = PVJConfiguredFeatures.register("sea_pickle", () -> new ConfiguredFeature(Feature.f_65740_, (FeatureConfiguration)new CountConfiguration(1)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> TIDE_POOL = PVJConfiguredFeatures.register("tide_pool", () -> new ConfiguredFeature((Feature)PVJFeatures.POOL.get(), (FeatureConfiguration)new MultipleVegetationPatchConfiguration((TagKey<Block>)BlockTags.f_144277_, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50069_), 0.15f, List.of(PlacementUtils.m_206506_((Holder)((Holder)SEA_PICKLE.getHolder().get()), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206506_((Holder)AquaticFeatures.f_194928_, (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206506_((Holder)AquaticFeatures.f_194931_, (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206506_((Holder)AquaticFeatures.f_194931_, (PlacementModifier[])new PlacementModifier[0])), CaveSurface.FLOOR, (IntProvider)ConstantInt.m_146483_((int)3), 1.0f, 5, 0.3f, (IntProvider)UniformInt.m_146622_((int)2, (int)3), 0.7f)));

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<?, ?>> register(String name, Supplier<ConfiguredFeature<?, ?>> configuredFeature) {
        return CONFIGURED_FEATURES.register(name, configuredFeature);
    }

    private static RandomPatchConfiguration randomPatchConfig(int tries, int xzSpread, int ySpread, BlockState block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206498_((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)block)), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50568_, Blocks.f_50125_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50125_, Blocks.f_50359_, Blocks.f_50360_, Blocks.f_49991_, Blocks.f_49990_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224782_((Fluid[])new Fluid[]{Fluids.f_76195_, Fluids.f_76193_}))})));
    }

    private static RandomPatchConfiguration cattailConfig(int tries, int xzSpread, int ySpread, BlockState block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206498_((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)block)), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50568_, Blocks.f_50125_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50125_, Blocks.f_50359_, Blocks.f_50360_, Blocks.f_49991_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224782_((Fluid[])new Fluid[]{Fluids.f_76195_}))})));
    }

    private static RandomPatchConfiguration groundcoverConfig(int tries, int xzSpread, int ySpread, Block block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206498_((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)new DirectionalStateProvider(block), GroundcoverBlock.MODEL, (IntProvider)UniformInt.m_146622_((int)0, (int)4))), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50568_, Blocks.f_50125_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50125_, Blocks.f_50359_, Blocks.f_50360_, Blocks.f_49991_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224782_((Fluid[])new Fluid[]{Fluids.f_76195_}))})));
    }

    private static RandomPatchConfiguration iceChunksConfig(int tries, int xzSpread, int ySpread, Block block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206498_((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)new DirectionalStateProvider(block), GroundcoverBlock.MODEL, (IntProvider)UniformInt.m_146622_((int)0, (int)4))), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50125_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50125_, Blocks.f_50359_, Blocks.f_50360_, Blocks.f_49991_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224782_((Fluid[])new Fluid[]{Fluids.f_76195_}))})));
    }

    private static RandomPatchConfiguration mossCarpetConfig(int tries, int xzSpread, int ySpread, Block block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206498_((Feature)((Feature)PVJFeatures.SIMPLE_BLOCK_MATCH_WATER.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block)), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190410_((Vec3i)Direction.DOWN.m_122436_())), BlockPredicate.m_198308_((Vec3i)Direction.DOWN.m_122436_(), (Direction)Direction.UP), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50568_, Blocks.f_50125_, Blocks.f_49990_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50125_, Blocks.f_50359_, Blocks.f_50360_, Blocks.f_49991_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224777_((Vec3i)Direction.DOWN.m_122436_(), (Fluid[])new Fluid[]{Fluids.f_76193_})), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224782_((Fluid[])new Fluid[]{Fluids.f_76195_}))})));
    }

    private static ConfiguredFeature<?, ?> fallenTree(Block hollowLog, Block baseLog, Set<TreeFeatureUtils.ChanceBiomeEntry> data) {
        return new ConfiguredFeature((Feature)PVJFeatures.FALLEN_TREE.get(), (FeatureConfiguration)new FallenTreeConfiguration(hollowLog.m_49966_(), baseLog.m_49966_(), new ArrayList<TreeFeatureUtils.ChanceBiomeEntry>(data)));
    }

    private static RandomPatchConfiguration simpleRandomPatch(BlockState blockstate) {
        return FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)blockstate)));
    }

    public static RandomPatchConfiguration simpleRandomPatch(BlockStateProvider provider) {
        return FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(provider));
    }

    private static RandomPatchConfiguration columnPlantWithFluid(int tries, int xzspread, int yspread, Block block, Fluid ... fluids) {
        return new RandomPatchConfiguration(tries, xzspread, yspread, PlacementUtils.m_206498_((Feature)Feature.f_190875_, (FeatureConfiguration)BlockColumnConfiguration.m_191224_((IntProvider)BiasedToBottomInt.m_146367_((int)2, (int)4), (BlockStateProvider)BlockStateProvider.m_191382_((Block)block)), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_224774_((Vec3i)BlockPos.f_121853_, (Block[])new Block[]{Blocks.f_50016_}), BlockPredicate.m_190399_((BlockState)block.m_49966_(), (Vec3i)BlockPos.f_121853_), BlockPredicate.m_190430_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_224784_((Vec3i)new BlockPos(1, -1, 0), List.of(fluids)), BlockPredicate.m_224784_((Vec3i)new BlockPos(1, -1, 0), List.of(fluids)), BlockPredicate.m_224784_((Vec3i)new BlockPos(-1, -1, 0), List.of(fluids)), BlockPredicate.m_224784_((Vec3i)new BlockPos(0, -1, 1), List.of(fluids)), BlockPredicate.m_224784_((Vec3i)new BlockPos(0, -1, -1), List.of(fluids))})})));
    }
}

