/*
 * Decompiled with CFR 0.152.
 */
package com.projectvibrantjourneys.core.registry.world;

import com.google.common.collect.ImmutableList;
import com.projectvibrantjourneys.core.registry.world.PVJConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class PVJPlacements {
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"projectvibrantjourneys");
    public static final RegistryObject<PlacedFeature> MOSS_CARPET = PVJPlacements.register("moss_carpet", PVJConfiguredFeatures.MOSS_CARPETS, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)3));
    public static final RegistryObject<PlacedFeature> SEA_OATS = PVJPlacements.register("sea_oats", PVJConfiguredFeatures.SEA_OATS, PVJPlacements.onceEvery(5));
    public static final RegistryObject<PlacedFeature> CATTAILS = PVJPlacements.register("cattails", PVJConfiguredFeatures.CATTAILS, PVJPlacements.onceEvery(1));
    public static final RegistryObject<PlacedFeature> BEACH_GRASS = PVJPlacements.register("beach_grass", PVJConfiguredFeatures.BEACH_GRASS, PVJPlacements.onceEvery(5));
    public static final RegistryObject<PlacedFeature> BARK_MUSHROOM = PVJPlacements.register("bark_mushroom", PVJConfiguredFeatures.BARK_MUSHROOM, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)30));
    public static final RegistryObject<PlacedFeature> SHORT_GRASS = PVJPlacements.register("short_grass", PVJConfiguredFeatures.SHORT_GRASS, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)3));
    public static final RegistryObject<PlacedFeature> SMALL_CACTUS = PVJPlacements.register("small_cactus", PVJConfiguredFeatures.SMALL_CACTUS, new PlacementModifier[]{RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> ICICLE = PVJPlacements.register("icicle", PVJConfiguredFeatures.ICICLE, new PlacementModifier[]{CountPlacement.m_191628_((int)150), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)50), (VerticalAnchor)VerticalAnchor.m_158922_((int)256)), EnvironmentScanPlacement.m_191657_((Direction)Direction.UP, (BlockPredicate)BlockPredicate.m_198913_((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.f_190393_, (int)12), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)-1)), BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> CAVE_ROOTS = PVJPlacements.register("cave_roots", PVJConfiguredFeatures.CAVE_ROOTS, new PlacementModifier[]{CountPlacement.m_191628_((int)188), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)256)), EnvironmentScanPlacement.m_191657_((Direction)Direction.UP, (BlockPredicate)BlockPredicate.m_198913_((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.f_190393_, (int)12), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)-1)), BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> REEDS = PVJPlacements.register("reeds", PVJConfiguredFeatures.REEDS, PVJPlacements.onceEvery(1));
    public static final RegistryObject<PlacedFeature> PRICKLY_BUSH = PVJPlacements.register("prickly_bush", PVJConfiguredFeatures.PRICKLY_BUSH, PVJPlacements.onceEvery(2));
    public static final RegistryObject<PlacedFeature> TWIGS = PVJPlacements.register("twigs", PVJConfiguredFeatures.TWIGS, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)3));
    public static final RegistryObject<PlacedFeature> FALLEN_LEAVES = PVJPlacements.register("fallen_leaves", PVJConfiguredFeatures.FALLEN_LEAVES, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)3));
    public static final RegistryObject<PlacedFeature> DEAD_FALLEN_LEAVES = PVJPlacements.register("dead_fallen_leaves", PVJConfiguredFeatures.DEAD_FALLEN_LEAVES, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)3));
    public static final RegistryObject<PlacedFeature> DENSE_DEAD_FALLEN_LEAVES = PVJPlacements.register("dense_dead_fallen_leaves", PVJConfiguredFeatures.DEAD_FALLEN_LEAVES, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)6));
    public static final RegistryObject<PlacedFeature> PINECONES = PVJPlacements.register("pinecones", PVJConfiguredFeatures.PINECONES, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)2));
    public static final RegistryObject<PlacedFeature> SEASHELLS = PVJPlacements.register("seashells", PVJConfiguredFeatures.SEASHELLS, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)2));
    public static final RegistryObject<PlacedFeature> OCEAN_FLOOR_SEASHELLS = PVJPlacements.register("ocean_floor_seashells", PVJConfiguredFeatures.SEASHELLS, (List<PlacementModifier>)AquaticPlacements.m_195233_((int)2));
    public static final RegistryObject<PlacedFeature> EXTRA_OCEAN_FLOOR_SEASHELLS = PVJPlacements.register("extra_ocean_floor_seashells", PVJConfiguredFeatures.SEASHELLS, (List<PlacementModifier>)AquaticPlacements.m_195233_((int)4));
    public static final RegistryObject<PlacedFeature> ROCKS = PVJPlacements.register("rocks", PVJConfiguredFeatures.ROCKS, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)2));
    public static final RegistryObject<PlacedFeature> ICE_CHUNKS = PVJPlacements.register("ice_chunks", PVJConfiguredFeatures.ICE_CHUNKS, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)1));
    public static final RegistryObject<PlacedFeature> BONES = PVJPlacements.register("bones", PVJConfiguredFeatures.BONES, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)1));
    public static final RegistryObject<PlacedFeature> CHARRED_BONES = PVJPlacements.register("charred_bones", PVJConfiguredFeatures.CHARRED_BONES, new PlacementModifier[]{RarityFilter.m_191900_((int)5), CountOnEveryLayerPlacement.m_191604_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> CAVE_BONES = PVJPlacements.register("cave_bones", PVJConfiguredFeatures.BONES, new PlacementModifier[]{CountPlacement.m_191628_((int)100), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)4), (VerticalAnchor)VerticalAnchor.m_158922_((int)60)), EnvironmentScanPlacement.m_191657_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)12), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)1)), BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> CAVE_ROCKS = PVJPlacements.register("cave_rocks", PVJConfiguredFeatures.ROCKS, new PlacementModifier[]{CountPlacement.m_191628_((int)250), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)4), (VerticalAnchor)VerticalAnchor.m_158922_((int)60)), EnvironmentScanPlacement.m_191657_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)12), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)1)), BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> WARPED_NETTLE = PVJPlacements.register("warped_nettle", PVJConfiguredFeatures.WARPED_NETTLE, new PlacementModifier[]{RarityFilter.m_191900_((int)4), CountOnEveryLayerPlacement.m_191604_((int)2), BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> CRIMSON_NETTLE = PVJPlacements.register("crimson_nettle", PVJConfiguredFeatures.CRIMSON_NETTLE, new PlacementModifier[]{RarityFilter.m_191900_((int)4), CountOnEveryLayerPlacement.m_191604_((int)2), BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> GLOWCAP = PVJPlacements.register("glowcap", PVJConfiguredFeatures.GLOWCAP, new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> CINDERCANE = PVJPlacements.register("cindercane", PVJConfiguredFeatures.CINDERCANE, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_()});
    public static final RegistryObject<PlacedFeature> OAK_FALLEN_TREE = PVJPlacements.register("oak_fallen_tree", PVJConfiguredFeatures.OAK_FALLEN_TREE, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)1));
    public static final RegistryObject<PlacedFeature> BIRCH_FALLEN_TREE = PVJPlacements.register("birch_fallen_tree", PVJConfiguredFeatures.BIRCH_FALLEN_TREE, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)1));
    public static final RegistryObject<PlacedFeature> SPRUCE_FALLEN_TREE = PVJPlacements.register("spruce_fallen_tree", PVJConfiguredFeatures.SPRUCE_FALLEN_TREE, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)1));
    public static final RegistryObject<PlacedFeature> JUNGLE_FALLEN_TREE = PVJPlacements.register("jungle_fallen_tree", PVJConfiguredFeatures.JUNGLE_FALLEN_TREE, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)1));
    public static final RegistryObject<PlacedFeature> ACACIA_FALLEN_TREE = PVJPlacements.register("acacia_fallen_tree", PVJConfiguredFeatures.ACACIA_FALLEN_TREE, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)1));
    public static final RegistryObject<PlacedFeature> DARK_OAK_FALLEN_TREE = PVJPlacements.register("dark_oak_fallen_tree", PVJConfiguredFeatures.DARK_OAK_FALLEN_TREE, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)1));
    public static final RegistryObject<PlacedFeature> NATURAL_COBWEB = PVJPlacements.register("natural_cobweb", PVJConfiguredFeatures.NATURAL_COBWEB, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)5));
    public static final RegistryObject<PlacedFeature> EXTRA_SEAGRASS = PVJPlacements.copy("extra_seagrass", (Holder<PlacedFeature>)AquaticPlacements.f_195221_);
    public static final RegistryObject<PlacedFeature> EXTRA_LILYPADS = PVJPlacements.register("extra_lilypads", PVJConfiguredFeatures.LILYPADS, (List<PlacementModifier>)VegetationPlacements.m_195474_((int)4));
    public static final RegistryObject<PlacedFeature> EXTRA_GRASS = PVJPlacements.copy("extra_grass", (Holder<PlacedFeature>)VegetationPlacements.f_195451_);
    public static final RegistryObject<PlacedFeature> TIDE_POOL = PVJPlacements.register("tide_pool", PVJConfiguredFeatures.TIDE_POOL, new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, EnvironmentScanPlacement.m_191657_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)12), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)1)), BiomeFilter.m_191561_()});

    private static RegistryObject<PlacedFeature> copy(String name, Holder<PlacedFeature> placedFeature) {
        return PVJPlacements.register(name, ((PlacedFeature)placedFeature.m_203334_()).f_191775_(), (List<PlacementModifier>)((PlacedFeature)placedFeature.m_203334_()).f_191776_());
    }

    private static <T extends FeatureConfiguration> RegistryObject<PlacedFeature> register(String name, Holder<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> modifiers) {
        return PLACED_FEATURES.register(name, () -> new PlacedFeature(Holder.m_205706_((Holder)feature), modifiers));
    }

    public static RegistryObject<PlacedFeature> register(String name, RegistryObject<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> modifiers) {
        return PLACED_FEATURES.register(name, () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)feature.getHolder().orElseThrow())), modifiers));
    }

    public static RegistryObject<PlacedFeature> register(String name, RegistryObject<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
        return PVJPlacements.register(name, feature, List.of(modifiers));
    }

    public static List<PlacementModifier> onceEvery(int distance) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)RarityFilter.m_191900_((int)distance));
        builder.add((Object)InSquarePlacement.m_191715_());
        builder.add((Object)PlacementUtils.f_195352_);
        builder.add((Object)BiomeFilter.m_191561_());
        return builder.build();
    }

    public static void init() {
    }
}

