/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.blocks;

import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBlocks;
import dev.orderedchaos.projectvibrantjourneys.util.LevelUtils;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IcicleBlock
extends Block
implements Fallable {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.f_155997_;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.f_155998_;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public IcicleBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TIP_DIRECTION, (Comparable)Direction.UP)).m_61124_(THICKNESS, (Comparable)DripstoneThickness.TIP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TIP_DIRECTION, THICKNESS});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return IcicleBlock.isValidPointedDripstonePlacement(level, pos, (Direction)state.m_61143_((Property)TIP_DIRECTION));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState state2, LevelAccessor level, BlockPos pos, BlockPos pos2) {
        if (dir != Direction.UP && dir != Direction.DOWN) {
            return state;
        }
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && level.m_183326_().m_183582_(pos, (Object)this)) {
            return state;
        }
        if (dir == direction.m_122424_() && !this.m_7898_(state, (LevelReader)level, pos)) {
            if (direction == Direction.DOWN) {
                level.m_186460_(pos, (Block)this, 2);
            } else {
                level.m_186460_(pos, (Block)this, 1);
            }
            return state;
        }
        boolean flag = state.m_61143_(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = IcicleBlock.calculateDripstoneThickness((LevelReader)level, pos, direction, flag);
        return (BlockState)state.m_61124_(THICKNESS, (Comparable)dripstonethickness);
    }

    public void m_5581_(Level level, BlockState pos, BlockHitResult result, Projectile projectile) {
        BlockPos blockpos = result.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockpos) && projectile instanceof ThrownTrident && projectile.m_20184_().m_82553_() > 0.6) {
            level.m_46961_(blockpos, true);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float height) {
        if (state.m_61143_((Property)TIP_DIRECTION) == Direction.UP && state.m_61143_(THICKNESS) == DripstoneThickness.TIP) {
            entity.m_142535_(height + 2.0f, 2.0f, level.m_269111_().m_269571_());
        } else {
            super.m_142072_(level, state, pos, entity, height);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((level.m_45517_(LightLayer.BLOCK, pos) > 11 - state.m_60739_((BlockGetter)level, pos) || ((Biome)level.m_204166_(pos).m_203334_()).m_198906_(pos)) && IcicleBlock.canDrip(state)) {
            IcicleBlock.spawnDripParticle(level, pos, state);
        }
    }

    public void m_213897_(BlockState p_154107_, ServerLevel p_154108_, BlockPos p_154109_, RandomSource p_154110_) {
        if (IcicleBlock.isStalagmite(p_154107_) && !this.m_7898_(p_154107_, (LevelReader)p_154108_, p_154109_)) {
            p_154108_.m_46961_(p_154109_, true);
        } else {
            IcicleBlock.spawnFallingStalactite(p_154107_, p_154108_, p_154109_);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.BLOCK, pos) > 11 - state.m_60739_((BlockGetter)level, pos) || ((Biome)level.m_204166_(pos).m_203334_()).m_198906_(pos)) {
            level.m_46961_(pos, true);
            for (int i = 0; i < 10; ++i) {
                IcicleBlock.spawnDripParticle((Level)level, pos, state);
            }
            BlockPos blockpos = IcicleBlock.findTip(state, (LevelAccessor)level, pos, 11, false);
            BlockPos cauldronPos = IcicleBlock.findFillableCauldronBelowStalactiteTip((Level)level, blockpos);
            if (cauldronPos != null) {
                BlockState cauldron = level.m_8055_(cauldronPos);
                if (cauldron.m_60734_() instanceof CauldronBlock) {
                    LevelUtils.setBlockAndUpdate((LevelAccessor)level, cauldronPos, Blocks.f_152476_.m_49966_());
                } else if (cauldron.m_60734_() == Blocks.f_152476_ && !((LayeredCauldronBlock)cauldron.m_60734_()).m_142596_(cauldron)) {
                    LevelUtils.setBlockAndUpdate((LevelAccessor)level, cauldronPos, (BlockState)cauldron.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf((Integer)cauldron.m_61143_((Property)LayeredCauldronBlock.f_153514_) + 1)));
                }
            }
        }
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(Level level, BlockPos pos) {
        Predicate<BlockState> predicate = state -> state.m_60734_() == Blocks.f_50256_ || state.m_60734_() == Blocks.f_152476_;
        BiPredicate<BlockPos, BlockState> bipredicate = (blockpos, state) -> IcicleBlock.canDripThrough((BlockGetter)level, blockpos, state);
        return IcicleBlock.findBlockVertical((LevelAccessor)level, pos, Direction.DOWN.m_122421_(), bipredicate, predicate, 11).orElse(null);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = context.m_43725_();
        Direction direction1 = IcicleBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = context.m_8083_(), direction = context.m_151260_().m_122424_());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !context.m_7078_();
        DripstoneThickness dripstonethickness = IcicleBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction1)).m_61124_(THICKNESS, (Comparable)dripstonethickness);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (state.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.m_60824_(level, pos);
        return voxelshape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public float m_142740_() {
        return 0.125f;
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity entity) {
        if (!entity.m_20067_()) {
            level.m_46796_(1045, pos, 0);
        }
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        BlockState blockstate = state;
        while (IcicleBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (IcicleBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.m_123342_() - blockpos$mutableblockpos.m_123342_(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.m_149656_(f, 40);
                break;
            }
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
        }
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state) {
        Vec3 vec3 = state.m_60824_((BlockGetter)level, pos);
        double d1 = (double)pos.m_123341_() + 0.5 + vec3.f_82479_;
        double d2 = (double)((float)(pos.m_123342_() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.m_123343_() + 0.5 + vec3.f_82481_;
        SimpleParticleType particleoptions = ParticleTypes.f_175824_;
        level.m_7106_((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos, int p_154134_, boolean p_154135_) {
        if (IcicleBlock.isTip(state, p_154135_)) {
            return pos;
        }
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.m_60713_((Block)PVJBlocks.ICICLE.get()) && p_202024_.m_61143_((Property)TIP_DIRECTION) == direction;
        return IcicleBlock.findBlockVertical(level, pos, direction.m_122421_(), bipredicate, p_154168_ -> IcicleBlock.isTip(p_154168_, p_154135_), p_154134_).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction dir) {
        Direction direction;
        if (IcicleBlock.isValidPointedDripstonePlacement(level, pos, dir)) {
            direction = dir;
        } else {
            if (!IcicleBlock.isValidPointedDripstonePlacement(level, pos, dir.m_122424_())) {
                return null;
            }
            direction = dir.m_122424_();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader level, BlockPos pos, Direction dir, boolean p_154096_) {
        Direction direction = dir.m_122424_();
        BlockState blockstate = level.m_8055_(pos.m_121945_(dir));
        if (IcicleBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !p_154096_ && blockstate.m_61143_(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!IcicleBlock.isPointedDripstoneWithDirection(blockstate, dir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.m_61143_(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = level.m_8055_(pos.m_121945_(direction));
            return !IcicleBlock.isPointedDripstoneWithDirection(blockstate1, dir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return IcicleBlock.isStalactite(state) && state.m_61143_(THICKNESS) == DripstoneThickness.TIP;
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockpos = pos.m_121945_(dir.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)level, blockpos, dir) || IcicleBlock.isPointedDripstoneWithDirection(blockstate, dir);
    }

    private static boolean isTip(BlockState state, boolean p_154155_) {
        if (!state.m_60713_((Block)PVJBlocks.ICICLE.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || p_154155_ && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isStalactite(BlockState state) {
        return IcicleBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return IcicleBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader level, BlockPos pos) {
        return IcicleBlock.isStalactite(state) && !level.m_8055_(pos.m_7494_()).m_60713_((Block)PVJBlocks.ICICLE.get());
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction dir) {
        return state.m_60713_((Block)PVJBlocks.ICICLE.get()) && state.m_61143_((Property)TIP_DIRECTION) == dir;
    }

    @Nullable
    public static BlockPos findStalactiteTipAboveCauldron(Level level, BlockPos pos) {
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202030_, p_202031_) -> IcicleBlock.canDripThrough((BlockGetter)level, p_202030_, p_202031_);
        return IcicleBlock.findBlockVertical((LevelAccessor)level, pos, Direction.UP.m_122421_(), bipredicate, IcicleBlock::canDrip, 11).orElse(null);
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection dir, BiPredicate<BlockPos, BlockState> p_202010_, Predicate<BlockState> p_202011_, int p_202012_) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)dir, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (int i = 1; i < p_202012_; ++i) {
            blockpos$mutableblockpos.m_122173_(direction);
            BlockState blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (p_202011_.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.m_7949_());
            }
            if (!level.m_151562_(blockpos$mutableblockpos.m_123342_()) && p_202010_.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60804_(level, pos)) {
            return false;
        }
        if (!state.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelshape = state.m_60812_(level, pos);
        return !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_);
    }
}

