/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.BarkMushroomBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.FallenLeavesBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.GroundcoverBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.HollowLogBlock;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.configurations.FallenTreeConfiguration;
import dev.orderedchaos.projectvibrantjourneys.core.config.PVJConfig;
import dev.orderedchaos.projectvibrantjourneys.util.LevelUtils;
import dev.orderedchaos.projectvibrantjourneys.util.PVJFeatureVars;
import dev.orderedchaos.projectvibrantjourneys.util.TreeFeatureUtils;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FallenTreeFeature
extends Feature<FallenTreeConfiguration> {
    public FallenTreeFeature(Codec<FallenTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FallenTreeConfiguration> context) {
        HashSet<TreeFeatureUtils.ChanceBiomeEntry> biomeEntries;
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource rand = context.m_225041_();
        BlockState hollowLog = ((FallenTreeConfiguration)context.m_159778_()).hollowLog();
        BlockState baseLog = ((FallenTreeConfiguration)context.m_159778_()).baseLog();
        String biome = ((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_().toString();
        int chance = TreeFeatureUtils.getChance(biome, biomeEntries = this.getEntrySet(baseLog.m_60734_()));
        if (chance == -1) {
            chance = 10;
        }
        if (rand.m_188501_() > (float)chance / 100.0f) {
            return false;
        }
        BlockState below = level.m_8055_(pos.m_7495_());
        if (below.m_204336_(BlockTags.f_13047_) || below.m_60734_() == Blocks.f_50127_ || below.m_60819_().m_76170_()) {
            return false;
        }
        int length = rand.m_188503_(3) + 4;
        Direction dir = Direction.Plane.HORIZONTAL.m_235690_(rand);
        Direction dirCounterClockwise = dir.m_122428_();
        Direction dirClockwise = dir.m_122427_();
        boolean branched = false;
        for (int i = 0; i < length; ++i) {
            if (!this.canReplace(level, pos)) {
                return false;
            }
            pos = pos.m_121955_(dir.m_122436_());
        }
        pos = context.m_159777_();
        List<FallenTreeConfiguration.FallenTreeVegetation> vegetationProviders = ((FallenTreeConfiguration)context.m_159778_()).vegetationProviders();
        RandomSource randomSource = level.m_213780_();
        for (int i = 0; i < length; ++i) {
            if (this.canReplace(level, pos)) {
                if (!below.m_247087_() && !below.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || i > length / 2) {
                    BarkMushroomBlock mushroom;
                    BlockState state;
                    boolean mossy = ((FallenTreeConfiguration)context.m_159778_()).canBeMossy() ? randomSource.m_188499_() : false;
                    LevelUtils.setBlock((LevelAccessor)level, pos, (BlockState)((BlockState)hollowLog.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_())).m_61124_((Property)HollowLogBlock.MOSSY, (Comparable)Boolean.valueOf(mossy)), 2);
                    if (level.m_46859_(pos.m_7494_()) && rand.m_188501_() < 0.75f) {
                        LevelUtils.setBlock((LevelAccessor)level, pos.m_7494_(), this.getVegetationToPlace(vegetationProviders, randomSource, pos.m_7494_()), 2);
                    }
                    if (!branched && i <= length / 2 + 1 && rand.m_188501_() < 0.5f) {
                        BlockPos branchPos = rand.m_188499_() ? pos.m_121955_(dirCounterClockwise.m_122436_()) : pos.m_121955_(dirClockwise.m_122436_());
                        LevelUtils.setBlock((LevelAccessor)level, branchPos, (BlockState)baseLog.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dirCounterClockwise.m_122434_()), 2);
                        if (level.m_46859_(branchPos.m_7494_()) && rand.m_188501_() < 0.4f) {
                            LevelUtils.setBlock((LevelAccessor)level, branchPos.m_7494_(), this.getVegetationToPlace(vegetationProviders, randomSource, branchPos.m_7494_()), 2);
                        }
                        branched = true;
                    }
                    BlockPos original = pos;
                    if (this.canReplace(level, pos = pos.m_121955_(dirCounterClockwise.m_122436_()))) {
                        if (rand.m_188501_() < 0.4f && Block.m_49918_((VoxelShape)level.m_8055_(pos.m_7495_()).m_60812_((BlockGetter)level, pos.m_7495_()), (Direction)Direction.UP)) {
                            state = this.getVegetationToPlace(vegetationProviders, randomSource, pos);
                            if (state.m_60710_((LevelReader)level, pos)) {
                                LevelUtils.setBlock((LevelAccessor)level, pos, state, 2);
                            }
                        } else if (rand.m_188501_() < 0.4f && ((Boolean)PVJConfig.configOptions.get("enableBarkMushrooms").get()).booleanValue()) {
                            mushroom = BarkMushroomBlock.getRandom(rand);
                            LevelUtils.setBlock((LevelAccessor)level, pos, (BlockState)mushroom.m_49966_().m_61124_((Property)BarkMushroomBlock.FACING, (Comparable)dirCounterClockwise), 2);
                        }
                    }
                    pos = original;
                    if (this.canReplace(level, pos = pos.m_121955_(dirClockwise.m_122436_()))) {
                        if (rand.m_188501_() < 0.4f && Block.m_49918_((VoxelShape)level.m_8055_(pos.m_7495_()).m_60812_((BlockGetter)level, pos.m_7495_()), (Direction)Direction.UP)) {
                            state = this.getVegetationToPlace(vegetationProviders, randomSource, pos);
                            if (state.m_60710_((LevelReader)level, pos)) {
                                LevelUtils.setBlock((LevelAccessor)level, pos, state, 2);
                            }
                        } else if (rand.m_188501_() < 0.4f && ((Boolean)PVJConfig.configOptions.get("enableBarkMushrooms").get()).booleanValue()) {
                            mushroom = BarkMushroomBlock.getRandom(rand);
                            LevelUtils.setBlock((LevelAccessor)level, pos, (BlockState)mushroom.m_49966_().m_61124_((Property)BarkMushroomBlock.FACING, (Comparable)dirClockwise), 2);
                        }
                    }
                    pos = original;
                    pos = pos.m_121955_(dir.m_122436_());
                } else {
                    dir = dir.m_122424_();
                    pos = context.m_159777_().m_121955_(dir.m_122436_());
                }
            } else {
                return length - i < length;
            }
            below = level.m_8055_(pos.m_7495_());
        }
        return true;
    }

    public boolean canReplace(WorldGenLevel world, BlockPos pos) {
        return world.m_8055_(pos).m_247087_() || world.m_46859_(pos) || world.m_8055_(pos).m_60734_() instanceof FallenLeavesBlock || world.m_8055_(pos).m_60734_() instanceof GroundcoverBlock;
    }

    public HashSet<TreeFeatureUtils.ChanceBiomeEntry> getEntrySet(Block log) {
        if (log == Blocks.f_49999_) {
            return PVJFeatureVars.OAK;
        }
        if (log == Blocks.f_50001_) {
            return PVJFeatureVars.BIRCH;
        }
        if (log == Blocks.f_50000_) {
            return PVJFeatureVars.SPRUCE;
        }
        if (log == Blocks.f_50002_) {
            return PVJFeatureVars.JUNGLE;
        }
        if (log == Blocks.f_50003_) {
            return PVJFeatureVars.ACACIA;
        }
        if (log == Blocks.f_50004_) {
            return PVJFeatureVars.DARK_OAK;
        }
        if (log == Blocks.f_220832_) {
            return PVJFeatureVars.MANGROVE;
        }
        if (log == Blocks.f_271170_) {
            return PVJFeatureVars.CHERRY;
        }
        return PVJFeatureVars.OAK;
    }

    private BlockState getVegetationToPlace(List<FallenTreeConfiguration.FallenTreeVegetation> vegetationProviders, RandomSource randomSource, BlockPos pos) {
        int numProviders = vegetationProviders.size();
        FallenTreeConfiguration.FallenTreeVegetation vegetation = null;
        while (vegetation == null) {
            String configOption;
            int random = randomSource.m_188503_(numProviders);
            FallenTreeConfiguration.FallenTreeVegetation temp = vegetationProviders.get(random);
            if (temp.configOption().isPresent() && !((Boolean)PVJConfig.configOptions.get(configOption = temp.configOption().get()).get()).booleanValue()) continue;
            vegetation = temp;
        }
        return vegetation.provider().m_213972_(randomSource, pos);
    }
}

