/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportals;

import dev.orderedchaos.projectvibrantjourneys.util.LevelUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RuinedNetherPortalDecorator {
    public static final List<RuinedNetherPortalDecorator> PORTAL_DECORATORS = new ArrayList<RuinedNetherPortalDecorator>();

    public static void registerPortalDecorators() {
        PORTAL_DECORATORS.add(new NetherWastesPortalDecorator());
        PORTAL_DECORATORS.add(new SoulSandValleyPortalDecorator());
        PORTAL_DECORATORS.add(new BasaltDeltasPortalDecorator());
        PORTAL_DECORATORS.add(new WarpedForestPortalDecorator());
        PORTAL_DECORATORS.add(new CrimsonForestPortalDecorator());
    }

    public abstract BlockState getTopSoil(WorldGenLevel var1, RandomSource var2);

    public abstract void decorate(WorldGenLevel var1, RandomSource var2, BlockPos var3);

    public static RuinedNetherPortalDecorator getRandomDecorator(RandomSource randomSource) {
        int random = randomSource.m_188503_(PORTAL_DECORATORS.size());
        return PORTAL_DECORATORS.get(random);
    }

    private static class NetherWastesPortalDecorator
    extends RuinedNetherPortalDecorator {
        private NetherWastesPortalDecorator() {
        }

        @Override
        public BlockState getTopSoil(WorldGenLevel level, RandomSource randomSource) {
            float random = randomSource.m_188501_();
            if (random <= 0.03f) {
                return Blocks.f_50331_.m_49966_();
            }
            if (random <= 0.05f) {
                return Blocks.f_49998_.m_49966_();
            }
            return null;
        }

        @Override
        public void decorate(WorldGenLevel level, RandomSource randomSource, BlockPos pos) {
        }
    }

    private static class SoulSandValleyPortalDecorator
    extends RuinedNetherPortalDecorator {
        private SoulSandValleyPortalDecorator() {
        }

        @Override
        public BlockState getTopSoil(WorldGenLevel level, RandomSource randomSource) {
            if (randomSource.m_188501_() < 0.75f) {
                return Blocks.f_50135_.m_49966_();
            }
            return null;
        }

        @Override
        public void decorate(WorldGenLevel level, RandomSource randomSource, BlockPos pos) {
            if (randomSource.m_188501_() < 0.4f) {
                LevelUtils.setBlock((LevelAccessor)level, pos.m_7494_(), Blocks.f_50084_.m_49966_(), 3);
            } else if (randomSource.m_188501_() < 0.05f) {
                int height = randomSource.m_188503_(3) + 2;
                for (int i = 1; i <= height && (level.m_46859_(pos.m_6630_(i)) || level.m_8055_(pos.m_6630_(i)).m_247087_()); ++i) {
                    LevelUtils.setBlock((LevelAccessor)level, pos.m_6630_(i), Blocks.f_50453_.m_49966_(), 3);
                }
            }
        }
    }

    private static class BasaltDeltasPortalDecorator
    extends RuinedNetherPortalDecorator {
        private BasaltDeltasPortalDecorator() {
        }

        @Override
        public BlockState getTopSoil(WorldGenLevel level, RandomSource randomSource) {
            float random = randomSource.m_188501_();
            if (random < 0.33f) {
                return Blocks.f_50730_.m_49966_();
            }
            if (random < 0.666f) {
                return Blocks.f_50137_.m_49966_();
            }
            return null;
        }

        @Override
        public void decorate(WorldGenLevel level, RandomSource randomSource, BlockPos pos) {
            if (randomSource.m_188501_() < 0.33f) {
                int height = randomSource.m_188503_(3) + 1;
                for (int i = 1; i <= height && (level.m_46859_(pos.m_6630_(i)) || level.m_8055_(pos.m_6630_(i)).m_247087_()); ++i) {
                    LevelUtils.setBlock((LevelAccessor)level, pos.m_6630_(i), Blocks.f_50137_.m_49966_(), 3);
                }
            }
        }
    }

    private static class WarpedForestPortalDecorator
    extends RuinedNetherPortalDecorator {
        private WarpedForestPortalDecorator() {
        }

        @Override
        public BlockState getTopSoil(WorldGenLevel level, RandomSource randomSource) {
            if (randomSource.m_188501_() < 0.75f) {
                return Blocks.f_50690_.m_49966_();
            }
            return null;
        }

        @Override
        public void decorate(WorldGenLevel level, RandomSource randomSource, BlockPos pos) {
            float random = randomSource.m_188501_();
            if (random < 0.17f) {
                LevelUtils.setBlock((LevelAccessor)level, pos.m_7494_(), Blocks.f_50691_.m_49966_(), 3);
            } else if (random < 0.34f) {
                LevelUtils.setBlock((LevelAccessor)level, pos.m_7494_(), Blocks.f_50694_.m_49966_(), 3);
            } else if (random < 0.5f) {
                LevelUtils.setBlock((LevelAccessor)level, pos.m_7494_(), Blocks.f_50693_.m_49966_(), 3);
            } else if (random < 0.8f) {
                int length = randomSource.m_188503_(3) + 1;
                int i = 1;
                while (length > 0 && level.m_46859_(pos.m_6630_(i))) {
                    LevelUtils.setBlock((LevelAccessor)level, pos.m_6630_(i), Blocks.f_50653_.m_49966_(), 3);
                    --length;
                    ++i;
                }
                LevelUtils.setBlock((LevelAccessor)level, pos.m_6630_(i - 1), Blocks.f_50704_.m_49966_(), 3);
            }
        }
    }

    private static class CrimsonForestPortalDecorator
    extends RuinedNetherPortalDecorator {
        private CrimsonForestPortalDecorator() {
        }

        @Override
        public BlockState getTopSoil(WorldGenLevel level, RandomSource randomSource) {
            if (randomSource.m_188501_() < 0.75f) {
                return Blocks.f_50699_.m_49966_();
            }
            return null;
        }

        @Override
        public void decorate(WorldGenLevel level, RandomSource randomSource, BlockPos pos) {
            float random = randomSource.m_188501_();
            if (random < 0.25f) {
                LevelUtils.setBlock((LevelAccessor)level, pos.m_7494_(), Blocks.f_50700_.m_49966_(), 3);
            } else if (random < 0.5f) {
                LevelUtils.setBlock((LevelAccessor)level, pos.m_7494_(), Blocks.f_50654_.m_49966_(), 3);
            }
        }
    }
}

