/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.modifiers;

import com.mojang.serialization.Codec;
import dev.orderedchaos.projectvibrantjourneys.core.config.PVJConfig;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBiomeModifiers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record PVJBiomeModifier(TagKey<Biome> dimension, List<HolderSet<Biome>> biomes, List<HolderSet<Biome>> blacklist, GenerationStep.Decoration decoration, Holder<PlacedFeature> feature, String configOption) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING && ((Boolean)PVJConfig.configOptions.get(this.configOption).get()).booleanValue() && biome.m_203656_(this.dimension)) {
            boolean flag = false;
            for (HolderSet<Biome> set : this.biomes) {
                if (!set.m_203333_(biome)) continue;
                flag = true;
                break;
            }
            if (flag) {
                for (HolderSet<Biome> set : this.blacklist) {
                    if (!set.m_203333_(biome)) continue;
                    return;
                }
                builder.getGenerationSettings().m_255419_(this.decoration, this.feature);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)PVJBiomeModifiers.BIOME_MODIFIER_SERIALIZER.get();
    }

    public static class Builder {
        private HolderGetter<PlacedFeature> placedFeatureGetter;
        private HolderGetter<Biome> biomeGetter;
        private TagKey<Biome> dimension = BiomeTags.f_215817_;
        private HolderSet.Named<Biome> namedTags;
        private List<TagKey<Biome>> biomeTags = new ArrayList<TagKey<Biome>>();
        private List<TagKey<Biome>> blacklistTags = new ArrayList<TagKey<Biome>>();
        private List<Holder<Biome>> extraBiomes = new ArrayList<Holder<Biome>>();
        private List<Holder<Biome>> extraBlacklist = new ArrayList<Holder<Biome>>();
        private GenerationStep.Decoration decoration = GenerationStep.Decoration.VEGETAL_DECORATION;
        private final String configOption;
        private ResourceKey<PlacedFeature> placedFeatureKey;

        public Builder(BootstapContext<BiomeModifier> context, String configOption) {
            this.placedFeatureGetter = context.m_255420_(Registries.f_256988_);
            this.biomeGetter = context.m_255420_(Registries.f_256952_);
            this.configOption = configOption;
        }

        public Builder placedFeature(ResourceKey<PlacedFeature> placedFeatureKey) {
            this.placedFeatureKey = placedFeatureKey;
            return this;
        }

        public Builder dimension(Dimension dim) {
            TagKey tagKey = BiomeTags.f_215817_;
            switch (dim) {
                case OVERWORLD: {
                    tagKey = BiomeTags.f_215817_;
                    break;
                }
                case NETHER: {
                    tagKey = BiomeTags.f_215817_;
                    break;
                }
                case END: {
                    tagKey = BiomeTags.f_215818_;
                }
            }
            this.dimension = tagKey;
            return this;
        }

        public Builder decoration(GenerationStep.Decoration decoration) {
            this.decoration = decoration;
            return this;
        }

        public Builder tag(List<TagKey<Biome>> tags) {
            this.biomeTags.addAll(this.combine(tags));
            return this;
        }

        public Builder blacklist(List<TagKey<Biome>> ... tags) {
            this.blacklistTags.addAll(this.combine(tags));
            return this;
        }

        public Builder extraBiomes(List<Holder<Biome>> ... biomes) {
            this.extraBiomes.addAll(this.combine(biomes));
            return this;
        }

        public Builder extraBiomes(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                Holder.Reference biomeHolder = this.biomeGetter.m_255043_(biome);
                this.extraBiomes.add((Holder<Biome>)biomeHolder);
            }
            return this;
        }

        public Builder biomes(HolderSet.Named<Biome> holders) {
            this.namedTags = holders;
            return this;
        }

        public Builder extraBlacklist(List<Holder<Biome>> ... biomes) {
            this.extraBlacklist.addAll(this.combine(biomes));
            return this;
        }

        public Builder extraBlacklist(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                Holder.Reference biomeHolder = this.biomeGetter.m_255043_(biome);
                this.extraBlacklist.add((Holder<Biome>)biomeHolder);
            }
            return this;
        }

        public Builder extraBlacklist(List<ResourceKey<Biome>> biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                Holder.Reference biomeHolder = this.biomeGetter.m_255043_(biome);
                this.extraBlacklist.add((Holder<Biome>)biomeHolder);
            }
            return this;
        }

        @SafeVarargs
        public final <T> List<T> combine(List<T> ... lists) {
            ArrayList<T> list = new ArrayList<T>();
            for (List<T> i : lists) {
                for (T tag : i) {
                    list.add(tag);
                }
            }
            return list;
        }

        public PVJBiomeModifier build() {
            ArrayList<HolderSet.Named> biomesSet = new ArrayList<HolderSet.Named>(this.biomeTags.stream().map(tag -> this.biomeGetter.m_254956_(tag)).toList());
            ArrayList<HolderSet.Named> blacklistSet = new ArrayList<HolderSet.Named>(this.blacklistTags.stream().map(tag -> this.biomeGetter.m_254956_(tag)).toList());
            if (!this.extraBiomes.isEmpty()) {
                biomesSet.add((HolderSet.Named)HolderSet.m_205800_(this.extraBiomes));
            }
            if (this.namedTags != null) {
                biomesSet.add(this.namedTags);
            }
            if (!this.extraBlacklist.isEmpty()) {
                blacklistSet.add((HolderSet.Named)HolderSet.m_205800_(this.extraBlacklist));
            }
            Holder.Reference placedFeature = this.placedFeatureGetter.m_255043_(this.placedFeatureKey);
            return new PVJBiomeModifier(this.dimension, biomesSet, blacklistSet, this.decoration, (Holder<PlacedFeature>)placedFeature, this.configOption);
        }

        public static enum Dimension {
            OVERWORLD,
            NETHER,
            END;

        }
    }
}

