/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.core.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.orderedchaos.projectvibrantjourneys.common.tags.PVJTags;
import dev.orderedchaos.projectvibrantjourneys.common.world.modifiers.PVJBiomeModifier;
import dev.orderedchaos.projectvibrantjourneys.common.world.modifiers.PVJSpawnModifier;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJPlacements;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class PVJBiomeModifiers {
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"projectvibrantjourneys");
    public static final RegistryObject<Codec<PVJBiomeModifier>> BIOME_MODIFIER_SERIALIZER = BIOME_MODIFIER_SERIALIZERS.register("biome_modifier_serializer", () -> RecordCodecBuilder.create(builder -> builder.group((App)TagKey.m_203877_((ResourceKey)Registries.f_256952_).fieldOf("dimension").forGetter(PVJBiomeModifier::dimension), (App)Biome.f_47432_.listOf().fieldOf("biomes").forGetter(PVJBiomeModifier::biomes), (App)Biome.f_47432_.listOf().fieldOf("blacklist").forGetter(PVJBiomeModifier::blacklist), (App)GenerationStep.Decoration.f_224188_.fieldOf("decoration").forGetter(PVJBiomeModifier::decoration), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(PVJBiomeModifier::feature), (App)PrimitiveCodec.STRING.fieldOf("configOption").forGetter(PVJBiomeModifier::configOption)).apply((Applicative)builder, PVJBiomeModifier::new)));
    public static final RegistryObject<Codec<PVJSpawnModifier>> SPAWN_MODIFIER_SERIALIZER = BIOME_MODIFIER_SERIALIZERS.register("spawn_modifier_serializer", () -> RecordCodecBuilder.create(builder -> builder.group((App)TagKey.m_203877_((ResourceKey)Registries.f_256952_).fieldOf("dimension").forGetter(PVJSpawnModifier::dimension), (App)Biome.f_47432_.fieldOf("biomes").forGetter(PVJSpawnModifier::biomes), (App)MobCategory.f_21584_.fieldOf("category").forGetter(PVJSpawnModifier::category), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("data").forGetter(PVJSpawnModifier::data), (App)PrimitiveCodec.STRING.fieldOf("configOption").forGetter(PVJSpawnModifier::configOption)).apply((Applicative)builder, PVJSpawnModifier::new)));

    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        PVJBiomeModifiers.bootstrapBiomeModifiers(context);
        PVJBiomeModifiers.bootstrapSpawnModifiers(context);
    }

    public static void bootstrapBiomeModifiers(BootstapContext<BiomeModifier> context) {
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.TWIGS, new PVJBiomeModifier.Builder(context, "enableTwigs").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.desert(), PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.FALLEN_LEAVES, new PVJBiomeModifier.Builder(context, "enableFallenLeaves").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.desert(), PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.DEAD_FALLEN_LEAVES, new PVJBiomeModifier.Builder(context, "enableFallenLeaves").extraBiomes(Biomes.f_186753_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.DENSE_DEAD_FALLEN_LEAVES, new PVJBiomeModifier.Builder(context, "enableFallenLeaves").extraBiomes(Biomes.f_186763_, Biomes.f_186764_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.PINECONES, new PVJBiomeModifier.Builder(context, "enablePinecones").tag(PVJBiomeModifiers.coniferous()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SEASHELLS, new PVJBiomeModifier.Builder(context, "enableSeashells").tag(PVJBiomeModifiers.oceanOrBeach()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.OCEAN_FLOOR_SEASHELLS, new PVJBiomeModifier.Builder(context, "enableSeashells").tag(PVJBiomeModifiers.oceanOrBeach()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.ROCKS, new PVJBiomeModifier.Builder(context, "enableRocks").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BONES, new PVJBiomeModifier.Builder(context, "enableBones").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CAVE_ROCKS, new PVJBiomeModifier.Builder(context, "enableRocks").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CAVE_BONES, new PVJBiomeModifier.Builder(context, "enableBones").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.ICE_CHUNKS, new PVJBiomeModifier.Builder(context, "enableIceChunks").tag(PVJBiomeModifiers.snowy()).extraBlacklist(Biomes.f_48148_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MOSS_CARPET, new PVJBiomeModifier.Builder(context, "enableMossCarpets").extraBiomes(Biomes.f_186763_, Biomes.f_186764_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BARK_MUSHROOM, new PVJBiomeModifier.Builder(context, "enableBarkMushrooms").tag(PVJBiomeModifiers.overworld()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SEA_OATS, new PVJBiomeModifier.Builder(context, "enableSeaOats").tag(PVJBiomeModifiers.beach()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BEACH_GRASS, new PVJBiomeModifier.Builder(context, "enableBeachGrass").tag(PVJBiomeModifiers.beach()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CATTAILS, new PVJBiomeModifier.Builder(context, "enableCattails").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.badlands()).extraBlacklist(PVJBiomeModifiers.veryCold()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SHORT_GRASS, new PVJBiomeModifier.Builder(context, "enableShortGrass").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(Biomes.f_186761_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.NATURAL_COBWEB, new PVJBiomeModifier.Builder(context, "enableNaturalCobwebs").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.mushroom()).extraBlacklist(Biomes.f_186761_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SMALL_CACTUS, new PVJBiomeModifier.Builder(context, "enableSmallCacti").tag(PVJBiomeModifiers.desert()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.EXTRA_SEAGRASS, new PVJBiomeModifier.Builder(context, "enableExtraSeagrass").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.desert()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.EXTRA_LILYPADS, new PVJBiomeModifier.Builder(context, "enableExtraLilypads").tag(PVJBiomeModifiers.overworld()).blacklist(PVJBiomeModifiers.oceanOrBeach(), PVJBiomeModifiers.desert()).extraBlacklist(PVJBiomeModifiers.veryCold()).extraBlacklist(Biomes.f_186760_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.EXTRA_GRASS, new PVJBiomeModifier.Builder(context, "enableExtraRiverGrass").tag(PVJBiomeModifiers.river()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.TIDE_POOL, new PVJBiomeModifier.Builder(context, "enableTidePools").extraBiomes(Biomes.f_186760_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CAVE_ROOTS, new PVJBiomeModifier.Builder(context, "enableCaveRoots").tag(PVJBiomeModifiers.overworld()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.REEDS, new PVJBiomeModifier.Builder(context, "enableReeds").extraBlacklist(Biomes.f_186761_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.PRICKLY_BUSH, new PVJBiomeModifier.Builder(context, "enablePricklyBush").extraBiomes(Biomes.f_186753_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.ICICLE, new PVJBiomeModifier.Builder(context, "enableIcicles").tag(PVJBiomeModifiers.snowy()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SANDY_SPROUTS, new PVJBiomeModifier.Builder(context, "enableSandySprouts").tag(PVJBiomeModifiers.beach()).extraBlacklist(PVJBiomeModifiers.veryCold()));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.OAK_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_OAK_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.BIRCH_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_BIRCH_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.SPRUCE_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_SPRUCE_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.JUNGLE_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_JUNGLE_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.ACACIA_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_ACACIA_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.DARK_OAK_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_DARK_OAK_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CHERRY_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_CHERRY_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.MANGROVE_FALLEN_TREE, new PVJBiomeModifier.Builder(context, "enableFallenTrees").tag(List.of(PVJTags.HAS_MANGROVE_LOGS)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CHARRED_BONES, new PVJBiomeModifier.Builder(context, "enableCharredBones").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).tag(List.of(BiomeTags.f_207612_)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.GLOWCAP, new PVJBiomeModifier.Builder(context, "enableGlowcap").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).tag(List.of(BiomeTags.f_207612_)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CINDERCANE, new PVJBiomeModifier.Builder(context, "enableCindercane").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).tag(List.of(BiomeTags.f_207612_)));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.WARPED_NETTLE, new PVJBiomeModifier.Builder(context, "enableNetherNettles").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).extraBiomes(Biomes.f_48201_));
        PVJBiomeModifiers.addBiomeModifier(context, PVJPlacements.CRIMSON_NETTLE, new PVJBiomeModifier.Builder(context, "enableNetherNettles").dimension(PVJBiomeModifier.Builder.Dimension.NETHER).extraBiomes(Biomes.f_48200_));
    }

    public static void bootstrapSpawnModifiers(BootstapContext<BiomeModifier> context) {
        PVJBiomeModifiers.addSpawnModifier(context, "tropical_fish_in_jungles", (TagKey<Biome>)BiomeTags.f_215817_, (TagKey<Biome>)BiomeTags.f_207610_, MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 5, 5), "enableJungleTropicalFish");
    }

    private static void addBiomeModifier(BootstapContext<BiomeModifier> context, ResourceKey<PlacedFeature> placedFeatureKey, PVJBiomeModifier.Builder builder) {
        PVJBiomeModifier modifier = builder.placedFeature(placedFeatureKey).build();
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)placedFeatureKey.m_135782_());
        context.m_255272_(key, (Object)modifier);
    }

    private static void addSpawnModifier(BootstapContext<BiomeModifier> context, String spawnName, TagKey<Biome> dimension, TagKey<Biome> biomes, MobCategory mobCategory, MobSpawnSettings.SpawnerData spawnerData, String configOption) {
        HolderGetter biomeGetter = context.m_255420_(Registries.f_256952_);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("projectvibrantjourneys", spawnName));
        PVJSpawnModifier modifier = new PVJSpawnModifier(dimension, (HolderSet<Biome>)biomeGetter.m_254956_(biomes), mobCategory, spawnerData, configOption);
        context.m_255272_(key, (Object)modifier);
    }

    private static List<TagKey<Biome>> forestOrPlains() {
        return List.of(Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_);
    }

    private static List<TagKey<Biome>> plainsType() {
        return List.of(Tags.Biomes.IS_PLAINS, BiomeTags.f_215816_);
    }

    private static List<TagKey<Biome>> oceanOrBeach() {
        return List.of(BiomeTags.f_207604_, BiomeTags.f_207603_);
    }

    private static List<TagKey<Biome>> badlands() {
        return List.of(BiomeTags.f_207607_);
    }

    private static List<TagKey<Biome>> beach() {
        return List.of(BiomeTags.f_207604_);
    }

    private static List<TagKey<Biome>> river() {
        return List.of(BiomeTags.f_207605_);
    }

    private static List<TagKey<Biome>> coniferous() {
        return List.of(Tags.Biomes.IS_CONIFEROUS);
    }

    private static List<TagKey<Biome>> snowy() {
        return List.of(Tags.Biomes.IS_SNOWY);
    }

    private static List<TagKey<Biome>> mushroom() {
        return List.of(Tags.Biomes.IS_MUSHROOM);
    }

    private static List<ResourceKey<Biome>> veryCold() {
        return List.of(Biomes.f_48212_, Biomes.f_186761_, Biomes.f_48148_, Biomes.f_186756_, Biomes.f_48182_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_186758_);
    }

    private static List<TagKey<Biome>> desert() {
        return List.of(BiomeTags.f_207614_, BiomeTags.f_207607_, BiomeTags.f_207590_);
    }

    private static List<TagKey<Biome>> overworld() {
        return List.of(BiomeTags.f_215817_);
    }

    private static List<TagKey<Biome>> nether() {
        return List.of(BiomeTags.f_207612_);
    }
}

